/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.library;

import com.sas.metadata.logical.library.LibraryImportItem;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SASLibrary;
import java.rmi.RemoteException;
import java.util.Map;

public class LibraryUtil {
    static final String MAP_TEMPLATE_FILES = "<Template><SASLibrary> <DeployedComponents> <ServerContext Name =\"\"/> </DeployedComponents><UsingPackages> <File FileName=\"\" TextRole=\"\"/> <Directory Name=\"\" /> </UsingPackages> </SASLibrary> </Template>";
    static final String LIBRARIES_WITH_SCHEMAS_METADATA_TEMPLATE = "<TEMPLATES><SASLibrary><UsingPackages/></SASLibrary><DatabaseSchema><Tables/></DatabaseSchema></TEMPLATES>";
    static final String CONTENT_PROPERTY_KEY = "Optional Content: ";
    static final String MAP_FILE_KEY = "###MAP_FILE###";
    static final String XML_FILE_KEY = "###XML_FILE###";
    static final String XML_MAP_ROLE = "XMLLibraryMap";
    static final String XML_FILE_ROLE = "XMLLibraryFile";

    public static Map getMapForLibraryItem(LibraryImportItem importItem, ImportOperationInterface importOperation) {
        Map libMap = null;
        Map objectMap = null;
        try {
            objectMap = importOperation.getAssociationsForObject((PromotionItemInterface)importItem, MAP_TEMPLATE_FILES);
            libMap = (Map)objectMap.get(importItem.getID());
        }
        catch (MetadataPromotionException metadataPromotionException) {
            // empty catch block
        }
        return libMap;
    }

    public static String getDirectoryName(ConnectionPointInterface pt) {
        String searchAttribute = pt.getSourceSearchString();
        int index = searchAttribute.indexOf("@DirectoryName='", 0);
        if (index > -1) {
            return searchAttribute.substring(index + 16, searchAttribute.indexOf("']", index + 16));
        }
        return null;
    }

    public static boolean hasAssociatedDirectory(SASLibrary library) throws MdException, RemoteException {
        AssociationList usingPackagesList = library.getUsingPackages();
        int size = usingPackagesList.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                CMetadata meta = (CMetadata)usingPackagesList.get(i);
                if (!meta.getCMetadataType().equalsIgnoreCase("Directory")) continue;
                return true;
            }
        }
        return false;
    }

    public static Directory getAssociatedDirectory(SASLibrary library, String directoryID) throws MdException, RemoteException {
        AssociationList usingPackagesList = library.getUsingPackages();
        int size = usingPackagesList.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                CMetadata meta = (CMetadata)usingPackagesList.get(i);
                if (!meta.getId().equalsIgnoreCase(directoryID) || !(meta instanceof Directory)) continue;
                return (Directory)meta;
            }
        }
        return null;
    }
}

