/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.library;

import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.library.RB;
import com.sas.metadata.logical.server.OtherServerConnectionType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionValidatorInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.ValidationResponse;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.ServerComponent;
import java.rmi.RemoteException;

public class LibraryOtherServerConnectionValidator
implements ConnectionValidatorInterface {
    public void validate(ValidationResponse response, ImportOperationInterface operation, ConnectionPointInterface connection) {
        String targetID = connection.getTargetID();
        int flags = 16652;
        String strType = "ServerComponent";
        String strSasCcTemplate = "<Templates><ServerComponent><SourceConnections/></ServerComponent></Templates>";
        try {
            ServerComponent server = (ServerComponent)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)operation.getStore(), "ServerComponent", targetID, null, null, "<Templates><ServerComponent><SourceConnections/></ServerComponent></Templates>", flags);
            AssociationList sccList = server.getSourceConnections();
            boolean foundSasCc = false;
            for (Connection c : sccList) {
                if (!(c instanceof SASClientConnection)) continue;
                foundSasCc = true;
                break;
            }
            if (!foundSasCc) {
                response.setReturnCode(2);
                String str = RB.getStringResource("LibraryOtherServerConnectionValidator.NoSasClientConnectionUI.txt");
                response.setMessage(UtilMisc.getMessage((String)str, (Object)server.getName()));
                connection.setTargetID(null);
            }
        }
        catch (RemoteException re) {
            response.setReturnCode(2);
            String str = RB.getStringResource("LibraryOtherServerConnectionValidator.NoSasClientConnectionException.txt");
            response.setMessage(UtilMisc.getMessage((String)str, (Object)targetID, (Object)re));
        }
        catch (MdException me) {
            response.setReturnCode(2);
            String str = RB.getStringResource("LibraryOtherServerConnectionValidator.NoSasClientConnectionException.txt");
            response.setMessage(UtilMisc.getMessage((String)str, (Object)targetID, (Object)((Object)me)));
        }
    }

    public String getConnectionTypeName() {
        return OtherServerConnectionType.class.getName();
    }
}

