/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.library;

import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.library.LibraryExportItem;
import com.sas.metadata.logical.library.LibraryImportItem;
import com.sas.metadata.logical.library.RB;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.PromotionPropertiesFile;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.TriStateCheckBox;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.JPanel;

public class LibraryOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int m_iInitialContent;
    private TriStateCheckBox m_ckbIncludeContent;
    private SimpleLogicalObjectInterface[] m_items;
    private int m_promotionType;
    private PromotionPropertiesFile m_propertiesFile;

    public LibraryOptionsPanel(int promotionType) {
        this.m_promotionType = promotionType;
        String cbText = RB.getStringResource("LibraryOptionsPanel.moveContent.txt");
        this.m_ckbIncludeContent = new TriStateCheckBox();
        this.m_ckbIncludeContent.setSelected(true);
        this.m_ckbIncludeContent.setText(Util.getLabelWithoutMnemonic((String)cbText));
        this.m_ckbIncludeContent.setMnemonic(Util.getDisplayedMnemonic((String)cbText));
        this.m_ckbIncludeContent.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)cbText));
        this.m_ckbIncludeContent.setToolTipText(RB.getStringResource("LibraryOptionsPanel.moveContent.Tooltip.txt"));
        this.m_ckbIncludeContent.setToolTipText("tool tip text");
        this.m_ckbIncludeContent.setCycleEnabled(false);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbl.setConstraints((Component)this.m_ckbIncludeContent, gbc);
        this.add((Component)this.m_ckbIncludeContent);
    }

    public void populateExportOptions(ExportItemInterface[] items, ExportOperationInterface exportHandler) {
        this.m_items = items;
        this.m_propertiesFile = exportHandler.getPropertiesFile();
        boolean bNoXmlLibraries = true;
        boolean bAllXmlLibraries = true;
        boolean bAllInclude = true;
        boolean bNoInclude = true;
        try {
            for (int i = 0; i < this.m_items.length; ++i) {
                LibraryExportItem exportItem = (LibraryExportItem)items[i];
                String engine = exportHandler.getMetadataFactory().getOMIUtil().getMetadataSimple("SASLibrary", exportItem.getID(), "Engine");
                if (engine.equalsIgnoreCase("XML")) {
                    bNoXmlLibraries &= false;
                } else {
                    bAllXmlLibraries &= false;
                    exportItem.m_bIncludeContent = false;
                }
                bAllInclude &= exportItem.m_bIncludeContent;
                bNoInclude &= !exportItem.m_bIncludeContent;
            }
        }
        catch (MdException mde) {
            UtilGui.displayMdException((MdException)mde);
        }
        catch (RemoteException e) {
            UtilGui.displayRemoteException((RemoteException)e);
        }
        if (bNoXmlLibraries) {
            this.m_iInitialContent = 0;
            this.m_ckbIncludeContent.setEnabled(false);
        } else {
            if (bAllXmlLibraries) {
                this.m_ckbIncludeContent.setEnabled(true);
            } else {
                this.m_ckbIncludeContent.setEnabled(false);
            }
            this.m_iInitialContent = bAllInclude ? 2 : (bNoInclude ? 0 : 1);
        }
        this.m_ckbIncludeContent.setSelectedValue(this.m_iInitialContent);
    }

    public void populateImportOptions(ImportItemInterface[] items, ImportOperationInterface importHandler) {
        this.m_items = items;
        this.m_propertiesFile = importHandler.getPropertiesFile();
        boolean bAllHaveContent = true;
        boolean bNoneHaveContent = true;
        boolean bAllInclude = true;
        boolean bNoInclude = true;
        for (int i = 0; i < this.m_items.length; ++i) {
            LibraryImportItem importItem = (LibraryImportItem)items[i];
            String sOptionalContent = this.m_propertiesFile.getProperty(this.m_items[i].getID() + "Optional Content: ");
            String string = sOptionalContent = sOptionalContent == null ? "false" : sOptionalContent;
            if (sOptionalContent.equalsIgnoreCase("true")) {
                bNoneHaveContent &= false;
            } else {
                bAllHaveContent &= false;
                importItem.m_bIncludeContent = false;
            }
            bAllInclude &= importItem.m_bIncludeContent;
            bNoInclude &= !importItem.m_bIncludeContent;
        }
        if (bNoneHaveContent) {
            this.m_ckbIncludeContent.setEnabled(false);
            this.m_iInitialContent = 0;
        } else {
            if (bAllHaveContent) {
                this.m_ckbIncludeContent.setEnabled(true);
            } else {
                this.m_ckbIncludeContent.setEnabled(false);
            }
            this.m_iInitialContent = bAllInclude ? 2 : (bNoInclude ? 0 : 1);
        }
        this.m_ckbIncludeContent.setSelectedValue(this.m_iInitialContent);
    }

    public void saveSettings() {
        int iState = this.m_ckbIncludeContent.getSelectedValue();
        if (this.m_iInitialContent != iState) {
            for (int i = 0; i < this.m_items.length; ++i) {
                if (this.m_promotionType == 0) {
                    ((LibraryExportItem)this.m_items[i]).m_bIncludeContent = this.m_ckbIncludeContent.isSelected();
                    continue;
                }
                ((LibraryImportItem)this.m_items[i]).m_bIncludeContent = this.m_ckbIncludeContent.isSelected();
            }
            this.m_iInitialContent = iState;
        }
    }
}

