/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.library;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.library.Library;
import com.sas.metadata.logical.library.LibraryType;
import com.sas.metadata.logical.library.RB;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.UpgradeLogicalObjectVersionAction;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.wadmin.visuals.JOMANotesTab;
import com.sas.wadmin.visuals.WAExtAttrPropertyTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.AssignLibraryView;
import com.sas.workspace.mgmt.visuals.DBMSLibnamePropertyView;
import com.sas.workspace.mgmt.visuals.GeneralPropertyView;
import com.sas.workspace.mgmt.visuals.LibraryPropertyView;
import com.sas.workspace.visuals.WsGenericGeneralPropertyTab;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;

public class LibraryObjectFactory
implements ObjectFactoryInterface {
    private LibraryType m_type;
    private Factory m_factory;

    public LibraryObjectFactory(LibraryType type, Factory factory) {
        this.m_type = type;
        this.m_factory = factory;
    }

    public Factory getFactory() {
        return this.m_factory;
    }

    public LogicalObjectInterface createItemFromMetadataObject(Root mdo) throws RemoteException {
        return new Library((SASLibrary)mdo, (TypeInterface)this.m_type, this.m_factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllObjects(String sRepositoryFQID) throws MdException, RemoteException {
        MdObjectStore store = null;
        try {
            store = Workspace.getMdFactory().createObjectStore(null, "LibraryUtil:getAllObjects()");
            StringBuffer sb = new StringBuffer();
            sb.append("<Templates><");
            sb.append(this.m_type.getMetadataType());
            sb.append(" ");
            sb.append(this.m_factory.getTemplateFormOfRequiredAndNeededAttributes((TypeInterface)this.m_type));
            sb.append("/></Templates>");
            int fFlags = 260;
            List lLibraries = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, sRepositoryFQID, "SASLibrary", fFlags, sb.toString());
            ArrayList<LogicalObjectInterface> lObjects = new ArrayList<LogicalObjectInterface>(lLibraries.size());
            for (int iLibrary = 0; iLibrary < lLibraries.size(); ++iLibrary) {
                lObjects.add(this.createItemFromMetadataObject((Root)((SASLibrary)lLibraries.get(iLibrary))));
            }
            ArrayList<LogicalObjectInterface> arrayList = lObjects;
            return arrayList;
        }
        finally {
            store.dispose();
        }
    }

    public List getPropertyTabs(LogicalObjectInterface lob, Root mdo, Config config) throws MdException, RemoteException {
        ArrayList<Object> lTabs = new ArrayList<Object>(2);
        com.sas.workspace.mgmt.visuals.Library lib = new com.sas.workspace.mgmt.visuals.Library(Workspace.getWorkspace().getDefaultRepository().getFQID(), (DeployedDataPackage)mdo, (MdObjectStore)mdo.getObjectStore());
        GeneralPropertyView tabGeneral = new GeneralPropertyView(lib, 1);
        tabGeneral.setName(RB.getStringResource("LibraryObjectFactory.General.txt"));
        lTabs.add(tabGeneral);
        AssignLibraryView assignTab = new AssignLibraryView(lib, 1);
        assignTab.setHelpTopic("assign_tab");
        assignTab.setHelpProduct("shared");
        lTabs.add(assignTab);
        lTabs.add(new LibraryPropertyView(lib, 1));
        try {
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)mdo, null, null, "", 8);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        if (((SASLibrary)mdo).getIsDBMSLibname() == 1) {
            DBMSLibnamePropertyView libnameTab;
            if (((SASLibrary)mdo).getEngine().startsWith("REMOTE")) {
                libnameTab = new DBMSLibnamePropertyView(lib, 1);
                libnameTab.setName(RB.getStringResource("LibraryObjectFactory.ShareServer.txt"));
                lTabs.add(libnameTab);
            } else if (!((SASLibrary)lib.getDeployedDataPackage()).getEngine().equalsIgnoreCase("SASIOIME")) {
                libnameTab = new DBMSLibnamePropertyView(lib, 1);
                libnameTab.setName(RB.getStringResource("LibraryObjectFactory.DataServer.txt"));
                lTabs.add(libnameTab);
            }
        }
        lTabs.add(new JOMANotesTab(mdo));
        WAExtAttrPropertyTab eaTab = new WAExtAttrPropertyTab((CMetadata)mdo);
        eaTab.setName(RB.getStringResource("LibraryObjectFactory.ExtendedAttributes.txt"));
        lTabs.add(eaTab);
        WsGenericGeneralPropertyTab tabAdvanced = new WsGenericGeneralPropertyTab((CMetadata)mdo);
        tabAdvanced.setName(RB.getStringResource("LibraryObjectFactory.Advanced.txt"));
        lTabs.add(tabAdvanced);
        return lTabs;
    }

    public Action[] getActions(LogicalObjectInterface lobData, Root mdoData, Config config) {
        Action[] upgradeActions = new Action[]{};
        if (lobData != null && lobData.getTypeInterface().getPublicType().equals(this.m_type.getPublicType())) {
            upgradeActions = UpgradeLogicalObjectVersionAction.getActions((Frame)this.getFactory().getFrame(), (LogicalObjectInterface)lobData, (Root)mdoData);
        }
        return upgradeActions;
    }

    public Action[] getActions(LogicalObjectInterface[] aLogicalObjects, Root[] aObjects, Config config) {
        return UpgradeLogicalObjectVersionAction.NO_ACTIONS;
    }
}

