/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.library;

import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportNameValidatorInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LibraryNameValidator
implements ImportNameValidatorInterface {
    public boolean validateName(ImportItemInterface importItem, ImportOperationInterface importOperation) throws MdException {
        boolean isUnique;
        block7: {
            isUnique = true;
            try {
                String proposedName = importItem.getName();
                if (importItem.getImportState() != 1) break block7;
                List connectionPoints = importItem.getConnectionPoints();
                for (ConnectionPointInterface pt : connectionPoints) {
                    ArrayList<Object> ddpList;
                    String targetID;
                    if ("ServerContext".equals(pt.getMetadataType())) {
                        targetID = pt.getTargetID();
                        if (targetID != null) {
                            ServerContext serverContext = (ServerContext)importOperation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)importOperation.getStore(), "ServerContext", targetID, null, null, null, 264);
                            ddpList = new ArrayList<DeployedDataPackage>((Collection<DeployedDataPackage>)serverContext.getDataPackages());
                            isUnique = !this.libnameExists(ddpList, proposedName);
                        }
                    } else if ("ServerComponent".equals(pt.getMetadataType()) && (targetID = pt.getTargetID()) != null) {
                        ServerComponent serverComponent = (ServerComponent)importOperation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)importOperation.getStore(), "ServerComponent", targetID, null, null, null, 264);
                        ddpList = new ArrayList(serverComponent.getDataPackages());
                        boolean bl = isUnique = !this.libnameExists(ddpList, proposedName);
                    }
                    if (isUnique) continue;
                    break;
                }
            }
            catch (RemoteException re) {
                throw new MdException((Throwable)re);
            }
        }
        return isUnique;
    }

    private boolean libnameExists(List<DeployedDataPackage> deployedDataPackages, String proposedName) throws RemoteException {
        boolean nameExists = false;
        for (DeployedDataPackage ddp : deployedDataPackages) {
            if (!(ddp instanceof SASLibrary) || !ddp.getName().equalsIgnoreCase(proposedName)) continue;
            nameExists = true;
            break;
        }
        return nameExists;
    }
}

