/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.library;

import com.sas.metadata.logical.library.RB;
import com.sas.metadata.logical.server.AppServerConnectionType;
import com.sas.metadata.promotion.AbstractConnectionType;
import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionPropertiesInterface;
import com.sas.metadata.promotion.ConnectionSearchInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.SearchCriteria;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SASLibrary;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LibraryConnectionType
extends AbstractConnectionType
implements ConnectionPropertiesInterface,
ConnectionSearchInterface {
    private static final String PROPERTY_SERVER = "SERVER_NAME";
    private static final String PROPERTY_LIBREF = "LIBREF";
    private static final String PROPERTY_ENGINE = "ENGINE";
    private static final String PROPERTY_LIBRARY_ID = "LIBRARY_ID";
    private static final String TYPE_NAME = "Library";
    public static final String TARGET_TYPE = "TargetType";
    public static final String TARGET_ID = "TargetID";
    private static final String LIBRARY_TEMPLATE = "<Templates><SASLibrary Name=\"\" Desc=\"\" Engine=\"\" Libref=\"\"><DeployedComponents/></SASLibrary><ServerContext Name=\"\"/><ServerComponent Name=\"\"/></Templates>";
    private static final String SCHEMA_TEMPLATE = "<Templates><DatabaseSchema Name=\"\"><UsedByPackages/></DatabaseSchema><SASLibrary Name=\"\"/></Templates>";
    private static String CLASS_NAME = LibraryConnectionType.class.getName();
    private List _libraryConnectionPoints;

    public LibraryConnectionType(PromotionInterface operation) {
        super(operation);
    }

    public String getConnectionTypeName() {
        return TYPE_NAME;
    }

    public static String getTypeClassName() {
        return CLASS_NAME;
    }

    public List getSourceConnections() {
        if (this._libraryConnectionPoints == null) {
            this._libraryConnectionPoints = new ArrayList();
            ArrayList allLibraries = new ArrayList();
            List libraries = this._connectionManager.getConnections(ConnectionObjectType.PublicType, TYPE_NAME);
            List schemas = this._connectionManager.getConnections(ConnectionObjectType.MetadataType, "DatabaseSchema");
            allLibraries.addAll(libraries);
            allLibraries.addAll(schemas);
            LinkedHashMap<String, SourceConnectionInterface> libraryCache = new LinkedHashMap<String, SourceConnectionInterface>(allLibraries.size());
            for (ConnectionPointInterface pt : allLibraries) {
                SourceConnectionInterface sourceConnection;
                String id = LibraryConnectionType.getLibraryId(pt);
                if (id != null && libraryCache.containsKey(id)) {
                    sourceConnection = (SourceConnectionInterface)libraryCache.get(id);
                    if (sourceConnection == null) continue;
                    sourceConnection.addConnectionPoint(pt);
                    continue;
                }
                sourceConnection = this.createSourceConnection(pt, LibraryConnectionType.getLibraryName(pt));
                this._libraryConnectionPoints.add(sourceConnection);
                libraryCache.put(id, sourceConnection);
            }
        }
        return this._libraryConnectionPoints;
    }

    public static String getLibraryId(ConnectionPointInterface pt) {
        if (TYPE_NAME.equalsIgnoreCase(pt.getPublicType())) {
            return pt.getSourceID();
        }
        if ("DatabaseSchema".equals(pt.getMetadataType())) {
            return pt.getUserDefinedProperty(PROPERTY_LIBRARY_ID);
        }
        return null;
    }

    public String getLocalizedTypeName() {
        return RB.getStringResource("LibraryConnectionType.Type.txt");
    }

    public String getPanelName() {
        return "com.sas.metadata.logical.library.LibraryConnectionPanel";
    }

    public List getTargetConnections() throws MdException, RemoteException {
        MdFactory factory = this._operation.getMetadataFactory();
        int flags = 8580;
        List targetLibraries = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)this._operation.getStore(), this._operation.getRepositoryID(), "SASLibrary", flags, LIBRARY_TEMPLATE, false);
        ArrayList<TargetConnectionInterface> libraries = new ArrayList<TargetConnectionInterface>(targetLibraries.size());
        for (SASLibrary library : targetLibraries) {
            libraries.add(this.createTargetConnection((CMetadata)library, library.getName()));
        }
        return libraries;
    }

    public String getTargetConnectionID(ConnectionPointInterface pt, TargetConnectionInterface targetValue) throws MdException, RemoteException {
        if (targetValue.getMetadataObject() instanceof SASLibrary) {
            String targetType;
            SASLibrary targetLibrary = (SASLibrary)targetValue.getMetadataObject();
            String sourceType = pt.getMetadataType();
            DatabaseSchema targetSchema = this.getDatabaseSchema(targetLibrary);
            String string = targetType = targetSchema == null ? "SASLibrary" : "DatabaseSchema";
            if (!sourceType.equals(targetType)) {
                pt.addUserDefinedProperty(TARGET_TYPE, targetType);
                pt.addUserDefinedProperty(TARGET_ID, targetSchema == null ? targetLibrary.getId() : targetSchema.getId());
                return targetLibrary.getId();
            }
            return targetSchema == null ? targetLibrary.getId() : targetSchema.getId();
        }
        return null;
    }

    public boolean isConnectionRequired(SourceConnectionInterface connection) {
        return false;
    }

    public void analyzeConnections() throws MdException, RemoteException {
        ArrayList allLibraries = new ArrayList();
        List libraries = this._connectionManager.getConnections(ConnectionObjectType.PublicType, TYPE_NAME, true);
        List schemas = this._connectionManager.getConnections(ConnectionObjectType.MetadataType, "DatabaseSchema", true);
        allLibraries.addAll(libraries);
        allLibraries.addAll(schemas);
        for (ConnectionPointInterface pt : allLibraries) {
            DatabaseSchema schema;
            if (pt.isUnknown()) continue;
            SASLibrary library = null;
            if (TYPE_NAME.equalsIgnoreCase(pt.getPublicType())) {
                library = this.getLibrary(pt.getSourceID());
            } else if ("DatabaseSchema".equalsIgnoreCase(pt.getMetadataType()) && (library = this.getLibrary(schema = this.getDatabaseSchema(pt.getSourceID()))) != null) {
                String[] path = BIPTreeUtil.getObjectPathFromServer((MdObjectStore)this._operation.getStore(), (String)library.getId(), (String)"SASLibrary");
                String objPath = BIPTreeUtil.pathToString((String[])path, (String)library.getName(), (String)TYPE_NAME);
                pt.setSourcePath(objPath);
                pt.addUserDefinedProperty(PROPERTY_LIBRARY_ID, library.getId());
            }
            if (library == null) continue;
            AssociationList servers = library.getDeployedComponents();
            if (servers.size() > 0) {
                String serverName = ((CMetadata)servers.get(0)).getName();
                pt.addUserDefinedProperty(PROPERTY_SERVER, serverName);
            }
            pt.addUserDefinedProperty(PROPERTY_LIBREF, library.getLibref());
            pt.addUserDefinedProperty(PROPERTY_ENGINE, library.getEngine());
        }
    }

    private DatabaseSchema getDatabaseSchema(String id) throws MdException, RemoteException {
        MdFactory factory = this._operation.getMetadataFactory();
        DatabaseSchema schema = (DatabaseSchema)factory.getOMIUtil().getMetadataAllDepths((MdStore)this._operation.getStore(), "DatabaseSchema", id, null, null, SCHEMA_TEMPLATE, 4);
        return schema;
    }

    private DatabaseSchema getDatabaseSchema(SASLibrary library) throws MdException, RemoteException {
        AssociationList assocList = library.getUsingPackages();
        for (CMetadata meta : assocList) {
            if (!(meta instanceof DatabaseSchema)) continue;
            return (DatabaseSchema)meta;
        }
        return null;
    }

    private SASLibrary getLibrary(String id) throws MdException, RemoteException {
        MdFactory factory = this._operation.getMetadataFactory();
        SASLibrary library = (SASLibrary)factory.getOMIUtil().getMetadataAllDepths((MdStore)this._operation.getStore(), "SASLibrary", id, null, null, LIBRARY_TEMPLATE, 4);
        return library;
    }

    private SASLibrary getLibrary(DatabaseSchema schema) throws MdException, RemoteException {
        AssociationList assocList = schema.getUsedByPackages();
        for (CMetadata meta : assocList) {
            if (!(meta instanceof SASLibrary)) continue;
            return (SASLibrary)meta;
        }
        return null;
    }

    public static String getLibraryName(ConnectionPointInterface pt) {
        int startIndex;
        String searchAttribute;
        int index;
        if ("DatabaseSchema".equals(pt.getMetadataType()) && (index = (searchAttribute = pt.getSourceSearchString()).indexOf("@Name='", startIndex = searchAttribute.indexOf("UsedByPackages/SASLibrary"))) > -1) {
            return searchAttribute.substring(index + 7, searchAttribute.indexOf("']", index + 7));
        }
        return pt.getName();
    }

    public static String getDatabaseSchemaName(ConnectionPointInterface pt) {
        if ("SASLibrary".equals(pt.getMetadataType())) {
            return null;
        }
        if ("DatabaseSchema".equals(pt.getMetadataType())) {
            return pt.getName();
        }
        return null;
    }

    public static String getAssociatedServerName(ConnectionPointInterface pt) {
        int index;
        String searchAttribute = pt.getSourceSearchString();
        int startIndex = searchAttribute.indexOf("DeployedComponents");
        if (startIndex > -1 && (index = searchAttribute.indexOf("@Name='", startIndex)) > -1) {
            return searchAttribute.substring(index + 7, searchAttribute.indexOf(39, index + 7));
        }
        return null;
    }

    public Map getPropertyNames() {
        LinkedHashMap<String, String> propertyMap = new LinkedHashMap<String, String>(3);
        propertyMap.put(PROPERTY_SERVER, RB.getStringResource("LibraryConnectionType.Server.txt"));
        propertyMap.put(PROPERTY_LIBREF, RB.getStringResource("LibraryConnectionType.Libref.txt"));
        propertyMap.put(PROPERTY_ENGINE, RB.getStringResource("LibraryConnectionType.Engine.txt"));
        return propertyMap;
    }

    public Map getSourcePropertyValues(SourceConnectionInterface source) throws MdException, RemoteException {
        LinkedHashMap<String, String> propertyValues = new LinkedHashMap<String, String>(3);
        ConnectionPointInterface pt = source.getConnectionPoint();
        if (pt != null) {
            String engine;
            String libref;
            String serverName = pt.getUserDefinedProperty(PROPERTY_SERVER);
            if (serverName != null) {
                propertyValues.put(PROPERTY_SERVER, serverName);
            }
            if ((libref = pt.getUserDefinedProperty(PROPERTY_LIBREF)) != null) {
                propertyValues.put(PROPERTY_LIBREF, libref);
            }
            if ((engine = pt.getUserDefinedProperty(PROPERTY_ENGINE)) != null) {
                propertyValues.put(PROPERTY_ENGINE, engine);
            }
            if (serverName == null && (serverName = LibraryConnectionType.getAssociatedServerName(pt)) != null) {
                propertyValues.put(PROPERTY_SERVER, serverName);
            }
        }
        return propertyValues;
    }

    public Map getTargetPropertyValues(TargetConnectionInterface target) throws MdException, RemoteException {
        LinkedHashMap<String, String> propertyValues = new LinkedHashMap<String, String>(3);
        CMetadata meta = target.getMetadataObject();
        if (meta instanceof SASLibrary) {
            SASLibrary library = (SASLibrary)meta;
            AssociationList servers = library.getDeployedComponents();
            if (servers.size() > 0) {
                String serverName = ((CMetadata)servers.get(0)).getName();
                propertyValues.put(PROPERTY_SERVER, serverName);
            }
            propertyValues.put(PROPERTY_LIBREF, library.getLibref());
            propertyValues.put(PROPERTY_ENGINE, library.getEngine());
        }
        return propertyValues;
    }

    public boolean isContainedByFolder() {
        return true;
    }

    public SearchCriteria generateSearchCriteria(SourceConnectionInterface connection, String objectName) throws MetadataPromotionException {
        Map serverMapping;
        SearchCriteria criteria = new SearchCriteria(connection);
        criteria.setSearchType(1);
        criteria.setMetadataType("SASLibrary");
        String targetServerName = null;
        ConnectionPointInterface pt = connection.getConnectionPoint();
        String server = LibraryConnectionType.getAssociatedServerName(pt);
        ConnectionTypeInterface serverType = this._operation.getConnectionType(AppServerConnectionType.getTypeClassName());
        if (serverType != null && (serverMapping = serverType.getConnectionMapping()) != null && server != null) {
            for (SourceConnectionInterface sc : serverMapping.keySet()) {
                TargetConnectionInterface tc;
                if (!sc.getDisplayName().equals(server) || (tc = (TargetConnectionInterface)serverMapping.get(sc)) == null) continue;
                targetServerName = tc.getDisplayName();
                break;
            }
        }
        if (targetServerName == null) {
            targetServerName = server;
        }
        if (targetServerName != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("*[@Name='");
            sb.append(objectName);
            sb.append("'][DeployedComponents/*[@Name='");
            sb.append(targetServerName);
            sb.append("']]");
            criteria.setSearchString(sb.toString());
        }
        return criteria;
    }
}

