/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.library;

import com.sas.metadata.logical.library.RB;
import com.sas.metadata.logical.server.AppServerConnectionType;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.visuals.connections.AbstractConnectionPanel;
import java.util.LinkedHashMap;
import java.util.Map;

public class LibraryConnectionPanel
extends AbstractConnectionPanel {
    private static final long serialVersionUID = 1L;

    public LibraryConnectionPanel(ImportOperationInterface operation, ConnectionTypeInterface type) {
        super(operation, type);
        this.setSupportedPublicTypes(new String[]{"Library"});
    }

    public String getHelpTopicSuffix() {
        return "librarieswin";
    }

    public String getDefaultSelectionValue() {
        return RB.getStringResource("LibraryConnectionPanel.NoneSelection.txt");
    }

    public String getPanelBorderLabel() {
        return RB.getStringResource("LibraryConnectionPanel.BorderTitle.txt");
    }

    public String getPanelDescription() {
        return RB.getStringResource("LibraryConnectionPanel.Desc.txt");
    }

    public String getPanelTitle() {
        return RB.getStringResource("LibraryConnectionPanel.Title.txt");
    }

    protected boolean shouldResetTargetSelections() {
        boolean reset = false;
        ConnectionTypeInterface serverType = this._importOperation.getConnectionType(AppServerConnectionType.getTypeClassName());
        if (serverType != null) {
            Map serverTargetMapping = serverType.getConnectionMapping();
            if (this._originalParentMapping == null) {
                reset = true;
            } else {
                boolean changesMade = this.compareTargetMappings(this._originalParentMapping, serverTargetMapping);
                if (changesMade) {
                    reset = true;
                }
            }
            if (serverTargetMapping != null) {
                this._originalParentMapping = new LinkedHashMap(serverTargetMapping);
            }
        }
        return reset;
    }
}

