/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.library;

import com.sas.metadata.logical.BaseLogicalObject;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.MemberInterface;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.library.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class Library
extends BaseLogicalObject
implements MemberInterface {
    public Library(SASLibrary mdoLibrary, TypeInterface type, Factory factory) throws RemoteException {
        super((Root)mdoLibrary, type, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(OperationUserInteractionInterface deleteInterface) throws LogicalTypeException, RemoteException {
        MdObjectStore objectStore = null;
        if (!this.isDeleteAllowed()) {
            throw new UnsupportedOperationException("This object cannot be deleted.");
        }
        String progressText = this.getProgressMessageForDelete();
        deleteInterface.updateProgress(progressText);
        try {
            int choice;
            objectStore = this.getFactory().getMdFactory().createObjectStore(null, "Library.java:delete:" + this.getID());
            int flags = 16652;
            String strLibTemplate = "<Templates><SASLibrary><Tables/><UsingPackages/></SASLibrary><DatabaseSchema><Tables/></DatabaseSchema></Templates>";
            SASLibrary sasLib = (SASLibrary)this.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)objectStore, "SASLibrary", this.getID(), null, null, strLibTemplate, flags);
            ArrayList physicalTableList = new ArrayList();
            if (sasLib.getIsDBMSLibname() == 1) {
                Object obj;
                AssociationList usingPackages = sasLib.getUsingPackages();
                if (!usingPackages.isEmpty() && (obj = usingPackages.get(0)) instanceof DatabaseSchema) {
                    DatabaseSchema schema = (DatabaseSchema)usingPackages.get(0);
                    physicalTableList.addAll(schema.getTables());
                }
            } else {
                physicalTableList.addAll(sasLib.getTables());
            }
            if (physicalTableList.size() == 0) {
                boolean usingPackages = super.delete(deleteInterface);
                return usingPackages;
            }
            if (!deleteInterface.isUserInteractionSupported()) {
                choice = 3;
            } else {
                String message = null;
                message = physicalTableList.size() == 1 ? UtilMisc.getMessage((String)RB.getStringResource("Library.confirm.table.txt"), (Object)physicalTableList.get(0).toString(), (Object)sasLib.getName()) : UtilMisc.getMessage((String)RB.getStringResource("Library.confirm.tables.txt"), (Object)Integer.toString(physicalTableList.size()), (Object)sasLib.getName());
                String title = UtilMisc.getMessage((String)RB.getStringResource("Library.ShortDescription.txt"), null);
                choice = deleteInterface.displayMessage(title, message, 3, OperationUserInteractionInterface.YES_NO_CANCEL_CHOICE_SET);
            }
            if (choice == 0) {
                for (PhysicalTable table : physicalTableList) {
                    LogicalObjectInterface loi = Factory.getInstance().getObject((Root)table);
                    if (loi == null || !"Table".equals(loi.getTypeInterface().getPublicType())) continue;
                    loi.delete(deleteInterface);
                }
            }
            if (choice == 0 || choice == 3) {
                progressText = this.getProgressMessageForDelete();
                deleteInterface.updateProgress(progressText);
                this.getFactory().getMdFactory().deleteMetadataObject((CMetadata)sasLib);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (deleteInterface.continueOperationWithPrompting()) {
                String folderName = "";
                try {
                    BrowseMetadataInterface browse = this.getBrowseObject();
                    folderName = this.getFolderLocation(browse);
                }
                catch (Exception browse) {
                    // empty catch block
                }
                String messageText = null;
                messageText = folderName.length() == 0 ? UtilMisc.getMessage((String)RB.getStringResource("BLO.DelExcpOccrdNoFolder.fmt.txt"), (Object)this._ti.getDisplayType(), (Object)this.getName(), (Object)UtilMisc.getExceptionMessageText((Exception)e)) : UtilMisc.getMessage((String)RB.getStringResource("BLO.DelExcpOccrd.fmt.txt"), (Object)this._ti.getDisplayType(), (Object)this.getName(), (Object)folderName, (Object)UtilMisc.getExceptionMessageText((Exception)e));
                int choice = deleteInterface.displayMessage(RB.getStringResource("BLO.DelDlgTitle.txt"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting((OperationUserInteractionInterface)deleteInterface, (int)choice);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (objectStore != null) {
                objectStore.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String proposedName, OperationUserInteractionInterface opUI) throws LogicalTypeException {
        MdObjectStore store = null;
        String strTemplate = "<TEMPLATES><SASLibrary Name =\"\" ><DeployedComponents/> </SASLibrary><ServerContext Name =\"\" > <DataPackages /> </ServerContext> </TEMPLATES>";
        int flags = 540932;
        try {
            store = this.getFactory().getMdFactory().createObjectStore();
            SASLibrary saslib = (SASLibrary)this.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, "SASLibrary", this.getID(), null, null, strTemplate, flags);
            AssociationList serverList = saslib.getDeployedComponents();
            for (DeployedComponent server : serverList) {
                if (!(server instanceof ServerContext)) continue;
                AssociationList dpList = server.getDataPackages();
                for (DeployedDataPackage ddp : dpList) {
                    if (!(ddp instanceof SASLibrary) || !ddp.getName().equalsIgnoreCase(proposedName)) continue;
                    LogicalTypeException loe = new LogicalTypeException(UtilMisc.getMessage((String)RB.getStringResource("Library.DuplicateLibraryObjectFound.txt"), (Object)proposedName, (Object)server.getName()));
                    throw loe;
                }
            }
            super.rename(proposedName, opUI);
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        finally {
            try {
                if (store != null) {
                    store.dispose();
                }
            }
            catch (RemoteException re2) {
                Workspace.handleRemoteException((RemoteException)re2);
            }
        }
    }
}

