/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.externalfile;

import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.externalfile.ExternalFileExportItem;
import com.sas.metadata.logical.externalfile.ExternalFileImportItem;
import com.sas.metadata.logical.externalfile.RB;
import com.sas.metadata.logical.table.DefaultMergeImportItem;
import com.sas.metadata.logical.table.TableImportItem;
import com.sas.metadata.logical.table.ViewColumnsAction;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.DefaultImportItem;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.NestedImportItem;
import com.sas.metadata.promotion.NestedImportItemInterface;
import com.sas.metadata.promotion.NotificationEvent;
import com.sas.metadata.promotion.NotificationListener;
import com.sas.metadata.promotion.PromotionPropertiesFile;
import com.sas.metadata.promotion.PublicObjectPromotionOptions;
import com.sas.metadata.tools.tablecomparator.NestedItemMergeManager;
import com.sas.swing.visuals.TriStateCheckBox;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.MessageUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ExternalFileOptionsPanel
extends JPanel
implements NotificationListener {
    private static final long serialVersionUID = 1L;
    private boolean m_bDataChanged;
    private int m_iInitialContent;
    private TriStateCheckBox m_ckbContent;
    private TriStateCheckBox m_ckbKeepTargetColumns;
    private TriStateCheckBox m_ckbKeepSourceColumns;
    private JButton m_btnViewColumns;
    private ViewColumnsAction m_viewAction;
    private String m_sContentToolTip;
    private String m_sDisabledContentToolTip;
    private boolean m_bExport;
    private PublicObjectPromotionOptions.SelectionState m_keepTargetColumns = PublicObjectPromotionOptions.SelectionState.ON;
    private PublicObjectPromotionOptions.SelectionState m_keepSourceColumns = PublicObjectPromotionOptions.SelectionState.ON;
    private SimpleLogicalObjectInterface[] m_aItems;
    private PromotionPropertiesFile m_propertiesFile;
    private Map m_unMatchColumnsMapping;
    private CheckboxActionListener m_checkboxActionListener;

    public ExternalFileOptionsPanel(int iPromotionType) {
        this.m_bExport = iPromotionType != 1;
        this.m_ckbContent = new TriStateCheckBox(Util.getLabelWithoutMnemonic((String)RB.getStringResource("ExternalFileOptionsPanel.ckbContent.txt")));
        this.m_ckbContent.setMnemonic(Util.getDisplayedMnemonic((String)RB.getStringResource("ExternalFileOptionsPanel.ckbContent.txt")));
        this.m_ckbContent.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)RB.getStringResource("ExternalFileOptionsPanel.ckbContent.txt")));
        this.m_sContentToolTip = RB.getStringResource("ExternalFileOptionsPanel.ckbContent.ToolTip.txt");
        this.m_sDisabledContentToolTip = RB.getStringResource("ExternalFileOptionsPanel.ckbContent.DisabledXMLToolTip.txt");
        this.m_ckbContent.setToolTipText(RB.getStringResource("ExternalFileOptionsPanel.ckbContent.ToolTip.txt"));
        this.m_ckbContent.setCycleEnabled(false);
        this.m_ckbContent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalFileOptionsPanel.this.m_bDataChanged = true;
            }
        });
        this.m_checkboxActionListener = new CheckboxActionListener();
        this.m_ckbKeepTargetColumns = new TriStateCheckBox(Util.getLabelWithoutMnemonic((String)RB.getStringResource("ExternalFileOptionsPanel.chbMergeKeepTargetColumns.txt")));
        this.m_ckbKeepTargetColumns.setMnemonic(Util.getDisplayedMnemonic((String)RB.getStringResource("ExternalFileOptionsPanel.chbMergeKeepTargetColumns.txt")));
        this.m_ckbKeepTargetColumns.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)RB.getStringResource("ExternalFileOptionsPanel.chbMergeKeepTargetColumns.txt")));
        this.m_ckbKeepTargetColumns.setCycleEnabled(false);
        this.m_ckbKeepTargetColumns.addActionListener((ActionListener)this.m_checkboxActionListener);
        this.m_ckbKeepSourceColumns = new TriStateCheckBox(Util.getLabelWithoutMnemonic((String)RB.getStringResource("ExternalFileOptionsPanel.keep.source.columns.txt")));
        this.m_ckbKeepSourceColumns.setMnemonic(Util.getDisplayedMnemonic((String)RB.getStringResource("ExternalFileOptionsPanel.keep.source.columns.txt")));
        this.m_ckbKeepSourceColumns.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)RB.getStringResource("ExternalFileOptionsPanel.keep.source.columns.txt")));
        this.m_ckbKeepSourceColumns.setCycleEnabled(false);
        this.m_ckbKeepSourceColumns.setToolTipText(RB.getStringResource("ExternalFileOptionsPanel.ckbKeepSourceColumns.ToolTip.txt"));
        this.m_ckbKeepSourceColumns.addActionListener((ActionListener)this.m_checkboxActionListener);
        String sMergeKeepTargetColumnsToolTip = RB.getStringResource("ExternalFileOptionsPanel.chbMergeKeepTargetColumns.ToolTip.txt");
        this.m_ckbKeepTargetColumns.setToolTipText(sMergeKeepTargetColumnsToolTip);
        this.m_viewAction = new ViewColumnsAction(this);
        this.m_btnViewColumns = new JButton(this.m_viewAction);
        this.m_btnViewColumns.setMnemonic(RB.getStringResource("ExternalFileOptionsPanel.btnViewColumns.mnem").charAt(0));
        this.setLayout(new GridBagLayout());
        JPanel mergePanel = new JPanel();
        mergePanel.setLayout(new GridBagLayout());
        mergePanel.add((Component)this.m_ckbKeepTargetColumns, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        mergePanel.add((Component)this.m_ckbKeepSourceColumns, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        mergePanel.add((Component)this.m_btnViewColumns, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 3), 0, 0));
        this.add((Component)this.m_ckbContent, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)mergePanel, new GridBagConstraints(0, 1, 4, 2, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void populateExportOptions(ExportItemInterface[] aItems) {
        this.m_aItems = aItems;
        this.m_ckbContent.setSelectedValue(this.determineCheckBoxState((SimpleLogicalObjectInterface[])aItems));
        this.m_btnViewColumns.setVisible(false);
        this.m_btnViewColumns.setEnabled(false);
        this.m_ckbKeepTargetColumns.setVisible(false);
        this.m_ckbKeepSourceColumns.setVisible(false);
    }

    private int getTriStateCheckBoxStateFromState(PublicObjectPromotionOptions.SelectionState selectionState) {
        boolean isToggle = false;
        switch (selectionState) {
            case ON: {
                return isToggle ? 0 : 2;
            }
            case OFF: {
                return isToggle ? 2 : 0;
            }
        }
        return 1;
    }

    public void populateImportOptions(ImportItemInterface[] aItems, PromotionPropertiesFile propertiesFile) {
        this.m_aItems = aItems;
        boolean isEnableUnmatchedView = false;
        boolean isSupportedVersion = false;
        this.m_ckbKeepTargetColumns.setVisible(true);
        this.m_ckbKeepSourceColumns.setVisible(true);
        ImportOperationInterface importHandler = null;
        boolean bNoContent = true;
        for (int i = 0; i < aItems.length; ++i) {
            String sOptionalContent;
            if (importHandler == null) {
                importHandler = aItems[0].getImportOperation();
            }
            if (!"true".equals(sOptionalContent = propertiesFile.getProperty(aItems[i].getID() + "Content"))) continue;
            bNoContent = false;
            break;
        }
        if (bNoContent) {
            this.m_ckbContent.setSelectedValue(0);
            this.m_ckbContent.setEnabled(false);
        } else {
            this.m_ckbContent.setEnabled(true);
            this.m_iInitialContent = this.determineCheckBoxState((SimpleLogicalObjectInterface[])aItems);
            this.m_ckbContent.setSelectedValue(this.m_iInitialContent);
        }
        this.m_ckbContent.setEnabled(!bNoContent);
        this.m_ckbContent.setSelectedValue(this.determineCheckBoxState((SimpleLogicalObjectInterface[])aItems));
        if (aItems != null) {
            for (ImportItemInterface item : aItems) {
                if (1 == item.getImportState()) continue;
                isEnableUnmatchedView = true;
                break;
            }
        }
        if (importHandler.getPackageFileVersion() >= 9200) {
            isSupportedVersion = true;
        }
        if (isEnableUnmatchedView) {
            this.m_ckbKeepTargetColumns.setEnabled(true);
            this.m_ckbKeepSourceColumns.setEnabled(true);
            this.updateVisualComponents();
            isEnableUnmatchedView = this.enableUnmatchedView(importHandler);
        } else {
            this.updateSelectionStateToOff();
        }
        if (!isSupportedVersion) {
            this.updateSelectionStateToOff();
        }
        this.m_btnViewColumns.setEnabled(isEnableUnmatchedView);
    }

    private void updateSelectionStateToOff() {
        this.m_ckbKeepTargetColumns.setSelectedValue(0);
        this.m_ckbKeepSourceColumns.setSelectedValue(0);
        this.m_ckbKeepTargetColumns.setEnabled(false);
        this.m_ckbKeepSourceColumns.setEnabled(false);
        this.m_bDataChanged = true;
        this.saveSettings();
    }

    private void updateVisualComponents() {
        boolean keepTarget = false;
        boolean keepNew = false;
        if (this.m_aItems.length == 1) {
            ExternalFileImportItem tableItem = (ExternalFileImportItem)this.m_aItems[0];
            this.m_keepTargetColumns = tableItem.getStateOfKeepDeletedOption();
            this.m_keepSourceColumns = tableItem.getStateOfKeepNewOption();
            if (!tableItem.isMerged()) {
                this.initChangeAnalysisOptions(tableItem);
            }
            if (tableItem.getMergeProperties().hasDeletedColumns()) {
                this.m_keepTargetColumns = tableItem.getStateOfKeepDeletedOption();
                keepTarget = true;
            }
            if (tableItem.getMergeProperties().hasNewColumns()) {
                this.m_keepSourceColumns = tableItem.getStateOfKeepNewOption();
                keepNew = true;
            }
        } else {
            this.m_keepTargetColumns = ((ExternalFileImportItem)this.m_aItems[0]).getStateOfKeepDeletedOption();
            this.m_keepSourceColumns = ((ExternalFileImportItem)this.m_aItems[0]).getStateOfKeepNewOption();
            if (!keepTarget || !keepNew) {
                if (!((TableImportItem)this.m_aItems[0]).isMerged()) {
                    this.initChangeAnalysisOptions((TableImportItem)this.m_aItems[0]);
                }
                keepTarget = keepTarget || ((TableImportItem)this.m_aItems[0]).getMergeProperties().hasDeletedColumns();
                keepNew = keepNew || ((TableImportItem)this.m_aItems[0]).getMergeProperties().hasNewColumns();
            }
            block22: for (int i = 1; i < this.m_aItems.length && (PublicObjectPromotionOptions.SelectionState.MIXED != this.m_keepTargetColumns || PublicObjectPromotionOptions.SelectionState.MIXED != this.m_keepSourceColumns); ++i) {
                ExternalFileImportItem item = (ExternalFileImportItem)this.m_aItems[i];
                if (!keepTarget || !keepNew) {
                    if (!item.isMerged()) {
                        this.initChangeAnalysisOptions(item);
                    }
                    keepTarget = keepTarget || item.getMergeProperties().hasDeletedColumns();
                    boolean bl = keepNew = keepNew || item.getMergeProperties().hasNewColumns();
                }
                if (PublicObjectPromotionOptions.SelectionState.MIXED != this.m_keepTargetColumns) {
                    block0 : switch (item.getStateOfKeepDeletedOption()) {
                        case ON: {
                            switch (this.m_keepTargetColumns) {
                                case ON: {
                                    break block0;
                                }
                            }
                            this.m_keepTargetColumns = PublicObjectPromotionOptions.SelectionState.MIXED;
                            break;
                        }
                        case OFF: {
                            switch (this.m_keepTargetColumns) {
                                case OFF: {
                                    break block0;
                                }
                            }
                            this.m_keepTargetColumns = PublicObjectPromotionOptions.SelectionState.MIXED;
                            break;
                        }
                        case MIXED: {
                            this.m_keepTargetColumns = PublicObjectPromotionOptions.SelectionState.MIXED;
                            break;
                        }
                    }
                }
                if (PublicObjectPromotionOptions.SelectionState.MIXED == this.m_keepSourceColumns) continue;
                switch (item.getStateOfKeepNewOption()) {
                    case ON: {
                        switch (this.m_keepSourceColumns) {
                            case ON: {
                                continue block22;
                            }
                        }
                        this.m_keepSourceColumns = PublicObjectPromotionOptions.SelectionState.MIXED;
                        continue block22;
                    }
                    case OFF: {
                        switch (this.m_keepSourceColumns) {
                            case OFF: {
                                continue block22;
                            }
                        }
                        this.m_keepSourceColumns = PublicObjectPromotionOptions.SelectionState.MIXED;
                        continue block22;
                    }
                    case MIXED: {
                        this.m_keepSourceColumns = PublicObjectPromotionOptions.SelectionState.MIXED;
                        continue block22;
                    }
                }
            }
        }
        if (!keepNew) {
            this.m_ckbKeepSourceColumns.setEnabled(false);
            this.m_ckbKeepSourceColumns.setSelectedValue(0);
        } else {
            this.m_ckbKeepSourceColumns.setEnabled(true);
            this.m_ckbKeepSourceColumns.setSelectedValue(this.getTriStateCheckBoxStateFromState(this.m_keepSourceColumns));
        }
        if (!keepTarget) {
            this.m_ckbKeepTargetColumns.setEnabled(false);
            this.m_ckbKeepTargetColumns.setSelectedValue(0);
        } else {
            this.m_ckbKeepTargetColumns.setEnabled(true);
            this.m_ckbKeepTargetColumns.setSelectedValue(this.getTriStateCheckBoxStateFromState(this.m_keepTargetColumns));
        }
        this.m_ckbKeepSourceColumns.repaint();
        this.m_ckbKeepTargetColumns.repaint();
    }

    private void initChangeAnalysisOptions(DefaultMergeImportItem table) {
        if (table != null && !table.isMerged()) {
            NestedItemMergeManager manager = NestedItemMergeManager.getInstance((ImportItemInterface)table);
            manager.mergeColumns((ImportItemInterface)table);
        }
    }

    private boolean enableUnmatchedView(ImportOperationInterface importHandler) {
        boolean returnValue;
        block5: {
            returnValue = false;
            if (this.m_aItems != null && this.m_aItems.length > 0 && importHandler != null) {
                DefaultImportItem item = (DefaultImportItem)this.m_aItems[0];
                Log logger = item.getImportOperation().getLogger();
                AbstractImportListener listener = (AbstractImportListener)item.getImportOperation().getImportListener(item.getTypeInterface().getPublicType());
                try {
                    List<SimpleLogicalObjectInterface> objects = Arrays.asList(this.m_aItems);
                    this.m_viewAction.setListenerAndHandler(listener, item.getImportOperation(), objects);
                    if (listener != null && item.getImportOperation() != null) {
                        returnValue = true;
                        break block5;
                    }
                    returnValue = false;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                returnValue = false;
            }
        }
        return returnValue;
    }

    public void saveSettings() {
        int i;
        if (!this.m_bDataChanged) {
            return;
        }
        for (int i2 = 0; i2 < this.m_aItems.length; ++i2) {
            if (this.m_bExport) {
                ((ExternalFileExportItem)this.m_aItems[i2]).m_bContentIncluded = this.m_ckbContent.isSelected();
                continue;
            }
            ((ExternalFileImportItem)this.m_aItems[i2]).setContentIncluded(this.m_ckbContent.isSelected());
        }
        int iState = this.m_ckbContent.getSelectedValue();
        if (this.m_iInitialContent != iState) {
            for (i = 0; i < this.m_aItems.length; ++i) {
                if (this.m_bExport) {
                    ((ExternalFileExportItem)this.m_aItems[i]).m_bContentIncluded = this.m_ckbContent.isSelected();
                    continue;
                }
                ((ExternalFileImportItem)this.m_aItems[i]).setContentIncluded(this.m_ckbContent.isSelected());
            }
            this.m_iInitialContent = iState;
        }
        this.m_bDataChanged = false;
        if (!this.m_bExport) {
            for (i = 0; i < this.m_aItems.length; ++i) {
                PublicObjectPromotionOptions.SelectionState selectionState = this.getStateFromTriStateCheckBox(this.m_ckbKeepTargetColumns);
                if (selectionState != PublicObjectPromotionOptions.SelectionState.MIXED) {
                    ((ExternalFileImportItem)this.m_aItems[i]).setStateOfKeepDeletedOption(selectionState);
                }
                if ((selectionState = this.getStateFromTriStateCheckBox(this.m_ckbKeepSourceColumns)) == PublicObjectPromotionOptions.SelectionState.MIXED) continue;
                ((ExternalFileImportItem)this.m_aItems[i]).setStateOfKeepNewOption(selectionState);
            }
        }
    }

    private PublicObjectPromotionOptions.SelectionState getStateFromTriStateCheckBox(TriStateCheckBox checkBox) {
        int state = checkBox.getSelectedValue();
        boolean isToggle = false;
        switch (state) {
            case 2: {
                return isToggle ? PublicObjectPromotionOptions.SelectionState.OFF : PublicObjectPromotionOptions.SelectionState.ON;
            }
            case 0: {
                return isToggle ? PublicObjectPromotionOptions.SelectionState.ON : PublicObjectPromotionOptions.SelectionState.OFF;
            }
        }
        return PublicObjectPromotionOptions.SelectionState.MIXED;
    }

    private int determineCheckBoxState(SimpleLogicalObjectInterface[] aItems) {
        boolean bAllOn = true;
        boolean bAllOff = true;
        for (int i = 0; i < this.m_aItems.length; ++i) {
            boolean bOn = this.m_bExport ? ((ExternalFileExportItem)this.m_aItems[i]).m_bContentIncluded : ((ExternalFileImportItem)this.m_aItems[i]).isContentIncluded();
            bAllOn &= bOn;
            bAllOff &= !bOn;
        }
        if (bAllOn) {
            return 2;
        }
        if (bAllOff) {
            return 0;
        }
        return 1;
    }

    public void notify(NotificationEvent event) {
        if (event != null && event.getEventType() == 290) {
            this.updateVisualComponents();
        } else if (event != null && event.getEventType() == 260) {
            List eventItems = event.getAssociatedPromotionItems();
            if (eventItems.get(0) instanceof ExternalFileImportItem) {
                this.m_ckbKeepTargetColumns.setSelectedValue(2);
                this.m_ckbKeepSourceColumns.setSelectedValue(2);
            }
            boolean stateOfExternalFile = false;
            for (int i = 0; i < eventItems.size(); ++i) {
                if (!(eventItems.get(i) instanceof ExternalFileImportItem)) continue;
                stateOfExternalFile = true;
            }
            if (this.isImportStateUpdate(eventItems) && stateOfExternalFile) {
                MessageUtil.displayMessage((String)RB.getStringResource("ExternalFileOptionsPanel.pathmodified.txt"), (int)2);
                ((ImportItemInterface)eventItems.get(0)).getImportOperation().getLogger().info((Object)RB.getStringResource("ExternalFileOptionsPanel.pathmodified.txt"));
            }
            this.ModifyNestedItemStateToOriginal(eventItems);
        }
    }

    private boolean isImportStateUpdate(List<ImportItemInterface> lstModifiedPromotionItem) {
        for (ImportItemInterface item : lstModifiedPromotionItem) {
            if (2 != item.getImportState()) continue;
            return true;
        }
        return false;
    }

    private void ModifyNestedItemStateToOriginal(List<ImportItemInterface> lstModifiedPromotionItem) {
        for (ImportItemInterface importItem : lstModifiedPromotionItem) {
            if (!importItem.containsNestedItems()) continue;
            List lstNested = importItem.getNestedItems();
            this.changeNestedItemStateToDefault(lstNested);
        }
    }

    private void changeNestedItemStateToDefault(List<NestedImportItemInterface> lstNested) {
        for (int i = 0; i < lstNested.size(); ++i) {
            NestedImportItem item = (NestedImportItem)lstNested.get(i);
            item.setImportState(-1);
        }
    }

    private boolean IfNestedItemStateChanged(List<NestedImportItemInterface> lstNested) {
        boolean flag = false;
        for (int i = 0; i < lstNested.size(); ++i) {
            boolean state;
            NestedImportItem item = (NestedImportItem)lstNested.get(i);
            boolean bl = state = item.getImportState() > -1;
            if (!state) continue;
            flag = state;
            break;
        }
        return flag;
    }

    private class CheckboxActionListener
    implements ActionListener {
        private CheckboxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExternalFileOptionsPanel.this.m_bDataChanged = true;
            ExternalFileOptionsPanel.this.saveSettings();
        }
    }
}

