/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.externalfile;

import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.externalfile.ExternalFileExportItem;
import com.sas.metadata.logical.externalfile.ExternalFileImportListener;
import com.sas.metadata.logical.externalfile.ExternalFileOptionsPanel;
import com.sas.metadata.logical.externalfile.RB;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ContentHelper;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionPropertiesFile;
import com.sas.metadata.promotion.visuals.PromotionOptionsInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASFileRef;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.TransportException;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.omg.CORBA.StringHolder;

public class ExternalFileExportListener
extends AbstractExportListener
implements PromotionOptionsInterface {
    private ExternalFileOptionsPanel m_pnlOptions;
    private Map m_mapContentInfo;
    private List m_jobContentList;

    public ExternalFileExportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getConnectionTypes() {
        return ExternalFileImportListener.CONNECTION_TYPES;
    }

    public ExportItemInterface createExportItem(String name, String id, TransportableTypeInterface type) {
        return new ExternalFileExportItem(name, id, type);
    }

    public JPanel getOptionsPanel(ExportItemInterface[] aItems, ExportOperationInterface exportHandler) {
        if (this.m_pnlOptions == null) {
            this.m_pnlOptions = new ExternalFileOptionsPanel(exportHandler.getPromotionType());
        }
        this.m_pnlOptions.populateExportOptions(aItems);
        return this.m_pnlOptions;
    }

    public JPanel getOptionsPanel(ImportItemInterface[] aItems, ImportOperationInterface importHandler) {
        return null;
    }

    public void saveSettings() {
        this.m_pnlOptions.saveSettings();
    }

    public int exportContent(ExportOperationInterface operation, List objects) throws TransportException, IOException, MdException, RemoteException {
        Log exportLogger = operation.getLogger();
        int iRC = 0;
        this.m_mapContentInfo = new HashMap();
        this.m_jobContentList = new ArrayList();
        int iOptions = 284;
        for (ExportItemInterface etExportItem : objects) {
            this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("ExternalFileExportListener.StatusIndicator.fmt"), (Object)etExportItem.getName()));
            ExternalTable mdET = (ExternalTable)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)operation.getStore(), "ExternalTable", etExportItem.getID(), null, null, "<Templates><ExternalTable><OwningFile/><TargetTransformations/></ExternalTable><ClassifierMap><TransformationSources/></ClassifierMap><File><DeployedComponents/><FileRefs/><TargetTransformations/></File><SASFileRef><DeployedComponents/></SASFileRef></Templates>", iOptions);
            if (mdET == null) continue;
            this.searchETForContent(mdET, etExportItem, operation.getPropertiesFile(), exportLogger);
        }
        for (ServerContext mdSC : this.m_mapContentInfo.keySet()) {
            int iTempRC;
            List lContentInfo = (List)this.m_mapContentInfo.get(mdSC);
            if (lContentInfo == null || lContentInfo.isEmpty() || (iTempRC = this.retrieveContentFromServer(mdSC, lContentInfo, operation, exportLogger)) <= iRC) continue;
            iRC = iTempRC;
        }
        return iRC;
    }

    private boolean searchETForContent(ExternalTable mdET, ExportItemInterface efExportItem, PromotionPropertiesFile propertiesFile, Log exportLogger) throws MdException, RemoteException {
        boolean bContentFound = false;
        ServerContext mdDefaultSC = null;
        List lContentInfo = null;
        File mdPhysFile = mdET.getOwningFile();
        if (mdPhysFile == null) {
            return bContentFound;
        }
        AssociationList lFileRefs = mdPhysFile.getFileRefs();
        if (!lFileRefs.isEmpty()) {
            SASFileRef mdFileRef = (SASFileRef)lFileRefs.get(0);
            AssociationList lSCs = mdFileRef.getDeployedComponents();
            for (Object object : lSCs) {
                if (!(object instanceof ServerContext)) continue;
                mdDefaultSC = (ServerContext)object;
            }
            if (mdDefaultSC == null) {
                return bContentFound;
            }
            if (((ExternalFileExportItem)efExportItem).m_bContentIncluded) {
                lContentInfo = this.getContentListForServer(mdDefaultSC);
                lContentInfo.add(new EFContentInfo(efExportItem.getName(), efExportItem.getID(), mdPhysFile.getFileName(), "###PHYSICAL###", true));
                bContentFound = true;
                propertiesFile.addProperty(efExportItem.getID() + "Content", "true");
            }
        }
        AssociationList lCMs = mdET.getTargetTransformations();
        for (Root mdTransformation : lCMs) {
            ServerContext mdSourceFileSC;
            AssociationList lSourceFileSCs;
            File mdSourceFile;
            if (!(mdTransformation instanceof ClassifierMap)) continue;
            ClassifierMap mdCM = (ClassifierMap)mdTransformation;
            if ("FormatFile".equals(mdCM.getTransformRole())) {
                AssociationList lFiles = mdCM.getTransformationSources();
                if (lFiles.isEmpty()) continue;
                File mdEFFFile = (File)lFiles.get(lFiles.size() - 1);
                ServerContext mdEFFSC = mdDefaultSC;
                AssociationList lEFFSCs = mdEFFFile.getDeployedComponents();
                if (!lEFFSCs.isEmpty()) {
                    mdEFFSC = (ServerContext)lEFFSCs.get(0);
                }
                lContentInfo = this.getContentListForServer(mdEFFSC);
                lContentInfo.add(new EFContentInfo(efExportItem.getName(), efExportItem.getID(), mdEFFFile.getFileName(), "###EFF###", false));
                bContentFound = true;
                AssociationList lCobolCMs = mdEFFFile.getTargetTransformations();
                for (ClassifierMap mdCobolCM : lCobolCMs) {
                    AssociationList lCobolFiles;
                    if (!"CobolFormatFile".equals(mdCobolCM.getTransformRole()) || (lCobolFiles = mdCobolCM.getTransformationSources()).isEmpty()) continue;
                    File mdCopyBookFile = (File)lCobolFiles.get(lCobolFiles.size() - 1);
                    ServerContext mdCopyBookSC = mdDefaultSC;
                    AssociationList lCopyBookSCs = mdEFFFile.getDeployedComponents();
                    if (!lCopyBookSCs.isEmpty()) {
                        mdCopyBookSC = (ServerContext)lCopyBookSCs.get(0);
                    }
                    lContentInfo = this.getContentListForServer(mdCopyBookSC);
                    lContentInfo.add(new EFContentInfo(efExportItem.getName(), efExportItem.getID(), mdCopyBookFile.getFileName(), "###COPYBOOK###", false));
                }
                continue;
            }
            if (!"UserWrittenSourceCode".equals(mdCM.getTransformRole())) continue;
            AssociationList lSourceFiles = mdCM.getTransformationSources();
            if (!lSourceFiles.isEmpty() && lSourceFiles.get(0) instanceof File) {
                mdSourceFile = (File)lSourceFiles.get(0);
                lSourceFileSCs = mdSourceFile.getDeployedComponents();
                if (lSourceFileSCs.isEmpty()) {
                    if (exportLogger.isDebugEnabled()) {
                        exportLogger.debug((Object)("No ServerContext found on ExternalTable " + mdET.getFQID()));
                    }
                    return bContentFound;
                }
                mdSourceFileSC = (ServerContext)lSourceFileSCs.get(0);
                lContentInfo = this.getContentListForServer(mdSourceFileSC);
                lContentInfo.add(new EFContentInfo(efExportItem.getName(), efExportItem.getID(), mdSourceFile.getFileName(), "###SOURCE###", true));
                bContentFound = true;
            }
            if ((lSourceFiles = mdCM.getSourceCodes()).isEmpty() || !(lSourceFiles.get(0) instanceof File)) continue;
            mdSourceFile = (File)lSourceFiles.get(0);
            lSourceFileSCs = mdSourceFile.getDeployedComponents();
            if (lSourceFileSCs.isEmpty()) {
                if (exportLogger.isDebugEnabled()) {
                    exportLogger.debug((Object)("No ServerContext found on ExternalTable " + mdET.getFQID()));
                }
                return bContentFound;
            }
            mdSourceFileSC = (ServerContext)lSourceFileSCs.get(0);
            lContentInfo = this.getContentListForServer(mdSourceFileSC);
            lContentInfo.add(new EFContentInfo(efExportItem.getName(), efExportItem.getID(), mdSourceFile.getFileName(), "###SOURCE###", true));
            bContentFound = true;
        }
        if (bContentFound) {
            this.m_jobContentList.add(efExportItem.getID());
        }
        return bContentFound;
    }

    private List getContentListForServer(ServerContext mdSC) {
        ArrayList lContentInfo = (ArrayList)this.m_mapContentInfo.get(mdSC);
        if (lContentInfo == null) {
            lContentInfo = new ArrayList();
            this.m_mapContentInfo.put(mdSC, lContentInfo);
        }
        return lContentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int retrieveContentFromServer(ServerContext mdSC, List lContentInfo, ExportOperationInterface operation, Log exportLogger) throws RemoteException {
        int iRC = 0;
        WsAppServer appServer = null;
        try {
            appServer = ContentHelper.openAppServerConnection((PromotionInterface)operation, (ServerContext)mdSC);
            ContentHandlerInterface contentHandler = operation.getContentHandler();
            ArrayList<String> uniqueFiles = new ArrayList<String>();
            for (EFContentInfo efContentInfo : lContentInfo) {
                String uniqueID = efContentInfo.m_sID + efContentInfo.m_sKey;
                if (uniqueFiles.contains(uniqueID)) continue;
                uniqueFiles.add(uniqueID);
                try {
                    IFileService fileService = appServer.getWorkspace().FileService();
                    IFileref fileRef = fileService.AssignFileref("TEMPREF", "DISK", efContentInfo.m_sPath, "", new StringHolder());
                    IBinaryStream inStream = fileRef.OpenBinaryStream(StreamOpenMode.StreamOpenModeForReading);
                    InputStream stream = contentHandler.getInputStream(inStream);
                    contentHandler.addBinaryContent(efContentInfo.m_sID, efContentInfo.m_sKey, stream);
                    fileService.DeassignFileref("TEMPREF");
                    exportLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("ExternalFileExportListener.ExportInfo.fmt"), (Object)efContentInfo.m_sPath, (Object)mdSC.getName(), (Object)efContentInfo.m_sName));
                }
                catch (Exception e) {
                    if (!efContentInfo.m_bRequired) {
                        iRC = 4;
                        exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("ExternalFileExportListener.ExportError.fmt"), (Object)efContentInfo.m_sPath, (Object)mdSC.getName(), (Object)efContentInfo.m_sName, (Object)e.getMessage()));
                        continue;
                    }
                    iRC = 8;
                    exportLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("ExternalFileExportListener.ExportError.fmt"), (Object)efContentInfo.m_sPath, (Object)mdSC.getName(), (Object)efContentInfo.m_sName, (Object)e.getMessage()));
                }
            }
        }
        catch (WsAppServerFailException e) {
            iRC = 8;
            exportLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("ExternalFileExportListener.ServerError.fmt"), (Object)mdSC.getName(), (Object)e.getMessage()));
        }
        finally {
            if (appServer != null) {
                appServer.dispose();
            }
        }
        return iRC;
    }

    private class EFContentInfo {
        String m_sName;
        String m_sID;
        String m_sPath;
        String m_sKey;
        boolean m_bRequired = true;

        EFContentInfo(String sName, String sID, String sPath, String sKey, boolean bRequired) {
            this.m_sName = sName;
            this.m_sID = sID;
            this.m_sPath = sPath;
            this.m_sKey = sKey;
            this.m_bRequired = bRequired;
        }
    }
}

