/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.comparison.visual;

import com.sas.metadata.logical.comparison.ComparisonResultNodeInterface;
import com.sas.metadata.logical.comparison.visual.ComparisonMainPanel;
import com.sas.metadata.logical.comparison.visual.ComparisonTreeNode;
import com.sas.metadata.logical.comparison.visual.RB;
import com.sas.metadata.tools.tablecomparator.PromotionComparisonNodeInterface;
import com.sas.swing.visuals.LabelView;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.workspace.WAPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.tree.TreeNode;

public class NodeSummaryPanel
extends WAPanel {
    private LabelView _titleLabel;
    private WAPanel _infoPanel;
    private WAPanel _fillerPanel;
    private int _version;

    public NodeSummaryPanel() {
        this.initialize();
    }

    public NodeSummaryPanel(ComparisonTreeNode ctn) {
        this();
        this.buildSummary(ctn);
    }

    public void setversion(int version) {
        this._version = version;
    }

    protected void initialize() {
        super.initialize();
        this._titleLabel = this.getNewLabelViewObject();
        this._infoPanel = new WAPanel();
        this._fillerPanel = new WAPanel();
    }

    private LabelView getNewLabelViewObject() {
        LabelView labelView = new LabelView();
        labelView.setLineWrap(true);
        labelView.setWrapStyleWord(true);
        labelView.setHorizontalTextPosition(2);
        labelView.setVerticalTextPosition(1);
        return labelView;
    }

    public void buildSummary(ComparisonTreeNode ctn) {
        this.removeAll();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(0, 1, 5, 10, true, true, true);
        this.setLayout((LayoutManager)layout);
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        if (ctn.isNodeTypeAssociation()) {
            Enumeration<TreeNode> childNodes = ctn.children();
            if (childNodes != null && childNodes.hasMoreElements()) {
                this._titleLabel.setText(Message.format((String)RB.getStringResource("NodeSummaryPanel.Total.Number.Of.Items.fmt.txt"), (Object[])new Object[]{ctn.getName(), ctn.getChildCount()}));
                this.add((Component)this._titleLabel);
                if (ctn.getName().contains("Column")) {
                    LabelView lblName;
                    Iterator it;
                    WAPanel pnlSubCategory;
                    ArrayList<String> lstAdded = new ArrayList<String>();
                    ArrayList<String> lstModified = new ArrayList<String>();
                    ArrayList<String> lstDeleted = new ArrayList<String>();
                    while (childNodes.hasMoreElements()) {
                        ComparisonResultNodeInterface childCrn;
                        ComparisonTreeNode child = (ComparisonTreeNode)childNodes.nextElement();
                        if (!child.isNodeTypeLogicalObject() || !((childCrn = child.getComparisonResultNode()) instanceof PromotionComparisonNodeInterface)) continue;
                        PromotionComparisonNodeInterface childPcn = (PromotionComparisonNodeInterface)childCrn;
                        PromotionComparisonNodeInterface.ImportState importState = childPcn.getImportstate();
                        String name = childPcn.getObjectName();
                        if (importState != null) {
                            int state = importState.getState();
                            if (state == 1) {
                                lstAdded.add(name);
                                continue;
                            }
                            if (state == 2) {
                                lstModified.add(name);
                                continue;
                            }
                            if (state != 3) continue;
                            lstDeleted.add(name);
                            continue;
                        }
                        ComparisonMainPanel.LOGGER.info((Object)Message.format((String)RB.getStringResource("NodeSummaryPanel.ImportStateNull.fmt.txt"), (Object)name));
                    }
                    this._infoPanel.removeAll();
                    AutoSizingGridLayout level1Layout = new AutoSizingGridLayout(0, 1, 0, 0, true, true, true);
                    this._infoPanel.setLayout((LayoutManager)level1Layout);
                    AutoSizingGridLayout level2Layout = new AutoSizingGridLayout(0, 1, 0, 0, true, true, true);
                    int iMarginLabelTop = 0;
                    int iMarginLevel1 = 20;
                    int iMarginLevel2 = 50;
                    if (!lstAdded.isEmpty()) {
                        LabelView lblViewInfo = this.getNewLabelViewObject();
                        lblViewInfo.setText(RB.getStringResource("NodeSummaryPanel.New.Items.txt"));
                        if (this._version < 9200) {
                            lblViewInfo.setText(RB.getStringResource("NodeSummaryPanel.packagebefore92.New.Items.txt"));
                        }
                        lblViewInfo.setBorder(BorderFactory.createEmptyBorder(iMarginLabelTop, iMarginLevel1, 0, 0));
                        lblViewInfo.setPreferredSpanSize(new Dimension(40, 40));
                        this._infoPanel.add((Component)lblViewInfo);
                        iMarginLabelTop = 10;
                        pnlSubCategory = new WAPanel();
                        pnlSubCategory.setLayout((LayoutManager)level2Layout);
                        it = lstAdded.iterator();
                        while (it.hasNext()) {
                            lblName = this.getNewLabelViewObject();
                            lblName.setText(Message.format((String)RB.getStringResource("NodeSummaryPanel.Dashed.Item.fmt.txt"), it.next()));
                            lblName.setBorder(BorderFactory.createEmptyBorder(0, iMarginLevel2, 0, 0));
                            pnlSubCategory.add((Component)lblName);
                        }
                        lblName = this.getNewLabelViewObject();
                        pnlSubCategory.add((Component)lblName);
                        this._infoPanel.add((Component)pnlSubCategory);
                    }
                    if (!lstModified.isEmpty()) {
                        LabelView lblViewInfo = this.getNewLabelViewObject();
                        lblViewInfo.setText(RB.getStringResource("NodeSummaryPanel.Modified.Items.txt"));
                        if (this._version < 9200) {
                            lblViewInfo.setText(RB.getStringResource("NodeSummaryPanel.packagebefore92.Modified.Items.txt"));
                        }
                        lblViewInfo.setBorder(BorderFactory.createEmptyBorder(iMarginLabelTop, iMarginLevel1, 0, 0));
                        lblViewInfo.setPreferredSpanSize(new Dimension(40, 40));
                        this._infoPanel.add((Component)lblViewInfo);
                        iMarginLabelTop = 10;
                        pnlSubCategory = new WAPanel();
                        pnlSubCategory.setLayout((LayoutManager)level2Layout);
                        it = lstModified.iterator();
                        while (it.hasNext()) {
                            lblName = this.getNewLabelViewObject();
                            lblName.setText(Message.format((String)RB.getStringResource("NodeSummaryPanel.Dashed.Item.fmt.txt"), it.next()));
                            lblName.setBorder(BorderFactory.createEmptyBorder(0, iMarginLevel2, 0, 0));
                            pnlSubCategory.add((Component)lblName);
                        }
                        lblName = this.getNewLabelViewObject();
                        pnlSubCategory.add((Component)lblName);
                        this._infoPanel.add((Component)pnlSubCategory);
                    }
                    if (!lstDeleted.isEmpty()) {
                        LabelView lblViewInfo = this.getNewLabelViewObject();
                        lblViewInfo.setText(RB.getStringResource("NodeSummaryPanel.Deleted.Items.txt"));
                        if (this._version < 9200) {
                            lblViewInfo.setText(RB.getStringResource("NodeSummaryPanel.packagebefore92.Deleted.Items.txt"));
                        }
                        lblViewInfo.setBorder(BorderFactory.createEmptyBorder(iMarginLabelTop, iMarginLevel1, 0, 0));
                        lblViewInfo.setPreferredSpanSize(new Dimension(40, 40));
                        this._infoPanel.add((Component)lblViewInfo);
                        pnlSubCategory = new WAPanel();
                        pnlSubCategory.setLayout((LayoutManager)level2Layout);
                        it = lstDeleted.iterator();
                        while (it.hasNext()) {
                            lblName = this.getNewLabelViewObject();
                            lblName.setText(Message.format((String)RB.getStringResource("NodeSummaryPanel.Dashed.Item.fmt.txt"), it.next()));
                            lblName.setBorder(BorderFactory.createEmptyBorder(0, iMarginLevel2, 0, 0));
                            pnlSubCategory.add((Component)lblName);
                        }
                        lblName = this.getNewLabelViewObject();
                        pnlSubCategory.add((Component)lblName);
                        this._infoPanel.add((Component)pnlSubCategory);
                    }
                    this.add((Component)this._infoPanel);
                }
            } else {
                this._titleLabel.setText(Message.format((String)RB.getStringResource("NodeSummaryPanel.No.Items.To.Summerize.fmt.txt"), (Object)ctn.getParent()));
                this.add((Component)this._titleLabel);
            }
            this.add((Component)this._fillerPanel);
        }
    }
}

