/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.comparison.visual;

import com.sas.metadata.logical.comparison.AttributeComparisonResult;
import com.sas.metadata.logical.comparison.ComparisonControllerInterface;
import com.sas.metadata.logical.comparison.ComparisonResultNodeInterface;
import com.sas.metadata.logical.comparison.visual.ComparisonCheckBoxTreeCellRenderer;
import com.sas.metadata.logical.comparison.visual.ComparisonCheckBoxTreeSelectionModel;
import com.sas.metadata.logical.comparison.visual.ComparisonTreeNode;
import com.sas.metadata.logical.comparison.visual.ComparisonTreeNodeSelectionListener;
import com.sas.metadata.logical.comparison.visual.ComparisonTristateCheckBox;
import com.sas.metadata.logical.comparison.visual.RB;
import com.sas.metadata.logical.images.IconFactory;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.visuals.ImportTreeManager;
import com.sas.metadata.promotion.visuals.ImportTreeNode;
import com.sas.metadata.promotion.visuals.TreeNodeInterface;
import com.sas.metadata.tools.tablecomparator.ComparisonControllerFactory;
import com.sas.metadata.tools.tablecomparator.PromotionComparisonNodeInterface;
import com.sas.services.ServiceException;
import com.sas.text.Message;
import com.sas.workspace.WsColumnMetadataUtil;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class ComparisonCheckBoxTreeManager
extends MouseAdapter
implements TreeSelectionListener,
KeyListener {
    static final String DUMMY_USEROBJECT = "#DummyNode#";
    private static final String ROOT_USEROBJECT = "#RootNode#";
    private ComparisonTreeNodeSelectionListener _nodeSelectionListener;
    private ComparisonControllerInterface _comparisonController;
    private ComparisonCheckBoxTreeSelectionModel _selectionModel;
    private IconFactory _iconFactory;
    private JTree _tree = new JTree();
    private DefaultTreeModel _treeModel;
    int _hotspot;
    private TreeNodeInterface[] _checkedNodes;
    private Log _log;

    public ComparisonCheckBoxTreeManager(ComparisonTreeNodeSelectionListener nodeSelectionListener, ComparisonControllerInterface comparisonController, IconFactory iconFactory) {
        this._hotspot = new JCheckBox().getPreferredSize().width;
        this._log = null;
        this._iconFactory = iconFactory;
        this._nodeSelectionListener = nodeSelectionListener;
        this._comparisonController = comparisonController;
        this._log = comparisonController.getLogger();
    }

    public void loadUIData() {
        this.initTreeModels();
        this._tree.setModel(this._treeModel);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._tree.setCellRenderer(new ComparisonCheckBoxTreeCellRenderer(this._tree.getCellRenderer(), this));
        this._tree.addMouseListener(this);
        this._tree.addKeyListener(this);
        TreeSelectionModel selectionModel = this._tree.getSelectionModel();
        if (selectionModel != null) {
            selectionModel.setSelectionMode(1);
        }
        this.expandAllNodes();
        this._tree.updateUI();
    }

    public IconFactory getIconFactory() {
        return this._iconFactory;
    }

    public JTree getTree() {
        return this._tree;
    }

    public Log getLogger() {
        return this._log;
    }

    public void expandAllNodes() {
        Object objRoot;
        if (this._tree != null && this._treeModel != null && (objRoot = this._treeModel.getRoot()) instanceof ComparisonTreeNode) {
            ComparisonTreeNode ctn = (ComparisonTreeNode)objRoot;
            this.expandNode(ctn);
        }
    }

    private void expandNode(ComparisonTreeNode ctn) {
        if (this._tree != null && ctn != null && !ctn.isLeaf()) {
            this._tree.expandPath(new TreePath(ctn.getPath()));
            Enumeration<TreeNode> children = ctn.children();
            if (children != null) {
                while (children.hasMoreElements()) {
                    TreeNode objchild = children.nextElement();
                    if (!(objchild instanceof ComparisonTreeNode)) continue;
                    this.expandNode((ComparisonTreeNode)objchild);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent me) {
        TreePath path = this._tree.getPathForLocation(me.getX(), me.getY());
        if (path == null) {
            this._tree.treeDidChange();
            return;
        }
        Object obj = path.getLastPathComponent();
        if (me.getX() < this._tree.getPathBounds((TreePath)path).x + this._hotspot) {
            boolean selected = this._selectionModel.isPathSelected(path, true);
            this._selectionModel.removeTreeSelectionListener(this);
            try {
                if (selected) {
                    this._selectionModel.removeSelectionPath(path);
                } else {
                    this._selectionModel.addSelectionPath(path);
                }
            }
            finally {
                this._selectionModel.addTreeSelectionListener(this);
                this._tree.treeDidChange();
            }
        }
        this._nodeSelectionListener.treePathSelected(path);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this._tree.treeDidChange();
    }

    private void initTreeModels() {
        ComparisonTreeNode rootNode = new ComparisonTreeNode(ROOT_USEROBJECT, null);
        this._treeModel = new DefaultTreeModel(rootNode);
        ComparisonTreeNode nodeRoot = (ComparisonTreeNode)this._treeModel.getRoot();
        try {
            if (this._comparisonController != null) {
                List<String> selectedObjects = this._comparisonController.getObjects();
                for (String objectName : selectedObjects) {
                    ComparisonResultNodeInterface crn = this._comparisonController.getComparisonResult(objectName);
                    ComparisonTreeNode childNode = new ComparisonTreeNode(this, crn, this.findIconFor(crn));
                    this.addChildNode(nodeRoot, childNode);
                    this.loadChildNodes(childNode);
                    this.initSelectionModel();
                }
            }
        }
        catch (Exception e) {
            this._log.error((Object)e.getMessage());
        }
    }

    private Icon findIconFor(ComparisonResultNodeInterface crn) {
        ComparisonResultNodeInterface.Location location = null;
        Icon icon = null;
        if (crn instanceof PromotionComparisonNodeInterface) {
            PromotionComparisonNodeInterface pcn = (PromotionComparisonNodeInterface)crn;
            location = pcn.getLocation();
        }
        String MetadataType = crn.getMetadataType();
        String type = crn.getObjectType();
        if (type != null && !"".equals(type) || "Column".equalsIgnoreCase(MetadataType)) {
            Icon iconObj = null;
            if ("Table".equalsIgnoreCase(type)) {
                type = "Table_metadata";
            }
            if ("Column".equalsIgnoreCase(type) || "Column".equalsIgnoreCase(MetadataType)) {
                AttributeComparisonResult att = crn.getAttributeComparison("SASColumnType");
                String src1 = att.getSource1Val();
                String src2 = att.getSource2Val();
                type = src1 == null || "".equals(src1) || ".".equals(src1) ? src2 : src1;
                iconObj = WsColumnMetadataUtil.getColumnTypeIcon((String)type);
            } else {
                iconObj = this._iconFactory.getIcon((Object)type);
            }
            icon = this.getOverlayedIcon(iconObj, location);
        } else {
            Icon iconObj = null;
            try {
                if ("Index".equalsIgnoreCase(MetadataType)) {
                    MetadataType = "Table_metadata_index";
                }
                iconObj = this._iconFactory.getIcon((Object)MetadataType);
                icon = this.getOverlayedIcon(iconObj, location);
            }
            catch (Exception e) {
                this._log.info((Object)Message.format((String)RB.getStringResource("ComparisonCheckBoxTreeManager.icon.not.found.fmt"), (Object)MetadataType));
            }
        }
        return icon;
    }

    private Icon getOverlayedIcon(Icon iconObj, ComparisonResultNodeInterface.Location location) {
        Icon icon = null;
        if (location != null) {
            switch (location) {
                case SOURCE1: {
                    icon = this._iconFactory.getNewOverlayObjectIcon(iconObj);
                    break;
                }
                case BOTH: {
                    icon = this._iconFactory.getAttentionOverlayObjectIcon(iconObj);
                    break;
                }
                case SOURCE2: {
                    icon = this._iconFactory.getDeletedOverlayObjectIcon(iconObj);
                    break;
                }
                default: {
                    icon = iconObj;
                }
            }
        }
        return icon;
    }

    private void initSelectionModel() {
        this._selectionModel = new ComparisonCheckBoxTreeSelectionModel(this._treeModel);
        ComparisonTreeNode nodeRoot = (ComparisonTreeNode)this._treeModel.getRoot();
        this.addNodeToSelectionModelIfNeeded(nodeRoot);
        this._selectionModel.addTreeSelectionListener(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addNodeToSelectionModelIfNeeded(ComparisonTreeNode ctn) {
        Enumeration<TreeNode> children = ctn.children();
        if (children != null && children.hasMoreElements()) {
            while (children.hasMoreElements()) {
                TreeNode objChild = children.nextElement();
                if (!(objChild instanceof ComparisonTreeNode)) continue;
                ComparisonTreeNode ctnChild = (ComparisonTreeNode)objChild;
                this.addNodeToSelectionModelIfNeeded(ctnChild);
            }
            return;
        } else {
            try {
                if (!ctn.isImportItem()) return;
                ComparisonResultNodeInterface.Location location = ctn.getComparisonResultNode().getLocation();
                PromotionComparisonNodeInterface.ImportState state = ctn.getImportState();
                if (location == ComparisonResultNodeInterface.Location.SOURCE2) {
                    if (!ctn.getImportState().equals((Object)PromotionComparisonNodeInterface.ImportState.OFF)) return;
                    TreePath path = new TreePath(ctn.getPath());
                    this._selectionModel.addSelectionPath(path);
                    return;
                }
                if (state == null || !state.equals((Object)PromotionComparisonNodeInterface.ImportState.ON)) return;
                TreePath path = new TreePath(ctn.getPath());
                this._selectionModel.addSelectionPath(path);
                return;
            }
            catch (Exception e) {
                this._log.error((Object)e.getMessage());
            }
        }
    }

    public void addChildNode(ComparisonTreeNode rootNode, ComparisonTreeNode childNode) {
        this._treeModel.insertNodeInto(childNode, rootNode, rootNode.getChildCount());
    }

    private void loadChildNodes(ComparisonTreeNode node) {
        block5: {
            block4: {
                if (!node.isNodeTypeLogicalObject()) break block4;
                ComparisonResultNodeInterface crn = node.getComparisonResultNode();
                if (crn == null) break block5;
                Icon icon = null;
                List<String> associations = crn.getAssociations();
                if (associations != null && associations.size() > 0) {
                    for (String assoc : associations) {
                        String displayName = crn.getAssocDisplayName(assoc);
                        ComparisonTreeNode childNode = new ComparisonTreeNode(this, new ComparisonTreeNode.AssociationWrapperNode(crn, assoc, displayName), icon);
                        this.addChildNode(node, childNode);
                        this.loadChildNodes(childNode);
                    }
                }
                break block5;
            }
            if (node.isNodeTypeAssociation()) {
                Collection<ComparisonResultNodeInterface> comparisonNodes = node.getAssociationWrapperNode().getAssociatedComparisonResultNodes();
                for (ComparisonResultNodeInterface crn : comparisonNodes) {
                    ComparisonTreeNode childNode = new ComparisonTreeNode(this, crn, this.findIconFor(crn));
                    this.addChildNode(node, childNode);
                    this.loadChildNodes(childNode);
                }
            }
        }
    }

    public Object getRootObject() {
        return this._tree.getModel().getRoot();
    }

    public boolean isTableNodeChecked(ImportItemInterface importItem) {
        TreeNodeInterface[] checkedNodes;
        if (importItem != null && (checkedNodes = this.getCheckedNodesFromImportTree()) != null) {
            for (TreeNodeInterface nodeName : checkedNodes) {
                String tableID = importItem.getID();
                try {
                    if (nodeName instanceof ImportTreeNode && tableID != null && tableID.equals(((ImportTreeNode)nodeName).getObjectID())) {
                        return true;
                    }
                }
                catch (RemoteException e) {
                    this.getLogger().error((Object)e);
                }
                catch (ServiceException e) {
                    this.getLogger().error((Object)e);
                }
            }
        }
        return false;
    }

    public TreePath setDefaultTreePathSelected() {
        this._tree.setSelectionRow(0);
        return this._tree.getPathForRow(0);
    }

    public TreeNodeInterface[] getCheckedNodesFromImportTree() {
        ImportTreeManager manager;
        ComparisonControllerFactory factory;
        if (this._checkedNodes == null && (factory = ComparisonControllerFactory.getInstance(this._comparisonController.getType())) != null && (manager = ImportTreeManager.getInstance((ImportOperationInterface)factory.getImportOperation())) != null) {
            this._checkedNodes = manager.getCheckedNodes();
        }
        if (this._checkedNodes == null) {
            this._checkedNodes = new TreeNodeInterface[0];
        }
        return this._checkedNodes.length == 0 ? null : this._checkedNodes;
    }

    public boolean isPathSelected(TreePath path, boolean dig) {
        return this._selectionModel.isPathSelected(path, dig);
    }

    public boolean isPartiallySelected(TreePath path) {
        return this._selectionModel.isPartiallySelected(path);
    }

    public boolean isNodeSelected(ComparisonTreeNode node) {
        TreePath nodePath = new TreePath(node.getPath());
        boolean result = this.isNodePresentInSelectionPaths(nodePath) ? true : this.isPathSelected(nodePath, true);
        ComparisonResultNodeInterface.Location loc = null;
        if (node.isNodeTypeLogicalObject()) {
            loc = node.getComparisonResultNode().getLocation();
        }
        return loc != null ? (loc == ComparisonResultNodeInterface.Location.SOURCE2 ? !result : result) : result;
    }

    public boolean isNodePresentInSelectionPaths(TreePath path) {
        boolean isSelected = false;
        if (this._selectionModel.isPathSelected(path)) {
            return true;
        }
        TreePath[] selectedPaths = this._selectionModel.getSelectionPaths();
        if (selectedPaths != null && selectedPaths.length != 0) {
            for (TreePath selectedPath : selectedPaths) {
                if (!path.equals(selectedPath)) continue;
                isSelected = true;
                break;
            }
        }
        return isSelected;
    }

    public ComparisonTristateCheckBox.CheckedState getSelectectionState(TreePath path) {
        if (this.isPathSelected(path, true)) {
            return ComparisonTristateCheckBox.CheckedState.ON;
        }
        if (this.isPartiallySelected(path)) {
            return ComparisonTristateCheckBox.CheckedState.MIXED;
        }
        return ComparisonTristateCheckBox.CheckedState.OFF;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased(KeyEvent e) {
        TreePath path = this._tree.getSelectionPath();
        if (path == null) {
            this._tree.treeDidChange();
            return;
        }
        this._nodeSelectionListener.treePathSelected(path);
        if (e.getKeyCode() == 32) {
            boolean selected = this._selectionModel.isPathSelected(path, true);
            this._selectionModel.removeTreeSelectionListener(this);
            try {
                if (selected) {
                    this._selectionModel.removeSelectionPath(path);
                } else {
                    this._selectionModel.addSelectionPath(path);
                }
            }
            finally {
                this._selectionModel.addTreeSelectionListener(this);
                this._tree.treeDidChange();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

