/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.comparison.visual;

import com.sas.metadata.logical.comparison.visual.ComparisonCheckBoxTreeManager;
import com.sas.metadata.logical.comparison.visual.ComparisonTreeNode;
import com.sas.metadata.logical.comparison.visual.ComparisonTristateCheckBox;
import com.sas.metadata.logical.images.IconFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class ComparisonCheckBoxTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private ComparisonCheckBoxTreeManager _treeManager;
    private TreeCellRenderer delegate;
    private ComparisonTristateCheckBox checkBox = new ComparisonTristateCheckBox();

    public ComparisonCheckBoxTreeCellRenderer(TreeCellRenderer delegate, ComparisonCheckBoxTreeManager manager) {
        this.delegate = delegate;
        this._treeManager = manager;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.checkBox.setOpaque(false);
        this.add((Component)this.checkBox, "West");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component renderer = this.delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value instanceof ComparisonTreeNode) {
            ComparisonTreeNode ctn = (ComparisonTreeNode)value;
            if (ctn.isCheckBoxVisible()) {
                this.checkBox.setVisible(true);
                this.checkBox.setState(this._treeManager.getSelectectionState(new TreePath(ctn.getPath())));
            } else {
                this.checkBox.setVisible(false);
            }
            if (renderer instanceof JLabel) {
                IconFactory iconFactory;
                Icon icon = ctn.getIcon();
                if (icon == null && !leaf && (iconFactory = this._treeManager.getIconFactory()) != null) {
                    int status = 0;
                    icon = iconFactory.getFolderIcon(status);
                }
                if (icon != null) {
                    ((JLabel)renderer).setIcon(icon);
                }
            }
        }
        this.add(renderer, "Center");
        return this;
    }
}

