/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.comparison;

import com.sas.metadata.logical.comparison.ComparisonConfigurationException;
import com.sas.metadata.logical.comparison.ComparisonTemplateNode;
import com.sas.metadata.logical.comparison.ComparisonTemplateNodeInterface;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ComparisonTemplateFactory {
    private static ComparisonTemplateFactory factory;
    private Map<String, String> deploymentTemplates = new HashMap<String, String>(3);
    private Map<String, ComparisonTemplateNodeInterface> comparisonTemplates = new HashMap<String, ComparisonTemplateNodeInterface>(3);

    private ComparisonTemplateFactory() {
    }

    public static ComparisonTemplateFactory getInstance() {
        if (factory == null) {
            factory = new ComparisonTemplateFactory();
        }
        return factory;
    }

    public ComparisonTemplateNodeInterface getTemplateRootNode(String logicalType) throws ComparisonConfigurationException {
        ComparisonTemplateNodeInterface rootNode = null;
        Class<?> thisInstance = this.getClass();
        boolean resourceFound = false;
        if (logicalType != null) {
            if (this.comparisonTemplates.containsKey(logicalType)) {
                rootNode = this.comparisonTemplates.get(logicalType);
                resourceFound = true;
            } else {
                Node xmlRootNode;
                String logicalTypeName = logicalType.toLowerCase() + ".xml";
                InputStream isFileContents = thisInstance.getResourceAsStream("/com/sas/metadata/logical/comparison/" + logicalTypeName);
                if (isFileContents != null && (xmlRootNode = this.getRootNode(isFileContents)) != null) {
                    resourceFound = true;
                    rootNode = new ComparisonTemplateNode(xmlRootNode);
                    this.comparisonTemplates.put(logicalType, rootNode);
                }
            }
        }
        if (!resourceFound) {
            throw new ComparisonConfigurationException("Comparison template Not found");
        }
        return rootNode;
    }

    public String getDeploymentTemplate(String logicalType) throws ComparisonConfigurationException {
        ComparisonTemplateNodeInterface rootNode = null;
        Class<?> thisInstance = this.getClass();
        boolean resourceFound = false;
        if (logicalType != null) {
            Node xmlRootNode;
            String logicalTypeName = logicalType.toLowerCase() + "_deployment.xml";
            InputStream isFileContents = thisInstance.getResourceAsStream("/com/sas/metadata/logical/comparison/" + logicalTypeName);
            if (isFileContents != null && (xmlRootNode = this.getRootNode(isFileContents)) != null) {
                resourceFound = true;
                rootNode = new ComparisonTemplateNode(xmlRootNode);
            }
        }
        if (!resourceFound) {
            throw new ComparisonConfigurationException("Deployment template Not found");
        }
        if (rootNode != null) {
            String xmlString = rootNode.getXML();
            xmlString = xmlString.replaceAll("\\r\\n\\s+", "");
            return xmlString;
        }
        return null;
    }

    public String getMetadataExtractionTemplate(String logicalType) throws ComparisonConfigurationException {
        Class<?> thisInstance = this.getClass();
        if (logicalType != null) {
            if (logicalType.toLowerCase().equalsIgnoreCase("physicaltable")) {
                return "<Templates><PhysicalTable><Columns/><ForeignKeys/><Indexes/><Notes/><UniqueKeys/></PhysicalTable><Column><Keys/></Column><ForeignKey><KeyedColumns/></ForeignKey><UniqueKey><KeyedColumns/></UniqueKey><Index><Columns/></Index></Templates>";
            }
            if (logicalType.toLowerCase().equalsIgnoreCase("externaltable")) {
                return "<Templates><ExternalTable><Columns/><OwningFile/></ExternalTable><Column><Documents/><Notes/><SourceFeatureMaps/><TargetFeatureMaps/><Keys/><QueryClauses/><ReferencedObjects/><SpecSourceTransformations/><SpecTargetTransformations/><Variables/></Column><File><DeployedComponents/><FileRefs/><TargetTransformations/></File><SASFileRef><DeployedComponents/></SASFileRef></Templates>";
            }
        }
        return null;
    }

    private Node getRootNode(InputStream isFileContents) {
        Document templateDocument = this.getDocument(isFileContents);
        Element docElement = null;
        if (templateDocument != null) {
            docElement = templateDocument.getDocumentElement();
        }
        return docElement;
    }

    public static void main(String[] args) throws ComparisonConfigurationException {
        String str = "<Template>\r\n        <PhysicalTable IsCompressed=\"\" IsDBMSView=\"\" MemberType=\"\" Name=\"\" NumRows=\"\" PublicType=\"\" SASTableName=\"\" TableName=\"\" UsageVersion=\"\">\r\n           <Columns>\r\n              <Column BeginPosition=\"\" ColumnLength=\"\" ColumnName=\"\" ColumnType=\"\" Desc=\"\" EndPosition=\"\" IsDiscrete=\"\" IsNullable=\"\" Name=\"\" PublicType=\"\" SASColumnLength=\"\" SASColumnName=\"\" SASColumnType=\"\" SASExtendedLength=\"\" SASFormat=\"\" SASInformat=\"\" SASPrecision=\"\" SASScale=\"\" UsageVersion=\"\">\r\n              </Column>\r\n           </Columns>\r\n           <UniqueKeys>\r\n           \t\t<UniqueKey Name=\"\">\r\n           \t\t\t<KeyedColumns>\r\n           \t\t\t\t<Column Name=\"\">\r\n           \t\t\t\t</Column>\r\n           \t\t\t</KeyedColumns>\r\n           \t\t</UniqueKey>\r\n           </UniqueKeys>\r\n         </PhysicalTable>\r\n         <RelationalTable IsCompressed=\"\" IsDBMSView=\"\" MemberType=\"\" Name=\"\" NumRows=\"\" PublicType=\"\" SASTableName=\"\" TableName=\"\" UsageVersion=\"\">\r\n            <Columns>\r\n               <Column BeginPosition=\"\" ColumnLength=\"\" ColumnName=\"\" ColumnType=\"\" Desc=\"\" EndPosition=\"\" IsDiscrete=\"\" IsNullable=\"\" Name=\"\" PublicType=\"\" SASColumnLength=\"\" SASColumnName=\"\" SASColumnType=\"\" SASExtendedLength=\"\" SASFormat=\"\" SASInformat=\"\" SASPrecision=\"\" SASScale=\"\" UsageVersion=\"\">\r\n               </Column>\r\n            </Columns>\r\n            <UniqueKeys>\r\n       \t\t\t<UniqueKey Name=\"\">\r\n       \t\t\t\t<KeyedColumns>\r\n       \t\t\t\t\t<Column Name=\"\">\r\n       \t\t\t\t\t</Column>\r\n       \t\t\t\t</KeyedColumns>\r\n       \t\t\t</UniqueKey>\r\n       \t\t</UniqueKeys>\r\n         </RelationalTable>\r\n      </Template>";
        ComparisonTemplateFactory factory = ComparisonTemplateFactory.getInstance();
        ComparisonTemplateNodeInterface rootTemplateNode = factory.getTemplateRootNode("physicaltable");
        ComparisonTemplateNode childAssoc = null;
        List<String> associations = rootTemplateNode.getAssociations();
        for (String assocName : associations) {
            childAssoc = rootTemplateNode.getTemplateNode(assocName);
            List<String> list = childAssoc.getAttributes();
        }
    }

    private Document getDocument(InputStream isFileContents) {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        Document comparisonTemplate = null;
        domFactory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            comparisonTemplate = builder.parse(isFileContents);
        }
        catch (ParserConfigurationException exception) {
            exception.printStackTrace(System.out);
        }
        catch (IOException exception) {
            exception.printStackTrace(System.out);
        }
        catch (SAXException exception) {
            exception.printStackTrace(System.out);
        }
        return comparisonTemplate;
    }

    public void dispose() {
        this.comparisonTemplates = null;
        this.deploymentTemplates = null;
        factory = null;
    }
}

