/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.server;

import com.sas.framework.annotation.services.Publishable;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.remote.MdException;
import com.sas.services.connection.HostPortPair;
import com.sas.services.connection.HostPortSet;
import com.sas.svcs.metadata.mgmt.client.ClusterDetails;
import com.sas.svcs.metadata.mgmt.client.ConnectedIdentityInfo;
import com.sas.svcs.metadata.mgmt.client.MetadataMgmtException;
import com.sas.svcs.metadata.mgmt.client.MetadataRepositoryService;
import com.sas.svcs.metadata.mgmt.client.MetadataServerService;
import com.sas.svcs.metadata.mgmt.client.ServerState;
import com.sas.svcs.metadata.mgmt.impl.AbstractMetadataManagementServiceImpl;
import com.sas.svcs.metadata.mgmt.impl.RequestContext;
import com.sas.svcs.metadata.mgmt.impl.server.RB;
import com.sas.svcs.metadata.mgmt.impl.server.ServerStatusProcessor;
import com.sas.text.Message;
import java.rmi.RemoteException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Service(value="MetadataServerService")
@Publishable
public class MetadataServerServiceImpl
extends AbstractMetadataManagementServiceImpl
implements MetadataServerService {
    private MetadataRepositoryService metadataRepositoryService;

    @Autowired
    public void setMetadataRepositoryService(MetadataRepositoryService metadataRepositoryService) {
        this.metadataRepositoryService = metadataRepositoryService;
    }

    public ServerState getServerState() {
        RequestContext ctx = this.getRequestContext();
        ServerStatusProcessor processor = new ServerStatusProcessor(ctx, this.metadataRepositoryService);
        ServerState state = processor.getServerState();
        return state;
    }

    public ServerState setServerState(ServerState serverState) throws IllegalArgumentException {
        RequestContext ctx = this.getRequestContext();
        switch (serverState.getAccess()) {
            case NOQUOROM: 
            case STARTING: 
            case RECOVERY: {
                throw new IllegalArgumentException(new Message(RB.getResources(), "MetadataServerService.IllegalStateException.BadAccessValue.txt", (Object)serverState.getAccess()).toString());
            }
        }
        ServerStatusProcessor processor = new ServerStatusProcessor(ctx, this.metadataRepositoryService);
        ServerState currentState = processor.setServerState(serverState);
        return currentState;
    }

    public void sendAlertMessage(String alertMessage) {
    }

    public ServerState pauseAdmin(String pauseComment) {
        RequestContext ctx = this.getRequestContext();
        ServerStatusProcessor processor = new ServerStatusProcessor(ctx, this.metadataRepositoryService);
        ServerState state = processor.getServerState();
        state.setAccess(ServerState.Access.ADMIN);
        if (pauseComment != null) {
            state.setPauseComment(pauseComment);
        } else {
            state.setPauseComment(RB.getStringResource("MetadataServerService.PauseAdmin.DefaultComment.txt"));
        }
        processor.setServerState(state);
        return state;
    }

    public ServerState pauseReadOnly(String pauseComment) {
        RequestContext ctx = this.getRequestContext();
        ServerStatusProcessor processor = new ServerStatusProcessor(ctx, this.metadataRepositoryService);
        ServerState state = processor.getServerState();
        state.setAccess(ServerState.Access.READONLY);
        if (pauseComment != null) {
            state.setPauseComment(pauseComment);
        } else {
            state.setPauseComment(RB.getStringResource("MetadataServerService.PauseReadOnly.DefaultComment.txt"));
        }
        processor.setServerState(state);
        return state;
    }

    public ServerState pauseOffline(String pauseComment) {
        RequestContext ctx = this.getRequestContext();
        ServerStatusProcessor processor = new ServerStatusProcessor(ctx, this.metadataRepositoryService);
        ServerState state = processor.getServerState();
        state.setAccess(ServerState.Access.OFFLINE);
        if (pauseComment != null) {
            state.setPauseComment(pauseComment);
        } else {
            state.setPauseComment(RB.getStringResource("MetadataServerService.PauseOffline.DefaultComment.txt"));
        }
        processor.setServerState(state);
        return state;
    }

    public ServerState resumeServer() {
        RequestContext ctx = this.getRequestContext();
        ServerStatusProcessor processor = new ServerStatusProcessor(ctx, this.metadataRepositoryService);
        ServerState state = processor.getServerState();
        state.setAccess(ServerState.Access.ONLINE);
        state.setPauseComment("");
        processor.setServerState(state);
        return state;
    }

    public void refreshServer() {
        this.refreshServer("<Server/> <CLUSTER/>");
    }

    public void refreshServer(String options) {
        RequestContext ctx = this.getRequestContext();
        try {
            ctx.getIServer().Refresh(options);
        }
        catch (GenericError e) {
            throw new RuntimeException(e);
        }
    }

    public void stopServer() {
        RequestContext ctx = this.getRequestContext();
        try {
            ctx.getIServer().Stop("<CLUSTER/>");
        }
        catch (GenericError e) {
            throw new RuntimeException(e);
        }
    }

    public String getServerStatus(String input, String options) {
        RequestContext ctx = this.getRequestContext();
        ServerStatusProcessor processor = new ServerStatusProcessor(ctx, this.metadataRepositoryService);
        String output = options == null ? processor.getServerStateString(input, "") : processor.getServerStateString(input, options);
        return output;
    }

    public ConnectedIdentityInfo getConnectedIdentityInfo() throws MetadataMgmtException {
        ConnectedIdentityInfo connectedIdentity = this.populateConnectedIdentityInfo();
        return connectedIdentity;
    }

    public boolean isClusterConfigured() throws MetadataMgmtException {
        String clusterGUIDValue = null;
        String statusResponseStr = "";
        String serverStatusInput = "<Cluster ClusterGUID=\"\" />";
        String serverStatusOptions = "<Cluster/>";
        RequestContext ctx = this.getRequestContext();
        try {
            statusResponseStr = this.getServerStatus("<Cluster ClusterGUID=\"\" />", "<Cluster/>");
            Document doc = ctx.getFactory().getOMIUtil().parseXML("<metadata>" + statusResponseStr + "</metadata>");
            NodeList nodeList = doc.getElementsByTagName("Cluster");
            Node node = nodeList.item(0);
            NamedNodeMap attrList = node.getAttributes();
            Node childNode = attrList.getNamedItem("ClusterGUID");
            if (childNode != null) {
                clusterGUIDValue = childNode.getNodeValue();
            }
        }
        catch (Exception e) {
            throw new MetadataMgmtException(e.getMessage());
        }
        return clusterGUIDValue != null && !clusterGUIDValue.isEmpty();
    }

    public ClusterDetails getClusterDetails() throws MetadataMgmtException {
        ClusterDetails clusterDetails = null;
        if (this.isClusterConfigured()) {
            clusterDetails = new ClusterDetails();
            this.populateClusterDetails(clusterDetails);
        }
        return clusterDetails;
    }

    private ConnectedIdentityInfo populateConnectedIdentityInfo() throws MetadataMgmtException {
        int atsign;
        String actualInternalValue;
        ISecurity_1_1 _iSecurity = null;
        ConnectedIdentityInfo connectedIdentity = null;
        String _userClass = null;
        String _authUserId = null;
        String _name = null;
        String _type = null;
        String _objectID = null;
        String _unrestrictedSource = null;
        RequestContext ctx = this.getRequestContext();
        try {
            _iSecurity = ctx.getFactory().getConnection().MakeISecurityConnection();
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        catch (MdException e1) {
            e1.printStackTrace();
        }
        if (_iSecurity == null) {
            throw new MetadataMgmtException("ISecurity Connection Error");
        }
        VariableArray2dOfStringHolder vaTmpOut = new VariableArray2dOfStringHolder();
        String[][] options = new String[][]{{"ReturnUnrestrictedSource"}, {""}};
        try {
            _iSecurity.GetInfo("GetIdentityInfo", "", options, vaTmpOut);
        }
        catch (Exception e) {
            throw new MetadataMgmtException(e.getMessage());
        }
        for (int i = 0; i < vaTmpOut.value.length; ++i) {
            String strKeyword = vaTmpOut.value[i][0];
            String strValue = vaTmpOut.value[i][1];
            if (strKeyword.equalsIgnoreCase("UserClass")) {
                _userClass = new String(strValue);
                continue;
            }
            if (strKeyword.equalsIgnoreCase("AuthenticatedUserid")) {
                _authUserId = new String(strValue);
                continue;
            }
            if (strKeyword.equalsIgnoreCase("IdentityName")) {
                _name = new String(strValue);
                continue;
            }
            if (strKeyword.equalsIgnoreCase("IdentityType")) {
                _type = new String(strValue);
                continue;
            }
            if (strKeyword.equalsIgnoreCase("IdentityObjectID")) {
                _objectID = new String(strValue);
                continue;
            }
            if (!strKeyword.equalsIgnoreCase("UnrestrictedSource")) continue;
            _unrestrictedSource = new String(strValue);
        }
        connectedIdentity = new ConnectedIdentityInfo();
        connectedIdentity.setUserClass(_userClass);
        connectedIdentity.setAuthenticatedUserId(_authUserId);
        connectedIdentity.setUserName(_name);
        connectedIdentity.setUserType(_type);
        connectedIdentity.setObjectId(_objectID);
        connectedIdentity.setUnrestrictedSource(_unrestrictedSource);
        if (_userClass != null && _userClass.indexOf("Unrestricted") != -1) {
            connectedIdentity.setIsUnrestricted(true);
        }
        if (_unrestrictedSource != null && _unrestrictedSource.indexOf("ConfigFile") != -1) {
            connectedIdentity.setIsUnrestrictedByFile(true);
        }
        if (_userClass != null && _userClass.indexOf("Unrestricted") != -1 || _userClass.indexOf("Administrator") != -1) {
            connectedIdentity.setIsAdministrator(true);
        }
        String internalIndicator = this.getInternalUserIndicator(ctx);
        if (_authUserId != null && (actualInternalValue = _authUserId.substring((atsign = _authUserId.indexOf(64)) + 1)).equalsIgnoreCase(internalIndicator)) {
            connectedIdentity.setIsInternalUser(true);
        }
        if (_userClass != null && _userClass.indexOf("Unrestricted") != -1 || _userClass.indexOf("Administrator") != -1 || _userClass.indexOf("Operator") != -1) {
            connectedIdentity.setIsOperator(true);
        }
        VariableArray2dOfStringHolder vaTmpOut2 = new VariableArray2dOfStringHolder();
        try {
            _iSecurity.GetAuthorizations("getIdentityDrivenPropertyValues", "", "SAS.IdentityGroups", "", vaTmpOut2);
        }
        catch (Exception e) {
            throw new MetadataMgmtException(e.getMessage());
        }
        finally {
            try {
                ctx.getFactory().getConnection().closeISecurityConnection((ISecurity)_iSecurity);
                _iSecurity = null;
            }
            catch (Exception error) {
                _iSecurity = null;
            }
        }
        for (int i = 0; i < vaTmpOut2.value.length; ++i) {
            String strGroupName = vaTmpOut2.value[i][2];
            if (!strGroupName.equalsIgnoreCase("SASAdministrators")) continue;
            connectedIdentity.setIsSASAdministratorGroupMember(true);
        }
        return connectedIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getInternalUserIndicator(RequestContext ctx) {
        String defaultIndicator = "saspw";
        VariableArray2dOfStringHolder returnInfo = new VariableArray2dOfStringHolder();
        String[][] parms = new String[][]{};
        ISecurity_1_1 iSecurity = null;
        try {
            iSecurity = ctx.getFactory().getConnection().MakeISecurityConnection();
            if (iSecurity == null) {
                String string = defaultIndicator;
                return string;
            }
            iSecurity.GetInfo("SASPW_Alias", "", parms, returnInfo);
            for (int i = 0; i < returnInfo.value.length; ++i) {
                if (!returnInfo.value[i][0].trim().equalsIgnoreCase("SASPW_Alias")) continue;
                String string = returnInfo.value[i][1].trim();
                return string;
            }
        }
        catch (Exception error) {
        }
        finally {
            try {
                ctx.getFactory().getConnection().closeISecurityConnection((ISecurity)iSecurity);
                iSecurity = null;
            }
            catch (Exception error) {
                iSecurity = null;
            }
        }
        return defaultIndicator;
    }

    private void populateClusterDetails(ClusterDetails clusterDetails) throws MetadataMgmtException {
        String statusResponseStr = "";
        String hostValue = null;
        String portValue = null;
        String activeNodeName = " ";
        String definedNodeName = " ";
        String stateValue = " ";
        String hasQuorumValue = " ";
        String selfValue = " ";
        HostPortSet definedHostPortSet = new HostPortSet();
        HostPortSet activeHostPortSet = new HostPortSet();
        HostPortSet offlineHostPortSet = new HostPortSet();
        String serverStatusInput = "<ClusterState/><Cluster Defined_Nodes=\"\" Current_Nodes=\"\" Has_Quorum=\"\" Defined =\"\" List=\"\"/>";
        String serverStatusOptions = "<Cluster/>";
        RequestContext ctx = this.getRequestContext();
        try {
            statusResponseStr = this.getServerStatus("<ClusterState/><Cluster Defined_Nodes=\"\" Current_Nodes=\"\" Has_Quorum=\"\" Defined =\"\" List=\"\"/>", "<Cluster/>");
            Document doc = ctx.getFactory().getOMIUtil().parseXML("<metadata>" + statusResponseStr + "</metadata>");
            NodeList nodeList = doc.getElementsByTagName("ClusterState");
            Node node = nodeList.item(0);
            stateValue = node.getTextContent();
            clusterDetails.setClusterState(stateValue);
            nodeList = doc.getElementsByTagName("Cluster");
            node = nodeList.item(0);
            NamedNodeMap attrList = node.getAttributes();
            Node childNode = attrList.getNamedItem("Defined_Nodes");
            if (childNode != null) {
                clusterDetails.setDefinedNodesCount(Integer.parseInt(childNode.getNodeValue()));
            }
            if ((childNode = attrList.getNamedItem("Current_Nodes")) != null) {
                clusterDetails.setCurrentNodesCount(Integer.parseInt(childNode.getNodeValue()));
            }
            if ((childNode = attrList.getNamedItem("Has_Quorum")) != null) {
                hasQuorumValue = childNode.getNodeValue();
                if ("YES".equalsIgnoreCase(hasQuorumValue)) {
                    clusterDetails.setHasQuorum(true);
                } else {
                    clusterDetails.setHasQuorum(false);
                }
            }
            NodeList activeNodeList = doc.getElementsByTagName("ClusterNode");
            NodeList definedNodeList = doc.getElementsByTagName("ClusterDefn");
            boolean isFirstNode = true;
            for (int i = 0; i < definedNodeList.getLength(); ++i) {
                int port = -1;
                node = definedNodeList.item(i);
                attrList = node.getAttributes();
                childNode = attrList.getNamedItem("Name");
                if (childNode != null) {
                    definedNodeName = childNode.getNodeValue();
                }
                boolean active = false;
                for (int j = 0; j < activeNodeList.getLength(); ++j) {
                    active = false;
                    Node node2 = activeNodeList.item(j);
                    NamedNodeMap attrList2 = node2.getAttributes();
                    Node childNode2 = attrList2.getNamedItem("Self");
                    if (childNode2 != null) {
                        selfValue = childNode2.getNodeValue();
                    }
                    if ((childNode2 = attrList2.getNamedItem("Name")) != null) {
                        activeNodeName = childNode2.getNodeValue();
                    }
                    if (selfValue.equals("Y")) {
                        if (!activeNodeName.equals(definedNodeName)) continue;
                        childNode = attrList.getNamedItem("Host");
                        if (childNode != null) {
                            hostValue = childNode.getNodeValue();
                        }
                        if ((childNode = attrList.getNamedItem("Port")) != null) {
                            portValue = childNode.getNodeValue();
                            port = Integer.parseInt(portValue);
                        }
                        active = true;
                        if (hostValue == null || port == -1) break;
                        HostPortPair master = new HostPortPair(hostValue, port);
                        activeHostPortSet.add((Object)master);
                        definedHostPortSet.add((Object)master);
                        clusterDetails.setMasterNode(master);
                        if (!isFirstNode) break;
                        clusterDetails.setFirstNode(master);
                        break;
                    }
                    if (!activeNodeName.equals(definedNodeName)) continue;
                    childNode = attrList.getNamedItem("Host");
                    if (childNode != null) {
                        hostValue = childNode.getNodeValue();
                    }
                    if ((childNode = attrList.getNamedItem("Port")) != null) {
                        portValue = childNode.getNodeValue();
                        port = Integer.parseInt(portValue);
                    }
                    active = true;
                    if (hostValue == null || port == -1) break;
                    HostPortPair slave = new HostPortPair(hostValue, port);
                    activeHostPortSet.add((Object)slave);
                    definedHostPortSet.add((Object)slave);
                    if (!isFirstNode) break;
                    clusterDetails.setFirstNode(slave);
                    break;
                }
                if (!active) {
                    childNode = attrList.getNamedItem("Host");
                    if (childNode != null) {
                        hostValue = childNode.getNodeValue();
                    }
                    if ((childNode = attrList.getNamedItem("Port")) != null) {
                        portValue = childNode.getNodeValue();
                        port = Integer.parseInt(portValue);
                    }
                    if (hostValue != null && port != -1) {
                        HostPortPair slave = new HostPortPair(hostValue, port);
                        offlineHostPortSet.add((Object)slave);
                        definedHostPortSet.add((Object)slave);
                        if (isFirstNode) {
                            clusterDetails.setFirstNode(slave);
                        }
                    }
                }
                isFirstNode = false;
            }
            clusterDetails.setDefinedClusterNodes(definedHostPortSet);
            clusterDetails.setActiveClusterNodes(activeHostPortSet);
            clusterDetails.setOfflineClusterNodes(offlineHostPortSet);
        }
        catch (Exception e) {
            throw new MetadataMgmtException(e.getMessage(), (Throwable)e);
        }
    }
}

