/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.repository;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Prototype;
import com.sas.svcs.metadata.mgmt.client.Repository;
import com.sas.svcs.metadata.mgmt.impl.RequestContext;
import com.sas.svcs.metadata.mgmt.impl.repository.LocalizedResourceUtility;
import com.sas.svcs.metadata.mgmt.impl.repository.RB;
import com.sas.svcs.metadata.mgmt.impl.repository.data.ResourceTemplates.ResourceBundleReader;
import com.sas.text.Message;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ResourceTemplateHelper {
    private final Logger logger = LogManager.getLogger(ResourceTemplateHelper.class);
    private RequestContext ctx;
    private static final String CLASS_IDENTIFIER = "ClassIdentifier";
    private static final String ENGINE = "Engine";
    private static final String SERVERCLASSIDENTIFIER = "ServerClassIdentifier";
    private static final String EXTENSION_ASSOC = "Extensions";
    private static final String PROTOTYPE_PROPERTIES = "PrototypeProperties";
    private static final String GENERIC_TEMPLATE = "Generic";
    private static final String xmlFileError = "FILE ERROR";

    ResourceTemplateHelper(RequestContext ctx) {
        this.ctx = ctx;
    }

    void addAllTemplates(Repository repository) throws Exception {
        Document doc;
        boolean errorOccurred = false;
        if (!repository.isFoundation()) {
            throw new Exception(RB.getStringResource("ResourceTemplateHelper.FoundationOnly.Error.txt"));
        }
        URL defaultUrl = LocalizedResourceUtility.urlFromFile(RB.getStringResource("ResourceTemplateHelper.PrototypeIndexFile.notrans"), new Locale("en", "US"));
        try {
            doc = this.ctx.getFactory().getOMIUtil().parseXML(defaultUrl);
        }
        catch (MdException exc) {
            throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ResourceTemplateHelper.ParsingIndexFile.Error.txt", (Object)exc.getMessage()));
        }
        Vector xmlToAddList = new Vector();
        Vector localeList = new Vector();
        Vector metadataTypeList = new Vector();
        Vector uniqueIDList = new Vector();
        Vector uniqueNameList = new Vector();
        if (doc != null) {
            this.buildData(doc, xmlToAddList, localeList, metadataTypeList, uniqueIDList, uniqueNameList, repository.getId());
        }
        int size = xmlToAddList.size();
        boolean bShowDuplicateMessage = true;
        for (int i = 0; i < xmlToAddList.size(); ++i) {
            String rtName = null;
            try {
                String strXML = (String)xmlToAddList.get(i);
                if (strXML.equalsIgnoreCase(xmlFileError)) continue;
                if (localeList != null && metadataTypeList != null && uniqueIDList != null) {
                    String strUniqueName;
                    String strLocale = (String)localeList.get(i);
                    int metadataTypeIndex = i;
                    if (i >= metadataTypeList.size()) {
                        metadataTypeIndex = i - (localeList.size() - metadataTypeList.size());
                    }
                    String strMetadataType = (String)metadataTypeList.get(metadataTypeIndex);
                    int uniqueIDIndex = i;
                    if (i >= uniqueIDList.size()) {
                        uniqueIDIndex = i - (localeList.size() - uniqueIDList.size());
                    }
                    String strUniqueID = (String)uniqueIDList.get(uniqueIDIndex);
                    int uniqueNameIndex = i;
                    if (i >= uniqueNameList.size()) {
                        uniqueNameIndex = i - (localeList.size() - uniqueNameList.size());
                    }
                    rtName = strUniqueName = (String)uniqueNameList.get(uniqueNameIndex);
                    boolean bAddTemplate = this.duplicateNotFound(repository.getId(), bShowDuplicateMessage, strLocale, strMetadataType, strUniqueID);
                    if (!bAddTemplate) {
                        bShowDuplicateMessage = false;
                        continue;
                    }
                }
                this.ctx.getFactory().getOMIUtil().DoRequest(strXML, false);
                continue;
            }
            catch (Exception e) {
                String errorMsg = Message.format((ResourceBundle)RB.getResources(), (String)"ResourceTemplateHelper.LoadingTemplate.Error.txt", rtName, (Object)e.getMessage());
                this.logger.error(errorMsg);
                errorOccurred = true;
                try {
                    if (!(e instanceof MdException)) continue;
                    this.ctx.getFactory().getUtil().printOutputln(errorMsg);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        if (errorOccurred) {
            throw new Exception(RB.getStringResource("ResourceTemplateHelper.AddAllResourceTemplates.Error.txt"));
        }
    }

    public static URL getURLfromPrototypeIndexFile() throws IOException {
        return LocalizedResourceUtility.urlFromFile(RB.getStringResource("ResourceTemplateHelper.PrototypeIndexFile.notrans"));
    }

    public static URL getURLfromPrototypeIndexFile(Locale locale) throws IOException {
        return LocalizedResourceUtility.urlFromFile(RB.getStringResource("ResourceTemplateHelper.PrototypeIndexFile.notrans"), locale);
    }

    private void buildData(Node node, List xmlToAddList, List localeList, List metadataTypeList, List uniqueIDList, List uniqueNameList, String repositoryId) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this.buildData(children.item(childIndex), xmlToAddList, localeList, metadataTypeList, uniqueIDList, uniqueNameList, repositoryId);
                }
                break;
            }
            case 1: {
                if (node.getNodeName().equals("Prototype")) {
                    NamedNodeMap childNodeMap = node.getAttributes();
                    String strFileName = childNodeMap.getNamedItem("FileName").getNodeValue();
                    if (strFileName.indexOf("_gx.xml") == -1) {
                        return;
                    }
                    localeList.add(GENERIC_TEMPLATE);
                    String strMetadataType = childNodeMap.getNamedItem("MetadataType").getNodeValue();
                    String strPrototypeName = null;
                    metadataTypeList.add(strMetadataType);
                    Node nameNode = childNodeMap.getNamedItem("Name");
                    if (nameNode != null && nameNode.getNodeValue().length() > 0) {
                        strPrototypeName = ResourceBundleReader.getDisplayString(nameNode.getNodeValue());
                        uniqueNameList.add(strPrototypeName);
                    }
                    Node classIDNode = childNodeMap.getNamedItem(CLASS_IDENTIFIER);
                    Node engineIDNode = childNodeMap.getNamedItem(ENGINE);
                    Node serverClassIDNode = childNodeMap.getNamedItem(SERVERCLASSIDENTIFIER);
                    String strUniqueID = "";
                    if (classIDNode != null && classIDNode.getNodeValue().length() > 0) {
                        strUniqueID = classIDNode.getNodeValue();
                    }
                    if (engineIDNode != null) {
                        if (engineIDNode.getNodeValue().length() > 0) {
                            strUniqueID = engineIDNode.getNodeValue();
                        }
                        if (strUniqueID.equals("DB2")) {
                            strUniqueID = serverClassIDNode.getNodeValue();
                        }
                    }
                    if (serverClassIDNode != null && serverClassIDNode.getNodeValue().length() > 0) {
                        strUniqueID = serverClassIDNode.getNodeValue();
                    }
                    uniqueIDList.add(strUniqueID);
                    try {
                        URL fileUrl;
                        Document doc = null;
                        try {
                            fileUrl = LocalizedResourceUtility.urlFromFile(strFileName);
                        }
                        catch (IOException exc) {
                            String errorMsg = Message.format((ResourceBundle)RB.getResources(), (String)"ResourceTemplateHelper.LoadingTemplate.Error.txt", (Object)strPrototypeName, (Object)exc.getMessage());
                            this.logger.error(errorMsg);
                            xmlToAddList.add(xmlFileError);
                            return;
                        }
                        try {
                            doc = this.ctx.getFactory().getOMIUtil().parseXML(fileUrl);
                        }
                        catch (MdException exc) {
                            String errorMsg = Message.format((ResourceBundle)RB.getResources(), (String)"ResourceTemplateHelper.LoadingTemplate.Error.txt", (Object)strPrototypeName, (Object)exc.getMessage());
                            this.logger.error(errorMsg);
                            xmlToAddList.add(xmlFileError);
                            return;
                        }
                        catch (RemoteException re) {
                            this.ctx.getFactory().getUtil().printStackTrace((Throwable)re);
                        }
                        String strFileContents = this.ctx.getFactory().getUtil().createStringForNode((Node)doc);
                        int reposIndex = strFileContents.lastIndexOf("_ReposID_");
                        String strFileXML = strFileContents.substring(0, reposIndex) + repositoryId + strFileContents.substring(reposIndex + 9);
                        xmlToAddList.add(strFileXML);
                    }
                    catch (RemoteException remoteException) {}
                    break;
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    this.buildData(children.item(childIndex), xmlToAddList, localeList, metadataTypeList, uniqueIDList, uniqueNameList, repositoryId);
                }
                break;
            }
        }
    }

    private boolean duplicateNotFound(String repositoryId, boolean bShowDuplicateMessage, String strLocale, String strMetadataType, String strUniqueID) {
        try {
            boolean bDuplicateNotFound = true;
            MdObjectStore store = this.ctx.getFactory().createObjectStore();
            try {
                Prototype prototype = this.getPrototypeByIdentifier(strUniqueID, repositoryId, strMetadataType, null, (MdStore)store);
                if (prototype != null) {
                    bDuplicateNotFound = false;
                }
            }
            catch (MdException e) {
                this.logger.error(e.getMessage());
                return false;
            }
            if (!bDuplicateNotFound && bShowDuplicateMessage) {
                String strMessage = RB.getStringResource("ResourceTemplateHelper.DuplicateTemplates.Message.txt");
                this.logger.error(strMessage);
            }
            return bDuplicateNotFound;
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    Prototype getPrototypeByIdentifier(String strValue, String strReposId, String strMetadataType, Locale locale, MdStore store) throws MdException, RemoteException {
        String strAssociation = PROTOTYPE_PROPERTIES;
        String strAttribute = CLASS_IDENTIFIER;
        if (strMetadataType == null) {
            return null;
        }
        if (strMetadataType.equalsIgnoreCase("DatabaseSchema")) {
            strAssociation = EXTENSION_ASSOC;
            strAttribute = SERVERCLASSIDENTIFIER;
        } else if (strMetadataType.equalsIgnoreCase("SASLibrary")) {
            if (strValue.equalsIgnoreCase("DB2UNXPC") || strValue.equalsIgnoreCase("DB2OS390")) {
                strAssociation = EXTENSION_ASSOC;
                strAttribute = SERVERCLASSIDENTIFIER;
            } else {
                strAttribute = ENGINE;
            }
        }
        return this.getPrototypeByIdentifier(strAssociation, strAttribute, strValue, strReposId, strMetadataType, locale, store);
    }

    Prototype getPrototypeByIdentifier(String strAssociation, String strAttribute, String strValue, String strReposId, String strMetadataType, Locale locale, MdStore store) throws MdException, RemoteException {
        Prototype prototype = null;
        String strLocale = GENERIC_TEMPLATE;
        if (strMetadataType == null) {
            strMetadataType = strAttribute.equalsIgnoreCase(ENGINE) ? "SASLibrary" : (strAttribute.equalsIgnoreCase(SERVERCLASSIDENTIFIER) ? "DatabaseSchema" : "ServerComponent");
        }
        String strNameAttribute = "Name";
        String strValueAttribute = "Value";
        if (strAssociation != null && strAssociation.equalsIgnoreCase(PROTOTYPE_PROPERTIES)) {
            strNameAttribute = "Property" + strNameAttribute;
            strValueAttribute = "Default" + strValueAttribute;
        }
        String strType = RB.getStringResource("Prototype.Type.notrans");
        String strTemplate = RB.getStringResource("Prototype.Template.Simple.notrans");
        String strSelect = "<XMLSELECT search=\"*[@MetadataType='" + strMetadataType + "'][" + strAssociation + "/*[@" + strNameAttribute + "='" + strAttribute + "' AND @" + strValueAttribute + "='" + strValue + "']/OwningPrototype/Prototype/Extensions/*[@Name='Locale' AND @Value='" + strLocale + "']]\"/>";
        if (strMetadataType.equals("DatabaseSchema") || strMetadataType.equals("SASLibrary") && strAttribute.equals(SERVERCLASSIDENTIFIER)) {
            strSelect = "<XMLSELECT search=\"*[@MetadataType='" + strMetadataType + "'][" + strAssociation + "/*[@" + strNameAttribute + "='" + strAttribute + "' AND @" + strValueAttribute + "='" + strValue + "']/OwningObject/Prototype/Extensions/*[@Name='Locale' AND @Value='" + strLocale + "']]\"/>";
        }
        if (strAssociation == null) {
            strSelect = "<XMLSELECT search=\"@" + strAttribute + "='" + strValue + "'\"/>";
        }
        String strOptions = strTemplate + strSelect;
        int flags = 396;
        List prototypeList = new Vector();
        try {
            prototypeList = this.ctx.getFactory().getOMIUtil().getMetadataObjectsSubset(store, strReposId, strType, flags, strOptions, true);
        }
        catch (MdException exc) {
            this.logger.error(exc.getMessage());
            throw exc;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (prototypeList.size() > 0) {
            prototype = (Prototype)prototypeList.get(0);
        }
        return prototype;
    }
}

