/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.repository;

import com.sas.batch.appmeta.ApplicationMetadataUtility;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurityAdmin;
import com.sas.meta.SASOMI.ISecurityAdminPackage.SECAD_ACT_ALREADY_EXISTS;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.FastMetadata;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Permission;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.SecurityRuleScheme;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.remote.TypeDefinition;
import com.sas.services.information.publicobject.PublicTypeUtility;
import com.sas.services.util.Names;
import com.sas.services.util.XMLUtil;
import com.sas.svcs.metadata.mgmt.client.ConnectedIdentityInfo;
import com.sas.svcs.metadata.mgmt.client.CustomRepository;
import com.sas.svcs.metadata.mgmt.client.FoundationRepository;
import com.sas.svcs.metadata.mgmt.client.MetadataRepositoryService;
import com.sas.svcs.metadata.mgmt.client.MetadataServerService;
import com.sas.svcs.metadata.mgmt.client.Operation;
import com.sas.svcs.metadata.mgmt.client.ProjectRepository;
import com.sas.svcs.metadata.mgmt.client.Repository;
import com.sas.svcs.metadata.mgmt.client.RepositoryCreationResult;
import com.sas.svcs.metadata.mgmt.impl.RequestContext;
import com.sas.svcs.metadata.mgmt.impl.repository.LocalizedResourceUtility;
import com.sas.svcs.metadata.mgmt.impl.repository.RB;
import com.sas.svcs.metadata.mgmt.impl.repository.RepositoryAuthorization;
import com.sas.svcs.metadata.mgmt.impl.repository.ResourceTemplateHelper;
import com.sas.text.Message;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class RepositoryHelper {
    private final Logger logger = LogManager.getLogger(RepositoryHelper.class);
    private RequestContext ctx;
    private MetadataRepositoryService repositoryService;
    private MetadataServerService serverService;
    private boolean alreadyLoadedTypeDefinitions = false;
    private boolean alreadyLoadedResourceTemplates = false;
    private boolean alreadyLoadedIdentityGroups = false;
    private boolean alreadyLoadedInheritanceRules = false;
    private boolean alreadyLoadedPolicies = false;
    private boolean alreadyLoadedEntityPropertyTypes = false;
    private static ApplicationMetadataUtility _amu = null;
    private static final String UPGRADE_LEVEL_NAME = "Upgrade Level";
    private static final String UPGRADE_LEVEL_ROLE = "UpgradeLevel";
    static final LinkedHashSet<String> PERMISSION_NAMES = new LinkedHashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("ReadMetadata");
            this.add("WriteMetadata");
            this.add("CheckInMetadata");
            this.add("Read");
            this.add("Write");
            this.add("Administer");
            this.add("Create");
            this.add("Delete");
            this.add("Execute");
            this.add("WriteMemberMetadata");
            this.add("Create Table");
            this.add("Drop Table");
            this.add("Alter Table");
            this.add("Select");
            this.add("Insert");
            this.add("Update");
            this.add("References");
            this.add("ManageCredentialsMetadata");
            this.add("ManageMemberMetadata");
        }
    };
    static final int CURRENT_UPGRADE_LEVEL = 9043001;
    static final String USER_FOLDER_SEPARATOR = "/";

    RepositoryHelper(RequestContext ctx, MetadataRepositoryService repositoryService, MetadataServerService serverService) {
        this.ctx = ctx;
        this.repositoryService = repositoryService;
        this.serverService = serverService;
    }

    int getUpgradeLevel(Repository repository) {
        int highestUpgrade;
        block12: {
            String XMLSELECT = "<XMLSELECT search=\"TextStore[@TextRole='UpgradeLevel'][Objects/SoftwareComponent[@ClassIdentifier='E5F27790-2149-11D6-8828-AA0004006D06']]\"/>";
            String OLD_XMLSELECT = "<XMLSELECT search=\"TextStore[@TextRole='UpgradeLevel'][Objects/Group[@Name='RepositoryUpgrades']]\"/>";
            int FLAGS = 392;
            highestUpgrade = 0;
            List textStores = null;
            try {
                int thisUpgrade;
                textStores = this.ctx.getFactory().getOMIUtil().getFastMetadataObjects("TextStore", repository.getId(), "<XMLSELECT search=\"TextStore[@TextRole='UpgradeLevel'][Objects/SoftwareComponent[@ClassIdentifier='E5F27790-2149-11D6-8828-AA0004006D06']]\"/>", 392);
                for (FastMetadata textStore : textStores) {
                    thisUpgrade = 0;
                    String storedText = textStore.getAttribute("StoredText");
                    Matcher m = Pattern.compile("(\\d+)\\.(\\d+)([M.](\\d+))?-(\\d+)").matcher(storedText);
                    if (!m.matches()) {
                        this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.GetUpgradeLevel.UnknownTextStore.Error.txt", (Object)UPGRADE_LEVEL_NAME, (Object)storedText));
                        continue;
                    }
                    thisUpgrade = Integer.parseInt(m.group(1)) * 1000000 + Integer.parseInt(m.group(2)) * 10000 + Integer.parseInt(m.group(5));
                    if (m.group(4) != null) {
                        thisUpgrade += Integer.parseInt(m.group(4)) * 1000;
                    }
                    if (thisUpgrade <= highestUpgrade) continue;
                    highestUpgrade = thisUpgrade;
                }
                if (highestUpgrade != 0) break block12;
                textStores = this.ctx.getFactory().getOMIUtil().getFastMetadataObjects("TextStore", repository.getId(), "<XMLSELECT search=\"TextStore[@TextRole='UpgradeLevel'][Objects/Group[@Name='RepositoryUpgrades']]\"/>", 392);
                for (FastMetadata textStore : textStores) {
                    thisUpgrade = 0;
                    String name = textStore.getAttribute("Name");
                    String storedText = textStore.getAttribute("StoredText");
                    if (name.startsWith("9.2.")) {
                        thisUpgrade = 9020000;
                    } else if (name.startsWith("9.3.")) {
                        thisUpgrade = 9030000;
                    }
                    try {
                    }
                    catch (NumberFormatException e) {
                        this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.GetUpgradeLevel.InvalidStoredText.Error.txt", (Object)name, (Object)storedText));
                        continue;
                    }
                    if ((thisUpgrade += Integer.parseInt(storedText)) <= highestUpgrade) continue;
                    highestUpgrade = thisUpgrade;
                }
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
            catch (MdException e) {
                this.logError(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.GetUpgradeLevel.Error.txt", (Object)e.getMessage()));
            }
        }
        return highestUpgrade;
    }

    void createUpgradeLevel(Repository repository, int upgradeLevel) {
        int currentLevel = this.getUpgradeLevel(repository);
        if (currentLevel == upgradeLevel) {
            return;
        }
        this.logger.info(RB.getStringResource("RepositoryHelper.Exec.UpgradeLevel.txt"));
        String XMLSELECT = "<XMLSELECT search=\"SoftwareComponent[@ClassIdentifier='E5F27790-2149-11D6-8828-AA0004006D06']\"/>";
        int FLAGS = 384;
        MdFactory factory = this.ctx.getFactory();
        try {
            MdObjectStore store = factory.createObjectStore();
            List softwareComponents = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "SoftwareComponent", 384, "<XMLSELECT search=\"SoftwareComponent[@ClassIdentifier='E5F27790-2149-11D6-8828-AA0004006D06']\"/>", false);
            if (softwareComponents.isEmpty()) {
                this.logError(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.BIPService.NotFound.Error.txt", (Object)repository.getName()));
                return;
            }
            TextStore upgradeLevelTextStore = (TextStore)factory.createComplexMetadataObject(store, UPGRADE_LEVEL_NAME, "TextStore", repository.getShortId());
            upgradeLevelTextStore.setTextRole(UPGRADE_LEVEL_ROLE);
            StringBuffer level = new StringBuffer();
            level.append(Integer.toString(upgradeLevel / 1000000));
            level.append(".");
            level.append(Integer.toString(upgradeLevel / 10000 % 100));
            int mLevel = upgradeLevel / 1000 % 10;
            if (mLevel > 0) {
                level.append("M");
                level.append(Integer.toString(mLevel));
            }
            level.append("-");
            level.append(Integer.toString(upgradeLevel % 1000));
            upgradeLevelTextStore.setStoredText(level.toString());
            upgradeLevelTextStore.getObjects().add(softwareComponents.get(0));
            upgradeLevelTextStore.updateMetadataAll();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            this.logError(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.CreateUpgradeLevel.Error.txt", (Object)e.getMessage()));
        }
        this.createPastReleaseUpgradeMarker(repository);
    }

    void createPastReleaseUpgradeMarker(Repository repository) {
        MdFactory factory = this.ctx.getFactory();
        String release = "9.4.0";
        String fixpack = "25";
        int upgradeLevel = 9040000;
        int pastLevel = this.getPastReleaseUpgradeLevel(repository);
        if (pastLevel >= 9040000) {
            return;
        }
        try {
            MdObjectStore store = factory.createObjectStore();
            IOMI omiConnection = factory.getConnection().getCMRHandle();
            String[][] PublicAuthOnUpgradeRecords = new String[][]{{"IdentityGroup", "PUBLIC", "G", "ReadMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}};
            Group grp = null;
            String grpId = null;
            grp = this.getUpgradeGroupRecord(store, repository);
            if (grp == null) {
                grp = (Group)factory.createComplexMetadataObject(store, "RepositoryUpgrades", "Group", repository.getShortId());
            }
            TextStore ts = (TextStore)factory.createComplexMetadataObject(store, "9.4.0", "TextStore", repository.getShortId());
            ts.setStoredText("25");
            ts.setTextRole(UPGRADE_LEVEL_ROLE);
            grp.getNotes().add((Object)ts);
            grp.updateMetadataAll();
            grpId = grp.getFQID();
            if (grpId != null) {
                ISecurityAdmin iSecAdmin = factory.getConnection().MakeISecurityAdminConnection(omiConnection);
                if (iSecAdmin == null) {
                    throw new MdException(RB.getStringResource("RepositoryAuthorization.ISecurityAdmin.Connection.Error5.txt"));
                }
                String shortFoundationId = repository.getShortId();
                String strAdminACT = "OMSOBJ:AccessControlTemplate/" + this.getActId(iSecAdmin, RB.getStringResource("RepositoryHelper.SASAdminACT.Name.notrans"), shortFoundationId);
                String strGRPObjID = "OMSOBJ:Group/" + grpId;
                StringHolder shTransContext = new StringHolder();
                iSecAdmin.BeginTransactionContext(strGRPObjID, 0, shTransContext);
                iSecAdmin.ApplyACTToObj(shTransContext.value, "", 0, strAdminACT);
                iSecAdmin.SetAuthorizationsOnObj("", strGRPObjID, 0, PublicAuthOnUpgradeRecords);
                iSecAdmin.EndTransactionContext(shTransContext.value, strGRPObjID, 1);
            }
            store.dispose();
        }
        catch (Exception e) {
            this.logError(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.CreatePastReleaseUpgradeMarker.Error.txt", (Object)e.getMessage()));
        }
    }

    int getPastReleaseUpgradeLevel(Repository repository) {
        String OLD_XMLSELECT = "<XMLSELECT search=\"TextStore[@TextRole='UpgradeLevel'][Objects/Group[@Name='RepositoryUpgrades']]\"/>";
        int FLAGS = 392;
        int highestUpgrade = 0;
        List textStores = null;
        try {
            textStores = this.ctx.getFactory().getOMIUtil().getFastMetadataObjects("TextStore", repository.getId(), "<XMLSELECT search=\"TextStore[@TextRole='UpgradeLevel'][Objects/Group[@Name='RepositoryUpgrades']]\"/>", 392);
            for (FastMetadata textStore : textStores) {
                int thisUpgrade = 0;
                String name = textStore.getAttribute("Name");
                String storedText = textStore.getAttribute("StoredText");
                if (name.startsWith("9.2.")) {
                    thisUpgrade = 9020000;
                } else if (name.startsWith("9.3.")) {
                    thisUpgrade = 9030000;
                } else if (name.startsWith("9.4.")) {
                    thisUpgrade = 9040000;
                }
                try {
                }
                catch (NumberFormatException e) {
                    this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.GetUpgradeLevel.InvalidStoredText.Error.txt", (Object)name, (Object)storedText));
                    continue;
                }
                if ((thisUpgrade += Integer.parseInt(storedText)) <= highestUpgrade) continue;
                highestUpgrade = thisUpgrade;
            }
        }
        catch (Exception e) {
            this.logError(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.GetUpgradeLevel.Error.txt", (Object)e.getMessage()));
        }
        return highestUpgrade;
    }

    void loadTypeDefinitions(Repository repository) throws Exception {
        if (this.alreadyLoadedTypeDefinitions) {
            return;
        }
        this.logger.info(RB.getStringResource("RepositoryHelper.Exec.TypeDictionary.txt"));
        boolean problem = false;
        if (!repository.isFoundation()) {
            return;
        }
        Map fileList = this.getTypeDefList();
        ArrayList<String> errorList = new ArrayList<String>();
        Set keys = fileList.keySet();
        for (String typeName : keys) {
            Map fileInfo = (Map)fileList.get(typeName);
            String fileName = (String)fileInfo.get("File");
            String templateName = (String)fileInfo.get("Template");
            if (fileName == null || fileName.equalsIgnoreCase("")) break;
            boolean loadedEntry = this.loadDictionaryEntries(this.ctx.getFactory(), fileName, repository.getId(), typeName, errorList, templateName);
            if (loadedEntry) continue;
            problem = true;
        }
        if (problem) {
            for (String errMsg : errorList) {
                this.logger.error(errMsg);
            }
            throw new Exception(RB.getStringResource("RepositoryHelper.AddTypeDictionary.Error.txt"));
        }
        this.alreadyLoadedTypeDefinitions = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadPermissions(Repository repository) throws Exception {
        String GRANT = "GRANT";
        String DENY = "DENY";
        this.logger.info(RB.getStringResource("RepositoryHelper.Exec.Permissions.txt"));
        String reposID = repository.getShortId();
        MdObjectStore store = this.ctx.getFactory().createObjectStore();
        try {
            int flags = 260;
            String template = "<Templates><Permission Name=\"\" Type=\"\"/></Templates>";
            List permissions = this.ctx.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "Permission", flags, template, false);
            if (permissions.isEmpty()) {
                for (String permName : PERMISSION_NAMES) {
                    this.createDefaultPermission(store, reposID, permName, GRANT);
                    this.createDefaultPermission(store, reposID, permName, DENY);
                }
            } else {
                for (String permName : PERMISSION_NAMES) {
                    boolean foundGrant = false;
                    boolean foundDeny = false;
                    for (Permission perm : permissions) {
                        if (permName.equals(perm.getName())) {
                            if (perm.getType().equals(GRANT)) {
                                foundGrant = true;
                            } else if (perm.getType().equals(DENY)) {
                                foundDeny = true;
                            }
                        }
                        if (!foundGrant || !foundDeny) continue;
                        break;
                    }
                    if (!foundDeny) {
                        this.createDefaultPermission(store, reposID, permName, DENY);
                    }
                    if (foundGrant) continue;
                    this.createDefaultPermission(store, reposID, permName, GRANT);
                }
            }
            store.updatedMetadataAll();
        }
        finally {
            try {
                if (store != null) {
                    store.dispose();
                }
            }
            catch (RemoteException remoteException) {}
        }
    }

    private void createDefaultPermission(MdObjectStore store, String repositoryId, String permName, String permType) throws RemoteException {
        Permission perm = (Permission)this.ctx.getFactory().createComplexMetadataObject(store, null, permName, "Permission", repositoryId);
        perm.setType(permType);
    }

    void loadIdentityGroups(Repository repository) throws Exception {
        String cleanDesc;
        String cleanName;
        String cleanDesc2;
        if (this.alreadyLoadedIdentityGroups) {
            return;
        }
        this.logger.info(RB.getStringResource("RepositoryHelper.Exec.Groups.txt"));
        String inXML = null;
        int flags = 0x10000180;
        MdFactory factory = this.ctx.getFactory();
        String options = "<XMLSELECT search=\"@Name = 'SASUSERS' OR @Name = 'PUBLIC' OR @Name = 'SASAdministrators' OR @Name = 'META: Unrestricted Users Role' OR @Name = 'META: User and Group Administrators Role' OR @Name = 'META: Operators Role' OR @Name = 'SAS System Services' OR @Name = 'SAS Administrators' \"/>";
        MdObjectStore store = factory.createObjectStore();
        List identityGroups = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "IdentityGroup", flags, options, false);
        boolean foundSASUSERS = false;
        boolean foundPUBLIC = false;
        boolean foundSASADMIN = false;
        boolean foundAltSASADMIN = false;
        boolean foundUNRESTRICTEDUSERS = false;
        boolean foundUSERADMINISTRATORS = false;
        boolean foundOPERATORS = false;
        boolean foundSASSystemServices = false;
        for (int i = 0; i < identityGroups.size(); ++i) {
            IdentityGroup group = (IdentityGroup)identityGroups.get(i);
            if (group.getName().equals("SASUSERS")) {
                foundSASUSERS = true;
                continue;
            }
            if (group.getName().equals("PUBLIC")) {
                foundPUBLIC = true;
                continue;
            }
            if (group.getName().equals("SASAdministrators")) {
                foundSASADMIN = true;
                continue;
            }
            if (group.getName().equals("META: Unrestricted Users Role")) {
                foundUNRESTRICTEDUSERS = true;
                continue;
            }
            if (group.getName().equals("META: User and Group Administrators Role")) {
                foundUSERADMINISTRATORS = true;
                continue;
            }
            if (group.getName().equals("META: Operators Role")) {
                foundOPERATORS = true;
                continue;
            }
            if (group.getName().equals("SAS System Services")) {
                foundSASSystemServices = true;
                continue;
            }
            if (!group.getName().equals("SAS Administrators")) continue;
            foundAltSASADMIN = true;
        }
        store.dispose();
        if (foundSASUSERS && foundPUBLIC && foundSASADMIN && foundUNRESTRICTEDUSERS && foundUSERADMINISTRATORS && foundOPERATORS && foundSASSystemServices) {
            return;
        }
        StringBuffer inXMLBuffer = new StringBuffer();
        if (!foundSASUSERS) {
            cleanDesc2 = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.SASUSERS.Description.txt"));
            inXMLBuffer.append("<IdentityGroup Name=\"SASUSERS\" Desc=\"" + cleanDesc2 + "\" PublicType=\"UserGroup\" UsageVersion=\"1000000.0\" />");
        }
        if (!foundPUBLIC) {
            cleanDesc2 = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.PUBLIC.Description.txt"));
            inXMLBuffer.append("<IdentityGroup Name=\"PUBLIC\" Desc=\"" + cleanDesc2 + "\" PublicType=\"UserGroup\" UsageVersion=\"1000000.0\" />");
        }
        if (!foundSASADMIN && !foundAltSASADMIN) {
            cleanName = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.SASAdministrators.DisplayName.txt"));
            cleanDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.SASAdministrators.Description.txt"));
            inXMLBuffer.append("<IdentityGroup Name=\"SASAdministrators\" DisplayName=\"" + cleanName + "\" Desc=\"" + cleanDesc + "\" PublicType=\"UserGroup\" UsageVersion=\"1000000.0\" />");
        }
        if (!foundUNRESTRICTEDUSERS) {
            cleanName = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.UnrestrictedUsersRole.DisplayName.txt"));
            cleanDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.UnrestrictedUsersRole.Description.txt"));
            inXMLBuffer.append("<IdentityGroup Name=\"META: Unrestricted Users Role\" GroupType=\"ROLE\" DisplayName=\"" + cleanName + "\" Desc=\"" + cleanDesc + "\" PublicType=\"Role\" UsageVersion=\"1000000.0\" />");
        }
        if (!foundUSERADMINISTRATORS) {
            cleanName = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.UserAdministratorsRole.DisplayName.txt"));
            cleanDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.UserAdministratorsRole.Description.txt"));
            inXMLBuffer.append("<IdentityGroup Name=\"META: User and Group Administrators Role\" GroupType=\"ROLE\" DisplayName=\"" + cleanName + "\" Desc=\"" + cleanDesc + "\" PublicType=\"Role\" UsageVersion=\"1000000.0\" />");
        }
        if (!foundOPERATORS) {
            cleanName = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.OperatorsRole.DisplayName.txt"));
            cleanDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.OperatorsRole.Description.txt"));
            inXMLBuffer.append("<IdentityGroup Name=\"META: Operators Role\" GroupType=\"ROLE\" DisplayName=\"" + cleanName + "\" Desc=\"" + cleanDesc + "\" PublicType=\"Role\" UsageVersion=\"1000000.0\" />");
        }
        if (!foundSASSystemServices) {
            cleanName = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.SASSystemServices.DisplayName.txt"));
            cleanDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.SASSystemServices.Description.txt"));
            inXMLBuffer.append("<IdentityGroup Name=\"SAS System Services\" DisplayName=\"" + cleanName + "\" Desc=\"" + cleanDesc + "\" PublicType=\"UserGroup\" UsageVersion=\"1000000.0\" />");
        }
        inXML = inXMLBuffer.toString();
        StringHolder outXML = new StringHolder();
        int rc = factory.getOMIUtil().addMetadata(inXML, repository.getShortId(), outXML, 0x10000000);
        if (rc == 0) {
            if (foundSASADMIN) {
                this.upgradeSASAdminGroupRoleAssociations(factory, repository.getId(), false);
            } else {
                this.upgradeSASAdminGroupRoleAssociations(factory, repository.getId(), foundAltSASADMIN);
            }
            String outXMLString = "<dummy>" + outXML.value + "</dummy>";
            Document mainDoc = factory.getOMIUtil().parseXML(outXMLString);
            if (mainDoc != null) {
                Element replyRoot = mainDoc.getDocumentElement();
                NodeList nodeList = replyRoot.getElementsByTagName("IdentityGroup");
                String[][] PublicDenials = new String[][]{{"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "CheckInMetadata", ""}};
                ISecurityAdmin iSecAdmin = factory.getConnection().MakeISecurityAdminConnection(factory.getConnection().getCMRHandle());
                if (iSecAdmin == null) {
                    this.logError(RB.getStringResource("RepositoryAuthorization.ISecurityAdmin.Connection.Error8.txt"));
                    return;
                }
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node currentNode = nodeList.item(i);
                    NamedNodeMap nodeMap = currentNode.getAttributes();
                    String strResourceId = "OMSOBJ:IdentityGroup/" + nodeMap.getNamedItem("Id").getNodeValue();
                    iSecAdmin.SetAuthorizationsOnObj("", strResourceId, 0, PublicDenials);
                }
            }
        }
        this.alreadyLoadedIdentityGroups = true;
    }

    void loadInheritanceRules(Repository repository) throws Exception {
        String ruleReposId;
        if (this.alreadyLoadedInheritanceRules) {
            return;
        }
        this.logger.info(RB.getStringResource("RepositoryHelper.Exec.InheritanceRules.txt"));
        MdObjectStore store = this.ctx.getFactory().createObjectStore();
        SecurityRuleScheme securityRule = this.getDefaultInheritanceRules(store, repository);
        if (securityRule != null && (ruleReposId = securityRule.getRepositoryID()) != null && ruleReposId.equals(repository.getShortId())) {
            return;
        }
        store.dispose();
        this.populateInheritanceRules(repository);
        this.alreadyLoadedInheritanceRules = true;
    }

    void upgradeInheritanceRules(Repository repository) throws Exception {
        SecurityRuleScheme defaultScheme = null;
        MdObjectStore store = this.ctx.getFactory().createObjectStore();
        try {
            defaultScheme = this.getDefaultInheritanceRules(store, repository);
        }
        catch (Exception e) {
            this.logger.error(RB.getStringResource("RepositoryHelper.SecurityRuleFetchError.txt"), (Throwable)e);
        }
        try {
            this.logger.info(RB.getStringResource("RepositoryHelper.AddSecurityRules.txt"));
            this.populateInheritanceRules(repository);
        }
        catch (Exception e) {
            this.logError(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.SecurityRuleAddError.txt", (Object)e.getMessage()));
            store.dispose();
            return;
        }
        try {
            if (defaultScheme != null) {
                this.logger.info(RB.getStringResource("RepositoryHelper.DeleteSecurityRules.txt"));
                boolean success = this.deleteInheritanceRules(repository, defaultScheme);
                if (!success) {
                    this.logger.warn(RB.getStringResource("RepositoryHelper.SecurityRuleDeleteError.txt"));
                }
            } else {
                this.logger.info(RB.getStringResource("RepositoryHelper.NoSecurityRules.txt"));
            }
        }
        catch (Exception e) {
            this.logger.warn(RB.getStringResource("RepositoryHelper.SecurityRuleDeleteError.txt"), (Throwable)e);
        }
        this.refreshServer(this.ctx);
        store.dispose();
    }

    private void populateInheritanceRules(Repository repository) throws Exception {
        URL url = LocalizedResourceUtility.urlFromFile("com/sas/svcs/metadata/mgmt/impl/repository/data/PhysicalRules.xml");
        InputStream inputStream = null;
        inputStream = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String strContents = "";
        String strBuffer = null;
        while ((strBuffer = reader.readLine()) != null) {
            strContents = strContents + strBuffer;
        }
        StringHolder outXML = new StringHolder();
        String inXML = strContents;
        this.ctx.getFactory().getConnection().getCMRHandle().AddMetadata(inXML, repository.getId(), outXML, "SAS", 0x10000000, "");
    }

    void loadPolicies(Repository repository) throws Exception {
        String propName;
        if (this.alreadyLoadedPolicies) {
            return;
        }
        this.logger.info(RB.getStringResource("RepositoryHelper.Exec.Policies.txt"));
        MdObjectStore store = this.ctx.getFactory().createObjectStore();
        int flags = 0x10000188;
        String options = "<XMLSELECT search=\"@PropertyName='Store User Definitions' OR @PropertyName='Path to Users Root Folder'\"/>";
        List policiesList = this.ctx.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "Property", flags, options, false);
        boolean foundStoreUsers = false;
        boolean foundPathtoRoot = false;
        for (int i = 0; i < policiesList.size(); ++i) {
            Property policy = (Property)policiesList.get(i);
            if (policy.getPropertyName().equals("Store User Definitions")) {
                foundStoreUsers = true;
                continue;
            }
            if (!policy.getPropertyName().equals("Path to Users Root Folder")) continue;
            foundPathtoRoot = true;
        }
        store.dispose();
        if (foundStoreUsers && foundPathtoRoot) {
            return;
        }
        String bipserviceID = this.getBIPTreeId(repository);
        if (bipserviceID == null) {
            this.logError(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.BIPService.NotFound.Error.txt", (Object)repository.getName()));
            return;
        }
        StringBuffer inXMLBuffer = new StringBuffer();
        String pSetName = this.ctx.getFactory().getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.DefaultPolicySet.Name.txt"));
        inXMLBuffer.append("<PropertySet Name=\"" + pSetName + "\" PropertySetName=\"Metadata Repository Policies\">");
        inXMLBuffer.append("<SetProperties>");
        if (!foundStoreUsers) {
            propName = this.ctx.getFactory().getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.DefaultStorePolicy.Name.txt"));
            if (repository.isFoundation()) {
                inXMLBuffer.append("<Property Name=\"" + propName + "\" PropertyName=\"Store User Definitions\" DefaultValue=\"Y\"/>");
            } else {
                inXMLBuffer.append("<Property Name=\"" + propName + "\" PropertyName=\"Store User Definitions\" DefaultValue=\"N\"/>");
            }
        }
        if (!foundPathtoRoot) {
            propName = this.ctx.getFactory().getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.DefaultPathPolicy.Name.txt"));
            String defaultValue = this.ctx.getFactory().getOMIUtil().cleanStringForXML(USER_FOLDER_SEPARATOR + RB.getStringResource("MetadataRepositoryServiceImpl.DefaultUserFolder.txt"));
            inXMLBuffer.append("<Property Name=\"" + propName + "\" PropertyName=\"Path to Users Root Folder\" DefaultValue=\"" + defaultValue + "\"/>");
        }
        inXMLBuffer.append("</SetProperties>");
        inXMLBuffer.append("<OwningObject>");
        inXMLBuffer.append("<SoftwareComponent Objref=\"" + bipserviceID + "\"/>");
        inXMLBuffer.append("</OwningObject>");
        inXMLBuffer.append("</PropertySet>");
        String inXML = inXMLBuffer.toString();
        StringHolder outXML = new StringHolder();
        this.ctx.getFactory().getOMIUtil().addMetadata(inXML, repository.getShortId(), outXML, 0x10000000);
        this.alreadyLoadedPolicies = true;
    }

    void loadEntityPropertyTypes(Repository repository) throws Exception {
        if (this.alreadyLoadedEntityPropertyTypes) {
            return;
        }
        this.logger.info(RB.getStringResource("RepositoryHelper.Exec.EntityPropertyTypes.txt"));
        String inXML = RB.getStringResource("RepositoryHelper.EntityPropertyType.template.notrans");
        StringHolder outXML = new StringHolder();
        this.ctx.getFactory().getOMIUtil().addMetadata(inXML, repository.getShortId(), outXML, 0x10000000);
        this.alreadyLoadedEntityPropertyTypes = true;
    }

    void createBIPTree(Repository repository) throws Exception {
        if (this.doesBIPTreeExist(repository)) {
            return;
        }
        this.logger.info(RB.getStringResource("RepositoryHelper.Exec.BIPTree.txt"));
        MdFactory factory = this.ctx.getFactory();
        String userFolder = RB.getStringResource("MetadataRepositoryServiceImpl.DefaultUserFolder.txt");
        String scDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.BIPService.Description.txt"));
        String prodDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.ProductFolder.Description.txt"));
        String sharedDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.SharedDataFolder.Description.txt"));
        String userDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.UserFolder.Description.txt"));
        String systemDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.SystemFolder.Description.txt"));
        String adminDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.AdministrationFolder.Description.txt"));
        String appsDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.ApplicationsFolder.Description.txt"));
        String typesDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.TypesFolder.Description.txt"));
        String servDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.ServicesFolder.Description.txt"));
        String pubsDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.PublishingFolder.Description.txt"));
        String channelsDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.ChannelsFolder.Description.txt"));
        String subsDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.SubscribersFolder.Description.txt"));
        String contentsubsDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.ContentsFolder.Description.txt"));
        String secLibFolderDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.SecuredLibrariesFolder.Description.txt"));
        StringBuffer inXMLBuffer = new StringBuffer();
        inXMLBuffer.append("<SoftwareComponent Name=\"BIP Service\" Desc=\"" + scDesc + "\" ClassIdentifier=\"E5F27790-2149-11D6-8828-AA0004006D06\" IsLicensed=\"0\" Major=\"9\" Minor=\"2\" ProductName=\"SAS\" Platform=\"Java\" PublicType=\"RootFolder\" UsageVersion=\"1000000.0\" >");
        inXMLBuffer.append("<SoftwareTrees>");
        inXMLBuffer.append("<Tree Name=\"Products\" Desc=\"" + prodDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\"/> ");
        inXMLBuffer.append("<Tree Name=\"Shared Data\" Desc=\"" + sharedDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\"/>");
        inXMLBuffer.append("<Tree Name=\"" + userFolder + "\" Desc=\"" + userDesc + "\" TreeType=\"System\" PublicType=\"Folder\" UsageVersion=\"1000000.0\"/>");
        inXMLBuffer.append("<Tree Name=\"System\" Desc=\"" + systemDesc + "\" TreeType=\"System\" PublicType=\"Folder\" UsageVersion=\"1000000.0\">");
        inXMLBuffer.append("<SubTrees>");
        inXMLBuffer.append("<Tree Name=\"Administration\" Desc=\"" + adminDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\"/>");
        inXMLBuffer.append("<Tree Name=\"Applications\" Desc=\"" + appsDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\"/>");
        inXMLBuffer.append("<Tree Name=\"Types\" Desc=\"" + typesDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\"/>");
        inXMLBuffer.append("<Tree Name=\"Services\" Desc=\"" + servDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\"/>");
        inXMLBuffer.append("<Tree Name=\"Secured Libraries\" Desc=\"" + secLibFolderDesc + "\" TreeType=\"System\" PublicType=\"Folder.SecuredData\" UsageVersion=\"1000000.0\"/>");
        inXMLBuffer.append("<Tree Name=\"Publishing\" Desc=\"" + pubsDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\">");
        inXMLBuffer.append("<SubTrees>");
        inXMLBuffer.append("<Tree Name=\"Channels\" Desc=\"" + channelsDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\"/>");
        inXMLBuffer.append("<Tree Name=\"Subscribers\" Desc=\"" + subsDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\">");
        inXMLBuffer.append("<SubTrees>");
        inXMLBuffer.append("<Tree Name=\"Content Subscribers\" Desc=\"" + contentsubsDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\"/>");
        inXMLBuffer.append("</SubTrees>");
        inXMLBuffer.append("</Tree>");
        inXMLBuffer.append("</SubTrees>");
        inXMLBuffer.append("</Tree>");
        inXMLBuffer.append("</SubTrees>");
        inXMLBuffer.append("</Tree>");
        inXMLBuffer.append("</SoftwareTrees>");
        inXMLBuffer.append("</SoftwareComponent>");
        String inXML = inXMLBuffer.toString();
        StringHolder outXML = new StringHolder();
        factory.getOMIUtil().addMetadata(inXML, repository.getShortId(), outXML, 0x10000000);
        String outXMLString = "<dummy>" + outXML.value + "</dummy>";
        Document mainDoc = factory.getOMIUtil().parseXML(outXMLString);
        if (mainDoc != null) {
            String strResourceId;
            String strName;
            NamedNodeMap nodeMap;
            Node currentNode;
            String[][] PublicDenials = new String[][]{{"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "CheckInMetadata", ""}};
            ISecurityAdmin iSecAdmin = factory.getConnection().MakeISecurityAdminConnection(factory.getConnection().getCMRHandle());
            if (iSecAdmin == null) {
                this.logError(RB.getStringResource("RepositoryAuthorization.ISecurityAdmin.Connection.Error8.txt"));
                return;
            }
            Element replyRoot = mainDoc.getDocumentElement();
            NodeList nodeList = replyRoot.getElementsByTagName("Tree");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                currentNode = nodeList.item(i);
                nodeMap = currentNode.getAttributes();
                strName = nodeMap.getNamedItem("Name").getNodeValue();
                if (!strName.equals(userFolder) && !strName.equals("System")) continue;
                strResourceId = "OMSOBJ:Tree/" + nodeMap.getNamedItem("Id").getNodeValue();
                iSecAdmin.SetAuthorizationsOnObj("", strResourceId, 0, PublicDenials);
            }
            NodeList nodeList2 = replyRoot.getElementsByTagName("SoftwareComponent");
            currentNode = nodeList2.item(0);
            nodeMap = currentNode.getAttributes();
            strName = nodeMap.getNamedItem("Name").getNodeValue();
            if (strName.equals("BIP Service")) {
                strResourceId = "OMSOBJ:SoftwareComponent/" + nodeMap.getNamedItem("Id").getNodeValue();
                iSecAdmin.SetAuthorizationsOnObj("", strResourceId, 0, PublicDenials);
            }
        }
    }

    void createCustomBIPTree(Repository repository) throws Exception {
        if (this.doesBIPTreeExist(repository)) {
            return;
        }
        this.logger.info(RB.getStringResource("RepositoryHelper.Exec.BIPTree.txt"));
        String strReposName = repository.getName();
        MdFactory factory = this.ctx.getFactory();
        String reposFolderName = Names.mapNameToOMRObjectName((String)strReposName);
        Repository foundation = this.repositoryService.getFoundationRepository();
        String bipServiceId = this.getBIPTreeId(foundation);
        if (bipServiceId == null) {
            throw new Exception(RB.getStringResource("RepositoryHelper.FoundationBIPServiceId.NotFound.Error.txt"));
        }
        String scCustomDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.BIPServiceCustom.Description.txt"));
        String reposFolderDesc = factory.getOMIUtil().cleanStringForXML(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataRepositoryServiceImpl.CustomReposFolder.Description.txt", (Object)strReposName));
        String systemDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.SystemFolder.Description.txt"));
        String secLibFolderDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.SecuredLibrariesFolder.Description.txt"));
        StringBuilder inXMLBuffer = new StringBuilder(750);
        inXMLBuffer.append("<SoftwareComponent Name=\"BIP Service\" Desc=\"" + scCustomDesc + "\" ClassIdentifier=\"E5F27790-2149-11D6-8828-AA0004006D06\" IsLicensed=\"0\" Major=\"9\" Minor=\"2\" ProductName=\"SAS\" Platform=\"Java\" PublicType=\"RootFolder\" UsageVersion=\"1000000.0\" >");
        inXMLBuffer.append("<SoftwareTrees>");
        inXMLBuffer.append("<Tree Name=\"" + reposFolderName + "\" Desc=\"" + reposFolderDesc + "\" TreeType=\"BIP Folder\" PublicType=\"Folder\" UsageVersion=\"1000000.0\">");
        inXMLBuffer.append("<SoftwareComponents>");
        inXMLBuffer.append("<SoftwareComponent Objref=\"" + bipServiceId + "\" />");
        inXMLBuffer.append("</SoftwareComponents>");
        inXMLBuffer.append("<SubTrees>");
        inXMLBuffer.append("<Tree Name=\"System\" Desc=\"" + systemDesc + "\" TreeType=\"System\" PublicType=\"Folder\" UsageVersion=\"1000000.0\">");
        inXMLBuffer.append("<SubTrees>");
        inXMLBuffer.append("<Tree Name=\"Secured Libraries\" Desc=\"" + secLibFolderDesc + "\" TreeType=\"System\" PublicType=\"Folder.SecuredData\" UsageVersion=\"1000000.0\"/>");
        inXMLBuffer.append("</SubTrees>");
        inXMLBuffer.append("</Tree>");
        inXMLBuffer.append("</SubTrees>");
        inXMLBuffer.append("</Tree>");
        inXMLBuffer.append("</SoftwareTrees>");
        inXMLBuffer.append("</SoftwareComponent>");
        String inXML = inXMLBuffer.toString();
        StringHolder outXML = new StringHolder();
        factory.getOMIUtil().addMetadata(inXML, repository.getShortId(), outXML, 0x10000000);
        String outXMLString = "<dummy>" + outXML.value + "</dummy>";
        Document mainDoc = factory.getOMIUtil().parseXML(outXMLString);
        if (mainDoc != null) {
            String[][] PublicDenials = new String[][]{{"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "CheckInMetadata", ""}};
            ISecurityAdmin iSecAdmin = factory.getConnection().MakeISecurityAdminConnection(factory.getConnection().getCMRHandle());
            if (iSecAdmin == null) {
                this.logError(RB.getStringResource("RepositoryAuthorization.ISecurityAdmin.Connection.Error8.txt"));
                return;
            }
            Element replyRoot = mainDoc.getDocumentElement();
            NodeList nodeList = replyRoot.getElementsByTagName("SoftwareComponent");
            Node currentNode = nodeList.item(0);
            NamedNodeMap nodeMap = currentNode.getAttributes();
            String strName = nodeMap.getNamedItem("Name").getNodeValue();
            if (strName.equals("BIP Service")) {
                String strResourceId = "OMSOBJ:SoftwareComponent/" + nodeMap.getNamedItem("Id").getNodeValue();
                String strAdminACT = "OMSOBJ:AccessControlTemplate/" + this.getActId(iSecAdmin, RB.getStringResource("RepositoryHelper.SASAdminACT.Name.notrans"), foundation.getShortId());
                StringHolder shTransContext = new StringHolder();
                iSecAdmin.BeginTransactionContext(strResourceId, 0, shTransContext);
                iSecAdmin.ApplyACTToObj(shTransContext.value, "", 0, strAdminACT);
                iSecAdmin.SetAuthorizationsOnObj(shTransContext.value, "", 0, PublicDenials);
                ConnectedIdentityInfo connectedIdentity = this.serverService.getConnectedIdentityInfo();
                if (!(connectedIdentity.getUserName().equalsIgnoreCase("Public") && connectedIdentity.getUserType().equalsIgnoreCase("IdentityGroup") || connectedIdentity.getUserClass().toUpperCase().contains("UNRESTRICTED"))) {
                    String[][] CreatorAuths = new String[][]{{connectedIdentity.getUserType(), connectedIdentity.getUserName(), "G", "ReadMetadata", ""}, {connectedIdentity.getUserType(), connectedIdentity.getUserName(), "G", "WriteMetadata", ""}};
                    iSecAdmin.SetAuthorizationsOnObj(shTransContext.value, "", 0, CreatorAuths);
                }
                iSecAdmin.EndTransactionContext(shTransContext.value, strResourceId, 1);
            }
        }
    }

    void createProjectBIPService(Repository repository) throws Exception {
        if (this.doesBIPTreeExist(repository)) {
            return;
        }
        this.logger.info(RB.getStringResource("RepositoryHelper.Exec.BIPTree.txt"));
        MdFactory factory = this.ctx.getFactory();
        Repository foundation = this.repositoryService.getFoundationRepository();
        String scProjectDesc = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryHelper.BIPServiceProject.Description.txt"));
        StringBuilder inXMLBuffer = new StringBuilder(300);
        inXMLBuffer.append("<SoftwareComponent Name=\"BIP Service\" Desc=\"" + scProjectDesc + "\" ClassIdentifier=\"E5F27790-2149-11D6-8828-AA0004006D06\" IsLicensed=\"0\" Major=\"9\" Minor=\"2\" ProductName=\"SAS\" Platform=\"Java\" PublicType=\"RootFolder\" UsageVersion=\"1000000.0\" />");
        String inXML = inXMLBuffer.toString();
        StringHolder outXML = new StringHolder();
        factory.getOMIUtil().addMetadata(inXML, repository.getShortId(), outXML, 0x10000000);
        String outXMLString = "<dummy>" + outXML.value + "</dummy>";
        Document mainDoc = factory.getOMIUtil().parseXML(outXMLString);
        if (mainDoc != null) {
            String[][] PublicDenials = new String[][]{{"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "CheckInMetadata", ""}};
            ISecurityAdmin iSecAdmin = factory.getConnection().MakeISecurityAdminConnection(factory.getConnection().getCMRHandle());
            if (iSecAdmin == null) {
                this.logError(RB.getStringResource("RepositoryAuthorization.ISecurityAdmin.Connection.Error8.txt"));
                return;
            }
            Element replyRoot = mainDoc.getDocumentElement();
            NodeList nodeList = replyRoot.getElementsByTagName("SoftwareComponent");
            Node currentNode = nodeList.item(0);
            NamedNodeMap nodeMap = currentNode.getAttributes();
            String strName = nodeMap.getNamedItem("Name").getNodeValue();
            if (strName.equals("BIP Service")) {
                String strResourceId = "OMSOBJ:SoftwareComponent/" + nodeMap.getNamedItem("Id").getNodeValue();
                String strAdminACT = "OMSOBJ:AccessControlTemplate/" + this.getActId(iSecAdmin, RB.getStringResource("RepositoryHelper.SASAdminACT.Name.notrans"), foundation.getShortId());
                StringHolder shTransContext = new StringHolder();
                iSecAdmin.BeginTransactionContext(strResourceId, 0, shTransContext);
                iSecAdmin.ApplyACTToObj(shTransContext.value, "", 0, strAdminACT);
                iSecAdmin.SetAuthorizationsOnObj(shTransContext.value, "", 0, PublicDenials);
                ConnectedIdentityInfo connectedIdentity = this.serverService.getConnectedIdentityInfo();
                if (!(connectedIdentity.getUserName().equalsIgnoreCase("Public") && connectedIdentity.getUserType().equalsIgnoreCase("IdentityGroup") || connectedIdentity.getUserClass().toUpperCase().contains("UNRESTRICTED"))) {
                    String[][] CreatorAuths = new String[][]{{connectedIdentity.getUserType(), connectedIdentity.getUserName(), "G", "ReadMetadata", ""}, {connectedIdentity.getUserType(), connectedIdentity.getUserName(), "G", "WriteMetadata", ""}};
                    iSecAdmin.SetAuthorizationsOnObj(shTransContext.value, "", 0, CreatorAuths);
                }
                iSecAdmin.EndTransactionContext(shTransContext.value, strResourceId, 1);
            }
        }
    }

    void createRepositoryACTs(Repository repository) throws Exception {
        this.logger.info(RB.getStringResource("RepositoryHelper.Exec.ACT.txt"));
        String shortReposId = repository.getShortId();
        String defaultACTname = RB.getStringResource("RepositoryHelper.DefaultACT.Name.txt");
        String defaultACTdesc = RB.getStringResource("RepositoryHelper.DefaultACT.Desc.fmt.txt");
        StringHolder tCtxt = new StringHolder();
        String[][] DefaultACTAttributes = new String[][]{{"NAME", defaultACTname}, {"USE", "REPOS"}, {"DESC", defaultACTdesc}};
        String[][] DefaultFoundationAuths = new String[][]{{"IdentityGroup", "PUBLIC", "D", "ReadMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "CheckInMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "WriteMemberMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "Administer", ""}, {"IdentityGroup", "PUBLIC", "D", "Read", ""}, {"IdentityGroup", "PUBLIC", "D", "Write", ""}, {"IdentityGroup", "PUBLIC", "D", "Create", ""}, {"IdentityGroup", "PUBLIC", "D", "Delete", ""}, {"IdentityGroup", "PUBLIC", "D", "Execute", ""}, {"IdentityGroup", "PUBLIC", "D", "Create Table", ""}, {"IdentityGroup", "PUBLIC", "D", "Drop Table", ""}, {"IdentityGroup", "PUBLIC", "D", "Alter Table", ""}, {"IdentityGroup", "PUBLIC", "D", "Select", ""}, {"IdentityGroup", "PUBLIC", "D", "Insert", ""}, {"IdentityGroup", "PUBLIC", "D", "Update", ""}, {"IdentityGroup", "PUBLIC", "D", "References", ""}, {"IdentityGroup", "SASAdministrators", "G", "ReadMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "WriteMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "CheckInMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "Administer", ""}, {"IdentityGroup", "SAS System Services", "G", "ReadMetadata", ""}, {"IdentityGroup", "SAS System Services", "G", "WriteMetadata", ""}, {"IdentityGroup", "SASUSERS", "G", "ReadMetadata", ""}, {"IdentityGroup", "SASUSERS", "G", "WriteMetadata", ""}, {"IdentityGroup", "SASUSERS", "G", "CheckInMetadata", ""}};
        String[][] DefaultCustomAuths = new String[][]{{"IdentityGroup", "PUBLIC", "D", "ReadMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "CheckInMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "WriteMemberMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "Administer", ""}, {"IdentityGroup", "PUBLIC", "D", "Read", ""}, {"IdentityGroup", "PUBLIC", "D", "Write", ""}, {"IdentityGroup", "PUBLIC", "D", "Create", ""}, {"IdentityGroup", "PUBLIC", "D", "Delete", ""}, {"IdentityGroup", "PUBLIC", "D", "Execute", ""}, {"IdentityGroup", "PUBLIC", "D", "Create Table", ""}, {"IdentityGroup", "PUBLIC", "D", "Drop Table", ""}, {"IdentityGroup", "PUBLIC", "D", "Alter Table", ""}, {"IdentityGroup", "PUBLIC", "D", "Select", ""}, {"IdentityGroup", "PUBLIC", "D", "Insert", ""}, {"IdentityGroup", "PUBLIC", "D", "Update", ""}, {"IdentityGroup", "PUBLIC", "D", "References", ""}, {"IdentityGroup", "SASAdministrators", "G", "ReadMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "WriteMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "CheckInMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "Administer", ""}, {"IdentityGroup", "SAS System Services", "G", "ReadMetadata", ""}, {"IdentityGroup", "SAS System Services", "G", "WriteMetadata", ""}, {"IdentityGroup", "SASUSERS", "G", "ReadMetadata", ""}, {"IdentityGroup", "SASUSERS", "G", "WriteMetadata", ""}, {"IdentityGroup", "SASUSERS", "G", "CheckInMetadata", ""}};
        ISecurityAdmin iSecAdmin = this.ctx.getFactory().getConnection().MakeISecurityAdminConnection(this.ctx.getFactory().getConnection().getCMRHandle());
        if (iSecAdmin == null) {
            this.logError(RB.getStringResource("RepositoryAuthorization.ISecurityAdmin.Connection.Error4.txt"));
            return;
        }
        RepositoryAuthorization repositoryAuthorization = new RepositoryAuthorization(this.ctx, this.repositoryService, this.serverService);
        if (!repository.isFoundation()) {
            if (this.doesRepositoryACTExists(repository)) {
                return;
            }
            try {
                iSecAdmin.BeginTransactionContext("", 0, tCtxt);
                try {
                    iSecAdmin.CreateAccessControlTemplate(tCtxt.value, "REPOSID:" + shortReposId, DefaultACTAttributes);
                }
                catch (SECAD_ACT_ALREADY_EXISTS se) {
                    DefaultACTAttributes[0][1] = defaultACTname + "NEW";
                    iSecAdmin.CreateAccessControlTemplate(tCtxt.value, "REPOSID:" + shortReposId, DefaultACTAttributes);
                }
                if (repository.isCustom()) {
                    iSecAdmin.SetAuthorizationsOnObj(tCtxt.value, "", 4, DefaultCustomAuths);
                } else if (repository.isProject()) {
                    String[][] DefaultProjectAuths = repositoryAuthorization.buildDefaultProjectACTEntries(repository);
                    iSecAdmin.SetAuthorizationsOnObj(tCtxt.value, "", 4, DefaultProjectAuths);
                }
                String[][] CreatorAuths = repositoryAuthorization.buildCreatorACTEntries(repository);
                if (CreatorAuths != null) {
                    iSecAdmin.SetAuthorizationsOnObj(tCtxt.value, "", 0, CreatorAuths);
                }
                iSecAdmin.EndTransactionContext(tCtxt.value, "", 1);
            }
            catch (Exception e) {
                if (repository.isCustom()) {
                    throw new Exception(Message.format((String)"RepositoryHelper.CustomACT.Creation.Exception.txt", (Object)e.getMessage()));
                }
                throw new Exception(Message.format((String)"RepositoryHelper.ProjectACT.Creation.Exception.txt", (Object)e.getMessage()));
            }
        }
        boolean addedACTs = repositoryAuthorization.addAdditionalFoundationRepositoryACTs(repository, iSecAdmin);
        boolean createdDefaultACT = false;
        if (!this.doesRepositoryACTExists(repository)) {
            try {
                iSecAdmin.BeginTransactionContext("", 0, tCtxt);
                iSecAdmin.CreateAccessControlTemplate(tCtxt.value, "REPOSID:" + shortReposId, DefaultACTAttributes);
                iSecAdmin.SetAuthorizationsOnObj(tCtxt.value, "", 4, DefaultFoundationAuths);
                iSecAdmin.EndTransactionContext(tCtxt.value, "", 1);
                createdDefaultACT = true;
            }
            catch (Exception e) {
                throw new Exception(Message.format((String)"RepositoryHelper.FoundationACT.Creation.Exception.txt", (Object)e.getMessage()));
            }
        }
        if (!createdDefaultACT && !addedACTs) {
            return;
        }
    }

    boolean doesBIPTreeExist(Repository repository) {
        String options = "<XMLSELECT search=\"@ClassIdentifier='E5F27790-2149-11D6-8828-AA0004006D06'\"/>";
        try {
            int count = this.ctx.getFactory().getOMIUtil().doesObjectExist(repository.getId(), "SoftwareComponent", options);
            if (count > 0) {
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return false;
    }

    boolean doesRepositoryACTExists(Repository repository) {
        String options = "<XMLSELECT search=\"@Use='REPOS'\"/>";
        try {
            int count = this.ctx.getFactory().getOMIUtil().doesObjectExist(repository.getId(), "AccessControlTemplate", options);
            if (count > 0) {
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return false;
    }

    void loadResourceTemplates(Repository repository) throws Exception {
        if (this.alreadyLoadedResourceTemplates) {
            return;
        }
        this.logger.info(RB.getStringResource("RepositoryHelper.Exec.ResourceTemplates.txt"));
        this.deleteAllResourceTemplates(repository);
        ResourceTemplateHelper resourceTemplateHelper = new ResourceTemplateHelper(this.ctx);
        resourceTemplateHelper.addAllTemplates(repository);
        this.alreadyLoadedResourceTemplates = true;
    }

    private void deleteAllResourceTemplates(Repository repository) {
        String deleteTemplate = "<Template TemplateName=\"ResourceTemplate\"><Prototype><Notes/><Associations/><Extensions/><PrimaryPropertyGroup/><PrototypeProperties/><Properties/></Prototype><AssociationProperty><AssociatedPrototypes/><StoredConfiguration/><Customizers/></AssociationProperty><AttributeProperty><OwningType/><AssociatedPrototype/><StoredConfiguration/></AttributeProperty><Property><StoredConfiguration/><OwningType><PropertyType match=\"*[@Name='GenericString']\" TemplateExpand=\"no\"/><PropertyType TemplateExpand=\"yes\" /></OwningType><PrimaryPropertyGroup /></Property><PropertyGroup><Properties/><Extensions/><GroupedProperties/><SubPropertyGroups/></PropertyGroup><PropertyType><StoredConfiguration/><ElementType/></PropertyType></Template>";
        MdFactory factory = this.ctx.getFactory();
        try {
            List<Prototype> templates = this.getResourceTemplateList(repository);
            for (Prototype resourceTemplate : templates) {
                factory.getOMIUtil().deleteMetadataObject(resourceTemplate.getCMetadataType(), resourceTemplate.getFQID(), "<Template TemplateName=\"ResourceTemplate\"><Prototype><Notes/><Associations/><Extensions/><PrimaryPropertyGroup/><PrototypeProperties/><Properties/></Prototype><AssociationProperty><AssociatedPrototypes/><StoredConfiguration/><Customizers/></AssociationProperty><AttributeProperty><OwningType/><AssociatedPrototype/><StoredConfiguration/></AttributeProperty><Property><StoredConfiguration/><OwningType><PropertyType match=\"*[@Name='GenericString']\" TemplateExpand=\"no\"/><PropertyType TemplateExpand=\"yes\" /></OwningType><PrimaryPropertyGroup /></Property><PropertyGroup><Properties/><Extensions/><GroupedProperties/><SubPropertyGroups/></PropertyGroup><PropertyType><StoredConfiguration/><ElementType/></PropertyType></Template>");
            }
        }
        catch (MdException e) {
            this.logError(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.DeleteResourceTemplates.Error.txt", (Object)e.getMessage()));
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Prototype> getResourceTemplateList(Repository repository) {
        List templates = null;
        String xmlSelect = "<XMLSELECT search=\"Prototype[@MetadataType='ServerComponent' OR @MetadataType='ServerContext' OR @MetadataType='DatabaseSchema' OR @MetadataType='SASLibrary']\" />";
        int FLAGS = 396;
        String template = "<TEMPLATES><Prototype><Extensions search=\"@Name='Locale'\"/></Prototype></TEMPLATES>";
        MdFactory factory = this.ctx.getFactory();
        String options = "<XMLSELECT search=\"Prototype[@MetadataType='ServerComponent' OR @MetadataType='ServerContext' OR @MetadataType='DatabaseSchema' OR @MetadataType='SASLibrary']\" /><TEMPLATES><Prototype><Extensions search=\"@Name='Locale'\"/></Prototype></TEMPLATES>";
        try {
            MdObjectStore store = factory.createObjectStore();
            templates = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "Prototype", 396, options, false);
        }
        catch (MdException e) {
            this.logError(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.QueryResourceTemplates.Error.txt", (Object)e.getMessage()));
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        return templates;
    }

    void applyAdminACT(Repository repository) throws Exception {
        StringHolder tCtxt = new StringHolder();
        this.logger.info(RB.getStringResource("RepositoryHelper.Exec.ApplyAdminACT.txt"));
        String SASAdminACTname = RB.getStringResource("RepositoryHelper.SASAdminACT.Name.notrans");
        String privatefolderACTname = RB.getStringResource("RepositoryHelper.privatefolderACT.Name.notrans");
        String[][] PublicAuthOnACT = new String[][]{{"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}};
        ISecurityAdmin iSecAdmin = this.ctx.getFactory().getConnection().MakeISecurityAdminConnection(this.ctx.getFactory().getConnection().getCMRHandle());
        if (iSecAdmin == null) {
            throw new Exception(RB.getStringResource("RepositoryAuthorization.ISecurityAdmin.Connection.Error.tx"));
        }
        if (repository.isFoundation()) {
            try {
                String actId = this.getActId(iSecAdmin, SASAdminACTname, repository.getShortId());
                String strSASAdminACT = "";
                if (actId != "") {
                    strSASAdminACT = "OMSOBJ:AccessControlTemplate/" + actId;
                }
                String privatefolderActId = this.getActId(iSecAdmin, privatefolderACTname, repository.getShortId());
                String strPrivateFolderACT = "";
                if (privatefolderActId != "") {
                    strPrivateFolderACT = "OMSOBJ:AccessControlTemplate/" + privatefolderActId;
                }
                MdObjectStore store = this.ctx.getFactory().createObjectStore();
                int flags = 0x10000180;
                String options = "<XMLSELECT search=\"@Name = 'SASUSERS' OR @Name = 'PUBLIC' OR @Name = 'SASAdministrators' OR @Name = 'META: Unrestricted Users Role' OR @Name = 'META: User and Group Administrators Role' OR @Name = 'META: Operators Role' OR @Name = 'SAS System Services' \"/>";
                List identityGroups = this.ctx.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "IdentityGroup", flags, options, false);
                String strSASUSERS = null;
                String strPUBLIC = null;
                String strSASADMIN = null;
                String strUNRESTRICTEDUSERS = null;
                String strUSERADMINISTRATORS = null;
                String strOPERATORS = null;
                String strSASSystemServices = null;
                for (int i = 0; i < identityGroups.size(); ++i) {
                    IdentityGroup group = (IdentityGroup)identityGroups.get(i);
                    if (group.getName().equals("SASUSERS")) {
                        strSASUSERS = "OMSOBJ:IdentityGroup/" + group.getFQID();
                        continue;
                    }
                    if (group.getName().equals("PUBLIC")) {
                        strPUBLIC = "OMSOBJ:IdentityGroup/" + group.getFQID();
                        continue;
                    }
                    if (group.getName().equals("SASAdministrators")) {
                        strSASADMIN = "OMSOBJ:IdentityGroup/" + group.getFQID();
                        continue;
                    }
                    if (group.getName().equals("META: Unrestricted Users Role")) {
                        strUNRESTRICTEDUSERS = "OMSOBJ:IdentityGroup/" + group.getFQID();
                        continue;
                    }
                    if (group.getName().equals("META: User and Group Administrators Role")) {
                        strUSERADMINISTRATORS = "OMSOBJ:IdentityGroup/" + group.getFQID();
                        continue;
                    }
                    if (group.getName().equals("META: Operators Role")) {
                        strOPERATORS = "OMSOBJ:IdentityGroup/" + group.getFQID();
                        continue;
                    }
                    if (!group.getName().equals("SAS System Services")) continue;
                    strSASSystemServices = "OMSOBJ:IdentityGroup/" + group.getFQID();
                }
                store.dispose();
                String defaultActId = this.getActId(iSecAdmin, "REPOS", repository.getShortId());
                String strDefaultACT = "";
                if (defaultActId.length() > 0) {
                    strDefaultACT = "OMSOBJ:AccessControlTemplate/" + defaultActId;
                }
                iSecAdmin.ApplyACTToObj("", strPrivateFolderACT, 0, strSASAdminACT);
                iSecAdmin.SetAuthorizationsOnObj("", strPrivateFolderACT, 0, PublicAuthOnACT);
                String bipServiceID = this.getBIPTreeId(repository);
                if (bipServiceID != null) {
                    String strBIPService = "OMSOBJ:SoftwareComponent/" + bipServiceID;
                    iSecAdmin.ApplyACTToObj("", strBIPService, 0, strSASAdminACT);
                    String usersFolder = RB.getStringResource("MetadataRepositoryServiceImpl.DefaultUserFolder.txt");
                    store = this.ctx.getFactory().createObjectStore();
                    SoftwareComponent sc = (SoftwareComponent)this.ctx.getFactory().createComplexMetadataObject(store, "BIP Service", "SoftwareComponent", bipServiceID);
                    AssociationList Trees = sc.getSoftwareTrees();
                    for (int i = 0; i < Trees.size(); ++i) {
                        Tree tree = (Tree)Trees.get(i);
                        if (!tree.getName().equals(usersFolder) && !tree.getName().equals("System")) continue;
                        String strResourceId = "OMSOBJ:Tree/" + tree.getFQID();
                        iSecAdmin.ApplyACTToObj("", strResourceId, 0, strSASAdminACT);
                    }
                    store.dispose();
                } else {
                    this.logError(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.BIPService.NotFound.Error.txt", (Object)repository.getName()));
                }
                if (strSASUSERS != null) {
                    iSecAdmin.ApplyACTToObj("", strSASUSERS, 0, strSASAdminACT);
                }
                if (strPUBLIC != null) {
                    iSecAdmin.ApplyACTToObj("", strPUBLIC, 0, strSASAdminACT);
                }
                if (strSASADMIN != null) {
                    iSecAdmin.ApplyACTToObj("", strSASADMIN, 0, strSASAdminACT);
                }
                if (strUNRESTRICTEDUSERS != null) {
                    iSecAdmin.ApplyACTToObj("", strUNRESTRICTEDUSERS, 0, strSASAdminACT);
                }
                if (strUSERADMINISTRATORS != null) {
                    iSecAdmin.ApplyACTToObj("", strUSERADMINISTRATORS, 0, strSASAdminACT);
                }
                if (strOPERATORS != null) {
                    iSecAdmin.ApplyACTToObj("", strOPERATORS, 0, strSASAdminACT);
                }
                if (strSASSystemServices != null) {
                    iSecAdmin.ApplyACTToObj("", strSASSystemServices, 0, strSASAdminACT);
                }
                iSecAdmin.ApplyACTToObj("", strSASAdminACT, 0, strSASAdminACT);
                iSecAdmin.SetAuthorizationsOnObj("", strSASAdminACT, 0, PublicAuthOnACT);
                iSecAdmin.BeginTransactionContext(strDefaultACT, 0, tCtxt);
                iSecAdmin.SetAuthorizationsOnObj(tCtxt.value, "", 0, PublicAuthOnACT);
                iSecAdmin.ApplyACTToObj(tCtxt.value, "", 0, strSASAdminACT);
                iSecAdmin.EndTransactionContext(tCtxt.value, "", 1);
            }
            catch (Exception e) {
                throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.ApplyAdminACT.Foundation.Exception.txt", (Object)e.getMessage()));
            }
        }
        try {
            Repository foundation = this.repositoryService.getFoundationRepository();
            if (foundation != null) {
                String actId = this.getActId(iSecAdmin, SASAdminACTname, foundation.getShortId());
                String strSASAdminACT = "OMSOBJ:AccessControlTemplate/" + actId;
                String defaultActId = this.getActId(iSecAdmin, "REPOS", repository.getShortId());
                String strDefaultACT = "OMSOBJ:AccessControlTemplate/" + defaultActId;
                iSecAdmin.BeginTransactionContext(strDefaultACT, 0, tCtxt);
                if (!repository.isProject()) {
                    iSecAdmin.SetAuthorizationsOnObj(tCtxt.value, "", 0, PublicAuthOnACT);
                }
                iSecAdmin.ApplyACTToObj(tCtxt.value, "", 0, strSASAdminACT);
                iSecAdmin.EndTransactionContext(tCtxt.value, "", 1);
                if (!repository.isProject()) {
                    String strBIPResId = "OMSOBJ:SoftwareComponent/" + this.getBIPTreeId(repository);
                    iSecAdmin.ApplyACTToObj("", strBIPResId, 0, strSASAdminACT);
                }
            }
        }
        catch (Exception e) {
            throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.ApplyAdminACT.Exception.txt", (Object)e.getMessage()));
        }
    }

    Group getUpgradeGroupRecord(MdObjectStore store, Repository repository) throws Exception {
        MdFactory factory = this.ctx.getFactory();
        String template = "<Templates><Group><Notes><TextStore Name=\"\" StoredText=\"\" TextRole=\"\" /></Notes></Group></Templates>";
        String select = "<XMLSELECT search=\"Group[@Name='RepositoryUpgrades'][Notes/TextStore[@TextRole='UpgradeLevel' OR @TextRole='Marker']]\"/>";
        int flags = 388;
        List grpList = null;
        String options = "<Templates><Group><Notes><TextStore Name=\"\" StoredText=\"\" TextRole=\"\" /></Notes></Group></Templates><XMLSELECT search=\"Group[@Name='RepositoryUpgrades'][Notes/TextStore[@TextRole='UpgradeLevel' OR @TextRole='Marker']]\"/>";
        grpList = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "Group", 388, options, false);
        if (grpList == null || grpList.isEmpty()) {
            return null;
        }
        Group grp = (Group)grpList.get(0);
        return grp;
    }

    Property getRepositoryDetailsProperty(MdObjectStore store, Repository repository) throws Exception {
        List propList = null;
        String template = "<Templates><Property Name=\"\" DefaultValue=\"\"><AssociatedObject><Group Name=\"\" /></AssociatedObject></Property></Templates>";
        String select = "<XMLSELECT search=\"Property[@Name='RepositoryDetails'][AssociatedObject/SoftwareComponent[@ClassIdentifier='E5F27790-2149-11D6-8828-AA0004006D06']]\"/>";
        String options = template + select;
        int flags = 388;
        propList = this.ctx.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "Property", flags, options, false);
        if (propList == null || propList.size() == 0) {
            return null;
        }
        Property prop = (Property)propList.get(0);
        return prop;
    }

    boolean loadRepositoryData(Repository repository, RepositoryCreationResult result) {
        try {
            if (repository.isFoundation()) {
                this.loadPermissions(repository);
                this.loadIdentityGroups(repository);
                this.loadInheritanceRules(repository);
                this.createBIPTree(repository);
                if (this.doesBIPTreeExist(repository)) {
                    this.loadPolicies(repository);
                }
                this.loadEntityPropertyTypes(repository);
                this.loadTypeDefinitions(repository);
                this.loadResourceTemplates(repository);
            } else if (repository.isCustom()) {
                this.createCustomBIPTree(repository);
            }
            this.createRepositoryACTs(repository);
            this.applyAdminACT(repository);
            this.loadRepositoryDetailsProperty(repository);
            this.createUpgradeLevel(repository, 9043001);
        }
        catch (Exception e) {
            result.setStatus(Operation.Status.ERROR);
            result.setErrorMessage(e.getMessage());
            this.logger.error(e.getMessage());
            return false;
        }
        result.setStatus(Operation.Status.SUCCESS);
        return true;
    }

    boolean loadProjectRepositoryData(Repository repository, RepositoryCreationResult result) {
        RepositoryAuthorization repositoryAuthorization = new RepositoryAuthorization(this.ctx, this.repositoryService, this.serverService);
        try {
            this.createRepositoryACTs(repository);
            this.applyAdminACT(repository);
            this.createProjectBIPService(repository);
            this.loadRepositoryDetailsProperty(repository);
            this.createUpgradeLevel(repository, 9043001);
            repositoryAuthorization.removeConnectedIdentityFromRepositoryACT(repository);
        }
        catch (Exception e) {
            result.setStatus(Operation.Status.ERROR);
            result.setErrorMessage(e.getMessage());
            this.logger.error(e.getMessage());
            return false;
        }
        result.setStatus(Operation.Status.SUCCESS);
        return true;
    }

    void verifyUpgradedRepositoryContent(Repository repository) {
        try {
            List extensionList;
            Identity ident;
            this.loadRepositoryDetailsProperty(repository);
            if (repository.isCustom()) {
                this.updateCustomRepositoryFolderAssociations(repository);
            }
            if (repository.isProject() && (ident = this.determineProjectOwner(extensionList = this.findProjectRepositoryExtensions(repository))) == null) {
                this.logger.error((Object)new Message(RB.getResources(), "RepositoryHelper.UpgradedProjectMissingOwner.txt", (Object)repository.getName()));
            }
        }
        catch (Exception e) {
            this.logError(e.getMessage());
        }
    }

    void validateBIPTree(Repository repository) throws Exception {
        MdObjectStore store = this.ctx.getFactory().createObjectStore();
        SoftwareComponent bipSC = this.getBIPTreeObject(store, repository.getId());
        if (bipSC == null) {
            this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.BIPService.NotFound.Error.txt", (Object)repository.getName()));
            this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.BIPService.Create.Warning.txt", (Object)repository.getName()));
            if (repository instanceof FoundationRepository) {
                this.createBIPTree(repository);
            } else if (repository instanceof CustomRepository) {
                this.createCustomBIPTree(repository);
            } else if (repository instanceof ProjectRepository) {
                this.createProjectBIPService(repository);
            }
        }
    }

    protected String getActId(ISecurityAdmin iSecAdmin, String name, String repositoryID) throws Exception {
        String actId = "";
        VariableArray2dOfStringHolder actList = new VariableArray2dOfStringHolder();
        int flags = 0;
        try {
            iSecAdmin.GetAccessControlTemplateList("", "REPOSID:" + repositoryID, flags, actList);
        }
        catch (Exception e) {
            throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.ACTQuery.Exception.txt", (Object)e.getMessage()));
        }
        for (int i = 0; i < actList.value.length; ++i) {
            if (actList.value[i][2].equals(name)) {
                actId = actList.value[i][1].toString();
                break;
            }
            if (!actList.value[i][4].equalsIgnoreCase("REPOS")) continue;
            actId = actList.value[i][1].toString();
            break;
        }
        return actId;
    }

    String getBIPTreeId(Repository repository) throws Exception {
        String strID = null;
        String options = "<XMLSELECT search=\"@ClassIdentifier='E5F27790-2149-11D6-8828-AA0004006D06'\"/>";
        int flags = 0x10000180;
        StringHolder outXML = new StringHolder();
        this.ctx.getFactory().getConnection().getCMRHandle().GetMetadataObjects(repository.getId(), "SoftwareComponent", outXML, "SAS", flags, options);
        String outXMLString = outXML.value;
        Document mainDoc = this.ctx.getFactory().getOMIUtil().parseXML(outXMLString);
        if (mainDoc != null) {
            Node firstNode = mainDoc.getFirstChild();
            NodeList nodeList = firstNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node currentNode = nodeList.item(i);
                NamedNodeMap nodeMap = currentNode.getAttributes();
                strID = nodeMap.getNamedItem("Id").getNodeValue();
            }
        }
        return strID;
    }

    void upgradeSASAdminGroupRoleAssociations(MdFactory factory, String strReposId, boolean fixGroupName) throws Exception {
        int flags = 0x10000180;
        MdObjectStore store = factory.createObjectStore();
        String options = "";
        options = fixGroupName ? "<XMLSELECT search=\"@Name = 'SAS Administrators' OR @Name = 'META: User and Group Administrators Role' OR @Name = 'META: Operators Role' \"/>" : "<XMLSELECT search=\"@Name = 'SASAdministrators' OR @Name = 'META: User and Group Administrators Role' OR @Name = 'META: Operators Role' \"/>";
        IdentityGroup adminsGrp = null;
        IdentityGroup opRole = null;
        IdentityGroup userAdmRole = null;
        List identityGroups = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposId, "IdentityGroup", flags, options, false);
        for (int i = 0; i < identityGroups.size(); ++i) {
            IdentityGroup group = (IdentityGroup)identityGroups.get(i);
            if (group.getName().equals("SASAdministrators") || group.getName().equals("SAS Administrators")) {
                adminsGrp = group;
                continue;
            }
            if (group.getName().equals("META: User and Group Administrators Role")) {
                userAdmRole = group;
                continue;
            }
            if (!group.getName().equals("META: Operators Role")) continue;
            opRole = group;
        }
        if (adminsGrp == null || userAdmRole == null || opRole == null) {
            store.dispose();
            throw new Exception(RB.getStringResource("RepositoryHelper.UpgradeSASAdminRoleAssociations.NotFound.Exception.txt"));
        }
        String updateMeta = "";
        if (fixGroupName) {
            String cleanName = factory.getOMIUtil().cleanStringForXML(RB.getStringResource("RepositoryUtil.SASAdministrators.DisplayName.txt"));
            String fixedAdminsGrp = "<IdentityGroup Id=\"" + adminsGrp.getFQID() + "\" Name=\"SASAdministrators\" DisplayName=\"" + cleanName + "\" PublicType=\"UserGroup\" UsageVersion=\"1000000.0\" >";
            updateMeta = fixedAdminsGrp + "   <IdentityGroups Function=\"Append\">      <IdentityGroup ObjRef=\"" + userAdmRole.getFQID() + "\" />      <IdentityGroup ObjRef=\"" + opRole.getFQID() + "\" />   </IdentityGroups> </IdentityGroup>";
        } else {
            updateMeta = "<IdentityGroup Id=\"" + adminsGrp.getFQID() + "\" >   <IdentityGroups Function=\"Append\">      <IdentityGroup ObjRef=\"" + userAdmRole.getFQID() + "\" />      <IdentityGroup ObjRef=\"" + opRole.getFQID() + "\" />   </IdentityGroups> </IdentityGroup>";
        }
        store.dispose();
        StringHolder outXML2 = new StringHolder();
        factory.getOMIUtil().updateMetadata(updateMeta, outXML2, 0x10000000);
    }

    SecurityRuleScheme getDefaultInheritanceRules(MdObjectStore store, Repository repository) throws Exception {
        List rulesSchemeList = new Vector(0);
        String options = "<XMLSELECT search=\"@Name='Physical'\"/>";
        int flags = 0x10000180;
        rulesSchemeList = this.ctx.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "SecurityRuleScheme", flags, options, false);
        if (rulesSchemeList == null || rulesSchemeList.size() == 0) {
            return null;
        }
        for (int i = 0; i < rulesSchemeList.size(); ++i) {
            SecurityRuleScheme scheme = (SecurityRuleScheme)rulesSchemeList.get(i);
            if (!scheme.getName().equalsIgnoreCase("Physical")) continue;
            return scheme;
        }
        return null;
    }

    private Map getTypeDefList() throws IOException, MdException {
        String indexFile = RB.getStringResource("RepositoryHelper.TypeDictionaryIndexFile.notrans");
        HashMap fileList = new HashMap();
        URL url = LocalizedResourceUtility.urlFromFile(indexFile);
        Document doc = this.ctx.getFactory().getOMIUtil().parseXML(url);
        Element docRoot = doc.getDocumentElement();
        NodeList typeDefNodeList = docRoot.getElementsByTagName("TypeDef");
        for (int i = 0; i < typeDefNodeList.getLength(); ++i) {
            Element typeDef = (Element)typeDefNodeList.item(i);
            HashMap<String, String> fileInfo = new HashMap<String, String>();
            if (typeDef.hasAttribute("TemplateName")) {
                fileInfo.put("Template", typeDef.getAttribute("TemplateName"));
            }
            fileInfo.put("File", typeDef.getAttribute("FileName"));
            fileList.put(typeDef.getAttribute("TypeName"), fileInfo);
        }
        return fileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    boolean loadDictionaryEntries(MdFactory m_Factory, String strFileName, String strReposId, String typeName, List<String> errorList, String templateName) {
        URL url = null;
        try {
            url = LocalizedResourceUtility.urlFromFile(strFileName);
        }
        catch (IOException exc) {
            Message errorMsg = new Message(RB.getResources(), "RepositoryHelper.TypeDictionaryTemplate.fileerror.txt", (Object)strFileName, (Object)exc.getMessage());
            errorList.add(errorMsg.toString());
            return false;
        }
        MdObjectStore store = null;
        Document doc = null;
        TypeDefinition typeDef = null;
        try {
            Message errorMsg;
            String localizedDesc;
            String localizedName;
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            documentFactory.setNamespaceAware(false);
            DocumentBuilder docBuilder = documentFactory.newDocumentBuilder();
            doc = docBuilder.parse(new InputSource(url.openStream()));
            store = m_Factory.createObjectStore();
            try {
                typeDef = this.findTypeDictionaryTemplate(m_Factory, store, strReposId, typeName);
            }
            catch (Exception exc) {
                Message errorMsg2 = new Message(RB.getResources(), "RepositoryHelper.QueryingTypeDefinition.Error.fmt.txt", (Object)typeName, (Object)exc.getMessage());
                this.logger.error((Object)errorMsg2);
                boolean bl = true;
                if (store != null) {
                    try {
                        store.dispose();
                    }
                    catch (RemoteException e) {
                        this.logger.error(e.getMessage());
                    }
                }
                return bl;
            }
            if (typeDef != null) {
                double metadataVersion;
                double fileVersion = metadataVersion = typeDef.getDefinitionVersion();
                NodeList typeDefNodeList = doc.getElementsByTagName("TypeDefinition");
                if (typeDefNodeList != null) {
                    Node typeDefNode = typeDefNodeList.item(0);
                    NamedNodeMap attrs = typeDefNode.getAttributes();
                    Node verNode = attrs.getNamedItem("DefinitionVersion");
                    if (verNode != null) {
                        String fileStringVer = verNode.getNodeValue();
                        Double definitionVersion = Double.valueOf(fileStringVer);
                        fileVersion = definitionVersion;
                    }
                    if (metadataVersion > fileVersion) {
                        boolean bl = true;
                        return bl;
                    }
                } else {
                    Message errorMsg3 = new Message(RB.getResources(), "RepositoryHelper.TypeDefinition.MissingTag.Error.txt", (Object)strFileName);
                    errorList.add(errorMsg3.toString());
                    boolean attrs = false;
                    return attrs;
                }
                boolean errorMsg3 = this.deleteTypeDefinition(typeDef);
            }
            if ((localizedName = PublicTypeUtility.getLocalizedName((String)typeName)) == null) {
                localizedName = typeName;
            }
            if (localizedName.length() > 60) {
                localizedName = localizedName.substring(0, 60);
            }
            if ((localizedDesc = PublicTypeUtility.getLocalizedDescription((String)typeName)) == null) {
                localizedDesc = "";
            } else if (localizedDesc.length() > 200) {
                localizedDesc = localizedDesc.substring(0, 200);
            }
            NodeList typeDefNodeList = doc.getElementsByTagName("TypeDefinition");
            Node typeDefNode = null;
            if (typeDefNodeList != null) {
                Node descNode;
                typeDefNode = typeDefNodeList.item(0);
                NamedNodeMap attrs = typeDefNode.getAttributes();
                Node nameNode = attrs.getNamedItem("Name");
                if (nameNode != null) {
                    nameNode.setTextContent(localizedName);
                }
                if ((descNode = attrs.getNamedItem("Desc")) != null) {
                    descNode.setTextContent(localizedDesc);
                }
            }
            if (templateName != null) {
                this.insertTemplate(docBuilder, typeDefNode, templateName);
            }
            if (_amu == null) {
                _amu = new ApplicationMetadataUtility();
            }
            if (this.ctx.getSession() == null) {
                this.logger.error(RB.getStringResource("RepositoryHelper.TypeDictionaryTemplate.sessionerror.txt"));
                boolean attrs = false;
                return attrs;
            }
            _amu.setConnection(this.ctx.getSession());
            try {
                String st = XMLUtil.convertNodeToString((Node)doc.getFirstChild());
                ByteArrayInputStream inputStream = new ByteArrayInputStream(st.getBytes("UTF-8"));
                _amu.setSourceXMLStream((InputStream)inputStream);
                _amu.execute();
            }
            catch (MdException exc) {
                errorMsg = new Message(RB.getResources(), "RepositoryHelper.LoadingTypeDefinition.Error.fmt.txt", (Object)typeName, (Object)exc.getMessage());
                errorList.add(errorMsg.toString());
                boolean bl = false;
                if (store != null) {
                    try {
                        store.dispose();
                    }
                    catch (RemoteException e) {
                        this.logger.error(e.getMessage());
                    }
                }
                return bl;
            }
            catch (RemoteException re) {
                boolean bl;
                block56: {
                    errorMsg = new Message(RB.getResources(), "RepositoryHelper.LoadingTypeDefinition.Error.fmt.txt", (Object)typeName, (Object)re.getMessage());
                    errorList.add(errorMsg.toString());
                    bl = false;
                    if (store == null) break block56;
                    try {
                        store.dispose();
                    }
                    catch (RemoteException e) {
                        this.logger.error(e.getMessage());
                    }
                }
                return bl;
            }
            boolean bl = true;
            return bl;
            {
                catch (Exception exc) {
                    Message errorMsg4 = new Message(RB.getResources(), "RepositoryHelper.LoadingTypeDefinition.Error.fmt.txt", (Object)typeName, (Object)exc.getMessage());
                    errorList.add(errorMsg4.toString());
                    boolean bl2 = false;
                    return bl2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (store != null) {
                try {
                    store.dispose();
                }
                catch (RemoteException e) {
                    this.logger.error(e.getMessage());
                }
            }
        }
    }

    private TypeDefinition findTypeDictionaryTemplate(MdFactory factory, MdObjectStore store, String strReposId, String typeName) throws MdException, RemoteException {
        TypeDefinition typeDef = null;
        String options = "<XMLSELECT search=\"@TypeName='" + typeName + "'\" />";
        int flags = 392;
        List typeList = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposId, "TypeDefinition", flags, options, false);
        if (typeList != null && typeList.size() > 0) {
            typeDef = (TypeDefinition)typeList.get(0);
        }
        return typeDef;
    }

    private boolean deleteTypeDefinition(TypeDefinition typedef) throws MdException, RemoteException {
        String typeName;
        Map fileList = null;
        try {
            fileList = this.getTypeDefList();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (typedef != null && fileList.containsKey(typeName = typedef.getTypeName())) {
            String strTemplate = RB.getStringResource("RepositoryHelper.TypeDefinition.Template.notrans");
            this.ctx.getFactory().deletePublicObject((CMetadata)typedef, strTemplate);
        }
        return true;
    }

    private boolean deleteInheritanceRules(Repository repository, SecurityRuleScheme scheme) throws Exception {
        StringHolder outXML = new StringHolder();
        String inXML = new String("");
        inXML = "<SecurityRuleScheme ID=\"" + scheme.getFQID() + "\"></SecurityRuleScheme>";
        int flags = 0x10000000;
        int rc = this.ctx.getFactory().getConnection().getCMRHandle().DeleteMetadata(inXML, outXML, "SAS", flags, "");
        if (rc != 0) {
            return false;
        }
        return true;
    }

    private void insertTemplate(DocumentBuilder docBuilder, Node typeDefNode, String templateName) throws MdException {
        if (typeDefNode == null) {
            return;
        }
        try {
            String str;
            URL url = LocalizedResourceUtility.urlFromFile(templateName);
            InputStream inputStream = null;
            inputStream = url.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            StringBuilder stringBuffer = new StringBuilder();
            while ((str = reader.readLine()) != null) {
                stringBuffer.append(str);
            }
            this.appendTemplateXmlToDocument(docBuilder, typeDefNode, stringBuffer.toString());
        }
        catch (Exception exc) {
            Message errorMsg = new Message(RB.getResources(), "RepositoryHelper.TypeDictionaryTemplate.fileerror.txt", (Object)templateName, (Object)exc.getMessage());
            this.logger.error((Object)errorMsg);
        }
    }

    private void appendTemplateXmlToDocument(DocumentBuilder docBuilder, Node node, String xmlTemplate) throws IOException, SAXException {
        Document doc = node.getOwnerDocument();
        Node subNode = docBuilder.parse(new InputSource(new StringReader(xmlTemplate))).getDocumentElement();
        subNode = doc.importNode(subNode, true);
        node.appendChild(subNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshServer(RequestContext ctx) {
        boolean paused = false;
        try {
            paused = true;
            this.serverService.refreshServer();
            this.serverService.resumeServer();
            paused = false;
        }
        catch (Exception exc) {
            String error = exc.getMessage();
            this.logger.error(error);
        }
        finally {
            if (paused) {
                try {
                    this.serverService.resumeServer();
                }
                catch (Exception exc2) {
                    String error2 = exc2.getMessage();
                    this.logger.error(error2);
                }
            }
        }
    }

    boolean isCheckedOutObjectsfromCustom(String repositoryId) throws MdException, RemoteException {
        List resultList = null;
        String strSelect = "<XMLSELECT search=\"*[@ChangeState ? 'Checked-out to']\"/>";
        int flags = 144;
        try {
            resultList = this.ctx.getFactory().getOMIUtil().getFastMetadataObjects("Root", repositoryId, strSelect, flags);
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (resultList == null || resultList.size() == 0) {
            return false;
        }
        resultList.clear();
        resultList = null;
        return true;
    }

    Tree getRepositoryFolder(MdFactory factory, MdObjectStore store, Repository repository) throws RemoteException, MdException {
        Tree repositoryTree = null;
        SoftwareComponent sc = null;
        String select = "<XMLSelect search=\"*[@ClassIdentifier = 'E5F27790-2149-11D6-8828-AA0004006D06']\"/>";
        String template = "<Templates><SoftwareComponent Name=\"\"><SoftwareTrees/></SoftwareComponent></Templates>";
        String options = template + select;
        int flags = 396;
        List comps = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "SoftwareComponent", flags, options, false);
        if (comps.size() <= 0) {
            return null;
        }
        sc = (SoftwareComponent)comps.get(0);
        Vector trees = new Vector(sc.getSoftwareTrees());
        if (trees.size() > 0) {
            repositoryTree = (Tree)trees.get(0);
        }
        return repositoryTree;
    }

    void updateCustomRepositoryFolderAssociations(Repository repository) throws Exception {
        if (!repository.isCustom()) {
            return;
        }
        MdObjectStore store = this.ctx.getFactory().createObjectStore();
        Tree folder = this.getRepositoryFolder(this.ctx.getFactory(), store, repository);
        if (folder != null) {
            AssociationList scList = folder.getSoftwareComponents();
            SoftwareComponent oldSC = null;
            for (SoftwareComponent scObject : scList) {
                if (scObject.getFQID().substring(0, 8).equalsIgnoreCase(repository.getShortId())) continue;
                oldSC = scObject;
                break;
            }
            SoftwareComponent foundationSC = null;
            CMetadata foundation = this.ctx.getFactory().getOMIUtil().getFoundationRepository();
            if (foundation != null) {
                foundationSC = this.getBIPTreeObject(store, foundation.getId());
            }
            if (foundationSC != null) {
                if (oldSC != null) {
                    if (oldSC.getFQID().equalsIgnoreCase(foundationSC.getFQID())) {
                        return;
                    }
                    folder.getSoftwareComponents().remove((Object)oldSC);
                    folder.getSoftwareComponents().add((Object)foundationSC);
                } else {
                    folder.getSoftwareComponents().add((Object)foundationSC);
                }
            }
            String folderName = repository.getName();
            String reposFolderName = Names.mapNameToOMRObjectName((String)folderName);
            folder.setName(reposFolderName);
            String reposFolderDesc = this.ctx.getFactory().getOMIUtil().cleanStringForXML(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataRepositoryServiceImpl.CustomReposFolder.Description.txt", (Object)reposFolderName));
            folder.setDesc(reposFolderDesc);
            folder.updateMetadataAll();
        }
        store.dispose();
    }

    SoftwareComponent getBIPTreeObject(MdObjectStore store, String reposId) throws Exception {
        String XMLSELECT = "<XMLSELECT search=\"SoftwareComponent[@ClassIdentifier='E5F27790-2149-11D6-8828-AA0004006D06']\"/>";
        int FLAGS = 0x10000180;
        MdFactory factory = this.ctx.getFactory();
        List softwareComponents = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, reposId, "SoftwareComponent", FLAGS, XMLSELECT, false);
        if (softwareComponents != null && !softwareComponents.isEmpty()) {
            return (SoftwareComponent)softwareComponents.get(0);
        }
        return null;
    }

    void cleanupCheckouts(String repositoryId) throws MdException, RemoteException {
        StringBuffer inXMLBuffer = new StringBuffer("<UndoCheckoutLogical>");
        inXMLBuffer.append(" <Metadata/>");
        inXMLBuffer.append(" <ProjectReposId>" + repositoryId + "</ProjectReposId>");
        inXMLBuffer.append(" <ns>SAS</ns>");
        inXMLBuffer.append(" <flags>1</flags>");
        inXMLBuffer.append(" <Options/>");
        inXMLBuffer.append("</UndoCheckoutLogical>");
        String strXML = inXMLBuffer.toString();
        try {
            this.ctx.getFactory().getOMIUtil().DoRequest(strXML, false);
        }
        catch (MdException e) {
            throw e;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean associateIdentityToProjectRepos(ProjectRepository repository) throws Exception {
        MdObjectStore store = this.ctx.getFactory().createObjectStore();
        String ownerName = repository.getProjectOwner();
        if (ownerName == null) return false;
        Identity projUser = this.getIdentityObjectfromOwnerName(store, (Repository)repository, ownerName);
        if (projUser == null) return false;
        try {
            Person per = this.getProjectOwnerbyId(store, projUser.getFQID());
            if (per == null) return true;
            Extension ext = (Extension)this.ctx.getFactory().createComplexMetadataObject(store, "ProjectRepository", "Extension", per.getFQID().substring(0, 8));
            ext.setValue(repository.getId());
            per.getExtensions().add((Object)ext);
            per.updateMetadataAll();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    Person getProjectOwnerbyId(MdObjectStore store, String ownerId) throws MdException, RemoteException {
        Person projPerson = null;
        int flags = 260;
        String strTemplate = "<Templates><Person><Extensions/></Person></Templates>";
        projPerson = (Person)this.ctx.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, "Person", ownerId, null, null, strTemplate, flags);
        if (projPerson != null) {
            return projPerson;
        }
        return null;
    }

    private Identity getIdentityObjectfromOwnerName(MdObjectStore objectStore, Repository repository, String projectOwner) throws Exception {
        Identity projUser = null;
        if (projectOwner != null) {
            try {
                if (repository == null && (repository = this.repositoryService.getFoundationRepository()) == null) {
                    return null;
                }
                List idList = this.getIdentityObjects(objectStore, repository);
                for (int i = 0; i < idList.size(); ++i) {
                    Identity idObj;
                    if (!(idList.get(i) instanceof IdentityGroup) && !(idList.get(i) instanceof Person) || !((idObj = (Identity)idList.get(i)) instanceof Person) || !idObj.getName().equals(projectOwner)) continue;
                    projUser = idObj;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return projUser;
    }

    List getIdentityObjects(MdObjectStore store, Repository repository) throws Exception {
        int flags = 272;
        Vector items = new Vector();
        List identityList = new ArrayList(0);
        identityList = this.ctx.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "Identity", flags, "", false);
        if (!repository.isFoundation()) {
            Repository foundation = this.repositoryService.getFoundationRepository();
            List subList = this.ctx.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, foundation.getId(), "Identity", flags, "", false);
            if (identityList != null) {
                identityList.addAll(subList);
            } else {
                identityList = subList;
            }
        }
        return identityList;
    }

    Identity determineProjectOwner(List extensionList) throws Exception {
        Identity ident = null;
        if (extensionList == null) {
            return ident;
        }
        if (extensionList.size() > 0) {
            Extension ext = (Extension)extensionList.get(0);
            ident = (Identity)ext.getOwningObject();
        }
        return ident;
    }

    List findProjectRepositoryExtensions(Repository repository) throws Exception {
        List extensionList = new Vector(0);
        String options = "<XMLSELECT search=\"@Name='ProjectRepository' AND @Value ='" + repository.getId() + "'\"/>";
        int flags = 335544712;
        MdObjectStore store = this.ctx.getFactory().createObjectStore();
        Repository foundation = this.repositoryService.getFoundationRepository();
        extensionList = this.ctx.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, foundation.getId(), "Extension", flags, options, false);
        if (extensionList == null || extensionList.size() == 0) {
            return null;
        }
        if (extensionList.size() > 1) {
            Collections.sort(extensionList, new extComparator());
        }
        return extensionList;
    }

    boolean deleteProjectRepositoryExtensions(List extensionList) throws Exception {
        Extension ext = null;
        for (int index = 0; index < extensionList.size(); ++index) {
            ext = (Extension)extensionList.get(index);
            try {
                StringHolder outXML = new StringHolder();
                String inXML = "";
                inXML = "<Extension ID=\"" + ext.getFQID() + "\"></Extension>";
                this.ctx.getFactory().getConnection().getCMRHandle().DeleteMetadata(inXML, outXML, "SAS", 0x10000000, "");
                continue;
            }
            catch (Exception e) {
                if (index != 0) continue;
                throw e;
            }
        }
        return true;
    }

    void loadRepositoryDetailsProperty(Repository repository) throws Exception {
        MdObjectStore store = this.ctx.getFactory().createObjectStore();
        try {
            SoftwareComponent bipSC = this.getBIPTreeObject(store, repository.getId());
            String repType = "";
            repType = repository instanceof FoundationRepository ? "Foundation" : (repository instanceof CustomRepository ? "Custom" : (repository instanceof ProjectRepository ? "Project" : "Unknown"));
            Property prop = this.getRepositoryDetailsProperty(store, repository);
            if (prop == null) {
                String propName = "RepositoryDetails";
                String propRole = "initialization";
                String propDesc = "The repository type and name information is stored here and delimited by a colon.";
                String defaultValue = repType + ":" + repository.getName();
                prop = (Property)this.ctx.getFactory().createComplexMetadataObject(store, propName, "Property", repository.getShortId());
                prop.setPropertyName(propName);
                prop.setPropertyRole(propRole);
                prop.setDesc(propDesc);
                prop.setDefaultValue(defaultValue);
                prop.getAssociatedObjects().add((Object)bipSC);
            } else {
                String defaultValue = repType + ":" + repository.getName();
                prop.setDefaultValue(defaultValue);
            }
            prop.updateMetadataAll();
        }
        catch (Exception e) {
            this.logError(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.CreateRepositoryDetails.Error.txt", (Object)e.getMessage()));
        }
        store.dispose();
    }

    private void logError(String message) {
        this.logger.error(message);
        this.ctx.setError(true);
    }

    private class extComparator
    implements Comparator {
        private extComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            try {
                Extension ext1 = (Extension)obj1;
                Extension ext2 = (Extension)obj2;
                String strDate1 = ext1.getMetadataCreated();
                String strDate2 = ext2.getMetadataCreated();
                if (strDate1.length() < 1 || strDate2.length() < 1) {
                    return -1;
                }
                Double dDate1 = new Double(strDate1);
                Double dDate2 = new Double(strDate2);
                return dDate2.compareTo(dDate1);
            }
            catch (RemoteException ex) {
                return -1;
            }
        }
    }
}

