/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.repository;

import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurityAdmin;
import com.sas.meta.SASOMI.ISecurityAdminHelper;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Person;
import com.sas.svcs.metadata.mgmt.client.ConnectedIdentityInfo;
import com.sas.svcs.metadata.mgmt.client.MetadataRepositoryService;
import com.sas.svcs.metadata.mgmt.client.MetadataServerService;
import com.sas.svcs.metadata.mgmt.client.Repository;
import com.sas.svcs.metadata.mgmt.impl.RequestContext;
import com.sas.svcs.metadata.mgmt.impl.repository.RB;
import com.sas.svcs.metadata.mgmt.impl.repository.RepositoryHelper;
import com.sas.text.Message;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;

final class RepositoryAuthorization {
    private final Logger logger = LogManager.getLogger(RepositoryAuthorization.class);
    private RequestContext ctx;
    private MetadataRepositoryService repositoryService;
    private MetadataServerService serverService;

    RepositoryAuthorization(RequestContext ctx, MetadataRepositoryService repositoryService, MetadataServerService serverService) {
        this.ctx = ctx;
        this.repositoryService = repositoryService;
        this.serverService = serverService;
    }

    boolean isUserAuthorizedonProjectIdentity(Identity ident) throws Exception {
        ConnectedIdentityInfo connectedIdentity = this.serverService.getConnectedIdentityInfo();
        if (connectedIdentity == null) {
            return false;
        }
        if (connectedIdentity.isUnrestricted()) {
            return true;
        }
        if (connectedIdentity.getObjectId().equalsIgnoreCase(ident.getFQID())) {
            return true;
        }
        ISecurity_1_1 iSecurity2 = this.ctx.getFactory().getConnection().MakeISecurityConnection();
        if (iSecurity2 == null) {
            throw new Exception(RB.getStringResource("RepositoryAuthorization.ISecurity.Connection.Error.txt"));
        }
        String resource = ident instanceof IdentityGroup ? "OMSOBJ:IdentityGroup/" + ident.getFQID() : "OMSOBJ:Person/" + ident.getFQID();
        StringHolder permissionCondition = new StringHolder();
        BooleanHolder authorized = new BooleanHolder();
        try {
            iSecurity2.IsAuthorized("", resource, "WriteMetadata", permissionCondition, authorized);
        }
        catch (Exception e) {
            throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryAuthorization.ISecurity.IsAuthorized.Error.txt", (java.lang.Object)e.getMessage()));
        }
        finally {
            try {
                this.ctx.getFactory().getConnection().closeISecurityConnection((ISecurity)iSecurity2);
                iSecurity2 = null;
            }
            catch (Exception error) {
                iSecurity2 = null;
            }
        }
        return authorized.value;
    }

    boolean isUserAuthorizedforCustomRepositoryAction() throws Exception {
        return this.isUserAuthorizedforDependentRepositoryAction();
    }

    boolean isUserAuthorizedforProjectRepositoryAction() throws Exception {
        return this.isUserAuthorizedforDependentRepositoryAction();
    }

    private boolean isUserAuthorizedforDependentRepositoryAction() throws Exception {
        ConnectedIdentityInfo connectedIdentity = this.serverService.getConnectedIdentityInfo();
        if (connectedIdentity == null) {
            return false;
        }
        if (connectedIdentity.isUnrestricted()) {
            return true;
        }
        if (connectedIdentity.getUserName().equalsIgnoreCase("Public") && connectedIdentity.getUserType().equalsIgnoreCase("IdentityGroup")) {
            return false;
        }
        return connectedIdentity.getUserClass().indexOf("Administrator") != -1 || connectedIdentity.getUserClass().indexOf("Operator") != -1;
    }

    boolean isConnectedUserAuthorizedOnBIPService() throws Exception {
        String strBipService = null;
        RepositoryHelper repositoryHelper = new RepositoryHelper(this.ctx, this.repositoryService, this.serverService);
        Repository foundation = this.repositoryService.getFoundationRepository();
        if (foundation != null) {
            strBipService = repositoryHelper.getBIPTreeId(foundation);
        }
        if (strBipService == null) {
            throw new Exception(RB.getStringResource("RepositoryAuthorization.FoundationBIPService.NotFound.Error.txt"));
        }
        String strResource = "OMSOBJ:SoftwareComponent/" + strBipService;
        ISecurity_1_1 iSecurity = this.ctx.getFactory().getConnection().MakeISecurityConnection();
        if (iSecurity != null) {
            StringHolder permCond = new StringHolder();
            BooleanHolder authorized = new BooleanHolder();
            try {
                iSecurity.IsAuthorized("", strResource, "WriteMetadata", permCond, authorized);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                try {
                    this.ctx.getFactory().getConnection().closeISecurityConnection((ISecurity)iSecurity);
                    iSecurity = null;
                }
                catch (Exception error) {
                    iSecurity = null;
                }
            }
            if (authorized.value) {
                return true;
            }
        }
        return false;
    }

    void removeConnectedIdentityFromRepositoryACT(Repository repository) {
        String defaultActId = "";
        VariableArray2dOfStringHolder actList = new VariableArray2dOfStringHolder();
        ISecurityAdmin iSecAdmin = null;
        try {
            iSecAdmin = ISecurityAdminHelper.narrow((Object)this.ctx.getFactory().getConnection().getCMRHandle());
            if (iSecAdmin == null) {
                this.logger.error(RB.getStringResource("RepositoryAuthorization.ISecurityAdmin.Connection.Error7.txt"));
                return;
            }
            iSecAdmin.GetAccessControlTemplateList("", "REPOSID:" + repository.getShortId(), 0, actList);
            for (int i = 0; i < actList.value.length; ++i) {
                if (!actList.value[i][4].equalsIgnoreCase("REPOS")) continue;
                defaultActId = actList.value[i][1].toString();
                break;
            }
        }
        catch (Exception e) {
            this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryAuthorization.RetrieveDefaultACT.Error.txt", (java.lang.Object)e.getMessage()));
            return;
        }
        if (defaultActId.equalsIgnoreCase("")) {
            this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryAuthorization.RetrieveDefaultACT.Error.txt", (java.lang.Object)repository.getName()));
            return;
        }
        Identity owner = this.getRepositoryOwner(repository);
        if (owner == null) {
            this.logger.error(RB.getStringResource("RepositoryAuthorization.ProjectOwner.NotFound.Error.txt"));
            return;
        }
        String strOwnerType = owner instanceof IdentityGroup ? "IdentityGroup" : (owner instanceof Person ? "Person" : "");
        try {
            ConnectedIdentityInfo connectedIdentity = this.serverService.getConnectedIdentityInfo();
            if (connectedIdentity == null) {
                this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryAuthorization.PermissionRemoval.ACT.Error.txt", (java.lang.Object)"unknown"));
                return;
            }
            if (!(connectedIdentity.getUserName().equalsIgnoreCase("Public") && connectedIdentity.getUserType().equalsIgnoreCase("IdentityGroup") || connectedIdentity.getUserClass().toUpperCase().contains("UNRESTRICTED") || strOwnerType.equalsIgnoreCase(connectedIdentity.getUserType()) && owner.getName().equalsIgnoreCase(connectedIdentity.getUserName()))) {
                String strDefaultACT = "OMSOBJ:AccessControlTemplate/" + defaultActId;
                String[][] ConnUserAuths = new String[][]{{connectedIdentity.getUserType(), connectedIdentity.getUserName(), "R", "", ""}};
                iSecAdmin.SetAuthorizationsOnObj("", strDefaultACT, 4, ConnUserAuths);
            }
        }
        catch (Exception e) {
            this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryAuthorization.PermissionRemoval.ACT.Error.txt", (java.lang.Object)e.getMessage()));
            return;
        }
    }

    Identity getRepositoryOwner(Repository repository) {
        List extensions = null;
        String options = "<XMLSELECT search=\"@Name='ProjectRepository' AND @Value='" + repository.getId() + "'\"/>";
        int flags = 392;
        try {
            MdObjectStore store = this.ctx.getFactory().createObjectStore();
            extensions = this.ctx.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "Extension", flags, options, false);
            if (!repository.isFoundation()) {
                Repository foundation = this.repositoryService.getFoundationRepository();
                List subList = this.ctx.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, foundation.getId(), "Extension", flags, options, false);
                if (extensions != null) {
                    extensions.addAll(subList);
                } else {
                    extensions = subList;
                }
            }
            if (extensions.size() > 0) {
                return (Identity)((Extension)extensions.get(0)).getOwningObject();
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return null;
    }

    String[][] buildDefaultProjectACTEntries(Repository repository) throws Exception {
        IdentityGroup publicGroup = this.getPublicGroup(repository);
        Identity owner = this.getRepositoryOwner(repository);
        if (owner == null) {
            throw new Exception(RB.getStringResource("RepositoryAuthorization.ProjectOwner.NotFound.Error.txt"));
        }
        if (publicGroup != null && owner.getFQID().equals(publicGroup.getFQID())) {
            throw new Exception(RB.getStringResource("RepositoryAuthorization.BuildDefaultProjectACTEntries.PublicOwner.Error.txt"));
        }
        boolean isOwnerGroup = owner instanceof IdentityGroup;
        ConnectedIdentityInfo connectedIdentity = this.serverService.getConnectedIdentityInfo();
        if (connectedIdentity == null) {
            throw new Exception(RB.getStringResource("RepositoryAuthorization.BuildDefaultProjectACTEntries.PublicCreator.Error.txt"));
        }
        if (!connectedIdentity.getUserClass().toUpperCase().contains("UNRESTRICTED") && connectedIdentity.getUserName().equalsIgnoreCase("Public") && connectedIdentity.getUserType().equalsIgnoreCase("IdentityGroup")) {
            throw new Exception(RB.getStringResource("RepositoryAuthorization.BuildDefaultProjectACTEntries.PublicCreator.Error.txt"));
        }
        String strOwnerType = null;
        strOwnerType = isOwnerGroup ? new String("IdentityGroup") : new String("Person");
        if (connectedIdentity.getUserClass().toUpperCase().contains("UNRESTRICTED") || connectedIdentity.getUserType().equalsIgnoreCase(strOwnerType) && connectedIdentity.getUserName().equalsIgnoreCase(owner.getName())) {
            String[][] DefaultProjectAuths = new String[][]{{"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "ReadMetadata", ""}, {strOwnerType, owner.getName(), "G", "WriteMetadata", ""}, {strOwnerType, owner.getName(), "G", "ReadMetadata", ""}};
            return DefaultProjectAuths;
        }
        String[][] DefaultProjectAuths = new String[][]{{"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "ReadMetadata", ""}, {strOwnerType, owner.getName(), "G", "WriteMetadata", ""}, {strOwnerType, owner.getName(), "G", "ReadMetadata", ""}, {connectedIdentity.getUserType(), connectedIdentity.getUserName(), "G", "ReadMetadata", ""}, {connectedIdentity.getUserType(), connectedIdentity.getUserName(), "G", "WriteMetadata", ""}};
        return DefaultProjectAuths;
    }

    String getRepositoryVersionString(String strReposId) throws Exception {
        ISecurity_1_1 iSecurity = this.ctx.getFactory().getConnection().MakeISecurityConnection();
        if (iSecurity != null) {
            VariableArray2dOfStringHolder vaTmpOut = new VariableArray2dOfStringHolder();
            try {
                iSecurity.GetAuthorizations("getRepositoryModel", "", strReposId.substring(strReposId.indexOf(46) + 1), "", vaTmpOut);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                try {
                    this.ctx.getFactory().getConnection().closeISecurityConnection((ISecurity)iSecurity);
                    iSecurity = null;
                }
                catch (Exception error) {
                    iSecurity = null;
                }
            }
            return vaTmpOut.value[0][0];
        }
        return "";
    }

    IdentityGroup getPublicGroup(Repository repository) {
        List identityGroups = null;
        String publicIdentityOptions = "<XMLSELECT search=\"@Name = 'PUBLIC'\"/>";
        int flags = 0x10000180;
        try {
            MdObjectStore store = this.ctx.getFactory().createObjectStore();
            identityGroups = this.ctx.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "IdentityGroup", flags, publicIdentityOptions, false);
            if (!repository.isFoundation()) {
                Repository foundation = this.repositoryService.getFoundationRepository();
                List subList = this.ctx.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, foundation.getId(), "IdentityGroup", flags, publicIdentityOptions, false);
                if (identityGroups != null) {
                    identityGroups.addAll(subList);
                } else {
                    identityGroups = subList;
                }
            }
            if (identityGroups.size() > 0) {
                return (IdentityGroup)identityGroups.get(0);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return null;
    }

    String[][] buildCreatorACTEntries(Repository repository) throws Exception {
        ConnectedIdentityInfo connectedIdentity = this.serverService.getConnectedIdentityInfo();
        if (connectedIdentity == null) {
            return null;
        }
        if (!(connectedIdentity.getUserName().equalsIgnoreCase("Public") && connectedIdentity.getUserType().equalsIgnoreCase("IdentityGroup") || connectedIdentity.getUserClass().toUpperCase().contains("UNRESTRICTED"))) {
            String[][] CreatorAuths = new String[][]{{connectedIdentity.getUserType(), connectedIdentity.getUserName(), "G", "ReadMetadata", ""}, {connectedIdentity.getUserType(), connectedIdentity.getUserName(), "G", "WriteMetadata", ""}};
            return CreatorAuths;
        }
        return null;
    }

    boolean addAdditionalFoundationRepositoryACTs(Repository repository, ISecurityAdmin iSecAdmin) throws Exception {
        boolean addedACT = false;
        String SASAdminACTname = RB.getStringResource("RepositoryHelper.SASAdminACT.Name.notrans");
        String SASAdminACTdesc = RB.getStringResource("RepositoryHelper.SASAdminACT.Desc.fmt.txt");
        String privatefolderACTname = RB.getStringResource("RepositoryHelper.privatefolderACT.Name.notrans");
        String privatefolderACTdesc = RB.getStringResource("RepositoryHelper.privatefolderACT.Desc.fmt.txt");
        String[][] SASAdminACTAttributes = new String[][]{{"NAME", SASAdminACTname}, {"USE", ""}, {"DESC", SASAdminACTdesc}};
        String[][] SASAdminGroupAuths = new String[][]{{"IdentityGroup", "SASAdministrators", "G", "WriteMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "ReadMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "CheckInMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "Administer", ""}, {"IdentityGroup", "SAS System Services", "G", "ReadMetadata", ""}};
        String[][] PrivateFolderACTAttributes = new String[][]{{"NAME", privatefolderACTname}, {"USE", ""}, {"DESC", privatefolderACTdesc}};
        String[][] PrivateFolderGroupAuths = new String[][]{{"IdentityGroup", "PUBLIC", "D", "WriteMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "ReadMetadata", ""}, {"IdentityGroup", "PUBLIC", "D", "CheckInMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "WriteMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "ReadMetadata", ""}, {"IdentityGroup", "SASAdministrators", "G", "CheckInMetadata", ""}, {"IdentityGroup", "SAS System Services", "G", "ReadMetadata", ""}};
        if (repository.isFoundation()) {
            StringHolder tCtxt = new StringHolder();
            if (iSecAdmin == null) {
                throw new Exception(RB.getStringResource("RepositoryAuthorization.ISecurityAdmin.Connection.Error2.txt"));
            }
            if (!this.doesACTExist(repository, SASAdminACTname)) {
                try {
                    iSecAdmin.BeginTransactionContext("", 0, tCtxt);
                    iSecAdmin.CreateAccessControlTemplate(tCtxt.value, "REPOSID:" + repository.getShortId(), SASAdminACTAttributes);
                    iSecAdmin.SetAuthorizationsOnObj(tCtxt.value, "", 4, SASAdminGroupAuths);
                    iSecAdmin.EndTransactionContext(tCtxt.value, "", 1);
                    addedACT = true;
                }
                catch (Exception e) {
                    throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryAuthorization.SASAdminSettingsACT.Creation.Exception.txt", (java.lang.Object)e.getMessage()));
                }
            }
            if (!this.doesACTExist(repository, privatefolderACTname)) {
                try {
                    iSecAdmin.BeginTransactionContext("", 0, tCtxt);
                    iSecAdmin.CreateAccessControlTemplate(tCtxt.value, "REPOSID:" + repository.getShortId(), PrivateFolderACTAttributes);
                    iSecAdmin.SetAuthorizationsOnObj(tCtxt.value, "", 4, PrivateFolderGroupAuths);
                    iSecAdmin.EndTransactionContext(tCtxt.value, "", 1);
                    addedACT = true;
                }
                catch (Exception e) {
                    throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryAuthorization.PrivateUserFolderACT.Creation.Exception.txt", (java.lang.Object)e.getMessage()));
                }
            }
        }
        return addedACT;
    }

    boolean doesACTExist(Repository repository, String actName) throws Exception {
        String type = "AccessControlTemplate";
        String options = "<XMLSELECT search=\"@Name = '" + actName + "' \"/>";
        int objCount = this.ctx.getFactory().getOMIUtil().doesObjectExist(repository.getId(), type, options);
        return objCount > 0;
    }
}

