/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.repository;

import com.sas.framework.annotation.services.Publishable;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.meta.SASOMI.IServer;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.OMIServerRepository;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.Names;
import com.sas.svcs.metadata.mgmt.client.AnalysisToolDescriptor;
import com.sas.svcs.metadata.mgmt.client.AnalysisToolGroup;
import com.sas.svcs.metadata.mgmt.client.ConnectedIdentityInfo;
import com.sas.svcs.metadata.mgmt.client.CustomRepository;
import com.sas.svcs.metadata.mgmt.client.FoundationRepository;
import com.sas.svcs.metadata.mgmt.client.MetadataAnalysisService;
import com.sas.svcs.metadata.mgmt.client.MetadataRepositoryService;
import com.sas.svcs.metadata.mgmt.client.MetadataServerService;
import com.sas.svcs.metadata.mgmt.client.Operation;
import com.sas.svcs.metadata.mgmt.client.ProjectRepository;
import com.sas.svcs.metadata.mgmt.client.Repository;
import com.sas.svcs.metadata.mgmt.client.RepositoryCreationResult;
import com.sas.svcs.metadata.mgmt.client.RepositoryDoesNotExistException;
import com.sas.svcs.metadata.mgmt.client.RepositoryException;
import com.sas.svcs.metadata.mgmt.client.RepositoryExistsException;
import com.sas.svcs.metadata.mgmt.client.RepositoryMgr;
import com.sas.svcs.metadata.mgmt.client.RepositoryViewNode;
import com.sas.svcs.metadata.mgmt.client.ServerState;
import com.sas.svcs.metadata.mgmt.client.UnknownRepository;
import com.sas.svcs.metadata.mgmt.client.UpgradeResult;
import com.sas.svcs.metadata.mgmt.impl.AbstractMetadataManagementServiceImpl;
import com.sas.svcs.metadata.mgmt.impl.RequestContext;
import com.sas.svcs.metadata.mgmt.impl.repository.OneOffUpgradeHelper;
import com.sas.svcs.metadata.mgmt.impl.repository.RB;
import com.sas.svcs.metadata.mgmt.impl.repository.RepositoryAuthorization;
import com.sas.svcs.metadata.mgmt.impl.repository.RepositoryHelper;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.StringHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Service(value="MetadataRepositoryService")
@Publishable
public class MetadataRepositoryServiceImpl
extends AbstractMetadataManagementServiceImpl
implements MetadataRepositoryService {
    private final Logger logger = LogManager.getLogger(MetadataRepositoryService.class);
    private boolean refreshRepositoryCache = false;
    public static final String REPOSMGRID = "A0000001.A0000001";
    public static final int OLDEST_REPOSITORY_VERSION_SUPPORTED = 6;
    @Autowired
    private MetadataServerService serverService;
    @Autowired
    private MetadataAnalysisService analysisService;
    public static UserContextInterface user;
    public static SessionContextInterface tempSession;

    public RepositoryMgr getRepositoryManager() throws RepositoryDoesNotExistException {
        return this.buildRepositoryMgr();
    }

    public Repository getFoundationRepository() {
        for (Repository repos : this.getRepositories()) {
            if (!repos.isFoundation()) continue;
            return repos;
        }
        return null;
    }

    public void clearRepositoryCache() {
        this.refreshRepositoryCache = true;
    }

    public List<Repository> getRepositories() {
        RequestContext ctx = this.getRequestContext();
        try {
            if (this.refreshRepositoryCache) {
                ((OMIServer)ctx.getServer()).reloadRepositoryData();
                this.refreshRepositoryCache = false;
            }
            List omiRepositories = ctx.getServer().getRepositories(true);
            ArrayList<Repository> repositories = new ArrayList<Repository>(omiRepositories.size());
            for (OMIRepositoryInterface omiRepository : omiRepositories) {
                String repositoryType = omiRepository.getRepositoryType();
                Object repository = "Foundation".equalsIgnoreCase(repositoryType) ? new FoundationRepository() : ("Custom".equalsIgnoreCase(repositoryType) ? new CustomRepository() : ("Project".equalsIgnoreCase(repositoryType) ? new ProjectRepository() : new UnknownRepository()));
                repository.setId(omiRepository.getDefaultRepositoryId());
                repository.setName(omiRepository.getDefaultRepositoryName());
                if (omiRepository instanceof OMIServerRepository) {
                    OMIServerRepository metadataRepos = (OMIServerRepository)omiRepository;
                    repository.setDescription(metadataRepos.getRepositoryDescription());
                    repository.setPath(metadataRepos.getRepositoryPath());
                    repository.setEngine(metadataRepos.getRepositoryEngine());
                    repository.setOptions(metadataRepos.getRepositoryOptions());
                    Repository.Access acc = Repository.Access.getByValue((String)metadataRepos.getRepositoryAccess());
                    repository.setRegisteredAccess(acc);
                    Repository.Access effacc = Repository.Access.getByValue((String)metadataRepos.getRepositoryEffectiveAccess());
                    repository.setEffectiveAccess(effacc);
                    String strReposFormat = metadataRepos.getRepositoryFormat();
                    try {
                        int formatVer = Integer.parseInt(strReposFormat);
                        repository.setRepositoryFormatVersion(formatVer);
                    }
                    catch (NumberFormatException e) {
                        repository.setRepositoryFormatVersion(-1);
                    }
                    repository.setState(metadataRepos.getRepositoryState());
                    repository.setCreatedDate(metadataRepos.getRepositoryCreatedDate());
                    repository.setModifiedDate(metadataRepos.getRepositoryUpdatedDate());
                }
                repositories.add((Repository)repository);
            }
            Collections.sort(repositories, new RepositoryComparator());
            return repositories;
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public Repository getRepositoryByName(String name) throws RepositoryDoesNotExistException {
        for (Repository repos : this.getRepositories()) {
            if (!repos.getName().equals(name)) continue;
            return repos;
        }
        throw new RepositoryDoesNotExistException(RB.getStringResource("MetadataRepositoryServiceImpl.RepositoryNotFound.Error.txt"));
    }

    public RepositoryViewNode getRepositoryView() {
        return null;
    }

    public Repository getRepositoryByIdentifier(String identifier) throws RepositoryDoesNotExistException {
        for (Repository repos : this.getRepositories()) {
            if (!repos.getId().equals(identifier)) continue;
            return repos;
        }
        throw new RepositoryDoesNotExistException(RB.getStringResource("MetadataRepositoryServiceImpl.RepositoryNotFound.Error.txt"));
    }

    public RepositoryCreationResult createRepository(Repository repository) throws RepositoryException, RepositoryExistsException {
        RequestContext ctx = this.getRequestContext();
        RepositoryAuthorization repositoryAuthorization = new RepositoryAuthorization(ctx, this, this.serverService);
        MdFactory factory = ctx.getFactory();
        this.logger.info(RB.getStringResource("MetadataRepositoryServiceImpl.CreateRepository.BeginMsg.txt"));
        RepositoryCreationResult result = null;
        try {
            if (repository.isFoundation()) {
                List<Repository> repositories = this.getRepositories();
                if (repositories.size() > 0) {
                    for (Repository repos : repositories) {
                        if (!repos.isFoundation()) continue;
                        throw new RepositoryExistsException(RB.getStringResource("MetadataRepositoryServiceImpl.CreateRepository.FoundationExists.Error.txt"));
                    }
                    throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.ServerNotEmpty.txt"));
                }
                ConnectedIdentityInfo connectedIdentity = this.serverService.getConnectedIdentityInfo();
                if (!connectedIdentity.isUnrestrictedByFile()) {
                    throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.NotAuthorizedToCreateFoundation.Error.txt"));
                }
            } else if (repository.isCustom()) {
                boolean m_UserAllowedToCreate = repositoryAuthorization.isUserAuthorizedforCustomRepositoryAction();
                if (!m_UserAllowedToCreate) {
                    throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.NotAuthorizedToCreateCustom.Error.txt"));
                }
            } else if (repository.isProject()) {
                boolean m_UserAllowedToCreate = repositoryAuthorization.isUserAuthorizedforProjectRepositoryAction();
                if (!m_UserAllowedToCreate) {
                    throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.NotAuthorizedToCreateProject.Error.txt"));
                }
            } else {
                throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.RepositoryTypeInvalid.Error.txt"));
            }
            Repository.Access finalAccess = repository.getRegisteredAccess();
            this.validateRepository(factory, repository);
            repository.setName(factory.getOMIUtil().cleanStringForXML(repository.getName()));
            repository.setDescription(factory.getOMIUtil().cleanStringForXML(repository.getDescription()));
            repository.setPath(factory.getOMIUtil().cleanStringForXML(repository.getPath()));
            repository.setEngine(factory.getOMIUtil().cleanStringForXML(repository.getEngine()));
            repository.setOptions(factory.getOMIUtil().cleanStringForXML(repository.getOptions()));
            String existingReposId = null;
            try {
                existingReposId = this.doesRepositoryExistAtPath(repository, factory, ctx.getIServer(), "Create");
            }
            catch (Exception e) {
                throw new RepositoryException(e.getMessage());
            }
            if (existingReposId != null) {
                if (existingReposId.equalsIgnoreCase("unknownpath")) {
                    if (!repository.isCreateRepositoryPath()) {
                        throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.CreateRepository.InvalidPath.Error.txt"));
                    }
                } else {
                    throw new RepositoryExistsException(RB.getStringResource("MetadataRepositoryServiceImpl.CreateRepository.RepositoryExists.Error.txt"));
                }
            }
            this.persist(ctx, repository);
            RepositoryHelper repositoryHelper = new RepositoryHelper(ctx, this, this.serverService);
            if (repository.isProject() && !repositoryHelper.associateIdentityToProjectRepos((ProjectRepository)repository)) {
                String errMsg = RB.getStringResource("MetadataRepositoryServiceImpl.AssociateIdentitytoProjectFailed.Error.txt");
                this.logger.error(errMsg);
                this.deleteRepository(repository);
                throw new RepositoryException(errMsg);
            }
            result = this.initializeRepository(ctx, repository);
            if (result == null) {
                result = new RepositoryCreationResult();
            }
            repository = this.postCreation(ctx, repository, finalAccess);
        }
        catch (RepositoryException rce) {
            throw rce;
        }
        catch (RepositoryExistsException rae) {
            throw rae;
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage());
        }
        Repository newRepository = this.refreshRepositoryfromServer(repository);
        if (newRepository != null) {
            result.setRepository(newRepository);
            return result;
        }
        result.setRepository(repository);
        return result;
    }

    public Repository registerRepository(Repository repository) throws RepositoryException, RepositoryExistsException {
        RequestContext ctx = this.getRequestContext();
        RepositoryAuthorization repositoryAuthorization = new RepositoryAuthorization(ctx, this, this.serverService);
        MdFactory factory = ctx.getFactory();
        this.logger.info(RB.getStringResource("MetadataRepositoryServiceImpl.RegisterRepository.BeginMsg.txt"));
        try {
            if (repository.isFoundation()) {
                List<Repository> repositories = this.getRepositories();
                if (repositories.size() > 0) {
                    for (Repository repos : repositories) {
                        if (!repos.isFoundation()) continue;
                        throw new RepositoryExistsException(RB.getStringResource("MetadataRepositoryServiceImpl.CreateRepository.FoundationExists.Error.txt"));
                    }
                    throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.ServerNotEmpty.txt"));
                }
                ConnectedIdentityInfo connectedIdentity = this.serverService.getConnectedIdentityInfo();
                if (!connectedIdentity.isUnrestrictedByFile()) {
                    throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.NotAuthorizedToRegisterFoundation.Error.txt"));
                }
            } else if (repository.isCustom()) {
                boolean m_UserAllowedToRegister = repositoryAuthorization.isUserAuthorizedforCustomRepositoryAction();
                if (!m_UserAllowedToRegister) {
                    throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.NotAuthorizedToRegisterCustom.Error.txt"));
                }
            } else if (repository.isProject()) {
                boolean m_UserAllowedToRegister = repositoryAuthorization.isUserAuthorizedforProjectRepositoryAction();
                if (!m_UserAllowedToRegister) {
                    throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.NotAuthorizedToRegisterProject.Error.txt"));
                }
            } else {
                throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.RepositoryTypeInvalid.Error.txt"));
            }
            Repository.Access finalAccess = repository.getRegisteredAccess();
            this.validateRepository(factory, repository);
            repository.setName(factory.getOMIUtil().cleanStringForXML(repository.getName()));
            repository.setDescription(factory.getOMIUtil().cleanStringForXML(repository.getDescription()));
            repository.setPath(factory.getOMIUtil().cleanStringForXML(repository.getPath()));
            repository.setEngine(factory.getOMIUtil().cleanStringForXML(repository.getEngine()));
            repository.setOptions(factory.getOMIUtil().cleanStringForXML(repository.getOptions()));
            String existingReposId = null;
            try {
                existingReposId = this.doesRepositoryExistAtPath(repository, factory, ctx.getIServer(), "Register");
            }
            catch (Exception e) {
                throw new RepositoryException(e.getMessage());
            }
            if (existingReposId == null) {
                throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.RegisterRepository.NotFound.Error.txt"));
            }
            this.persist(ctx, repository);
            Repository statusRepository = this.refreshRepositoryfromServer(repository);
            try {
                repository = this.postRegistration(ctx, repository, finalAccess);
                if (repository == null) {
                    return null;
                }
            }
            catch (RepositoryException e) {
                if (statusRepository.getEffectiveAccess() == Repository.Access.READONLY) {
                    this.logger.error(e.getMessage());
                    String warningMsg = RB.getStringResource("MetadataRepositoryServiceImpl.RegisterRepository.Incomplete.Warning.txt");
                    throw new RepositoryException(warningMsg);
                }
                throw e;
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new RepositoryException(e.getMessage());
        }
        Repository registeredRepository = this.refreshRepositoryfromServer(repository);
        if (registeredRepository != null) {
            return registeredRepository;
        }
        return repository;
    }

    public void deleteRepository(Repository repository) throws RepositoryException {
        block20: {
            boolean foundCheckedOutObjects = false;
            boolean foundCustomLockedObjects = false;
            RequestContext ctx = this.getRequestContext();
            RepositoryAuthorization repositoryAuthorization = new RepositoryAuthorization(ctx, this, this.serverService);
            RepositoryHelper repositoryHelper = new RepositoryHelper(ctx, this, this.serverService);
            try {
                boolean allowed;
                if (repository.isFoundation()) {
                    List<Repository> repositories = this.getRepositories();
                    if (repositories.size() > 1) {
                        throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.FoundationDeleteError.txt"));
                    }
                    ConnectedIdentityInfo connectedIdentity = this.serverService.getConnectedIdentityInfo();
                    if (!connectedIdentity.isUnrestrictedByFile()) {
                        throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.DeleteFoundationError.UnrestrictedUser.txt"));
                    }
                    if (connectedIdentity.isInternalUser()) {
                        throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.DeleteFoundationError.InternalUser.txt"));
                    }
                    break block20;
                }
                if (repository.isCustom()) {
                    boolean m_UserAllowedToDelete = repositoryAuthorization.isUserAuthorizedforCustomRepositoryAction();
                    if (!m_UserAllowedToDelete) {
                        throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.DeleteRepositoryError.UserNotAuthorized.txt"));
                    }
                    m_UserAllowedToDelete = repositoryAuthorization.isConnectedUserAuthorizedOnBIPService();
                    if (!m_UserAllowedToDelete) {
                        throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.DeleteCustomError.UserNotAuthorized.txt"));
                    }
                    try {
                        foundCustomLockedObjects = repositoryHelper.isCheckedOutObjectsfromCustom(repository.getId());
                    }
                    catch (Exception e) {
                        if (e.getMessage() == null) {
                            e.printStackTrace();
                        }
                        this.logger.error(e.getMessage());
                    }
                    if (foundCustomLockedObjects) {
                        throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.CustomObjectsLocked.DeleteError.txt"));
                    }
                    break block20;
                }
                if (!repository.isProject()) break block20;
                boolean m_UserAllowedToUnregister = repositoryAuthorization.isUserAuthorizedforProjectRepositoryAction();
                if (!m_UserAllowedToUnregister) {
                    throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.DeleteRepositoryError.UserNotAuthorized.txt"));
                }
                if (repository.getRegisteredAccess() == Repository.Access.READONLY) {
                    throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.AccessReadOnly.Error.txt"));
                }
                foundCheckedOutObjects = this.containsCheckedOutObjects((ProjectRepository)repository);
                List extensionList = repositoryHelper.findProjectRepositoryExtensions(repository);
                Identity ident = repositoryHelper.determineProjectOwner(extensionList);
                if (ident != null && !(allowed = repositoryAuthorization.isUserAuthorizedonProjectIdentity(ident))) {
                    throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.UserNotAuthorizedforOwner.Error.txt"));
                }
                if (extensionList != null) {
                    try {
                        repositoryHelper.deleteProjectRepositoryExtensions(extensionList);
                    }
                    catch (Exception e) {
                        throw new RepositoryException(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataRepositoryServiceImpl.DeleteProject.ExtensionCleanup.Error.txt", (Object)e.getMessage()));
                    }
                }
                if (foundCheckedOutObjects) {
                    repositoryHelper.cleanupCheckouts(repository.getId());
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                throw new RepositoryException(e.getMessage());
            }
        }
        this.removeRepository(repository, 32);
    }

    public void unregisterRepository(Repository repository) throws RepositoryException {
        boolean foundCheckedOutObjects = false;
        boolean foundCustomLockedObjects = false;
        RequestContext ctx = this.getRequestContext();
        RepositoryAuthorization repositoryAuthorization = new RepositoryAuthorization(ctx, this, this.serverService);
        RepositoryHelper repositoryHelper = new RepositoryHelper(ctx, this, this.serverService);
        boolean allowForcedUnregister = this.isForcedUnregisterAllowed(repository.getState(), repository.getRegisteredAccess());
        try {
            if (repository.isFoundation()) {
                List<Repository> repositories = this.getRepositories();
                if (repositories.size() > 1) {
                    throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.FoundationDeleteError.txt"));
                }
                ConnectedIdentityInfo connectedIdentity = this.serverService.getConnectedIdentityInfo();
                if (!connectedIdentity.isUnrestrictedByFile()) {
                    throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.DeleteFoundationError.UnrestrictedUser.txt"));
                }
                if (connectedIdentity.isInternalUser()) {
                    throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.DeleteFoundationError.InternalUser.txt"));
                }
            } else if (repository.isCustom()) {
                boolean m_UserAllowedToUnregister = repositoryAuthorization.isUserAuthorizedforCustomRepositoryAction();
                if (!m_UserAllowedToUnregister) {
                    throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.DeleteRepositoryError.UserNotAuthorized.txt"));
                }
                m_UserAllowedToUnregister = repositoryAuthorization.isConnectedUserAuthorizedOnBIPService();
                if (!m_UserAllowedToUnregister) {
                    throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.DeleteCustomError.UserNotAuthorized.txt"));
                }
                if (!allowForcedUnregister) {
                    try {
                        foundCustomLockedObjects = repositoryHelper.isCheckedOutObjectsfromCustom(repository.getId());
                    }
                    catch (Exception e) {
                        if (e.getMessage() == null) {
                            e.printStackTrace();
                        }
                        this.logger.error(e.getMessage());
                    }
                    if (foundCustomLockedObjects) {
                        throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.CustomObjectsLocked.DeleteError.txt"));
                    }
                }
            } else if (repository.isProject()) {
                boolean allowed;
                boolean m_UserAllowedToUnregister = repositoryAuthorization.isUserAuthorizedforProjectRepositoryAction();
                if (!m_UserAllowedToUnregister) {
                    throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.DeleteRepositoryError.UserNotAuthorized.txt"));
                }
                if (repository.getRegisteredAccess() == Repository.Access.READONLY && !allowForcedUnregister) {
                    throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.AccessReadOnly.Error.txt"));
                }
                foundCheckedOutObjects = this.containsCheckedOutObjects((ProjectRepository)repository);
                List extensionList = repositoryHelper.findProjectRepositoryExtensions(repository);
                Identity ident = repositoryHelper.determineProjectOwner(extensionList);
                if (ident != null && !(allowed = repositoryAuthorization.isUserAuthorizedonProjectIdentity(ident))) {
                    throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.UserNotAuthorizedforOwner.Error.txt"));
                }
                if (extensionList != null) {
                    try {
                        repositoryHelper.deleteProjectRepositoryExtensions(extensionList);
                    }
                    catch (Exception e) {
                        throw new RepositoryException(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataRepositoryServiceImpl.DeleteProject.ExtensionCleanup.Error.txt", (Object)e.getMessage()));
                    }
                }
                if (foundCheckedOutObjects && !allowForcedUnregister) {
                    repositoryHelper.cleanupCheckouts(repository.getId());
                }
            }
            if (!allowForcedUnregister) {
                repositoryHelper.loadRepositoryDetailsProperty(repository);
            }
            this.removeRepository(repository, 0);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new RepositoryException(e.getMessage());
        }
    }

    public Repository updateRepository(Repository repository) throws RepositoryDoesNotExistException, RepositoryException {
        RequestContext ctx = this.getRequestContext();
        RepositoryHelper repositoryHelper = new RepositoryHelper(ctx, this, this.serverService);
        try {
            ConnectedIdentityInfo connectedIdentity = this.serverService.getConnectedIdentityInfo();
            if (!connectedIdentity.isUnrestricted()) {
                throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.NotAuthorizedToCreateFoundation.Error.txt"));
            }
            this.persist(ctx, repository);
            repositoryHelper.refreshServer(ctx);
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage());
        }
        Repository newRepository = this.refreshRepositoryfromServer(repository);
        if (newRepository != null) {
            return newRepository;
        }
        return repository;
    }

    public void validateRepositoryName(String repositoryName, boolean isProject) throws RepositoryException, RepositoryExistsException {
        RequestContext ctx = this.getRequestContext();
        MdFactory factory = ctx.getFactory();
        List<Repository> repositories = this.getRepositories();
        if (repositories == null || repositories.size() == 0) {
            return;
        }
        for (Repository repos : repositories) {
            if (!repositoryName.equalsIgnoreCase(repos.getName())) continue;
            throw new RepositoryExistsException(RB.getStringResource("MetadataRepositoryServiceImpl.DuplicateRepositoryName.Error.txt"));
        }
        if (isProject) {
            return;
        }
        Repository foundation = this.getFoundationRepository();
        MdObjectStore store = null;
        try {
            store = factory.createObjectStore();
            try {
                String strSelect = "<XMLSelect search=\"*[@ClassIdentifier = 'E5F27790-2149-11D6-8828-AA0004006D06']\"/>";
                String strTemplate = "<Templates><SoftwareComponent Name=\"\"><SoftwareTrees/></SoftwareComponent></Templates>";
                String strOptions = strTemplate + strSelect;
                int flags = 396;
                List comps = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, foundation.getId(), "SoftwareComponent", flags, strOptions, false);
                SoftwareComponent sc = null;
                if (comps.size() != 1) {
                    this.logger.error(RB.getStringResource("RepositoryAuthorization.FoundationBIPService.NotFound.Error.txt"));
                    throw new RepositoryException(RB.getStringResource("RepositoryAuthorization.FoundationBIPService.NotFound.Error.txt"));
                }
                sc = (SoftwareComponent)comps.get(0);
                Vector trees = new Vector(sc.getSoftwareTrees());
                if (trees != null && trees.size() > 0) {
                    for (int j = 0; j < trees.size(); ++j) {
                        Tree tr = (Tree)trees.get(j);
                        if (!repositoryName.equalsIgnoreCase(tr.getName())) continue;
                        throw new RepositoryExistsException(RB.getStringResource("MetadataRepositoryServiceImpl.RepositoryandTreeName.Duplicate.Error.txt"));
                    }
                }
            }
            catch (MdException e) {
                throw new RepositoryException(e.getMessage());
            }
            finally {
                if (store != null) {
                    store.dispose();
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean isRepositoryUpgradeRequired(Repository repository) {
        RequestContext ctx = this.getRequestContext();
        RepositoryHelper repositoryHelper = new RepositoryHelper(ctx, this, this.serverService);
        int originalRevision = repositoryHelper.getUpgradeLevel(repository);
        return originalRevision < 9043001;
    }

    public boolean containsCheckedOutObjects(ProjectRepository repository) throws RepositoryException {
        List resultList = null;
        RequestContext ctx = this.getRequestContext();
        String strSelect = "<XMLSELECT search=\"@Name?'SavedPrimaryState'\"/>";
        int flags = 2176;
        try {
            resultList = ctx.getFactory().getOMIUtil().getMetadataObjects(repository.getId(), "TextStore", flags, strSelect);
        }
        catch (MdException e) {
            throw new RepositoryException(e.getMessage());
        }
        catch (RemoteException e) {
            // empty catch block
        }
        if (resultList != null && resultList.size() > 0) {
            return true;
        }
        strSelect = "<XMLSELECT search=\"@ChangeState?'" + repository.getShortId() + "'\"/>";
        flags = 10384;
        try {
            resultList = ctx.getFactory().getOMIUtil().getFastMetadataObjects("Root", repository.getId(), strSelect, flags);
        }
        catch (MdException e) {
            throw new RepositoryException(e.getMessage());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (resultList == null || resultList.size() == 0) {
            return false;
        }
        resultList.clear();
        resultList = null;
        return true;
    }

    public UpgradeResult portAllRepositories() {
        RequestContext ctx = this.getRequestContext();
        UpgradeResult result = new UpgradeResult();
        try {
            ConnectedIdentityInfo connectedIdentity = this.serverService.getConnectedIdentityInfo();
            if (!connectedIdentity.isUnrestricted()) {
                throw new Exception(RB.getStringResource("MetadataRepositoryServiceImpl.PortMetadata.Authorization.Error.txt"));
            }
        }
        catch (Exception e) {
            this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataRepositoryServiceImpl.PortMetadata.AuthorizationCheck.Error.txt", (Object)e.getMessage()));
            ctx.setError(true);
            result.setStatus(Operation.Status.ERROR);
            return result;
        }
        ServerState originalState = this.serverService.getServerState();
        if (originalState.getAccess() != ServerState.Access.ONLINE && originalState.getAccess() != ServerState.Access.ADMIN) {
            throw new IllegalStateException(RB.getStringResource("MetadataRepositoryServiceImpl.PortMetadata.IllegalState.Error.txt"));
        }
        this.logger.info(RB.getStringResource("MetadataRepositoryServiceImpl.PortMetadata.BeginMsg.txt"));
        result.setStatus(Operation.Status.ACTIVE);
        try {
            if (originalState.getAccess() != ServerState.Access.ADMIN) {
                this.serverService.pauseAdmin(RB.getStringResource("MetadataRepositoryServiceImpl.PortMetadata.PauseComment.txt"));
            }
            this.replicateMetadata(ctx, true);
            if (originalState.getAccess() == ServerState.Access.ADMIN) {
                this.serverService.pauseAdmin(originalState.getPauseComment());
            } else {
                this.serverService.resumeServer();
            }
        }
        catch (Exception e) {
            ctx.setError(true);
            this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataRepositoryServiceImpl.PortMetadata.FailedMsg.txt", (Object)e.getMessage()));
        }
        if (ctx.isError()) {
            result.setStatus(Operation.Status.ERROR);
            this.logger.info(RB.getStringResource("MetadataRepositoryServiceImpl.PortMetadata.Summary.Errors.txt"));
        } else {
            result.setStatus(Operation.Status.SUCCESS);
            if (ctx.isWarning()) {
                result.setWarningDetected(true);
                this.logger.info(RB.getStringResource("MetadataRepositoryServiceImpl.PortMetadata.Summary.Warnings.txt"));
            } else {
                this.logger.info(RB.getStringResource("MetadataRepositoryServiceImpl.PortMetadata.Summary.Completed.txt"));
            }
        }
        return result;
    }

    public UpgradeResult upgradeAllRepositories() {
        RequestContext ctx = this.getRequestContext();
        UpgradeResult result = new UpgradeResult();
        try {
            ConnectedIdentityInfo connectedIdentity = this.serverService.getConnectedIdentityInfo();
            if (!connectedIdentity.isUnrestricted()) {
                throw new Exception(RB.getStringResource("MetadataRepositoryServiceImpl.UpgradeMetadata.Authorization.Error.txt"));
            }
        }
        catch (Exception e) {
            this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataRepositoryServiceImpl.UpgradeMetadata.AuthorizationCheck.Error.txt", (Object)e.getMessage()));
            ctx.setError(true);
            result.setStatus(Operation.Status.ERROR);
            return result;
        }
        ServerState originalState = this.serverService.getServerState();
        if (originalState.getAccess() != ServerState.Access.ONLINE && originalState.getAccess() != ServerState.Access.ADMIN) {
            throw new IllegalStateException(RB.getStringResource("MetadataRepositoryServiceImpl.UpgradeMetadata.IllegalState.Error.txt"));
        }
        result.setStatus(Operation.Status.ACTIVE);
        RepositoryHelper repositoryHelper = new RepositoryHelper(ctx, this, this.serverService);
        try {
            String currentPlatformVersion = originalState.getPlatformVersion();
            int upgradelevel = 9043001;
            StringBuffer level = new StringBuffer();
            level.append(Integer.toString(upgradelevel / 1000000));
            level.append(".");
            level.append(Integer.toString(upgradelevel / 10000 % 100));
            String softwareReleaseLevel = level.toString();
            if (!currentPlatformVersion.startsWith(softwareReleaseLevel)) {
                this.logger.error(RB.getStringResource("MetadataRepositoryServiceImpl.UpgradeMetadata.ServerVersion.Error.txt"));
                this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataRepositoryServiceImpl.UpgradeMetadata.VersionIncompatible.Info.txt", (Object)softwareReleaseLevel, (Object)currentPlatformVersion.substring(0, 3)));
                ctx.setError(true);
                result.setStatus(Operation.Status.ERROR);
                return result;
            }
            this.logger.info(RB.getStringResource("MetadataRepositoryServiceImpl.UpgradeMetadata.BeginMsg.txt"));
            this.logger.info(RB.getStringResource("MetadataRepositoryServiceImpl.UpgradeMetadata.PauseAdmin.txt"));
            if (originalState.getAccess() != ServerState.Access.ADMIN) {
                this.serverService.pauseAdmin(RB.getStringResource("MetadataRepositoryServiceImpl.UpgradeMetadata.PauseComment.txt"));
            }
            this.logger.info(RB.getStringResource("MetadataRepositoryServiceImpl.UpgradeMetadata.PhysicalUpgrade.txt"));
            this.replicateMetadata(ctx, false);
            this.serverService.resumeServer();
            this.serverService.pauseAdmin(RB.getStringResource("MetadataRepositoryServiceImpl.UpgradeMetadata.PauseComment.txt"));
            this.logger.info(RB.getStringResource("MetadataRepositoryServiceImpl.UpgradeMetadata.PhysicalAnalysis.txt"));
            this.analyzePhysicalStructure();
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataRepositoryServiceImpl.UpgradeMetadata.ToVersion.Info.txt", (Object)this.getUpgradeLevelString(9043001)));
            for (Repository repository : this.getRepositories()) {
                if (repository.getRegisteredAccess() == Repository.Access.OFFLINE || repository.getRegisteredAccess() == Repository.Access.ADMIN_RO || repository.getRegisteredAccess() == Repository.Access.READONLY) continue;
                try {
                    OneOffUpgradeHelper oneOffUpgradeHelper = new OneOffUpgradeHelper(ctx, this);
                    int originalRevision = repositoryHelper.getUpgradeLevel(repository);
                    this.logger.info("*****************************");
                    this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataRepositoryServiceImpl.UpgradeMetadata.RepositoryName.Info.txt", (Object)repository.getName()));
                    this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataRepositoryServiceImpl.UpgradeMetadata.FromVersion.Info.txt", (Object)repository.getName(), (Object)this.getUpgradeLevelString(originalRevision)));
                    if (originalRevision < 9020000) {
                        // empty if block
                    }
                    repositoryHelper.validateBIPTree(repository);
                    if (originalRevision < 9020019) {
                        oneOffUpgradeHelper.upgradeNetezzaServersAndLibraries(repository);
                    }
                    if (originalRevision < 9030000) {
                        if (repository.isFoundation()) {
                            oneOffUpgradeHelper.upgradeContentMappingDocuments(repository);
                            oneOffUpgradeHelper.removeTableServerMetadata();
                            oneOffUpgradeHelper.removeAnalyticsPlatformMetadata();
                        } else if (repository.isCustom()) {
                            oneOffUpgradeHelper.createSystemFolderForCustomRepositories(repository);
                        }
                    }
                    if (originalRevision < 9040001) {
                        if (repository.isFoundation()) {
                            oneOffUpgradeHelper.removeEventSubscribersTree(repository);
                            oneOffUpgradeHelper.removeFrameworkDataServerMetadata();
                            oneOffUpgradeHelper.upgradePermissionsOnUserHomeFolders(repository);
                        }
                        if (repository.isProject()) {
                            repositoryHelper.createProjectBIPService(repository);
                        }
                        oneOffUpgradeHelper.upgradeSecurityDisplayNamesAndDescriptions(repository, repositoryHelper);
                    }
                    if (originalRevision < 9041001 && repository.isFoundation()) {
                        oneOffUpgradeHelper.convertAuthorResponsibilities(repository);
                    }
                    if (repository.isFoundation()) {
                        repositoryHelper.loadPermissions(repository);
                        repositoryHelper.upgradeInheritanceRules(repository);
                        repositoryHelper.loadTypeDefinitions(repository);
                        repositoryHelper.loadResourceTemplates(repository);
                        ctx.getServer().loadTypes(true);
                    }
                    oneOffUpgradeHelper.createPublicObjects(repository);
                    oneOffUpgradeHelper.updatePublicTypeInformation(repository);
                    repositoryHelper.verifyUpgradedRepositoryContent(repository);
                    repositoryHelper.createUpgradeLevel(repository, 9043001);
                    repositoryHelper.applyAdminACT(repository);
                    this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataRepositoryServiceImpl.UpgradeMetadata.CompletedRepository.Msg.txt", (Object)repository.getName()));
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                    this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataRepositoryServiceImpl.UpgradeMetadata.FailedRepository.Msg.txt", (Object)repository.getName()));
                    ctx.setError(true);
                    if (!repository.isFoundation()) continue;
                    this.logger.error(RB.getStringResource("MetadataRepositoryServiceImpl.UpgradeMetadata.StoppedMsg.txt"));
                    break;
                }
            }
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataRepositoryServiceImpl.UpgradeMetadata.ResetState.txt", (Object)originalState.getAccess()));
            if (originalState.getAccess() == ServerState.Access.ADMIN) {
                this.serverService.pauseAdmin(originalState.getPauseComment());
            } else {
                this.serverService.resumeServer();
            }
        }
        catch (Exception e) {
            ctx.setError(true);
            this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataRepositoryServiceImpl.UpgradeMetadata.FailedMsg.txt", (Object)e.getMessage()));
        }
        if (ctx.isError()) {
            result.setStatus(Operation.Status.ERROR);
            this.logger.info(RB.getStringResource("MetadataRepositoryServiceImpl.UpgradeMetadata.Summary.Errors.txt"));
        } else {
            result.setStatus(Operation.Status.SUCCESS);
            if (ctx.isWarning()) {
                result.setWarningDetected(true);
                this.logger.info(RB.getStringResource("MetadataRepositoryServiceImpl.UpgradeMetadata.Summary.Warnings.txt"));
            } else {
                this.logger.info(RB.getStringResource("MetadataRepositoryServiceImpl.UpgradeMetadata.Summary.Completed.txt"));
            }
        }
        return result;
    }

    Repository refreshRepositoryfromServer(Repository repository) {
        Repository refreshedRepository = null;
        try {
            if (repository != null) {
                this.clearRepositoryCache();
                refreshedRepository = this.getRepositoryByIdentifier(repository.getId());
            }
        }
        catch (RepositoryDoesNotExistException e) {
            e.printStackTrace();
        }
        return refreshedRepository;
    }

    void setChangeManaged(MdFactory factory, Repository repository) throws Exception {
        String options = "<XMLSELECT search=\"@Name='ChangeManagement'\"/>";
        int count = factory.getOMIUtil().doesObjectExist(repository.getId(), "Group", options);
        if (count > 0) {
            return;
        }
        StringBuffer inXMLBuffer = new StringBuffer("<Group Name=\"ChangeManagement\"/>");
        StringHolder outXML = new StringHolder();
        String inXML = inXMLBuffer.toString();
        factory.getConnection().getCMRHandle().AddMetadata(inXML, repository.getId(), outXML, "SAS", 0x10000000, "");
    }

    boolean removeChangeManaged(MdFactory factory, Repository repository) throws Exception {
        MdObjectStore store = factory.createObjectStore();
        String strSelect = "<XMLSELECT Search=\"@Name='ChangeManagement'\"/>";
        int flags = 392;
        List groupList = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "Group", flags, strSelect, false);
        if (groupList == null || groupList.size() == 0) {
            store.dispose();
            return true;
        }
        Group grp = (Group)groupList.get(0);
        String inXML = "<Group ID=\"" + grp.getFQID() + "\" />";
        StringHolder outXML = new StringHolder();
        int rc = factory.getConnection().getCMRHandle().DeleteMetadata(inXML, outXML, "SAS", 0x10000000, "");
        if (rc != 0) {
            store.dispose();
            return false;
        }
        store.dispose();
        return true;
    }

    String getFoundationRepositoryId() {
        Repository foundation = this.getFoundationRepository();
        if (foundation != null) {
            return foundation.getId();
        }
        return null;
    }

    Logger getLogger() {
        return this.logger;
    }

    private Repository postCreation(RequestContext ctx, Repository repository, Repository.Access finalAccess) throws RepositoryException {
        try {
            if (!repository.isProject()) {
                if (repository.isFoundation()) {
                    if (((FoundationRepository)repository).isChangeManaged()) {
                        this.setChangeManaged(ctx.getFactory(), repository);
                    }
                } else if (repository.isCustom() && ((CustomRepository)repository).isChangeManaged()) {
                    this.setChangeManaged(ctx.getFactory(), repository);
                }
            }
            if (finalAccess != null && finalAccess != repository.getEffectiveAccess()) {
                String accessSetting = null;
                StringHolder outXML = new StringHolder();
                switch (finalAccess) {
                    case ONLINE: {
                        accessSetting = " Access=\"0\"";
                        break;
                    }
                    case READONLY: {
                        accessSetting = " Access=\"1\"";
                        break;
                    }
                    case ADMIN: {
                        accessSetting = " Access=\"2\"";
                        break;
                    }
                    case OFFLINE: {
                        accessSetting = " Access=\"4\"";
                        break;
                    }
                    case ADMIN_RO: {
                        accessSetting = " Access=\"2\"";
                    }
                }
                StringBuffer resetAccessXMLBuffer = new StringBuffer("<RepositoryBase ");
                resetAccessXMLBuffer.append(" ID=\"" + repository.getId() + "\"" + accessSetting + "/>");
                String resetAccessXML = resetAccessXMLBuffer.toString();
                try {
                    ctx.getFactory().getConnection().getCMRHandle().UpdateMetadata(resetAccessXML, outXML, "REPOS", 0x10000000, "");
                }
                catch (Exception e) {
                    this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataRepositoryServiceImpl.ResetAccessError.txt", (Object)e.getMessage()));
                }
            }
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage());
        }
        return repository;
    }

    private RepositoryMgr buildRepositoryMgr() throws RepositoryDoesNotExistException {
        block12: {
            StringBuffer inXMLBuffer = new StringBuffer("<RepositoryMgrBase Id=\"A0000001.A0000001\" />");
            StringHolder outXML = new StringHolder();
            String inXML = inXMLBuffer.toString();
            int flags = 0x4000001;
            RequestContext ctx = this.getRequestContext();
            try {
                ctx.getFactory().getConnection().getCMRHandle().GetMetadata(inXML, outXML, "REPOS", flags, "");
                String xmlOut = outXML.value;
                Document mainDoc = ctx.getFactory().getOMIUtil().parseXML(xmlOut);
                if (mainDoc == null) break block12;
                Node firstNode = mainDoc.getFirstChild();
                RepositoryMgr reposMgr = new RepositoryMgr();
                NamedNodeMap childNodeMap = firstNode.getAttributes();
                String strFQID = childNodeMap.getNamedItem("Id").getNodeValue();
                String strName = childNodeMap.getNamedItem("Name").getNodeValue();
                String strPath = childNodeMap.getNamedItem("RepositoryPath").getNodeValue();
                String strEngine = childNodeMap.getNamedItem("RepositoryEngine").getNodeValue();
                String strOptions = childNodeMap.getNamedItem("RepositoryOptions").getNodeValue();
                String strReposFormat = childNodeMap.getNamedItem("RepositoryFormat").getNodeValue();
                String strDesc = childNodeMap.getNamedItem("Desc").getNodeValue();
                String strLibref = childNodeMap.getNamedItem("RepositoryLibref").getNodeValue();
                if (strFQID != null) {
                    reposMgr.setId(strFQID);
                }
                if (strName != null) {
                    reposMgr.setName(strName);
                }
                if (strPath != null) {
                    reposMgr.setPath(strPath);
                }
                if (strOptions != null) {
                    reposMgr.setOptions(strOptions);
                }
                if (strEngine != null) {
                    reposMgr.setEngine(strEngine);
                }
                if (strReposFormat != null) {
                    try {
                        int formatVer = Integer.parseInt(strReposFormat);
                        reposMgr.setRepositoryFormatVersion(formatVer);
                    }
                    catch (NumberFormatException e) {
                        reposMgr.setRepositoryFormatVersion(-1);
                    }
                }
                if (strDesc != null) {
                    reposMgr.setDescription(strDesc);
                }
                if (strLibref != null) {
                    reposMgr.setLibref(strLibref);
                }
                return reposMgr;
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                throw new RepositoryDoesNotExistException(e.getMessage());
            }
        }
        return null;
    }

    private String doesRepositoryExistAtPath(Repository repository, MdFactory factory, IServer server, String action) throws RepositoryException {
        String reposID;
        block8: {
            reposID = null;
            String exists = null;
            StringHolder output = new StringHolder();
            String input = "<ReposId Path=\"" + repository.getPath() + "\" />";
            try {
                server.Status(input, output, "");
                String outputStr = output.value;
                int beginReposIdIndex = outputStr.lastIndexOf("ReposId=");
                if (beginReposIdIndex == -1) {
                    return null;
                }
                int beginQuoteIndex = beginReposIdIndex + 8;
                int endQuoteIndex = outputStr.indexOf(34, beginQuoteIndex + 1);
                if (endQuoteIndex - beginQuoteIndex > 1) {
                    reposID = outputStr.substring(beginQuoteIndex + 1, endQuoteIndex);
                    break block8;
                }
                if (action.equalsIgnoreCase("Register")) {
                    return null;
                }
                int beginExistsIndex = outputStr.indexOf("Exists=");
                if (beginExistsIndex == -1) {
                    return null;
                }
                beginQuoteIndex = beginExistsIndex + 7;
                endQuoteIndex = outputStr.indexOf(34, beginQuoteIndex + 1);
                if (endQuoteIndex - beginQuoteIndex > 1) {
                    exists = outputStr.substring(beginQuoteIndex + 1, endQuoteIndex);
                    if (!exists.equalsIgnoreCase("No")) {
                        return null;
                    }
                    reposID = "unknownpath";
                    break block8;
                }
                return null;
            }
            catch (GenericError e) {
                throw new RepositoryException(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataRepositoryServiceImpl.ServerStatusError.txt", (Object)e.getMessage()));
            }
        }
        return reposID;
    }

    private Repository postRegistration(RequestContext ctx, Repository repository, Repository.Access finalAccess) throws RepositoryException {
        RepositoryAuthorization repositoryAuthorization = new RepositoryAuthorization(ctx, this, this.serverService);
        RepositoryHelper repositoryHelper = new RepositoryHelper(ctx, this, this.serverService);
        try {
            int repositoryVersion = 0;
            try {
                String sRepFormatVer = repositoryAuthorization.getRepositoryVersionString(repository.getId());
                repositoryVersion = Integer.valueOf(sRepFormatVer);
            }
            catch (Exception e) {
                repositoryVersion = 0;
            }
            if (repositoryVersion < 6) {
                this.unregisterRepository(repository);
                this.logger.error(RB.getStringResource("MetadataRepositoryServiceImpl.UnsupportedRepositoryVersion.Error.txt"));
                return null;
            }
            if (!repository.isProject()) {
                if (repository.isFoundation()) {
                    if (((FoundationRepository)repository).isChangeManaged()) {
                        this.setChangeManaged(ctx.getFactory(), repository);
                    } else {
                        this.removeChangeManaged(ctx.getFactory(), repository);
                    }
                } else if (repository.isCustom()) {
                    if (((CustomRepository)repository).isChangeManaged()) {
                        this.setChangeManaged(ctx.getFactory(), repository);
                    } else {
                        this.removeChangeManaged(ctx.getFactory(), repository);
                    }
                }
            } else if (!repositoryHelper.associateIdentityToProjectRepos((ProjectRepository)repository)) {
                this.unregisterRepository(repository);
                this.logger.error(RB.getStringResource("MetadataRepositoryServiceImpl.AssociateIdentitytoProjectFailed.Error.txt"));
                return null;
            }
            MdObjectStore store = ctx.getFactory().createObjectStore(null, "postRegistrationStore");
            try {
                SoftwareComponent bipSC = repositoryHelper.getBIPTreeObject(store, repository.getId());
                if (bipSC == null) {
                    this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.BIPService.NotFound.Error.txt", (Object)repository.getName()));
                    this.logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"RepositoryHelper.BIPService.Create.Warning.txt", (Object)repository.getName()));
                    if (repository instanceof FoundationRepository) {
                        repositoryHelper.createBIPTree(repository);
                    } else if (repository instanceof CustomRepository) {
                        repositoryHelper.createCustomBIPTree(repository);
                    } else if (repository instanceof ProjectRepository) {
                        repositoryHelper.createProjectBIPService(repository);
                    }
                    bipSC = repositoryHelper.getBIPTreeObject(store, repository.getId());
                } else {
                    String repType = "";
                    repType = repository instanceof FoundationRepository ? "Foundation" : (repository instanceof CustomRepository ? "Custom" : (repository instanceof ProjectRepository ? "Project" : "Unknown"));
                    Property prop = repositoryHelper.getRepositoryDetailsProperty(store, repository);
                    if (prop == null) {
                        String propName = "RepositoryDetails";
                        String propRole = "initialization";
                        String propDesc = "The repository type and name information is stored here and delimited by a colon.";
                        String defaultValue = repType + ":" + repository.getName();
                        prop = (Property)ctx.getFactory().createComplexMetadataObject(store, propName, "Property", repository.getId().substring(9, 17));
                        prop.setPropertyName(propName);
                        prop.setPropertyRole(propRole);
                        prop.setDesc(propDesc);
                        prop.setDefaultValue(defaultValue);
                        prop.getAssociatedObjects().add((Object)bipSC);
                    } else {
                        String defaultValue = prop.getDefaultValue();
                        String oldrepType = defaultValue.substring(0, defaultValue.indexOf(58));
                        if (!oldrepType.equalsIgnoreCase(repType)) {
                            this.logger.error(RB.getStringResource("MetadataRepositoryServiceImpl.RegisterRepos.InvalidTypeChange.Error.txt"));
                            this.unregisterRepository(repository);
                            store.dispose();
                            return null;
                        }
                        defaultValue = repType + ":" + repository.getName();
                        prop.setDefaultValue(defaultValue);
                    }
                }
            }
            catch (RemoteException e) {
                store.dispose();
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                throw new RepositoryException(e.getMessage());
            }
            if (repository.isCustom()) {
                repositoryHelper.updateCustomRepositoryFolderAssociations(repository);
            }
            try {
                store.updatedMetadataAll();
            }
            catch (Exception e) {
                store.dispose();
                throw new RepositoryException(e.getMessage());
            }
            store.dispose();
            if (finalAccess != null && finalAccess != repository.getEffectiveAccess()) {
                String accessSetting = null;
                StringHolder outXML = new StringHolder();
                switch (finalAccess) {
                    case ONLINE: {
                        accessSetting = " Access=\"0\"";
                        break;
                    }
                    case READONLY: {
                        accessSetting = " Access=\"1\"";
                        break;
                    }
                    case ADMIN: {
                        accessSetting = " Access=\"2\"";
                        break;
                    }
                    case OFFLINE: {
                        accessSetting = " Access=\"4\"";
                        break;
                    }
                    case ADMIN_RO: {
                        accessSetting = " Access=\"2\"";
                    }
                }
                StringBuffer resetAccessXMLBuffer = new StringBuffer("<RepositoryBase ");
                resetAccessXMLBuffer.append(" ID=\"" + repository.getId() + "\"" + accessSetting + "/>");
                String resetAccessXML = resetAccessXMLBuffer.toString();
                try {
                    ctx.getFactory().getConnection().getCMRHandle().UpdateMetadata(resetAccessXML, outXML, "REPOS", 0x10000000, "");
                }
                catch (Exception e) {
                    this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataRepositoryServiceImpl.ResetAccessError.txt", (Object)e.getMessage()));
                }
            }
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage());
        }
        return repository;
    }

    private void persist(RequestContext ctx, Repository repository) throws Exception {
        String accessSetting = null;
        boolean isNewRepository = repository.getId().equals(REPOSMGRID);
        StringBuffer inXMLBuffer = new StringBuffer("<RepositoryBase ");
        if (repository.getId() != null) {
            inXMLBuffer.append(" ID=\"" + repository.getId() + "\"");
        }
        if (repository.getName() != null) {
            inXMLBuffer.append(" Name=\"" + repository.getName() + "\"");
        }
        if (repository.getDescription() != null) {
            inXMLBuffer.append(" Desc=\"" + repository.getDescription() + "\"");
        }
        if (isNewRepository) {
            if (repository instanceof FoundationRepository) {
                inXMLBuffer.append(" RepositoryType=\"FOUNDATION\"");
            } else if (repository instanceof CustomRepository) {
                inXMLBuffer.append(" RepositoryType=\"CUSTOM\"");
            } else if (repository instanceof ProjectRepository) {
                inXMLBuffer.append(" RepositoryType=\"PROJECT\"");
            } else {
                inXMLBuffer.append(" RepositoryType=\"UNKNOWN\"");
            }
        }
        if (isNewRepository && repository.getPath() != null && repository.getPath().length() > 0) {
            inXMLBuffer.append(" Path=\"" + repository.getPath() + "\"");
        }
        if (isNewRepository && repository.getEngine() != null) {
            inXMLBuffer.append(" Engine=\"" + repository.getEngine() + "\"");
        } else {
            inXMLBuffer.append(" Engine=\"BASE\"");
        }
        if (repository.getOptions() != null && repository.getOptions().length() > 0) {
            inXMLBuffer.append(" Options=\"" + repository.getOptions() + "\"");
        } else {
            inXMLBuffer.append(" Options=\"\"");
        }
        switch (repository.getEffectiveAccess()) {
            case ONLINE: {
                inXMLBuffer.append(" Access=\"0\"");
                break;
            }
            case READONLY: {
                if (isNewRepository) {
                    inXMLBuffer.append(" Access=\"2\"");
                    accessSetting = " Access=\"1\"";
                    break;
                }
                inXMLBuffer.append(" Access=\"1\"");
                break;
            }
            case ADMIN: {
                inXMLBuffer.append(" Access=\"2\"");
                break;
            }
            case OFFLINE: {
                if (isNewRepository) {
                    inXMLBuffer.append(" Access=\"2\"");
                    accessSetting = " Access=\"4\"";
                    break;
                }
                inXMLBuffer.append(" Access=\"4\"");
            }
        }
        inXMLBuffer.append("/>");
        try {
            StringHolder outXML = new StringHolder();
            String inXML = inXMLBuffer.toString();
            MdFactory factory = ctx.getFactory();
            if (isNewRepository) {
                if (repository.isCreateRepositoryPath()) {
                    factory.getConnection().getCMRHandle().AddMetadata(inXML, REPOSMGRID, outXML, "REPOS", 0x10000000, "<CreateReposContainer/>");
                } else {
                    factory.getConnection().getCMRHandle().AddMetadata(inXML, REPOSMGRID, outXML, "REPOS", 0x10000000, "");
                }
                String reposId = null;
                String outXMLString = outXML.value;
                Document mainDoc = factory.getOMIUtil().parseXML(outXMLString);
                if (mainDoc != null) {
                    Node firstNode = mainDoc.getFirstChild();
                    NamedNodeMap attrMap = firstNode.getAttributes();
                    reposId = attrMap.getNamedItem("ID").getNodeValue();
                    repository.setId(reposId);
                    repository.setDescription(attrMap.getNamedItem("Desc").getNodeValue());
                    String engine = attrMap.getNamedItem("Engine").getNodeValue();
                    repository.setEngine(engine);
                    repository.setPath(attrMap.getNamedItem("Path").getNodeValue());
                    repository.setOptions(attrMap.getNamedItem("Options").getNodeValue());
                    String strAccess = attrMap.getNamedItem("Access").getNodeValue();
                    repository.setRegisteredAccess(Repository.Access.getByNumberValue((String)strAccess));
                }
                if (accessSetting != null) {
                    StringBuffer followUpdateXMLBuffer = new StringBuffer("<RepositoryBase ");
                    followUpdateXMLBuffer.append(" ID=\"" + reposId + "\"" + accessSetting + "/>");
                    String followUpdateXML = followUpdateXMLBuffer.toString();
                    factory.getConnection().getCMRHandle().UpdateMetadata(followUpdateXML, outXML, "REPOS", 0x10000000, "");
                }
            } else {
                factory.getConnection().getCMRHandle().UpdateMetadata(inXML, outXML, "REPOS", 0x10000000, "");
            }
            this.clearRepositoryCache();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw e;
        }
    }

    private void removeRepository(Repository repository, int flag) throws RepositoryException {
        RequestContext ctx = this.getRequestContext();
        try {
            String reposName = repository.getName();
            StringHolder outXML = new StringHolder();
            String inXML = "";
            inXML = "<RepositoryBase ID=\"" + repository.getId() + "\"></RepositoryBase>";
            int flags = flag + 0x10000000;
            ctx.getFactory().getConnection().getCMRHandle().DeleteMetadata(inXML, outXML, "REPOS", flags, "");
            ((OMIServer)ctx.getServer()).RepositoryDeleted(reposName);
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage());
        }
    }

    private boolean isForcedUnregisterAllowed(String pauseState, Repository.Access access) {
        if (pauseState == null) {
            return false;
        }
        if (pauseState.equalsIgnoreCase("OFFLINE") && access != Repository.Access.OFFLINE) {
            return true;
        }
        return (pauseState.equalsIgnoreCase("READONLY") || pauseState.equalsIgnoreCase("ADMIN(READONLY)")) && access != Repository.Access.READONLY;
    }

    private void validateRepository(MdFactory factory, Repository repository) throws RepositoryException, RepositoryExistsException {
        if (repository.isFoundation()) {
            if (repository.getName() == null || repository.getName().length() == 0) {
                repository.setName("Foundation");
            }
            if (repository.getPath() == null || repository.getPath().length() == 0) {
                repository.setPath("MetadataRepositories/Foundation");
            }
        }
        if (repository.getName() == null || repository.getName().length() == 0) {
            throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.CreateRepository.NameMissing.Error.txt"));
        }
        try {
            Names.validateOMRObjectName((String)repository.getName(), (boolean)true);
        }
        catch (IllegalArgumentException e) {
            throw new RepositoryException(e.getLocalizedMessage());
        }
        this.validateRepositoryName(repository.getName(), repository.isProject());
        if (repository.getPath() == null || repository.getPath().length() == 0) {
            throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.CreateRepository.PathMissing.Error.txt"));
        }
        switch (repository.getRegisteredAccess()) {
            case ONLINE: 
            case READONLY: 
            case ADMIN: {
                break;
            }
            case OFFLINE: {
                if (!repository.isFoundation()) break;
                throw new RepositoryException(RB.getStringResource("MetadataRepositoryServiceImpl.CreateRepository.AccessOffline.Error.txt"));
            }
        }
    }

    private RepositoryCreationResult initializeRepository(RequestContext ctx, Repository repository) throws Exception {
        boolean isStoringUsers = false;
        String usersPath = null;
        RepositoryCreationResult result = new RepositoryCreationResult();
        this.logger.info(RB.getStringResource("RepositoryHelper.Exec.Desc.txt"));
        MdFactory factory = ctx.getFactory();
        if (repository.isFoundation()) {
            isStoringUsers = true;
            usersPath = ((FoundationRepository)repository).getPathtoUsersRootFolder();
            usersPath = usersPath == null || usersPath.length() == 0 ? "/" + RB.getStringResource("MetadataRepositoryServiceImpl.DefaultUserFolder.txt") : factory.getOMIUtil().cleanStringForXML(usersPath);
        }
        boolean initialized = false;
        RepositoryHelper repositoryHelper = new RepositoryHelper(ctx, this, this.serverService);
        initialized = repository.isProject() ? repositoryHelper.loadProjectRepositoryData(repository, result) : repositoryHelper.loadRepositoryData(repository, result);
        if (initialized) {
            if (repository.isFoundation() || repository.isCustom()) {
                try {
                    int flags = 0x10000188;
                    String options = "<XMLSELECT search=\"@Name = 'Store User Definitions' OR @Name = 'Path to Users Root Folder'\"/>";
                    MdObjectStore store = factory.createObjectStore();
                    List policiesList = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository.getId(), "Property", flags, options, false);
                    Property propertyPathToRoot = null;
                    Property propertyStoreUsers = null;
                    for (int i = 0; i < policiesList.size(); ++i) {
                        Property policy = (Property)policiesList.get(i);
                        if (policy.getPropertyName().equals("Store User Definitions")) {
                            propertyStoreUsers = policy;
                            continue;
                        }
                        if (!policy.getPropertyName().equals("Path to Users Root Folder")) continue;
                        propertyPathToRoot = policy;
                    }
                    boolean commitOutstandingChanges = false;
                    String storeUsers = isStoringUsers ? "Y" : "N";
                    if (isStoringUsers && propertyStoreUsers != null && !storeUsers.equals(propertyStoreUsers.getDefaultValue())) {
                        propertyStoreUsers.setDefaultValue(storeUsers);
                        commitOutstandingChanges = true;
                    }
                    if (usersPath != null && propertyPathToRoot != null && !usersPath.equals(propertyPathToRoot.getDefaultValue())) {
                        propertyPathToRoot.setDefaultValue(usersPath);
                        commitOutstandingChanges = true;
                    }
                    if (commitOutstandingChanges) {
                        store.updatedMetadataAll();
                    }
                    store.dispose();
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                    result.setStatus(Operation.Status.ERROR);
                    result.setErrorMessage(e.getMessage());
                }
                if (repository.isFoundation()) {
                    repositoryHelper.refreshServer(ctx);
                }
            }
            if (result.getStatus() == Operation.Status.ERROR || ctx.isError()) {
                result.setStatus(Operation.Status.ERROR);
                this.logger.info(RB.getStringResource("RepositoryHelper.RepositoryInitialization.Error.txt"));
            } else {
                result.setStatus(Operation.Status.SUCCESS);
                this.logger.info(RB.getStringResource("RepositoryHelper.RepositoryInitialization.Success.txt"));
            }
        } else {
            this.logger.info(RB.getStringResource("RepositoryHelper.RepositoryInitialization.Error.txt"));
            result.setStatus(Operation.Status.ERROR);
        }
        return result;
    }

    private void replicateMetadata(RequestContext ctx, boolean force) {
        ArrayList<Object> repositories = new ArrayList<Object>();
        try {
            repositories.add(this.getRepositoryManager());
        }
        catch (RepositoryDoesNotExistException e) {
            this.logger.error("Unable to find rposmgr.  replicateMetadata has failed");
            throw new RuntimeException("Unable to find rposmgr", e);
        }
        for (Repository repository : this.getRepositories()) {
            if (repository.getRegisteredAccess() == Repository.Access.OFFLINE) {
                this.logger.info("Skipping offline repository " + repository.getName());
                continue;
            }
            if (repository.getRegisteredAccess() == Repository.Access.ADMIN_RO || repository.getRegisteredAccess() == Repository.Access.READONLY) {
                this.logger.info("Skipping readonly repository " + repository.getName());
                continue;
            }
            repositories.add(repository);
        }
        StringBuffer request = new StringBuffer();
        request.append("<EXCLUSIVE_LOCK>\n <ReplicateMetadata> \n  <Metadata>\n");
        for (Repository repository : repositories) {
            request.append("    <RepositoryBase Name='");
            request.append(StringEscapeUtils.escapeXml((String)repository.getName()));
            request.append("' Id='");
            request.append(repository.getId());
            request.append("'>\n");
            request.append("      <CopyTarget>\n");
            request.append("        <RepositoryBase Name='");
            request.append(StringEscapeUtils.escapeXml((String)repository.getName()));
            request.append("' Path='");
            request.append(StringEscapeUtils.escapeXml((String)repository.getPath()));
            request.append("' Options='");
            request.append(StringEscapeUtils.escapeXml((String)repository.getOptions()));
            request.append("'/>\n");
            request.append("      </CopyTarget>\n    </RepositoryBase>\n");
        }
        request.append("  </Metadata> \n  <NS>REPOS</NS>\n  <Flags>268435456</Flags>\n");
        if (force) {
            request.append("  <Options><FORCEUPGRADE/></Options>\n");
        } else {
            request.append("  <Options><INPLACEUPGRADE/></Options>\n");
        }
        request.append(" </ReplicateMetadata>\n</EXCLUSIVE_LOCK>");
        try {
            ctx.getFactory().getOMIUtil().DoRequest(request.toString());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Failed to upgrade metadata", remoteException);
        }
        catch (MdException mdException) {
            throw new RuntimeException("Failed to upgrade metadata", mdException);
        }
        this.serverService.pauseOffline("Reloading metadata");
    }

    private void analyzePhysicalStructure() {
        AnalysisToolGroup physicalTools = this.analysisService.getAnalysisToolGroup("Physical");
        for (Repository repository : this.getRepositories()) {
            for (AnalysisToolDescriptor analysisTool : physicalTools.getMembers()) {
                if (repository.getRegisteredAccess() == Repository.Access.OFFLINE || repository.getRegisteredAccess() == Repository.Access.ADMIN_RO || repository.getRegisteredAccess() == Repository.Access.READONLY) continue;
                this.analysisService.repair(repository, analysisTool.getId());
            }
        }
    }

    private String getUpgradeLevelString(int upgradeLevel) {
        StringBuffer level = new StringBuffer();
        level.append(Integer.toString(upgradeLevel / 1000000));
        level.append(".");
        level.append(Integer.toString(upgradeLevel / 10000 % 100));
        int mLevel = upgradeLevel / 1000 % 10;
        if (mLevel > 0) {
            level.append("M");
            level.append(Integer.toString(mLevel));
        }
        level.append("-");
        level.append(Integer.toString(upgradeLevel % 1000));
        return level.toString();
    }

    class RepositoryComparator
    implements Comparator<Object> {
        RepositoryComparator() {
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            if (obj1 == obj2) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            return this.runCompare(obj1, obj2);
        }

        private int runCompare(Object obj1, Object obj2) {
            Repository repos1 = null;
            Repository repos2 = null;
            if (!(obj1 instanceof Repository)) {
                return -1;
            }
            repos1 = (Repository)obj1;
            if (!(obj2 instanceof Repository)) {
                return 1;
            }
            repos2 = (Repository)obj2;
            if (repos1.isFoundation() && repos2.isFoundation() || repos1.isCustom() && repos2.isCustom() || repos1.isProject() && repos2.isProject()) {
                Collator collator = Collator.getInstance();
                return collator.compare(repos1.getName(), repos2.getName());
            }
            if (repos1.isFoundation()) {
                return -1;
            }
            if (repos2.isFoundation()) {
                return 1;
            }
            if (repos1.isCustom()) {
                return -1;
            }
            return 1;
        }
    }
}

