/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.analysis;

import com.sas.metadata.remote.MdException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.svcs.metadata.mgmt.client.Operation;
import com.sas.svcs.metadata.mgmt.impl.analysis.AbstractToolImpl;
import com.sas.svcs.metadata.mgmt.impl.analysis.AnalysisTool;
import com.sas.svcs.metadata.mgmt.impl.analysis.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VerifyMetadataFiles
extends AbstractToolImpl {
    static final String NAME = RB.getStringResource("VerifyMetadataFiles.tool.name.txt");
    static final String DESCRIPTION = RB.getStringResource("VerifyMetadataFiles.tool.desc.txt");
    static final String ID = "Files";
    private static AnalysisTool _factoryInstance;
    private String _datasetErrors = null;
    private String _datasetRepairs = null;
    private String _datasetWarnings = null;

    public static AnalysisTool getFactory() {
        if (_factoryInstance == null) {
            _factoryInstance = new VerifyMetadataFiles();
        }
        return _factoryInstance;
    }

    private VerifyMetadataFiles() {
    }

    private VerifyMetadataFiles(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
    }

    @Override
    public AnalysisTool newInstance(OMIRepositoryInterface repository, Logger log) {
        VerifyMetadataFiles newObject = new VerifyMetadataFiles(repository, log);
        return newObject;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public void analyzeImpl() {
        try {
            StringBuffer inXMLBuffer = new StringBuffer();
            inXMLBuffer.append("<EXCLUSIVE_LOCK><AnalyzeMetadata>");
            inXMLBuffer.append("<Metadata><Statistics Errors=\"\" Warnings=\"\" Repairs=\"\"/></Metadata>");
            inXMLBuffer.append("<ReposId>");
            inXMLBuffer.append(this._repository.getDefaultRepositoryId());
            inXMLBuffer.append("</ReposId>");
            inXMLBuffer.append("<Flags/>");
            inXMLBuffer.append("<Ns>REPOS</Ns>");
            inXMLBuffer.append("<Options><VerifyMetadataFiles/></Options>");
            inXMLBuffer.append("</AnalyzeMetadata></EXCLUSIVE_LOCK>");
            String inXML = inXMLBuffer.toString();
            this._log.debug(inXML);
            Document mainDoc = this._OMIUtil.DoRequest(inXML);
            if (mainDoc != null) {
                Node attrNode;
                NamedNodeMap attrNodeMap;
                String childName;
                Node childNode;
                int j;
                NodeList nodeList = mainDoc.getElementsByTagName("Metadata");
                Node node = nodeList.item(0);
                NodeList childList = node.getChildNodes();
                for (j = 0; j < childList.getLength(); ++j) {
                    childNode = childList.item(j);
                    childName = childNode.getNodeName();
                    if (!childName.equalsIgnoreCase("Statistics")) continue;
                    attrNodeMap = childNode.getAttributes();
                    attrNode = attrNodeMap.getNamedItem("Errors");
                    this._datasetErrors = attrNode.getNodeValue();
                    attrNode = attrNodeMap.getNamedItem("Warnings");
                    this._datasetWarnings = attrNode.getNodeValue();
                    attrNode = attrNodeMap.getNamedItem("Repairs");
                    this._datasetRepairs = attrNode.getNodeValue();
                }
                nodeList = mainDoc.getElementsByTagName("OmiWarnings");
                if (nodeList != null && nodeList.getLength() > 0) {
                    node = nodeList.item(0);
                    childList = node.getChildNodes();
                    for (j = 0; j < childList.getLength(); ++j) {
                        childNode = childList.item(j);
                        childName = childNode.getNodeName();
                        if (!childName.equalsIgnoreCase("Warning")) continue;
                        attrNodeMap = childNode.getAttributes();
                        attrNode = attrNodeMap.getNamedItem("Name");
                        String severity = attrNode.getNodeValue();
                        attrNode = attrNodeMap.getNamedItem("Desc");
                        String text = attrNode.getNodeValue();
                        if (severity.equals("ERROR")) {
                            this._log.error(text);
                            continue;
                        }
                        if (severity.equals("WARN")) {
                            this._log.warn(text);
                            continue;
                        }
                        if (!severity.equals("INFO") || text.indexOf("OpenRepository") >= 0 || text.indexOf("CloseRepository") >= 0) continue;
                        this._log.info(text);
                    }
                }
            }
            if (!this._datasetErrors.equalsIgnoreCase("0")) {
                this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyMetadataFiles.Analyze.CandidatesFound.fmt", (Object)this._datasetErrors, (Object)this._datasetWarnings, (Object)this._datasetRepairs, (Object)this._repository.getDefaultRepositoryName()));
                this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyMetadataFiles.Analyze.FatalErrorsFound.fmt", (Object)this._repository.getDefaultRepositoryName()));
                this._result.setStatus(Operation.Status.FATAL);
                this._result.setRepairNeeded(true);
            } else if (!this._datasetRepairs.equalsIgnoreCase("0")) {
                this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyMetadataFiles.Analyze.CandidatesFound.fmt", (Object)this._datasetErrors, (Object)this._datasetWarnings, (Object)this._datasetRepairs, (Object)this._repository.getDefaultRepositoryName()));
                this._result.setStatus(Operation.Status.SUCCESS);
                this._result.setWarningDetected(true);
                this._result.setRepairNeeded(true);
            } else if (!this._datasetWarnings.equalsIgnoreCase("0")) {
                this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyMetadataFiles.Analyze.CandidatesFound.fmt", (Object)this._datasetErrors, (Object)this._datasetWarnings, (Object)this._datasetRepairs, (Object)this._repository.getDefaultRepositoryName()));
                this._result.setStatus(Operation.Status.SUCCESS);
                this._result.setWarningDetected(true);
                this._result.setRepairNeeded(true);
            } else {
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyMetadataFiles.Analyze.NoCandidates.fmt", (Object)this._repository.getDefaultRepositoryName()));
                this._result.setStatus(Operation.Status.SUCCESS);
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (DOMException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void repairImpl() {
        try {
            Node attrNode;
            NamedNodeMap attrNodeMap;
            String childName;
            Node childNode;
            int j;
            NodeList childList;
            Node node;
            NodeList nodeList;
            StringBuffer inXMLBuffer = new StringBuffer();
            inXMLBuffer.append("<EXCLUSIVE_LOCK><RepairMetadata>");
            inXMLBuffer.append("<Metadata><Statistics Errors=\"\" Warnings=\"\" Repairs=\"\"/></Metadata>");
            inXMLBuffer.append("<ReposId>");
            inXMLBuffer.append(this._repository.getDefaultRepositoryId());
            inXMLBuffer.append("</ReposId>");
            inXMLBuffer.append("<Flags>269484932</Flags>");
            inXMLBuffer.append("<Ns>REPOS</Ns>");
            inXMLBuffer.append("<Options><VerifyMetadataFiles/></Options>");
            inXMLBuffer.append("</RepairMetadata></EXCLUSIVE_LOCK>");
            String inXML = inXMLBuffer.toString();
            this._log.debug(inXML);
            Document mainDoc = this._OMIUtil.DoRequest(inXML);
            if (mainDoc != null) {
                nodeList = mainDoc.getElementsByTagName("Metadata");
                node = nodeList.item(0);
                childList = node.getChildNodes();
                for (j = 0; j < childList.getLength(); ++j) {
                    childNode = childList.item(j);
                    childName = childNode.getNodeName();
                    if (!childName.equalsIgnoreCase("Statistics")) continue;
                    attrNodeMap = childNode.getAttributes();
                    attrNode = attrNodeMap.getNamedItem("Errors");
                    this._datasetErrors = attrNode.getNodeValue();
                    attrNode = attrNodeMap.getNamedItem("Warnings");
                    this._datasetWarnings = attrNode.getNodeValue();
                    attrNode = attrNodeMap.getNamedItem("Repairs");
                    this._datasetRepairs = attrNode.getNodeValue();
                }
            }
            if ((nodeList = mainDoc.getElementsByTagName("OmiWarnings")) != null && nodeList.getLength() > 0) {
                node = nodeList.item(0);
                childList = node.getChildNodes();
                for (j = 0; j < childList.getLength(); ++j) {
                    childNode = childList.item(j);
                    childName = childNode.getNodeName();
                    if (!childName.equalsIgnoreCase("Warning")) continue;
                    attrNodeMap = childNode.getAttributes();
                    attrNode = attrNodeMap.getNamedItem("Name");
                    String severity = attrNode.getNodeValue();
                    attrNode = attrNodeMap.getNamedItem("Desc");
                    String text = attrNode.getNodeValue();
                    if (severity.equals("ERROR")) {
                        this._log.error(text);
                        continue;
                    }
                    if (severity.equals("WARN")) {
                        this._log.warn(text);
                        continue;
                    }
                    if (!severity.equals("INFO") || text.indexOf("OpenRepository") >= 0 || text.indexOf("CloseRepository") >= 0) continue;
                    this._log.info(text);
                }
            }
            if (this._datasetRepairs.equalsIgnoreCase("0")) {
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyMetadataFiles.Repair.NoRepairRequired.fmt", (Object)this._datasetErrors, (Object)this._datasetWarnings, (Object)this._repository.getDefaultRepositoryName()));
            } else {
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyMetadataFiles.Repair.Results.fmt", (Object)this._datasetRepairs, (Object)this._datasetErrors, (Object)this._datasetWarnings, (Object)this._repository.getDefaultRepositoryName()));
            }
            if (!this._datasetErrors.equalsIgnoreCase("0")) {
                this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyMetadataFiles.Repair.FatalErrorsFound.fmt", (Object)this._repository.getDefaultRepositoryName()));
                this._result.setStatus(Operation.Status.FATAL);
            } else {
                this._result.setStatus(Operation.Status.SUCCESS);
                this._result.setWarningDetected(!this._datasetWarnings.equalsIgnoreCase("0"));
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (DOMException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new RuntimeException(e);
        }
    }
}

