/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.analysis;

import com.sas.metadata.remote.MdException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.svcs.metadata.mgmt.client.Operation;
import com.sas.svcs.metadata.mgmt.impl.analysis.AbstractToolImpl;
import com.sas.svcs.metadata.mgmt.impl.analysis.AnalysisTool;
import com.sas.svcs.metadata.mgmt.impl.analysis.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VerifyAssociations
extends AbstractToolImpl {
    static final String NAME = RB.getStringResource("VerifyAssociations.tool.name.txt");
    static final String DESCRIPTION = RB.getStringResource("VerifyAssociations.tool.desc.txt");
    static final String ID = "Assoc";
    private static AnalysisTool _factoryInstance;
    private String _brokenAssociations = null;
    private String _deletedAssociations = null;
    private String _suspectCrossReferences = null;
    private String _totalAssociations = null;

    public static AnalysisTool getFactory() {
        if (_factoryInstance == null) {
            _factoryInstance = new VerifyAssociations();
        }
        return _factoryInstance;
    }

    private VerifyAssociations() {
    }

    private VerifyAssociations(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
    }

    @Override
    public AnalysisTool newInstance(OMIRepositoryInterface repository, Logger log) {
        VerifyAssociations newObject = new VerifyAssociations(repository, log);
        return newObject;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public void analyzeImpl() {
        try {
            StringBuffer inXMLBuffer = new StringBuffer();
            inXMLBuffer.append("<EXCLUSIVE_LOCK><AnalyzeMetadata>");
            inXMLBuffer.append("<Metadata><Statistics Broken=\"\" Suspect=\"\" Total=\"\"/></Metadata>");
            inXMLBuffer.append("<ReposId>");
            inXMLBuffer.append(this._repository.getDefaultRepositoryId());
            inXMLBuffer.append("</ReposId>");
            inXMLBuffer.append("<Flags/>");
            inXMLBuffer.append("<Ns>REPOS</Ns>");
            inXMLBuffer.append("<Options><VerifyAssociations/></Options>");
            inXMLBuffer.append("</AnalyzeMetadata></EXCLUSIVE_LOCK>");
            String inXML = inXMLBuffer.toString();
            this._log.debug(inXML);
            Document mainDoc = this._OMIUtil.DoRequest(inXML);
            if (mainDoc != null) {
                Node attrNode;
                NamedNodeMap attrNodeMap;
                String childName;
                Node childNode;
                int j;
                NodeList nodeList = mainDoc.getElementsByTagName("Metadata");
                Node node = nodeList.item(0);
                NodeList childList = node.getChildNodes();
                for (j = 0; j < childList.getLength(); ++j) {
                    childNode = childList.item(j);
                    childName = childNode.getNodeName();
                    if (!childName.equalsIgnoreCase("Statistics")) continue;
                    attrNodeMap = childNode.getAttributes();
                    attrNode = attrNodeMap.getNamedItem("Broken");
                    this._brokenAssociations = attrNode.getNodeValue();
                    attrNode = attrNodeMap.getNamedItem("Suspect");
                    this._suspectCrossReferences = attrNode.getNodeValue();
                    attrNode = attrNodeMap.getNamedItem("Total");
                    this._totalAssociations = attrNode.getNodeValue();
                }
                nodeList = mainDoc.getElementsByTagName("OmiWarnings");
                if (nodeList != null && nodeList.getLength() > 0) {
                    node = nodeList.item(0);
                    childList = node.getChildNodes();
                    for (j = 0; j < childList.getLength(); ++j) {
                        childNode = childList.item(j);
                        childName = childNode.getNodeName();
                        if (!childName.equalsIgnoreCase("Warning")) continue;
                        attrNodeMap = childNode.getAttributes();
                        attrNode = attrNodeMap.getNamedItem("Name");
                        String severity = attrNode.getNodeValue();
                        attrNode = attrNodeMap.getNamedItem("Desc");
                        String text = attrNode.getNodeValue();
                        if (severity.equals("ERROR")) {
                            this._log.error(text);
                            continue;
                        }
                        if (severity.equals("WARN")) {
                            this._log.warn(text);
                            continue;
                        }
                        if (!severity.equals("INFO") || text.indexOf("intermediate results:") >= 0) continue;
                        this._log.info(text);
                    }
                }
            }
            if (this._brokenAssociations.equalsIgnoreCase("0") && this._suspectCrossReferences.equalsIgnoreCase("0")) {
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyAssociations.Analyze.NoCandidates.fmt", (Object)this._repository.getDefaultRepositoryName(), (Object)this._totalAssociations));
                this._result.setStatus(Operation.Status.SUCCESS);
            } else {
                this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyAssociations.Analyze.CandidatesFound.fmt", (Object)this._repository.getDefaultRepositoryName(), (Object)this._totalAssociations, (Object)this._brokenAssociations, (Object)this._suspectCrossReferences));
                this._result.setStatus(Operation.Status.SUCCESS);
                this._result.setWarningDetected(true);
                this._result.setRepairNeeded(true);
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (DOMException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void repairImpl() {
        try {
            StringBuffer inXMLBuffer = new StringBuffer();
            inXMLBuffer.append("<EXCLUSIVE_LOCK><RepairMetadata>");
            inXMLBuffer.append("<Metadata><Statistics Deleted=\"\" Total=\"\"/></Metadata>");
            inXMLBuffer.append("<ReposId>");
            inXMLBuffer.append(this._repository.getDefaultRepositoryId());
            inXMLBuffer.append("</ReposId>");
            inXMLBuffer.append("<Flags>269484932</Flags>");
            inXMLBuffer.append("<Ns>REPOS</Ns>");
            inXMLBuffer.append("<Options><VerifyAssociations/></Options>");
            inXMLBuffer.append("</RepairMetadata></EXCLUSIVE_LOCK>");
            String inXML = inXMLBuffer.toString();
            this._log.debug(inXML);
            Document mainDoc = this._OMIUtil.DoRequest(inXML);
            if (mainDoc != null) {
                Node attrNode;
                NamedNodeMap attrNodeMap;
                String childName;
                Node childNode;
                int j;
                NodeList nodeList = mainDoc.getElementsByTagName("Metadata");
                Node node = nodeList.item(0);
                NodeList childList = node.getChildNodes();
                for (j = 0; j < childList.getLength(); ++j) {
                    childNode = childList.item(j);
                    childName = childNode.getNodeName();
                    if (!childName.equalsIgnoreCase("Statistics")) continue;
                    attrNodeMap = childNode.getAttributes();
                    attrNode = attrNodeMap.getNamedItem("Deleted");
                    this._deletedAssociations = attrNode.getNodeValue();
                    attrNode = attrNodeMap.getNamedItem("Total");
                    this._totalAssociations = attrNode.getNodeValue();
                }
                nodeList = mainDoc.getElementsByTagName("OmiWarnings");
                if (nodeList != null && nodeList.getLength() > 0) {
                    node = nodeList.item(0);
                    childList = node.getChildNodes();
                    for (j = 0; j < childList.getLength(); ++j) {
                        childNode = childList.item(j);
                        childName = childNode.getNodeName();
                        if (!childName.equalsIgnoreCase("Warning")) continue;
                        attrNodeMap = childNode.getAttributes();
                        attrNode = attrNodeMap.getNamedItem("Name");
                        String severity = attrNode.getNodeValue();
                        attrNode = attrNodeMap.getNamedItem("Desc");
                        String text = attrNode.getNodeValue();
                        if (severity.equals("ERROR")) {
                            this._log.error(text);
                            continue;
                        }
                        if (severity.equals("WARN")) {
                            this._log.warn(text);
                            continue;
                        }
                        if (!severity.equals("INFO") || text.indexOf("intermediate results:") >= 0) continue;
                        this._log.info(text);
                    }
                }
            }
            if (this._deletedAssociations.equalsIgnoreCase("0")) {
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyAssociations.Repair.NoRepairRequired.fmt", (Object)this._repository.getDefaultRepositoryName(), (Object)this._totalAssociations));
            } else {
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyAssociations.Repair.Results.fmt", (Object)this._repository.getDefaultRepositoryName(), (Object)this._totalAssociations, (Object)this._deletedAssociations));
            }
            this._result.setStatus(Operation.Status.SUCCESS);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (DOMException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new RuntimeException(e);
        }
    }
}

