/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.analysis;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.meta.SASOMI.IServer;
import com.sas.meta.SASOMI.IServerHelper;
import com.sas.services.ServiceException;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.HostPortPair;
import com.sas.services.connection.HostPortSet;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.Server;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.svcs.metadata.mgmt.client.ClusterDetails;
import com.sas.svcs.metadata.mgmt.client.MetadataMgmtException;
import com.sas.svcs.metadata.mgmt.client.MetadataServerService;
import com.sas.svcs.metadata.mgmt.client.Operation;
import com.sas.svcs.metadata.mgmt.impl.analysis.AbstractToolImpl;
import com.sas.svcs.metadata.mgmt.impl.analysis.AnalysisTool;
import com.sas.svcs.metadata.mgmt.impl.analysis.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SynchCheck
extends AbstractToolImpl {
    static final String NAME = RB.getStringResource("SynchCheck.tool.name.txt");
    static final String DESCRIPTION = RB.getStringResource("SynchCheck.tool.desc.txt");
    static final String ID = "Synch";
    private static AnalysisTool _factoryInstance;
    private MetadataServerInterface server = null;
    private MetadataServerService metadataServerService;
    private IServer iServer = null;

    public static AnalysisTool getFactory() {
        if (_factoryInstance == null) {
            _factoryInstance = new SynchCheck();
        }
        return _factoryInstance;
    }

    private SynchCheck() {
    }

    public void setMetadataServerService(MetadataServerService metadataServerService) {
        this.metadataServerService = metadataServerService;
    }

    private SynchCheck(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
        try {
            this.server = (MetadataServerInterface)repository.getServer();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AnalysisTool newInstance(OMIRepositoryInterface repository, Logger log) {
        SynchCheck newObject = new SynchCheck(repository, log);
        return newObject;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public void analyzeImpl() {
        try {
            boolean isCluster = this.checkIfCluster();
            if (!isCluster) {
                return;
            }
            boolean repair = false;
            String reposName = this._repository.getDefaultRepositoryName();
            String reposType = this._repository.getRepositoryType();
            this.doSynchCheck(reposName, repair);
            if ("FOUNDATION".equalsIgnoreCase(reposType)) {
                this._log.info(RB.getStringResource("SynchCheck.tool.Analysis.Start.fmt.txt"));
                this.doSynchCheck("REPOSMGR", repair);
            }
        }
        catch (Exception e) {
            this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.Failed.fmt.txt", (java.lang.Object)e.getLocalizedMessage()));
            this._result.setStatus(Operation.Status.ERROR);
        }
    }

    @Override
    public void repairImpl() {
        try {
            boolean isCluster = this.checkIfCluster();
            if (!isCluster) {
                return;
            }
            boolean repair = true;
            String reposName = this._repository.getDefaultRepositoryName();
            String reposType = this._repository.getRepositoryType();
            this.doSynchCheck(reposName, repair);
            if ("FOUNDATION".equalsIgnoreCase(reposType)) {
                this._log.info(RB.getStringResource("SynchCheck.tool.Repair.Start.fmt.txt"));
                this.doSynchCheck("REPOSMGR", repair);
            }
        }
        catch (Exception e) {
            this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.Failed.fmt.txt", (java.lang.Object)e.getLocalizedMessage()));
            this._result.setStatus(Operation.Status.ERROR);
        }
    }

    private void doSynchCheck(String reposName, boolean repair) throws Exception {
        HostPortSet activeNodes;
        ClusterDetails clusterDetails;
        String repairStr = "N";
        if (repair) {
            repairStr = "Y";
        }
        if ((clusterDetails = this.metadataServerService.getClusterDetails()) == null) {
            return;
        }
        HostPortSet offlineHostPortSet = clusterDetails.getOfflineClusterNodes();
        if (offlineHostPortSet.size() > 0) {
            for (HostPortPair pair : offlineHostPortSet) {
                String host = pair.getHost();
                int port = pair.getPort();
                String serverName = host + ":" + port;
                this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.NodeOffline.Warning.fmt.txt", (java.lang.Object)serverName, (java.lang.Object)reposName));
                this._result.setWarningDetected(true);
            }
        }
        if ((activeNodes = clusterDetails.getActiveClusterNodes()).size() <= 1) {
            this._log.info(RB.getStringResource("SynchCheck.tool.InsufficentCluster.txt"));
            return;
        }
        HostPortSet serversWithProblems = this.synchCheck(reposName, repairStr, activeNodes);
        if (serversWithProblems.size() > 0) {
            this._result.setWarningDetected(true);
            this._result.setRepairNeeded(true);
            this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.ErrorsFound.fmt.txt", (java.lang.Object)serversWithProblems.size()));
            for (HostPortPair pair : serversWithProblems) {
                String host = pair.getHost();
                int port = pair.getPort();
                String serverName = host + ":" + port;
                this._log.warn("     " + Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.ErrorNodes.fmt.txt", (java.lang.Object)serverName, (java.lang.Object)reposName));
            }
            if (repair) {
                this._log.warn(RB.getStringResource("SynchCheck.tool.AlertWarning1.txt"));
                this._log.warn(RB.getStringResource("SynchCheck.tool.AlertWarning2.txt"));
                this._log.warn(RB.getStringResource("SynchCheck.tool.AlertWarning3.txt"));
                this._log.warn(RB.getStringResource("SynchCheck.tool.AlertWarning4.txt"));
            }
        } else {
            this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.NoErrors.txt", (java.lang.Object)reposName));
        }
    }

    private HostPortSet synchCheck(String reposName, String repair, HostPortSet activeNodes) throws RemoteException, ServiceException {
        Date timeSynchCheckStarted;
        HostPortSet serversWithProblems;
        block31: {
            String synchCheckResultsRequest = "<SynchCheck>   <Results ReposName=\"" + reposName + "\" /></SynchCheck><OMA JOURNALENTRYNUMBER=\"\"/><OMA JOURNALENTRYGUID=\"\"/><Scheduler Ping=\"\">   <AlertConditions/></Scheduler>";
            String synchCheckString = "<SynchCheck SampleStart=\"01Jan1960:00:00:00\" SendAlerts=\"" + repair + "\" ReposName=\"" + reposName + "\" />";
            String domain = this.server.getDomain();
            String strUser = null;
            String strPassword = null;
            UserIdentityInterface userIdentity = this.server.getUserContext().getIdentityByDomain(domain);
            if (userIdentity != null) {
                strUser = (String)userIdentity.getPrincipal();
                strPassword = (String)userIdentity.getCredential();
            }
            int expectedSynchCheckJournalEntryNumber = 0;
            serversWithProblems = new HostPortSet();
            timeSynchCheckStarted = new Date();
            Iterator it = activeNodes.iterator();
            HostPortPair pair = (HostPortPair)it.next();
            String host = pair.getHost();
            int port = pair.getPort();
            String serverName = host + ":" + port;
            int countErrorsThisNode = 0;
            int countAlertsThisNode = 0;
            ArrayList<String> alertNotifications = new ArrayList<String>();
            int countContainersThisNode = 0;
            int timeTaken = 0;
            int timeOut = 30;
            int currentJournalEntryNumber = 0;
            try {
                this.connectNoredirect(host, port, strUser, strPassword);
                expectedSynchCheckJournalEntryNumber = this.getJournalEntryNumber();
                this.doRefresh(synchCheckString);
                while (it.hasNext()) {
                    pair = (HostPortPair)it.next();
                    host = pair.getHost();
                    port = pair.getPort();
                    serverName = host + ":" + port;
                    this.connectNoredirect(host, port, strUser, strPassword);
                    timeTaken = 0;
                    timeOut = 30;
                    currentJournalEntryNumber = 0;
                    do {
                        countErrorsThisNode = 0;
                        countAlertsThisNode = 0;
                        countContainersThisNode = 0;
                        Document doc = null;
                        Element domElement = null;
                        boolean checkAlerts = false;
                        currentJournalEntryNumber = this.getJournalEntryNumber();
                        if (currentJournalEntryNumber >= expectedSynchCheckJournalEntryNumber) {
                            doc = this.doStatusWithWrapperAndParse(synchCheckResultsRequest, null, true);
                            if (doc == null) {
                                this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.Node.UnabletoGetStatus.Warning.fmt.txt", (java.lang.Object)serverName));
                                this._result.setWarningDetected(true);
                                break;
                            }
                            int countRepositories = 0;
                            domElement = doc.getDocumentElement();
                            NodeList synchNodeList = domElement.getElementsByTagName("SynchCheck");
                            for (int synchIx = 0; synchIx < synchNodeList.getLength(); ++synchIx) {
                                Element synchElement = (Element)synchNodeList.item(synchIx);
                                NodeList resultsElements = synchElement.getElementsByTagName("Results");
                                if (resultsElements.getLength() <= 0) continue;
                                Element resultsElement = (Element)resultsElements.item(0);
                                NodeList repositoryElements = resultsElement.getElementsByTagName("Repository");
                                for (int reposIx = 0; reposIx < repositoryElements.getLength(); ++reposIx) {
                                    ++countRepositories;
                                    Element repositoryElement = (Element)repositoryElements.item(reposIx);
                                    String repositoryName = repositoryElement.getAttribute("Name");
                                    String repositoryStatus = repositoryElement.getAttribute("Status");
                                    if (repositoryStatus != null && !repositoryStatus.equals("OK")) {
                                        String repositoryProblem = repositoryElement.getAttribute("Problem");
                                        if ("ERROR".equals(repositoryStatus)) {
                                            if (repositoryProblem != null) {
                                                this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.Repository.Details.ProblemFound.fmt.txt", (java.lang.Object)repositoryName, (java.lang.Object)repositoryProblem));
                                            } else {
                                                this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.Repository.Generic.ProblemFound.fmt.txt", (java.lang.Object)repositoryName));
                                            }
                                        } else if ("WARNING".equals(repositoryStatus)) {
                                            if (repositoryProblem != null) {
                                                this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.Repository.Details.PossibleProblemFound.fmt.txt", (java.lang.Object)repositoryName, (java.lang.Object)repositoryProblem));
                                            } else {
                                                this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.Repository.Generic.PossibleProblemFound.fmt.txt", (java.lang.Object)repositoryName));
                                            }
                                        }
                                    }
                                    NodeList repositoryNodeList = repositoryElement.getChildNodes();
                                    for (int containerIx = 0; containerIx < repositoryNodeList.getLength(); ++containerIx) {
                                        Node aContainerNode = repositoryNodeList.item(containerIx);
                                        if (aContainerNode.getNodeType() != 1) continue;
                                        Element aContainerElement = (Element)aContainerNode;
                                        ++countContainersThisNode;
                                        String status = aContainerElement.getAttribute("Status");
                                        if (!"ERROR".equals(status)) continue;
                                        String containerName = aContainerElement.getAttribute("Name");
                                        this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.Node.Error.Summary.fmt.txt", (java.lang.Object)serverName, (java.lang.Object)repositoryName, (java.lang.Object)containerName));
                                        ++countErrorsThisNode;
                                        checkAlerts = true;
                                    }
                                }
                            }
                            NodeList omaNodeList = domElement.getElementsByTagName("OMA");
                            for (int omaIx = 0; omaIx < omaNodeList.getLength(); ++omaIx) {
                                Element omaElement = (Element)omaNodeList.item(omaIx);
                                String journalEntryNumberText = omaElement.getAttribute("JOURNALENTRYNUMBER");
                                if (journalEntryNumberText == null || journalEntryNumberText.length() <= 0) continue;
                                currentJournalEntryNumber = Integer.parseInt(journalEntryNumberText);
                            }
                            NodeList schedulerNodeList = domElement.getElementsByTagName("Scheduler");
                            if (checkAlerts) {
                                for (int schedIx = 0; schedIx < schedulerNodeList.getLength(); ++schedIx) {
                                    Element schedulerElement = (Element)schedulerNodeList.item(schedIx);
                                    NodeList alertConditionsElements = schedulerElement.getElementsByTagName("AlertConditions");
                                    if (alertConditionsElements.getLength() <= 0) continue;
                                    Element alertsElement = (Element)alertConditionsElements.item(0);
                                    NodeList alerts = alertsElement.getElementsByTagName("AlertCondition");
                                    for (int i = 0; i < alerts.getLength(); ++i) {
                                        Element alert = (Element)alerts.item(i);
                                        String alertMessage = Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.Node.AlertCondition.Warning.fmt.txt", (java.lang.Object)serverName, (java.lang.Object)alert.getTextContent());
                                        alertNotifications.add(alertMessage);
                                        ++countAlertsThisNode;
                                    }
                                    NodeList expireDates = alertsElement.getElementsByTagName("ExpirationTime");
                                    for (int i = 0; i < expireDates.getLength(); ++i) {
                                        Element expirationDateforNode = (Element)expireDates.item(0);
                                        String expirationDateMessage = Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.Node.AlertCondition.Warning.ExpireDate.fmt.txt", (java.lang.Object)serverName, (java.lang.Object)expirationDateforNode.getTextContent());
                                        alertNotifications.add(expirationDateMessage);
                                    }
                                }
                            }
                            if (countRepositories == 0) {
                                this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.Node.UnabletoSynch.Warning.fmt.txt", (java.lang.Object)serverName));
                                this._result.setWarningDetected(true);
                                break;
                            }
                        }
                        if (currentJournalEntryNumber >= expectedSynchCheckJournalEntryNumber) continue;
                        ++timeTaken;
                        this._log.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.Node.StillRunning.Debug.fmt.txt", (java.lang.Object)serverName, (java.lang.Object)currentJournalEntryNumber, (java.lang.Object)expectedSynchCheckJournalEntryNumber));
                        Thread.sleep(1000L);
                    } while (currentJournalEntryNumber < expectedSynchCheckJournalEntryNumber && timeTaken < timeOut);
                    if (timeTaken >= timeOut) {
                        this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.Node.SynchTimeout.Error.fmt.txt", (java.lang.Object)serverName, (java.lang.Object)timeOut, (java.lang.Object)currentJournalEntryNumber, (java.lang.Object)expectedSynchCheckJournalEntryNumber));
                        this._result.setStatus(Operation.Status.ERROR);
                    }
                    if (countErrorsThisNode > 0) {
                        HostPortPair errorPair = new HostPortPair(pair.getHost(), pair.getPort());
                        serversWithProblems.add((java.lang.Object)errorPair);
                    }
                    if (countAlertsThisNode > 0) {
                        ArrayList filteredAlertsList = new ArrayList(new LinkedHashSet(alertNotifications));
                        for (String alertMsg : filteredAlertsList) {
                            this._log.warn(alertMsg);
                        }
                    }
                    Date timeSynchCheckDoneThisNode = new Date();
                    this._log.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.Node.Debug.Summary.fmt.txt", (java.lang.Object)serverName, (java.lang.Object)((double)(timeSynchCheckDoneThisNode.getTime() - timeSynchCheckStarted.getTime()) / 1000.0), (java.lang.Object)countErrorsThisNode, (java.lang.Object)countContainersThisNode));
                }
            }
            catch (COMM_FAILURE e) {
                this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.CommunicationsFailure.Exception.fmt.txt", (java.lang.Object)serverName, (java.lang.Object)e.getLocalizedMessage()));
                this._result.setStatus(Operation.Status.ERROR);
            }
            catch (OBJECT_NOT_EXIST e) {
                this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.ObjectNotExist.Exception.fmt.txt", (java.lang.Object)serverName, (java.lang.Object)e.getLocalizedMessage()));
                this._result.setStatus(Operation.Status.ERROR);
            }
            catch (InterruptedException e) {
            }
            catch (ConnectionFactoryException e) {
                this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.Connection.Exception.fmt.txt", (java.lang.Object)e.getMessage()));
                this._result.setStatus(Operation.Status.ERROR);
                if (!this._log.isDebugEnabled()) break block31;
                this._log.debug("Stacktrace:", (Throwable)e);
            }
        }
        Date timeSynchAllDone = new Date();
        this._log.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.Debug.Summary.fmt.txt", (java.lang.Object)((double)(timeSynchAllDone.getTime() - timeSynchCheckStarted.getTime()) / 1000.0)));
        return serversWithProblems;
    }

    private int getJournalEntryNumber() {
        Element domElement;
        NodeList statusNodeList;
        String journalEntryNumberRequest = "<OMA JOURNALENTRYNUMBER=\"\"/>";
        int journalEntryNumber = 0;
        Document doc = this.doStatusWithWrapperAndParse("<OMA JOURNALENTRYNUMBER=\"\"/>", null, true);
        if (doc != null && (statusNodeList = (domElement = doc.getDocumentElement()).getChildNodes()) != null) {
            for (int ix = 0; ix < statusNodeList.getLength(); ++ix) {
                Element statusElement;
                String elementName;
                Node aNode = statusNodeList.item(ix);
                if (aNode.getNodeType() != 1 || !"OMA".equals(elementName = (statusElement = (Element)aNode).getNodeName())) continue;
                String journalEntryNumberText = statusElement.getAttribute("JOURNALENTRYNUMBER");
                if (journalEntryNumberText == null || journalEntryNumberText.length() <= 0) break;
                journalEntryNumber = Integer.parseInt(journalEntryNumberText) + 1;
                break;
            }
        }
        return journalEntryNumber;
    }

    private void connectNoredirect(String host, int port, String user, String password) throws ConnectionFactoryException {
        BridgeServer server = new BridgeServer("0217e202-b560-11db-ad91-001083ff6836", host, port);
        ConnectionFactoryManager cxfManager = new ConnectionFactoryManager();
        ManualConnectionFactoryConfiguration cxfConfig = new ManualConnectionFactoryConfiguration((Server)server, true);
        ConnectionInterface cx = null;
        this.iServer = null;
        ConnectionFactoryInterface cxf = cxfManager.getFactory((ConnectionFactoryConfiguration)cxfConfig);
        cx = cxf.getConnection(user, password);
        if (cx != null) {
            Object obj = cx.getObject();
            this.iServer = IServerHelper.narrow((Object)obj);
        }
    }

    private String doStatusWithWrapper(String request, String options, boolean withWrapper) {
        String output;
        block5: {
            output = null;
            if (options == null) {
                options = "";
            }
            try {
                this._log.trace(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.StatusCall.TraceDetails1.fmt.txt", (java.lang.Object)request.replaceAll("><", ">\n   <")));
                if (options != null && !options.isEmpty()) {
                    this._log.trace(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.StatusCall.TraceDetails2.fmt.txt", (java.lang.Object)options.replaceAll("><", ">\n   <")));
                }
                long startTime = System.currentTimeMillis();
                StringHolder response = new StringHolder();
                this.iServer.Status(request, response, options);
                output = response.value;
                long endTime = System.currentTimeMillis();
                this._log.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.StatusCall.Debug.Timing.fmt.txt", (java.lang.Object)((double)(endTime - startTime) / 1000.0)));
                this._log.trace(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.StatusCall.TraceDetails3.fmt.txt", (java.lang.Object)output.replaceAll("><", ">\n   <")));
                if (withWrapper) {
                    output = "<wrapper>" + output + "</wrapper>";
                }
            }
            catch (GenericError e) {
                this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.StatusCall.Exception.fmt.txt", (java.lang.Object)e.getMessage()));
                this._result.setStatus(Operation.Status.ERROR);
                if (!this._log.isDebugEnabled()) break block5;
                this._log.debug("Stacktrace:", (Throwable)e);
            }
        }
        return output;
    }

    private Document doStatusWithWrapperAndParse(String request, String options, boolean withWrapper) {
        Document doc;
        block3: {
            doc = null;
            try {
                String output = this.doStatusWithWrapper(request, options, withWrapper);
                if (output != null && output.length() > 0) {
                    doc = this._OMIUtil.parseXML(output);
                }
            }
            catch (Exception e) {
                this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.StatusCall.ParseXML.Exception.fmt.txt", (java.lang.Object)e.getMessage()));
                this._result.setStatus(Operation.Status.ERROR);
                if (!this._log.isDebugEnabled()) break block3;
                this._log.debug("Stacktrace:", (Throwable)e);
            }
        }
        return doc;
    }

    private void doRefresh(String options) {
        this._log.trace(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.RefreshCall.TraceDetails.fmt.txt", (java.lang.Object)options.replaceAll("><", ">\n   <")));
        long startTime = System.currentTimeMillis();
        this.metadataServerService.refreshServer(options);
        long endTime = System.currentTimeMillis();
        this._log.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SynchCheck.tool.RefreshCall.Debug.Timing.fmt.txt", (java.lang.Object)((double)(endTime - startTime) / 1000.0)));
    }

    private boolean checkIfCluster() throws MetadataMgmtException {
        if (!this.metadataServerService.isClusterConfigured()) {
            this._log.info(RB.getStringResource("SynchCheck.tool.NonClusterDetected.Info.txt"));
            this._result.setStatus(Operation.Status.SUCCESS);
            return false;
        }
        return true;
    }
}

