/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.analysis;

import com.sas.metadata.remote.FastMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.svcs.metadata.mgmt.impl.analysis.AbstractOrphanObjectTool;
import com.sas.svcs.metadata.mgmt.impl.analysis.AnalysisTool;
import com.sas.svcs.metadata.mgmt.impl.analysis.OrphanObjectComponentInterface;
import com.sas.svcs.metadata.mgmt.impl.analysis.RB;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class OrphanedTextStores
extends AbstractOrphanObjectTool
implements OrphanObjectComponentInterface {
    private static final String NAME = RB.getStringResource("OrphanedTextStores.tool.name.txt");
    private static final String DESCRIPTION = RB.getStringResource("OrphanedTextStores.tool.desc.txt");
    private static final String ID = "OrphTxtStr";
    private String ANALYZE_TEMPLATE = null;
    private boolean _templateSet = false;
    private static final String SELECT = "<XMLSelect search=\"*[@PublicType='' and @ChangeState='']\"/>";
    private static AnalysisTool _factoryInstance;

    public static AnalysisTool getFactory() {
        if (_factoryInstance == null) {
            _factoryInstance = new OrphanedTextStores();
        }
        return _factoryInstance;
    }

    private OrphanedTextStores() {
    }

    private OrphanedTextStores(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
        this.setProcessCount(1000);
    }

    @Override
    public AnalysisTool newInstance(OMIRepositoryInterface repository, Logger log) {
        OrphanedTextStores newObject = new OrphanedTextStores(repository, log);
        return newObject;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getComponentLabel() {
        return RB.getStringResource("OrphanedTextStores.tool.label.txt");
    }

    @Override
    public String getAnalyzeTemplate() {
        return this.ANALYZE_TEMPLATE;
    }

    @Override
    public String getXMLSelectString() {
        return SELECT;
    }

    @Override
    public String getMetadataType() {
        return "TextStore";
    }

    @Override
    public String getRepairTemplate() {
        return null;
    }

    @Override
    public boolean isOrphan(FastMetadata objectMap) throws MdException, RemoteException {
        if (objectMap == null) {
            return false;
        }
        String publicType = objectMap.getAttribute("PublicType");
        if (publicType != null && publicType.length() > 0) {
            return false;
        }
        String changeState = objectMap.getAttribute("ChangeState");
        if (changeState != null && changeState.length() > 0) {
            return false;
        }
        return !this.containsAssociations(objectMap);
    }

    @Override
    public AnalysisTool getParentAnalyzeTool() {
        return this;
    }

    @Override
    public void analysisSetup() {
        super.analysisSetup();
        if (!this._templateSet) {
            Set<String> assocs = this.getAssociationNames();
            if (assocs != null && assocs.size() > 0) {
                StringBuilder sb = new StringBuilder(850);
                sb.append("<Templates><TextStore Name=\"\" PublicType=\"\" ChangeState=\"\">");
                for (String assocName : assocs) {
                    sb.append("<").append(assocName).append("/>");
                }
                sb.append("</TextStore></Templates>");
                this.ANALYZE_TEMPLATE = sb.toString();
            } else {
                this.ANALYZE_TEMPLATE = null;
            }
            this._templateSet = true;
        }
    }

    private Set<String> getAssociationNames() {
        try {
            HashMap attrs = new HashMap();
            HashMap assocs = new HashMap();
            this._factory.getOMIUtil().getTypeProperties("TextStore", attrs, assocs);
            return assocs.keySet();
        }
        catch (Exception e) {
            this._log.debug("Unable to retrieve the list of associations for a TextStore");
            return null;
        }
    }
}

