/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.analysis;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Text;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.svcs.metadata.mgmt.client.Operation;
import com.sas.svcs.metadata.mgmt.impl.analysis.AbstractToolImpl;
import com.sas.svcs.metadata.mgmt.impl.analysis.AnalysisTool;
import com.sas.svcs.metadata.mgmt.impl.analysis.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Logger;

public class OrphanedPropertyTypes
extends AbstractToolImpl {
    private static final String NAME = RB.getStringResource("OrphanedPropertyTypes.tool.name");
    private static final String DESCRIPTION = RB.getStringResource("OrphanedPropertyTypes.tool.desc");
    private static final String ID = "OrphPropTyp";
    private static AnalysisTool _factoryInstance;
    private List<String> _orphansList = null;
    private Map<String, Map<String, String>> _storedConfigMap = null;
    private int _propTypeCount = 0;

    public static AnalysisTool getFactory() {
        if (_factoryInstance == null) {
            _factoryInstance = new OrphanedPropertyTypes();
        }
        return _factoryInstance;
    }

    private OrphanedPropertyTypes() {
    }

    private OrphanedPropertyTypes(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
    }

    @Override
    public AnalysisTool newInstance(OMIRepositoryInterface repository, Logger log) {
        OrphanedPropertyTypes newObject = new OrphanedPropertyTypes(repository, log);
        return newObject;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public void analyzeImpl() {
        this._propTypeCount = 0;
        this._orphansList = null;
        this._storedConfigMap = null;
        try {
            this.createObjectStore();
            String strTemplate = "<TEMPLATES><PropertyType Name=\"\"><Groups/><TypedProperties/><TypedAttProperties/><ElementType/><ArrayTypes/><StoredConfiguration/></PropertyType></TEMPLATES>";
            int flags = 2308;
            List propTypeList = this._OMIUtil.getMetadataObjectsSubset((MdStore)this._store, this._repository.getDefaultRepositoryId(), "PropertyType", flags, strTemplate, false);
            if (propTypeList == null || propTypeList.size() == 0) {
                this._log.info(RB.getStringResource("OrphanedPropertyTypes.Analyze.NotFound.txt"));
                this._result.setStatus(Operation.Status.SUCCESS);
                return;
            }
            int objectCount = propTypeList.size();
            if (this._log.isDebugEnabled()) {
                this._log.debug("Found " + objectCount + " total PropertyType objects.  Searching for orphans.");
            }
            for (int i = 0; i < objectCount; ++i) {
                Text storedConfigObj;
                AssociationList storedConfigList;
                PropertyType pType = (PropertyType)propTypeList.get(i);
                AssociationList groupsAssocList = pType.getGroups(false);
                AssociationList typedPropAssocList = pType.getTypedProperties(false);
                AssociationList typedAttPropAssocList = pType.getTypedAttProperties(false);
                AssociationList arrayTypeAssocList = pType.getArrayTypes(false);
                AssociationList elementTypeAssocList = pType.getElementTypes(false);
                if (groupsAssocList != null && groupsAssocList.size() != 0 || typedPropAssocList != null && typedPropAssocList.size() != 0 || typedAttPropAssocList != null && typedAttPropAssocList.size() != 0 || arrayTypeAssocList != null && arrayTypeAssocList.size() != 0 || elementTypeAssocList != null && elementTypeAssocList.size() != 0) continue;
                ++this._propTypeCount;
                if (this._orphansList == null) {
                    this._orphansList = new ArrayList<String>();
                }
                this._orphansList.add(pType.getFQID());
                if (this._propTypeCount <= 100 && this._log.isDebugEnabled()) {
                    this._log.debug("Found orphaned PropertyType: " + pType.getName() + " (" + pType.getId() + ")");
                }
                if ((storedConfigList = pType.getStoredConfigurations(false)) == null || storedConfigList.size() <= 0 || (storedConfigObj = (Text)storedConfigList.get(0)) == null) continue;
                if (this._storedConfigMap == null) {
                    this._storedConfigMap = new HashMap<String, Map<String, String>>();
                }
                HashMap<String, String> subMap = new HashMap<String, String>();
                subMap.put(storedConfigObj.getFQID(), storedConfigObj.getCMetadataType());
                this._storedConfigMap.put(pType.getFQID(), subMap);
            }
            if (this._orphansList == null) {
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"OrphanedPropertyTypes.Analyze.NoOrphans.txt", (Object)this._repository.getDefaultRepositoryName()));
            } else {
                Integer total = new Integer(this._propTypeCount);
                this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"OrphanedPropertyTypes.Analyze.OrphansFound.txt", (Object)total, (Object)this._repository.getDefaultRepositoryName()));
                this._result.setWarningDetected(true);
                this._result.setRepairNeeded(true);
            }
            this._result.setStatus(Operation.Status.SUCCESS);
        }
        catch (MdException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.releaseObjectStore();
        }
    }

    @Override
    public void repairImpl() {
        int deletedCount = 0;
        int deletedConfigCount = 0;
        try {
            for (String orphanID : this._orphansList) {
                List deletedConfigList;
                Map<String, String> subMap;
                List deletedList = this._OMIUtil.deleteMetadataObject("PropertyType", orphanID);
                if (deletedList == null || deletedList.size() <= 0) continue;
                ++deletedCount;
                if (this._storedConfigMap == null || (subMap = this._storedConfigMap.get(orphanID)) == null || (deletedConfigList = this._OMIUtil.deleteMetadataObjects(subMap)) == null || deletedConfigList.size() <= 0) continue;
                ++deletedConfigCount;
            }
            Integer deleted = new Integer(deletedCount);
            Integer total = new Integer(this._orphansList.size());
            this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"OrphanedPropertyTypes.Repair.Results.txt", (Object)deleted, (Object)total));
            if (deletedConfigCount > 0) {
                Integer deletedConfigs = new Integer(deletedConfigCount);
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"OrphanedPropertyTypes.Repair.Results2.txt", (Object)deletedConfigs));
            }
            if (this._orphansList != null) {
                this._orphansList.clear();
                this._orphansList = null;
            }
            if (this._storedConfigMap != null) {
                this._storedConfigMap.clear();
                this._storedConfigMap = null;
            }
            this._result.setStatus(Operation.Status.SUCCESS);
        }
        catch (MdException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }
}

