/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.analysis;

import com.sas.metadata.remote.FastMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.svcs.metadata.mgmt.impl.analysis.AbstractPropertyObjectComponent;
import com.sas.svcs.metadata.mgmt.impl.analysis.AnalysisTool;
import com.sas.svcs.metadata.mgmt.impl.analysis.RB;
import java.rmi.RemoteException;
import java.util.List;

public class OrphanedPropertyComponent
extends AbstractPropertyObjectComponent {
    private static final String ANALYZE_TEMPLATE = "<TEMPLATES><Property Name=\"\"><Customizers/><Editors/><Validators/><Implementors/><AssociatedLocalizedObject/><AssociatedObject/><AssociatedPropertySet/><AssociatedPropertyGroup/><StoredConfiguration/></Property></TEMPLATES>";

    public OrphanedPropertyComponent(AnalysisTool parentAnalyzeTool) {
        super(parentAnalyzeTool);
    }

    @Override
    public String getComponentLabel() {
        return RB.getStringResource("OrphanedPropertyComponent.tool.label.txt");
    }

    @Override
    public String getAnalyzeTemplate() {
        return ANALYZE_TEMPLATE;
    }

    @Override
    public String getMetadataType() {
        return "Property";
    }

    @Override
    public boolean isOrphan(FastMetadata objectMap) throws MdException, RemoteException {
        if (objectMap == null) {
            return false;
        }
        if (this.containsCommonAssociations(objectMap)) {
            return false;
        }
        List propSetsList = objectMap.getAssociation("AssociatedPropertySet");
        if (propSetsList != null && propSetsList.size() > 0) {
            return false;
        }
        List assocObjectsList = objectMap.getAssociation("AssociatedObject");
        if (assocObjectsList != null && assocObjectsList.size() > 0) {
            return false;
        }
        List propGroupsList = objectMap.getAssociation("AssociatedPropertyGroup");
        if (propGroupsList != null && propGroupsList.size() > 0) {
            return false;
        }
        List localizedObjectsList = objectMap.getAssociation("AssociatedLocalizedObject");
        return localizedObjectsList == null || localizedObjectsList.size() <= 0;
    }
}

