/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.analysis;

import com.sas.framework.annotation.services.Publishable;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.svcs.metadata.mgmt.client.AnalysisResult;
import com.sas.svcs.metadata.mgmt.client.AnalysisToolDescriptor;
import com.sas.svcs.metadata.mgmt.client.AnalysisToolGroup;
import com.sas.svcs.metadata.mgmt.client.BackupOptions;
import com.sas.svcs.metadata.mgmt.client.MetadataAnalysisService;
import com.sas.svcs.metadata.mgmt.client.MetadataBackupService;
import com.sas.svcs.metadata.mgmt.client.MetadataRepositoryService;
import com.sas.svcs.metadata.mgmt.client.MetadataServerService;
import com.sas.svcs.metadata.mgmt.client.Repository;
import com.sas.svcs.metadata.mgmt.client.ServerState;
import com.sas.svcs.metadata.mgmt.impl.AbstractMetadataManagementServiceImpl;
import com.sas.svcs.metadata.mgmt.impl.RequestContext;
import com.sas.svcs.metadata.mgmt.impl.analysis.AnalysisTool;
import com.sas.svcs.metadata.mgmt.impl.analysis.FolderStructure;
import com.sas.svcs.metadata.mgmt.impl.analysis.OrphanedAces;
import com.sas.svcs.metadata.mgmt.impl.analysis.OrphanedDirectories;
import com.sas.svcs.metadata.mgmt.impl.analysis.OrphanedJobMetadata;
import com.sas.svcs.metadata.mgmt.impl.analysis.OrphanedProperties;
import com.sas.svcs.metadata.mgmt.impl.analysis.OrphanedTextStores;
import com.sas.svcs.metadata.mgmt.impl.analysis.RB;
import com.sas.svcs.metadata.mgmt.impl.analysis.SynchCheck;
import com.sas.svcs.metadata.mgmt.impl.analysis.VerifyAssociations;
import com.sas.svcs.metadata.mgmt.impl.analysis.VerifyAuthenticationDomains;
import com.sas.svcs.metadata.mgmt.impl.analysis.VerifyMetadataFiles;
import com.sas.svcs.metadata.mgmt.impl.analysis.VerifyPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="MetadataAnalysisService")
@Publishable
public class MetadataAnalysisServiceImpl
extends AbstractMetadataManagementServiceImpl
implements MetadataAnalysisService {
    private static Map<String, AnalysisTool> tools;
    private static List<AnalysisToolGroup> toolGroups;
    private Logger logger = LogManager.getLogger(MetadataAnalysisService.class);
    private MetadataServerService metadataServerService;
    private MetadataBackupService metadataBackupService;
    private MetadataRepositoryService metadataRepositoryService;

    MetadataAnalysisServiceImpl() {
        if (tools == null) {
            MetadataAnalysisServiceImpl.initializeClass();
        }
    }

    private static void initializeClass() {
        tools = new HashMap<String, AnalysisTool>();
        toolGroups = new ArrayList<AnalysisToolGroup>();
        AnalysisToolGroup group = new AnalysisToolGroup();
        group.setName(RB.getStringResource("MetadataAnalysisServiceImpl.Physical.group.name.txt"));
        group.setId("Physical");
        group.setDescription(RB.getStringResource("MetadataAnalysisServiceImpl.Physical.group.desc.txt"));
        group.setMembers(Arrays.asList(MetadataAnalysisServiceImpl.newTool(VerifyMetadataFiles.getFactory()), MetadataAnalysisServiceImpl.newTool(VerifyAssociations.getFactory()), MetadataAnalysisServiceImpl.newTool(SynchCheck.getFactory())));
        toolGroups.add(group);
        group = new AnalysisToolGroup();
        group.setName(RB.getStringResource("MetadataAnalysisServiceImpl.Security.group.name.txt"));
        group.setId("Security");
        group.setDescription(RB.getStringResource("MetadataAnalysisServiceImpl.Security.group.desc.txt"));
        group.setMembers(Arrays.asList(MetadataAnalysisServiceImpl.newTool(VerifyPermissions.getFactory()), MetadataAnalysisServiceImpl.newTool(VerifyAuthenticationDomains.getFactory())));
        toolGroups.add(group);
        group = new AnalysisToolGroup();
        group.setName(RB.getStringResource("MetadataAnalysisServiceImpl.Usage.group.name.txt"));
        group.setId("Usage");
        group.setDescription(RB.getStringResource("MetadataAnalysisServiceImpl.Usage.group.desc.txt"));
        group.setMembers(Arrays.asList(MetadataAnalysisServiceImpl.newTool(OrphanedAces.getFactory()), MetadataAnalysisServiceImpl.newTool(OrphanedDirectories.getFactory()), MetadataAnalysisServiceImpl.newTool(OrphanedJobMetadata.getFactory()), MetadataAnalysisServiceImpl.newTool(OrphanedProperties.getFactory()), MetadataAnalysisServiceImpl.newTool(OrphanedTextStores.getFactory()), MetadataAnalysisServiceImpl.newTool(FolderStructure.getFactory())));
        toolGroups.add(group);
    }

    private static AnalysisToolDescriptor newTool(AnalysisTool tool) {
        tools.put(tool.getId().toLowerCase(), tool);
        return tool.getAnalysisToolDescriptor();
    }

    @Autowired
    public void setMetadataServerService(MetadataServerService metadataServerService) {
        this.metadataServerService = metadataServerService;
    }

    @Autowired
    public void setMetadataBackupService(MetadataBackupService metadataBackupService) {
        this.metadataBackupService = metadataBackupService;
    }

    @Autowired
    public void setMetadataRepositoryService(MetadataRepositoryService metadataRepositoryService) {
        this.metadataRepositoryService = metadataRepositoryService;
    }

    public AnalysisToolDescriptor getAnalysisTool(String toolId) {
        AnalysisTool tool = tools.get(toolId.toLowerCase());
        if (tool == null) {
            return null;
        }
        return tool.getAnalysisToolDescriptor();
    }

    public AnalysisToolGroup getAnalysisToolGroup(String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException();
        }
        for (AnalysisToolGroup group : toolGroups) {
            if (!groupId.equalsIgnoreCase(group.getId())) continue;
            return group;
        }
        return null;
    }

    public List<AnalysisToolGroup> getAnalysisToolGroups() {
        return Collections.unmodifiableList(toolGroups);
    }

    public List<AnalysisToolDescriptor> getAnalysisTools() {
        ArrayList<AnalysisToolDescriptor> allTools = new ArrayList<AnalysisToolDescriptor>(tools.size());
        for (AnalysisToolGroup toolGroup : toolGroups) {
            allTools.addAll(toolGroup.getMembers());
        }
        return allTools;
    }

    public AnalysisResult analyze(Repository repository, String toolId) {
        RequestContext ctx = this.getRequestContext();
        AnalysisTool tool = tools.get(toolId.toLowerCase());
        if (tool == null) {
            throw new IllegalArgumentException("No such tool");
        }
        OMIRepositoryInterface omiRepository = ctx.getRepository(repository.getName());
        if (omiRepository == null) {
            throw new IllegalArgumentException("No such repository");
        }
        AnalysisTool toolInstance = tool.newInstance(omiRepository, this.logger);
        if (tool instanceof SynchCheck) {
            ((SynchCheck)toolInstance).setMetadataServerService(this.metadataServerService);
        }
        return toolInstance.analyze();
    }

    public AnalysisResult repair(Repository repository, String toolId) {
        RequestContext ctx = this.getRequestContext();
        AnalysisTool tool = tools.get(toolId.toLowerCase());
        if (tool == null) {
            throw new IllegalArgumentException("No such tool");
        }
        OMIRepositoryInterface omiRepository = ctx.getRepository(repository.getName());
        if (omiRepository == null) {
            throw new IllegalArgumentException("No such repository");
        }
        AnalysisTool toolInstance = tool.newInstance(omiRepository, this.logger);
        if (tool instanceof SynchCheck) {
            ((SynchCheck)toolInstance).setMetadataServerService(this.metadataServerService);
        }
        return toolInstance.repair();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AnalysisResult> analyze() {
        RequestContext ctx = this.getRequestContext();
        ArrayList<AnalysisResult> results = new ArrayList<AnalysisResult>(tools.size());
        ServerState originalState = this.metadataServerService.getServerState();
        boolean serverPaused = false;
        switch (originalState.getAccess()) {
            case NOQUOROM: 
            case STARTING: {
                throw new IllegalStateException("Server cannot perform analysis");
            }
            case ADMIN: 
            case READONLY: 
            case ADMIN_RO: {
                break;
            }
            default: {
                this.metadataServerService.pauseAdmin(RB.getStringResource("MetadataAnalysisServiceImpl.PauseForAnalysis.Comment.txt"));
                this.logger.info(RB.getStringResource("MetadataAnalysisServiceImpl.PauseForAnalysis.Log.txt"));
                serverPaused = true;
            }
        }
        try {
            List repositories = this.metadataRepositoryService.getRepositories();
            boolean backupPerformed = false;
            for (Repository repository : repositories) {
                Repository.Access access = repository.getEffectiveAccess();
                if (access == Repository.Access.OFFLINE) continue;
                OMIRepositoryInterface repository2 = ctx.getRepository(repository.getName());
                for (AnalysisToolDescriptor toolDescriptor : this.getAnalysisTools()) {
                    AnalysisTool tool = tools.get(toolDescriptor.getId().toLowerCase()).newInstance(repository2, this.logger);
                    if (tool instanceof SynchCheck) {
                        ((SynchCheck)tool).setMetadataServerService(this.metadataServerService);
                    }
                    AnalysisResult result = tool.analyze();
                    results.add(result);
                }
            }
        }
        finally {
            if (serverPaused) {
                this.metadataServerService.setServerState(originalState);
                this.logger.info(RB.getStringResource("MetadataAnalysisServiceImpl.ResumeAfterAnalysis.Log.txt"));
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AnalysisResult> repair() {
        RequestContext ctx = this.getRequestContext();
        ArrayList<AnalysisResult> results = new ArrayList<AnalysisResult>(tools.size());
        ServerState originalState = this.metadataServerService.getServerState();
        boolean serverPaused = false;
        switch (originalState.getAccess()) {
            case NOQUOROM: 
            case STARTING: 
            case RECOVERY: {
                throw new IllegalStateException("Server cannot perform analysis");
            }
            case ADMIN: {
                break;
            }
            case READONLY: 
            case ADMIN_RO: {
                throw new IllegalStateException("Server cannot perform repairs while in READONLY state");
            }
            default: {
                this.metadataServerService.pauseAdmin(RB.getStringResource("MetadataAnalysisServiceImpl.PauseForAnalysis.Comment.txt"));
                this.logger.info(RB.getStringResource("MetadataAnalysisServiceImpl.PauseForAnalysis.Log.txt"));
                serverPaused = true;
            }
        }
        try {
            List repositories = this.metadataRepositoryService.getRepositories();
            boolean backupPerformed = false;
            for (Repository repository : repositories) {
                Repository.Access access = repository.getEffectiveAccess();
                if (access == Repository.Access.OFFLINE) continue;
                OMIRepositoryInterface repository2 = ctx.getRepository(repository.getName());
                for (AnalysisToolDescriptor toolDescriptor : this.getAnalysisTools()) {
                    AnalysisResult result;
                    AnalysisTool tool = tools.get(toolDescriptor.getId().toLowerCase()).newInstance(repository2, this.logger);
                    if (tool instanceof SynchCheck) {
                        ((SynchCheck)tool).setMetadataServerService(this.metadataServerService);
                    }
                    if ((result = tool.analyze()).isRepairNeeded() && access != Repository.Access.READONLY && access != Repository.Access.ADMIN_RO) {
                        if (!backupPerformed) {
                            this.logger.info(RB.getStringResource("MetadataAnalysisServiceImpl.BackupForAnalysis.Log.txt"));
                            BackupOptions backupOptions = new BackupOptions();
                            backupOptions.setComment(RB.getStringResource("MetadataAnalysisServiceImpl.BackupForAnalysis.Comment.txt"));
                            backupOptions.setReorganizeRepositories(false);
                            this.metadataBackupService.backup(backupOptions);
                            backupPerformed = true;
                        }
                        result = tool.repair();
                    }
                    results.add(result);
                }
            }
        }
        finally {
            if (serverPaused) {
                this.metadataServerService.setServerState(originalState);
                this.logger.info(RB.getStringResource("MetadataAnalysisServiceImpl.ResumeAfterAnalysis.Log.txt"));
            }
        }
        return results;
    }
}

