/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.analysis;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.FastMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderAdminInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.util.Names;
import com.sas.svcs.metadata.mgmt.client.Operation;
import com.sas.svcs.metadata.mgmt.impl.analysis.AbstractToolImpl;
import com.sas.svcs.metadata.mgmt.impl.analysis.AnalysisTool;
import com.sas.svcs.metadata.mgmt.impl.analysis.FolderStructureUtil;
import com.sas.svcs.metadata.mgmt.impl.analysis.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Logger;

public class FolderStructure
extends AbstractToolImpl {
    private static final String NAME = RB.getStringResource("FolderStructure.tool.name.txt");
    private static final String DESCRIPTION = RB.getStringResource("FolderStructure.tool.desc.txt");
    private static final String ID = "FoldStruct";
    private static final int OBJECT_DUPLICATE = 1;
    private static final int OBJECT_INVALID_NAME = 2;
    private static final int OBJECT_MISSING_NAME = 4;
    private static final int OBJECT_MISSING_PUBLICTYPE = 8;
    private static final int OBJECT_INVALID_REPOS = 16;
    private static final int OBJECT_MULTIPLE_PARENTS = 32;
    private static final int OBJECT_INVALID_PARENT = 64;
    private static final int OBJECT_ORPHAN_FOLDER = 128;
    private static final int SYSTEM_MISSING_ROOT = 1;
    private static final int SYSTEM_MULTIPLE_ROOTS = 2;
    private static final int SYSTEM_INVALID_ROOT_PUBLICTYPE = 4;
    private static final int SYSTEM_CUSTOM_MISSING_TOPLEVEL = 8;
    private static final int SYSTEM_CUSTOM_MULTIPLE_TOPLEVEL = 16;
    private static final String FOLDER_TEMPLATE = "<Templates><Tree><ParentTree/><SoftwareComponents/></Tree></Templates>";
    private static final char PATH_SEPARATOR = '/';
    private static AnalysisTool _factoryInstance;
    private ServerInterface _server;
    private Map<String, TreeNode> _objectNodeCache = new HashMap<String, TreeNode>(100);
    private List<TreeNode> _objectRepairList = new ArrayList<TreeNode>();
    private TreeNode _rootNode;
    private String _shortReposID = "";
    private int _systemRepairType = 0;
    private int _errorCount = 0;
    private int _warningCount = 0;
    private int _objectRepairFailedCount = 0;

    public static AnalysisTool getFactory() {
        if (_factoryInstance == null) {
            _factoryInstance = new FolderStructure();
        }
        return _factoryInstance;
    }

    private FolderStructure() {
    }

    private FolderStructure(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
    }

    @Override
    public AnalysisTool newInstance(OMIRepositoryInterface repository, Logger log) {
        FolderStructure newObject = new FolderStructure(repository, log);
        return newObject;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    private String getShortRepositoryID(String objectID) {
        return objectID == null ? null : objectID.substring(0, 8);
    }

    private String getRepositoryID(String objectID) {
        return objectID == null ? null : "A0000001." + objectID.substring(0, 8);
    }

    private void logInfo(String message) {
        this._log.info(message);
    }

    private void logWarning(String message) {
        ++this._warningCount;
        this._result.setWarningDetected(true);
        this._log.warn(message);
    }

    private void logError(String message) {
        ++this._errorCount;
        this._result.setStatus(Operation.Status.ERROR);
        this._log.error(message);
    }

    private void incrementObjectRepairFailedCount() {
        ++this._objectRepairFailedCount;
    }

    private int getObjectRepairFailedCount() {
        return this._objectRepairFailedCount;
    }

    private void setSystemRepairType(int type) {
        this._systemRepairType |= type;
    }

    private void setObjectToRepair(TreeNode node) {
        this._objectRepairList.add(node);
    }

    private boolean isRepairNeeded(int repairType, int flag) {
        return (repairType & flag) > 0;
    }

    @Override
    public void analyzeImpl() {
        try {
            this._warningCount = 0;
            this._errorCount = 0;
            this._server = this._repository.getServer();
            String reposType = this._repository.getRepositoryType();
            if (!("FOUNDATION".equalsIgnoreCase(reposType) || "CUSTOM".equalsIgnoreCase(reposType) || "PROJECT".equalsIgnoreCase(reposType))) {
                this.logError(RB.getStringResource("FolderStructure.InvalidReposType.txt"));
                return;
            }
            String reposID = this._repository.getDefaultRepositoryId();
            if (reposID == null) {
                this.logError(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.InvalidReposID.fmt.txt", (Object)this._repository.getDefaultRepositoryName()));
                this.fail();
                return;
            }
            this._shortReposID = reposID.substring(9);
            this.createObjectStore();
            this.validateFolderStructure();
            if (this._warningCount > 0 || this._errorCount > 0) {
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Analyze.FoundErrors.fmt.txt", (Object)new Integer(this._warningCount), (Object)new Integer(this._errorCount)));
            }
        }
        catch (MdException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.releaseObjectStore();
            if (this._objectRepairList.size() > 0 || this._systemRepairType > 0) {
                this._result.setRepairNeeded(true);
            }
        }
        this._result.setStatus(Operation.Status.SUCCESS);
    }

    private void validateFolderStructure() throws ServiceException, MdException, RemoteException {
        SoftwareComponent sc = this.validateRootFolderSettings();
        if (sc != null) {
            this.validateFolders(sc);
        }
    }

    private SoftwareComponent validateRootFolderSettings() throws MdException, RemoteException {
        List<SoftwareComponent> rootFolders = FolderStructureUtil.getRootFolders(this._repository.getDefaultRepositoryId(), this._factory, this._store);
        String reposType = this._repository.getRepositoryType();
        if ("FOUNDATION".equalsIgnoreCase(reposType) || "CUSTOM".equalsIgnoreCase(reposType)) {
            if (rootFolders == null || rootFolders.size() == 0) {
                this.logError("FolderStructure.Analyze.SoftwareComponentNotFound.txt");
            } else if (rootFolders.size() > 1) {
                this.logError(RB.getStringResource("FolderStructure.Analyze.MultipleSoftwareComponents.txt"));
            } else {
                SoftwareComponent bipService = rootFolders.get(0);
                if (!"RootFolder".equalsIgnoreCase(bipService.getPublicType())) {
                    this.setSystemRepairType(4);
                    if ("CUSTOM".equalsIgnoreCase(reposType)) {
                        this.logWarning(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Analyze.CustomInvalidRootType.fmt.txt", (Object)this._repository.getDefaultRepositoryName()));
                    } else {
                        this.logWarning(RB.getStringResource("FolderStructure.Analyze.InvalidRootType.txt"));
                    }
                }
                return bipService;
            }
        }
        return null;
    }

    private void validateFolders(SoftwareComponent bipService) throws ServiceException, MdException, RemoteException {
        int size;
        this._rootNode = new TreeNode(bipService.getName(), "RootFolder", "SoftwareComponent", bipService.getId());
        String reposType = this._repository.getRepositoryType();
        FastMetadata topLevelFoldersMap = FolderStructureUtil.getTopLevelFolders(this._factory, bipService.getId());
        List topLevelFolders = topLevelFoldersMap.getAssociation("SoftwareTrees");
        int n = size = topLevelFolders == null ? 0 : topLevelFolders.size();
        if (size == 0) {
            if ("FOUNDATION".equalsIgnoreCase(reposType)) {
                this.logWarning(RB.getStringResource("FolderStructure.Analyze.NoTopLevelFolders.txt"));
            } else if ("CUSTOM".equalsIgnoreCase(reposType)) {
                this.setSystemRepairType(8);
                this.logWarning(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Analyze.Custom.NoTopLevelFolders.fmt.txt", (Object)this._repository.getDefaultRepositoryName()));
            }
        } else {
            if ("CUSTOM".equalsIgnoreCase(reposType) && size > 1) {
                this.logError(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Analyze.Custom.MultipleTopLevelFolders.fmt.txt", (Object)this._repository.getDefaultRepositoryName()));
                return;
            }
            for (FastMetadata topLevelFolder : topLevelFolders) {
                String folderID = (String)topLevelFolder.get((Object)"Id");
                if (!this._shortReposID.equalsIgnoreCase(this.getShortRepositoryID(folderID))) continue;
                FastMetadata folderMap = FolderStructureUtil.getFolderContents(this._factory, folderID);
                this.validateFolder(this._rootNode, folderMap);
            }
            this.checkForInvalidFolders(this._rootNode);
            this.logInfo(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Analyze.NumObjects.fmt.txt", (Object)new Integer(this._objectNodeCache.size())));
        }
    }

    private void validateFolder(TreeNode parentNode, FastMetadata folderMap) throws ServiceException, RemoteException {
        List members;
        TreeNode folderNode = this.validateFolderMember(parentNode, folderMap);
        if (folderNode == null) {
            return;
        }
        String folderID = folderNode.getObjectID();
        List subtrees = folderMap.getAssociation("SubTrees");
        if (subtrees != null) {
            for (FastMetadata subtree : subtrees) {
                String subFolderID = (String)subtree.get((Object)"Id");
                if (folderID.equalsIgnoreCase(subFolderID)) continue;
                this.validateFolder(folderNode, subtree);
            }
            subtrees.clear();
        }
        if ((members = folderMap.getAssociation("Members")) != null) {
            for (FastMetadata member : members) {
                this.validateFolderMember(folderNode, member);
            }
            members.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeNode validateFolderMember(TreeNode parentNode, FastMetadata memberMap) throws ServiceException, RemoteException {
        String id = (String)memberMap.get((Object)"Id");
        String metadataType = (String)memberMap.get((Object)"MetadataObjectType");
        if (id == null || metadataType == null || parentNode == null) {
            return null;
        }
        if (this._objectNodeCache.containsKey(id)) {
            TreeNode node = this._objectNodeCache.get(id);
            if (node.getObjectCount() == 1) {
                node.setRepairType(32);
                this.setObjectToRepair(node);
                TypeDescriptorInterface type = this._server.getTypeDescriptor(node.getType());
                StringBuilder sb = new StringBuilder();
                try {
                    for (String path : this.getObjectPaths(metadataType, id)) {
                        sb.append("\r\n\t");
                        sb.append("\"").append(path).append("\"");
                    }
                }
                catch (Exception e) {
                    sb.append("Unknown");
                }
                this.logWarning(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Analyze.MultipleParentFolders.fmt.txt", (Object)type.getLabel(), (Object)node.getName(), (Object)sb.toString()));
            }
            node.incrementCount();
            return null;
        }
        String publicType = (String)memberMap.get((Object)"PublicType");
        String name = (String)memberMap.get((Object)"Name");
        String displayPath = this.getDisplayPathForNode(parentNode, name);
        TreeNode node = new TreeNode(name, publicType, metadataType, id);
        this._objectNodeCache.put(id, node);
        try {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Analyzing \"" + displayPath + "\"");
            }
            if (publicType == null || publicType.length() == 0) {
                node.setRepairType(8);
                this.logWarning(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Analyze.MissingPublicType.fmt.txt", (Object)displayPath, (Object)metadataType));
                TreeNode path = node;
                return path;
            }
            TypeDescriptorInterface type = this._server.getTypeDescriptor(publicType);
            String typeLabel = type == null ? publicType : type.getLabel();
            if (name == null || name.length() == 0) {
                node.setRepairType(4);
                this.logWarning(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Analyze.MissingName.fmt.txt", (Object)typeLabel, (Object)parentNode.getDisplayPath()));
                TreeNode treeNode = node;
                return treeNode;
            }
            if (!Names.validateOMRObjectName((String)name, (boolean)false)) {
                node.setRepairType(2);
                this.logWarning(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Analyze.InvalidName.fmt.txt", (Object)typeLabel, (Object)displayPath));
                TreeNode treeNode = node;
                return treeNode;
            }
            boolean isUnique = this.isUnique(parentNode, name, publicType);
            if (isUnique) {
                parentNode.addChild(node);
            } else {
                node.setRepairType(1);
                this.logWarning(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Analyze.DuplicateObject.fmt.txt", (Object)typeLabel, (Object)name, (Object)parentNode.getDisplayPath()));
            }
            if (!this._shortReposID.equalsIgnoreCase(this.getShortRepositoryID(id))) {
                if (this.isRepairNeeded(parentNode.getRepairType(), 16)) {
                    if (this._log.isDebugEnabled()) {
                        this._log.debug("Found object contained in wrong repository: " + node.getDisplayPath());
                    }
                } else {
                    node.setRepairType(16);
                    this.logWarning(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Analyze.IncorrectRepository.fmt.txt", (Object)typeLabel, (Object)displayPath));
                }
            }
            if (node.isFolder() && id.equals(parentNode.getObjectID())) {
                node.setRepairType(64);
                this.logWarning(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Analyze.InvalidParent.fmt.txt", (Object)displayPath));
            }
            TreeNode treeNode = node;
            return treeNode;
        }
        finally {
            if (node.isRepairNeeded()) {
                this.setObjectToRepair(node);
            }
        }
    }

    private void checkForInvalidFolders(TreeNode root) throws MdException, RemoteException {
        List<FastMetadata> folders;
        if (this._log.isDebugEnabled()) {
            this._log.debug("Scanning for invalid folder associations");
        }
        if ((folders = FolderStructureUtil.getAllFolders(this._factory, this._repository.getDefaultRepositoryId())) != null) {
            for (FastMetadata folderMap : folders) {
                String id = (String)folderMap.get((Object)"Id");
                if (id == null || this._objectNodeCache.containsKey(id)) continue;
                FastMetadata folder = FolderStructureUtil.getFolderDetails(this._factory, id);
                List parents = folder.getAssociation("ParentTree");
                if (parents != null && parents.size() > 0) {
                    String parentID = (String)((FastMetadata)parents.get(0)).get((Object)"Id");
                    if (!id.equalsIgnoreCase(parentID)) continue;
                    String name = (String)folder.get((Object)"Name");
                    TreeNode node = new TreeNode(name, "Folder", "Tree", id);
                    node.setRepairType(64);
                    this.setObjectToRepair(node);
                    this.logWarning(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Analyze.InvalidParent.fmt.txt", (Object)name));
                    continue;
                }
                parents = folder.getAssociation("SoftwareComponents");
                if (parents != null && parents.size() != 0) continue;
                String name = (String)folder.get((Object)"Name");
                TreeNode node = new TreeNode(name, "Folder", "Tree", id);
                node.setRepairType(128);
                this.setObjectToRepair(node);
                this.logWarning(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Analyze.OrphanFolder.fmt.txt", (Object)name, (Object)id));
            }
        }
    }

    @Override
    public void repairImpl() {
        try {
            this.createObjectStore();
            this._server = this._repository.getServer();
            if (this._systemRepairType > 0) {
                this.repairSystem();
            }
            if (this._objectRepairList != null) {
                for (TreeNode node : this._objectRepairList) {
                    this.repairObject(node);
                }
                if (this.getObjectRepairFailedCount() > 0) {
                    this._result.setWarningDetected(true);
                    this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Repair.FailedCount.fmt.txt", (Object)new Integer(this.getObjectRepairFailedCount())));
                }
            }
            this._result.setStatus(Operation.Status.SUCCESS);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.release();
        }
    }

    private void repairSystem() throws ServiceException, RemoteException {
        try {
            RootFolderInterface root;
            List<SoftwareComponent> rootFolders = FolderStructureUtil.getRootFolders(this._repository.getDefaultRepositoryId(), this._factory, this._store);
            SoftwareComponent rootFolder = null;
            if (rootFolders != null && rootFolders.size() > 0) {
                rootFolder = rootFolders.get(0);
            }
            if (this.isRepairNeeded(this._systemRepairType, 1)) {
                // empty if block
            }
            if (this.isRepairNeeded(this._systemRepairType, 2)) {
                // empty if block
            }
            if (this.isRepairNeeded(this._systemRepairType, 8) && (root = this._server.getRootFolder()) instanceof FolderAdminInterface) {
                this.logInfo(RB.getStringResource("FolderStructure.Repair.MissingCustomFolder.txt"));
                String name = FolderUtil.makeValidFolderName((String)this._repository.getDefaultRepositoryName(), (FolderInterface)root, null);
                FolderInterface folder = ((FolderAdminInterface)root).createTopLevelFolder(this._repository, name);
                if (folder != null) {
                    folder.update();
                    this.logInfo(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Repair.MissingCustomFolder2.fmt.txt", (Object)this.getObjectDisplayPath((MetadataInterface)folder)));
                }
            }
            if (this.isRepairNeeded(this._systemRepairType, 16)) {
                // empty if block
            }
            if (this.isRepairNeeded(this._systemRepairType, 4)) {
                this.logInfo(RB.getStringResource("FolderStructure.Repair.InvalidRootType.txt"));
                FolderStructureUtil.repairInvalidRootFolderType(rootFolder);
            }
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private void repairObject(TreeNode node) throws ServiceException, RemoteException {
        String typeLabel = node.getType();
        int repairType = node.getRepairType();
        try {
            FolderInterface repairFolder;
            FolderInterface parent;
            FolderInterface repairFolder2;
            Tree folder;
            Root root;
            AssociationList parentFolders;
            CMetadata obj;
            String originalName;
            MetadataInterface meta = this.fetchObject(node);
            if (meta == null) {
                return;
            }
            TypeDescriptorInterface type = meta.getTypeDescriptor();
            if (type == null || type.getType() == null || type.getType().length() == 0) {
                this.incrementObjectRepairFailedCount();
                return;
            }
            typeLabel = type.getLabel();
            if (this.isRepairNeeded(repairType, 4)) {
                meta.setName(RB.getStringResource("FolderStructure.Repair.Unnamed.txt"));
                this.makeValidObjectName(meta);
                this.logInfo(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Repair.MissingName.fmt.txt", (Object)typeLabel, (Object)meta.getName()));
            }
            if (this.isRepairNeeded(repairType, 2) && !Names.validateOMRObjectName((String)(originalName = meta.getName()), (boolean)false)) {
                this.makeValidObjectName(meta);
                this.logInfo(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Repair.ObjectRename.fmt.txt", (Object)typeLabel, (Object)originalName, (Object)meta.getPathUrl().getDisplayPath()));
            }
            if (this.isRepairNeeded(repairType, 1)) {
                originalName = meta.getName();
                this.makeValidObjectName(meta);
                this.logInfo(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Repair.DuplicateObject.fmt.txt", (Object)typeLabel, (Object)originalName, (Object)meta.getPathUrl().getDisplayPath()));
            }
            if (this.isRepairNeeded(repairType, 16)) {
                FolderInterface repairFolder3;
                obj = (CMetadata)meta.getRepositoryEntity();
                AssociationList parentFolders2 = null;
                if (meta instanceof FolderInterface) {
                    Tree tree = (Tree)meta.getRepositoryEntity();
                    parentFolders2 = tree.getParentTrees();
                } else {
                    Root root2 = (Root)obj;
                    parentFolders2 = root2.getTrees();
                }
                if (parentFolders2 != null && parentFolders2.size() > 0 && (repairFolder3 = FolderStructureUtil.makeRepairObjectFolder((OMIRepositoryInterface)meta.getRepository())) != null) {
                    parentFolders2.clear();
                    Tree targetFolder = (Tree)repairFolder3.getRepositoryEntity();
                    parentFolders2.add(targetFolder);
                    this.makeValidObjectName(meta);
                    this.logWarning(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Repair.IncorrectRepos.fmt.txt", (Object)typeLabel, (Object)meta.getName(), (Object)this.getObjectDisplayPath((MetadataInterface)repairFolder3)));
                }
            }
            if (this.isRepairNeeded(repairType, 32) && (obj = (CMetadata)meta.getRepositoryEntity()) instanceof Root && (parentFolders = (root = (Root)obj).getTrees()).size() > 1) {
                int count = 0;
                Object[] folders = parentFolders.toArray();
                boolean updated = false;
                for (int index = 0; index < folders.length; ++index) {
                    Tree parent2 = (Tree)folders[index];
                    if (!"Folder".equalsIgnoreCase(parent2.getPublicType()) || ++count <= 1) continue;
                    parentFolders.remove(index);
                    updated = true;
                }
                if (updated) {
                    this.logInfo(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Repair.MultipleParents.fmt.txt", (Object)typeLabel, (Object)meta.getName(), (Object)this.getObjectDisplayPath((MetadataInterface)meta.getParent())));
                }
            }
            if (this.isRepairNeeded(repairType, 64) && node.isFolder() && (obj = (CMetadata)meta.getRepositoryEntity()) instanceof Tree && (parentFolders = (folder = (Tree)obj).getParentTrees()).size() > 0 && (repairFolder2 = FolderStructureUtil.makeRepairObjectFolder((OMIRepositoryInterface)meta.getRepository())) != null) {
                parentFolders.clear();
                meta.update();
                Tree targetFolder = (Tree)repairFolder2.getRepositoryEntity();
                parentFolders.add(targetFolder);
                this.makeValidObjectName(meta);
                this.logWarning(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Repair.InvalidParent.fmt.txt", (Object)typeLabel, (Object)meta.getName(), (Object)this.getObjectDisplayPath((MetadataInterface)repairFolder2)));
            }
            if (this.isRepairNeeded(repairType, 128) && meta instanceof FolderInterface && (parent = meta.getParent()) == null && (repairFolder = FolderStructureUtil.makeRepairObjectFolder((OMIRepositoryInterface)meta.getRepository())) != null) {
                String originalName2 = meta.getName();
                if (repairFolder.hasDuplicateSubfolder(originalName2)) {
                    String newName = FolderUtil.makeValidFolderName((String)originalName2, (FolderInterface)repairFolder, null);
                    Tree tree = (Tree)meta.getRepositoryEntity();
                    tree.setName(newName);
                }
                repairFolder.addChild((PublicObjectInterface)meta);
                this.logWarning(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Repair.OrphanFolder.fmt.txt", (Object)originalName2, (Object)meta.getPathUrl().getDisplayPath()));
            }
            meta.update();
        }
        catch (Exception e) {
            this.incrementObjectRepairFailedCount();
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructure.Repair.ObjectRepairFailed.fmt.txt", (Object)typeLabel, (Object)node.getDisplayPath(), (Object)e.getLocalizedMessage());
            this.logError(msg);
        }
    }

    private void makeValidObjectName(MetadataInterface meta) throws ServiceException, RemoteException {
        String originalName = meta.getName();
        String newName = null;
        newName = meta instanceof FolderInterface ? FolderUtil.makeValidFolderName((String)originalName, (FolderInterface)meta.getParent(), null) : FolderUtil.makeValidObjectName((FolderInterface)meta.getParent(), (MetadataInterface)meta);
        if (!originalName.equalsIgnoreCase(newName)) {
            meta.setName(newName);
        }
    }

    private MetadataInterface fetchObject(TreeNode node) throws ServiceException, RemoteException {
        if (this._repository != null) {
            String id = node.getObjectID();
            Filter filter = new Filter();
            filter.setOMRRepository(this.getRepositoryID(id));
            filter.setType(node.getMetadataType());
            filter.setExplicitSearchString("omi", "<XMLSelect search=\"@Id='" + id + "'\"/>");
            if (node.isFolder()) {
                filter.setOMRTemplate(FOLDER_TEMPLATE);
            } else {
                StringBuilder sb = new StringBuilder(120);
                sb.append("<Templates><");
                sb.append(node.getMetadataType());
                sb.append("><Trees/></");
                sb.append(node.getMetadataType());
                sb.append("><Tree><ParentTree/><SoftwareComponents/></Tree></Templates>");
                filter.setOMRTemplate(sb.toString());
            }
            List items = this._repository.getServer().search((FilterInterface)filter);
            if (items != null && items.size() > 0) {
                return (MetadataInterface)items.get(0);
            }
        }
        return null;
    }

    private boolean isUnique(TreeNode parentNode, String name, String publicType) {
        if (parentNode == null || !parentNode.isFolder()) {
            return true;
        }
        List<TreeNode> children = parentNode.getChildren();
        for (TreeNode child : children) {
            if (!child.getType().equalsIgnoreCase(publicType) || !child.getName().equalsIgnoreCase(name)) continue;
            return false;
        }
        return true;
    }

    private String getObjectDisplayPath(MetadataInterface meta) throws ServiceException, RemoteException {
        PathUrl pathUrl = meta.getPathUrl();
        return pathUrl == null ? meta.getName() : pathUrl.getDisplayPath();
    }

    private String getDisplayPathForNode(TreeNode parentNode, String nodeName) {
        String parentPath = parentNode == null || parentNode.isRoot() ? "" : parentNode.getDisplayPath();
        return parentPath + '/' + nodeName;
    }

    private List<String> getObjectPaths(String metadataType, String id) throws MdException, RemoteException {
        ArrayList<String> assoc = new ArrayList<String>(1);
        assoc.add("Trees");
        Root obj = (Root)this._factory.getOMIUtil().getMetadataAllDepths((MdStore)this._store, metadataType, id, null, assoc, "", 8);
        AssociationList folders = obj.getTrees();
        if (folders.size() > 0) {
            ArrayList<String> paths = new ArrayList<String>();
            for (Tree folder : folders) {
                String folderPath = this._factory.getOMIUtil().getObjectPath(this._store, (PrimaryType)folder, false);
                paths.add(folderPath);
            }
            return paths;
        }
        return null;
    }

    class TreeNode {
        protected TreeNode _parentNode;
        protected String _metadataType;
        protected String _publicType;
        protected String _name;
        protected String _objectID;
        protected List<TreeNode> _children;
        protected int _repairType = 0;
        protected int _objectCount = 1;

        public TreeNode(String name, String publicType, String metadataType, String id) {
            this._name = name;
            this._publicType = publicType;
            this._metadataType = metadataType;
            this._objectID = id;
            if (this.isFolder()) {
                this._children = new ArrayList<TreeNode>();
            }
        }

        public void addChild(TreeNode childNode) {
            if (this.isFolder() && !this._children.contains(childNode)) {
                childNode.setParentNode(this);
                this._children.add(childNode);
            }
        }

        private void setParentNode(TreeNode parentNode) {
            this._parentNode = parentNode;
        }

        public void removeChild(TreeNode childNode) {
            if (this._children != null) {
                Object[] children = this._children.toArray();
                int len = children.length;
                for (int i = 0; i < len; ++i) {
                    TreeNode child = (TreeNode)children[i];
                    if (!child.getObjectID().equals(childNode.getObjectID())) continue;
                    this._children.remove(i);
                    break;
                }
            }
        }

        public void incrementCount() {
            ++this._objectCount;
        }

        public int getObjectCount() {
            return this._objectCount;
        }

        public void setRepairType(int type) {
            this._repairType |= type;
        }

        public int getRepairType() {
            return this._repairType;
        }

        public boolean isRepairNeeded() {
            return this._repairType > 0;
        }

        public int getChildCount() {
            return this._children == null ? 0 : this._children.size();
        }

        public List<TreeNode> getChildren() {
            return this._children;
        }

        public String getName() {
            return this._name;
        }

        public String getObjectID() {
            return this._objectID;
        }

        public TreeNode getParent() {
            return this._parentNode;
        }

        public String getType() {
            return this._publicType;
        }

        public String getMetadataType() {
            return this._metadataType;
        }

        public boolean isFolder() {
            return "Folder".equalsIgnoreCase(this._publicType) || "RootFolder".equalsIgnoreCase(this._publicType);
        }

        public boolean isRoot() {
            return "RootFolder".equalsIgnoreCase(this._publicType);
        }

        public boolean isLeaf() {
            if (this.isFolder()) {
                return this._children == null ? false : this._children.size() == 0;
            }
            return true;
        }

        public TreeNode[] getPathToRoot() {
            ArrayList<TreeNode> pathList = new ArrayList<TreeNode>(5);
            for (TreeNode parent = this.getParent(); parent != null; parent = parent.getParent()) {
                pathList.add(parent);
            }
            Collections.reverse(pathList);
            return pathList.toArray(new TreeNode[pathList.size()]);
        }

        public String getDisplayPath() {
            StringBuffer sb = new StringBuffer();
            TreeNode[] path = this.getPathToRoot();
            for (int i = 0; i < path.length; ++i) {
                TreeNode node = path[i];
                if (node.isRoot()) continue;
                sb.append('/');
                sb.append(node.getName());
            }
            sb.append('/');
            sb.append(this._name);
            return sb.toString();
        }

        public String toString() {
            return this.getDisplayPath();
        }
    }
}

