/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sasserver.dataset;

import com.sas.awt.util.Util;
import com.sas.query.Query;
import com.sas.query.QueryException;
import com.sas.query.WhereBuilder;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.WebAfDataSource;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.Table;
import com.sas.query.visuals.ImageHandler;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.StandardDialog;
import com.sas.query.visuals.WindowUtil;
import com.sas.rmi.Connection;
import com.sas.sasserver.RB;
import com.sas.text.Message;
import com.sas.util.ThreadedCommand;
import com.sas.visuals.CommandProgress;
import com.sas.visuals.MessageBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class WhereCustomizerDialog
extends StandardDialog {
    protected transient String m_where;
    protected transient String m_originalWhere;
    protected transient String saveWhereString;
    protected transient String m_dataSet;
    protected transient Container m_panel;
    protected transient DataSource m_dataSource;
    protected transient WhereBuilder whereDefiner;
    protected transient Connection m_connection;
    protected transient Component m_owner;
    protected transient boolean wasCancelled = false;
    protected transient boolean exceptionThrown = false;
    protected transient MessageHandler m_messages;
    protected static int preferredWidth = 780;
    protected static int preferredHeight = 450;
    static final String RB_KEY = "WhereCustomizerDialog.";

    public WhereCustomizerDialog(Frame parentFrame, Component owner, Connection conn, String dataSet, String where) {
        this(parentFrame, conn, dataSet, where);
        this.m_owner = owner;
    }

    public WhereCustomizerDialog(Frame parentFrame, Connection conn, String dataSet, String where) {
        super(parentFrame, true);
        this.m_where = where;
        this.saveWhereString = null;
        this.m_dataSet = dataSet;
        this.m_connection = conn;
        this.m_dataSource = this.createWebAfDataSource(conn);
        this.setTitle("Where Clause Builder");
    }

    protected WhereCustomizerDialog(Frame parentFrame, DataSource dataSource, String dataSet, String where, String title) {
        super(parentFrame, true);
        this.m_where = where;
        this.saveWhereString = null;
        this.m_dataSet = dataSet;
        this.m_dataSource = dataSource;
        this.setTitle(title);
        if (this.m_dataSource instanceof WebAfDataSource) {
            this.m_connection = ((WebAfDataSource)this.m_dataSource).getConnection();
        }
    }

    protected WhereCustomizerDialog(Frame parentFrame, Component owner, Connection conn, DataSource dataSource, String dataSet, String where) {
        super(parentFrame, true);
        this.m_where = where;
        this.saveWhereString = null;
        this.m_dataSet = dataSet;
        this.m_connection = conn;
        this.m_dataSource = dataSource;
        this.m_owner = owner;
        this.setTitle("Where Clause Builder");
    }

    private WebAfDataSource createWebAfDataSource(Connection conn) {
        WebAfDataSource dso = null;
        try {
            this.m_messages = new MessageHandler();
            dso = new WebAfDataSource(conn, this.m_messages);
        }
        catch (QueryException e) {
            MessageBox.showModalMessageBox((Component)Util.getParentFrame((Component)this), (String)e.getLocalizedMessage());
        }
        return dso;
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public void setDataSet(String tableName) {
        this.m_dataSet = tableName;
        if (this.m_query == null) {
            this.setQuery(new Query(this.m_dataSource, 2));
            this.m_messages = this.m_query.getMessageHandler();
        } else {
            this.m_query.clear();
        }
        Table logicalTable = this.m_query.addTable(this.m_dataSet);
        this.m_query.addResultItems(logicalTable);
        if (this.whereDefiner != null) {
            this.whereDefiner.repaint();
        }
    }

    public String getDataSet() {
        return this.m_dataSet;
    }

    private void _init() {
        if (this.wasCancelled) {
            return;
        }
        this.m_originalWhere = this.m_where;
        if (this.m_dataSource == null) {
            this.m_dataSource = this.createWebAfDataSource(this.m_connection);
        }
        this.setDataSet(this.m_dataSet);
        try {
            this.m_query.setWhereString(this.m_where);
            if (this.m_messages.failureHasOccurred()) {
                MessageBox mb = new MessageBox(new Frame(), this.m_messages.getOneBigMessage());
                mb.initialize();
                mb.setVisible(true);
                this.wasCancelled = true;
            } else {
                this.createPanel();
                this.setMainPanel(this.m_panel);
            }
            QueryResource iconBundle = new QueryResource(ImageHandler.class);
            ImageIcon qIcon = ImageHandler.getImageIcon(iconBundle, "qIcon");
            WindowUtil.getParentFrame(this).setIconImage(qIcon.getImage());
        }
        catch (Exception e) {
            this.showException(e);
            this.exceptionThrown = true;
        }
    }

    public void initialize() {
        if (this.m_owner == null) {
            this._init();
        } else {
            block5: {
                try {
                    boolean exceptionThrown = false;
                    boolean wasCancelled = false;
                    CommandProgress.executeAsynchronously((ThreadedCommand)new Connect(), null, (String)RB.getStringResource((String)"progressDialogTitle.txt"), (String)Message.format((String)RB.getStringResource((String)"progressDialogText.txt"), (Object)this.m_connection.getHost()), (Object)this, (Component)this.m_owner);
                }
                catch (Exception e) {
                    boolean bl = this.wasCancelled = e.getMessage() == com.sas.visuals.RB.getStringResource((String)"CommandProgress.cancelMessage.txt");
                    if (this.wasCancelled) break block5;
                    this.showException(e);
                }
            }
            if (!this.wasCancelled) {
                this._init();
            }
        }
    }

    protected void createPanel() {
        this.m_panel = new JPanel();
        BorderLayout border = new BorderLayout();
        this.m_panel.setLayout(border);
        this.whereDefiner = new WhereBuilder(this.m_query);
        this.m_panel.add("Center", this.whereDefiner);
    }

    public void centerOver(Component component) {
        Util.centerOver((Window)this, (Component)component);
    }

    public String getWhere() {
        String retString = this.m_query != null ? this.m_query.getWhereString() : (this.saveWhereString != null ? this.saveWhereString : this.m_originalWhere);
        return retString;
    }

    public void setWhere(String newWhere) {
        if (this.m_query != null) {
            this.m_query.setWhereString(newWhere);
        }
    }

    @Override
    public void onOK() {
        this.saveWhereString = this.getWhere();
        super.onOK();
    }

    @Override
    protected void onCancel() {
        this.saveWhereString = null;
        if (this.m_query != null) {
            this.m_query.setWhereString(this.m_originalWhere);
        }
        super.onCancel();
        this.wasCancelled = true;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension tryThis = new Dimension(preferredWidth, preferredHeight);
        Dimension preferred = WindowUtil.getBestWindowSize(tryThis);
        return preferred;
    }

    public boolean wasConfirmed() {
        return !this.wasCancelled && !this.exceptionThrown;
    }

    @Override
    public void closing() {
        super.closing();
        this.m_connection = null;
        this.m_originalWhere = null;
        this.m_messages = null;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_owner = null;
        this.m_dataSource = null;
        this.m_query = null;
        if (this.whereDefiner != null) {
            this.whereDefiner.closing();
            this.whereDefiner = null;
        }
        if (this.m_panel != null) {
            this.m_panel.removeAll();
            this.m_panel = null;
        }
    }

    class Connect
    implements ThreadedCommand {
        Connect() {
        }

        public void execute(Object o) {
            try {
                WhereCustomizerDialog.this.m_connection.connect();
            }
            catch (Exception e) {
                e.printStackTrace();
                WhereCustomizerDialog.this.m_connection.stop();
                WhereCustomizerDialog.this.exceptionThrown = true;
            }
        }

        public void interrupt() {
            WhereCustomizerDialog.this.m_connection.stop();
            WhereCustomizerDialog.this.wasCancelled = true;
        }
    }
}

