/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ResultItem;
import com.sas.query.visuals.ClueView;
import com.sas.query.visuals.DrawUtil;
import com.sas.query.visuals.PopMenuItem;
import com.sas.query.visuals.QueryComponentDialog;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.ResultItemPropertyView;
import com.sas.query.visuals.StandardView;
import com.sas.query.visuals.UnionListQueryView;
import com.sas.query.visuals.UnionPropertyView;
import com.sas.query.visuals.WindowUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class UnionListView
extends StandardView {
    protected JScrollPane m_scrollPane;
    protected JTabbedPane m_tabbedPane;
    protected int m_ascent = 0;
    protected int m_lineHeight = 0;
    protected Vector m_views = new Vector();
    protected ClueView m_message = null;
    protected ClueView m_unionMessage = null;
    protected boolean m_bHasDragged = false;
    protected boolean m_doActionOnNewNode = true;
    protected UnionListQueryView m_selectedQuery = null;
    protected Query m_selectedUnion = null;
    protected Color m_selectedBackground = Color.white;
    protected JPopupMenu m_barPopmenu;
    protected JPopupMenu m_partPopmenu;
    protected JPopupMenu m_joinPopmenu;
    protected int m_hitLocationType;
    protected Object m_hitLocationObject;
    protected static final int ON_NOTHING = 1;
    protected static final int ON_QUERY = 2;
    protected static final int ON_UNION = 3;
    protected transient boolean m_fReadyToDrag = false;
    protected transient boolean m_bDragging = false;
    protected transient Dimension m_dragOffset;
    protected transient Point m_dragPoint = new Point(-1, -1);
    protected static QueryResource bundle = new QueryResource(UnionListView.class);
    protected transient boolean m_bShowJoinMessage = true;

    public UnionListView(Query query, JScrollPane scrollPane, JTabbedPane tabbedPane) {
        super(query);
        this.m_scrollPane = scrollPane;
        this.m_tabbedPane = tabbedPane;
        for (Query nextQuery = this.m_query; nextQuery != null; nextQuery = nextQuery.getUnion()) {
            nextQuery.addPropertyListener(this, 28);
        }
        this._refresh();
        this.m_message = new ClueView(bundle.getString("UnionListView.Clue1.1.txt"), bundle.getString("UnionListView.Clue1.2.txt"));
        this.m_unionMessage = new ClueView(bundle.getString("UnionListView.Clue2.1.txt"), bundle.getString("UnionListView.Clue2.2.txt"));
        if (this.m_views.size() == 0) {
            this.add(this.m_message);
        }
        this.m_unionMessage.setVisible(false);
        this.add(this.m_unionMessage);
        this.addFocusListener(new FocusHandler());
        this.addMouseListener(new MouseHandler());
        this.addMouseMotionListener(new MouseMotionHandler());
    }

    @Override
    public void closing() {
        this.m_query.removePropertyListener(this);
    }

    public void onEditQuery() {
        int index = 1;
        Query query = this.m_query;
        while (query != null && query != this.getSelectedQueryView().getQuery()) {
            query = query.getUnion();
            ++index;
        }
        this.m_tabbedPane.setSelectedIndex(index);
    }

    public void onEditUnion() {
        Query query = this.getSelectedUnion();
        UnionPropertyView propertyPanel = new UnionPropertyView(query);
        QueryComponentDialog editDialog = new QueryComponentDialog(WindowUtil.getParentFrame(this), this.m_query, propertyPanel, "BUG - need Prefix");
        WindowUtil.centerOverWindow(editDialog, this);
        editDialog.setModal(true);
        editDialog.pack();
        editDialog.setVisible(true);
        propertyPanel.closing();
        this.firePropertyChanges();
    }

    public void onInsertQuery() {
        Query query = this.m_query;
        if (this.getSelectedQueryView() != null && this.getSelectedQueryView().getQuery() != null) {
            query = this.getSelectedQueryView().getQuery();
        }
        while (query.getUnion() != null) {
            query = query.getUnion();
        }
        query.addUnion(new Query(query.getDataSource(), query.getMessageHandler()), 0);
        this.displayMessages();
        this.firePropertyChanges();
    }

    public void onDeleteQuery() {
        this.getSelectedQueryView().getQuery().deleteFromUnion();
        this.displayMessages();
        this.firePropertyChanges();
    }

    public void onEditResultItem() {
        ResultItem item = this.getSelectedQueryView().getSelectedColumn();
        ResultItemPropertyView propertyPanel = new ResultItemPropertyView(this.getSelectedQueryView().getQuery(), item);
        QueryComponentDialog editDialog = new QueryComponentDialog(WindowUtil.getParentFrame(this), this.m_query, propertyPanel, "BUG - need Prefix");
        WindowUtil.centerOverWindow(editDialog, this);
        editDialog.setModal(true);
        editDialog.pack();
        editDialog.setVisible(true);
        propertyPanel.closing();
    }

    public void onOrderByResultItem() {
        ResultItem item = this.getSelectedQueryView().getSelectedColumn();
        this.getSelectedQueryView().getQuery().addOrderItem(item);
        this.displayMessages();
        this.firePropertyChanges();
    }

    public void onRemoveFromResults() {
        ResultItem item = this.getSelectedQueryView().getSelectedColumn();
        this.getSelectedQueryView().getQuery().deleteResultItem(item);
        this.displayMessages();
        this.firePropertyChanges();
    }

    public UnionListQueryView getNodeView(Query query) {
        for (int index = 0; index < this.m_views.size(); ++index) {
            if (((UnionListQueryView)this.m_views.elementAt(index)).getQuery() != query) continue;
            return (UnionListQueryView)this.m_views.elementAt(index);
        }
        UnionListQueryView newView = new UnionListQueryView(this, query);
        this.m_views.addElement(newView);
        if (this.m_message != null) {
            this.remove(this.m_message);
            this.m_message = null;
        }
        this._repositionView(newView);
        if (this.m_doActionOnNewNode && this.isShowing()) {
            this.setSelectedQuery(newView);
        }
        return newView;
    }

    public UnionListQueryView getSelectedQueryView() {
        return this.m_selectedQuery;
    }

    public synchronized void setSelectedQuery(UnionListQueryView queryView) {
        this.m_selectedQuery = queryView;
        this.m_selectedUnion = null;
    }

    public Query getSelectedUnion() {
        return this.m_selectedUnion;
    }

    public synchronized void setSelectedUnion(Query union) {
        this.m_selectedQuery = null;
        this.m_selectedUnion = union;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(500, 280);
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle rect = this.getBounds();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, rect.width, rect.height);
        for (int tableIndex = 0; tableIndex < this.m_views.size(); ++tableIndex) {
            UnionListQueryView view = (UnionListQueryView)this.m_views.elementAt(tableIndex);
            view.paintView(g);
        }
        if (this.m_bDragging) {
            UnionListQueryView dropTable;
            g.setColor(this.getBackground().brighter());
            g.drawRect(this.m_dragPoint.x + 10, this.m_dragPoint.y + 12, 12, 10);
            this._internalHitTest(this.m_dragPoint);
            if (this.m_hitLocationType == 2 && (dropTable = (UnionListQueryView)this.m_hitLocationObject) != null && dropTable != this.getSelectedQueryView()) {
                Rectangle dropZone = dropTable.getDropZone(this.m_dragPoint);
                if (dropZone == null) {
                    return;
                }
                g.setColor(Color.white);
                WindowUtil.drawFocusRect(g, dropZone.x + 2, dropZone.y + 2, dropZone.width - 4, dropZone.height - 2, false);
                Rectangle source = this.getSelectedQueryView().getResultItemBounds(this.getSelectedQueryView().getSelectedIndex());
                DrawUtil.drawUnionLine(0, this, g, source, dropZone);
            }
        }
        if (!this.m_bHasDragged && this.m_views.size() == 2 && this.m_bShowJoinMessage && !this.m_unionMessage.isVisible()) {
            this.m_unionMessage.setVisible(true);
            this.setBorder(BorderFactory.createEmptyBorder(((UnionListQueryView)this.m_views.elementAt((int)1)).y + ((UnionListQueryView)this.m_views.elementAt((int)1)).height + 10, ((UnionListQueryView)this.m_views.elementAt((int)1)).x - 54, 0, 0));
            this.doLayout();
        } else if (this.m_views.size() > 1 && this.m_bShowJoinMessage) {
            this.m_bShowJoinMessage = false;
            this.m_unionMessage.setVisible(false);
            this.repaint();
        }
        this.paintUnions(g, this.m_query);
    }

    public void paintUnions(Graphics g, Query query) {
        if (query.getUnion() == null) {
            return;
        }
        int unionType = query.getUnionType();
        Rectangle dest = this.getNodeView(query).getBounds();
        Rectangle source = this.getNodeView(query.getUnion()).getBounds();
        DrawUtil.drawUnionLine(unionType, this, g, source, dest);
        this.paintUnions(g, query.getUnion());
    }

    protected void _refresh() {
        Query query;
        int cQueries = 0;
        for (query = this.m_query; query != null; query = query.getUnion()) {
            this.getNodeView(query);
            ++cQueries;
        }
        for (int index = this.m_views.size() - 1; index >= 0; --index) {
            UnionListQueryView view = (UnionListQueryView)this.m_views.elementAt(index);
            boolean bFound = false;
            for (query = this.m_query; query != null; query = query.getUnion()) {
                if (query != view.getQuery()) continue;
                bFound = true;
                break;
            }
            if (bFound) continue;
            this.m_views.removeElementAt(index);
        }
    }

    protected void _repositionView(UnionListQueryView viewToPosition) {
        int nextX = 10;
        for (int tableIndex = 0; tableIndex < this.m_views.size(); ++tableIndex) {
            UnionListQueryView view = (UnionListQueryView)this.m_views.elementAt(tableIndex);
            if (view.x == -32153) continue;
            nextX = Math.max(nextX, view.x + view.width);
        }
        viewToPosition.x = nextX += 35;
        viewToPosition.y = 20;
    }

    protected Query _getUnionByLocation(Point point) {
        return this.m_query;
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        this._refresh();
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public JPopupMenu getOverallPopmenu() {
        if (this.m_barPopmenu == null) {
            this.m_barPopmenu = new JPopupMenu("BarViewMenu");
            this.m_barPopmenu.add(new PopMenuItem("Insert Table...", "onInsert", this));
        }
        return this.m_barPopmenu;
    }

    public void setBarPopmenu(JPopupMenu menu) {
        this.m_barPopmenu = menu;
    }

    public JPopupMenu getTablePopmenu() {
        this.m_partPopmenu = new JPopupMenu("BarViewMenu");
        if (this.m_tabbedPane != null) {
            this.m_partPopmenu.add(new PopMenuItem(bundle.getString("UnionListView.EditQuery....txt"), "onEditQuery", this));
        }
        this.m_partPopmenu.add(new PopMenuItem(bundle.getString("UnionListView.DeleteQuery.txt"), "onDeleteQuery", this));
        this.m_partPopmenu.addSeparator();
        this.m_partPopmenu.add(new PopMenuItem(bundle.getString("UnionListView.InsertQuery....txt"), "onInsertQuery", this));
        return this.m_partPopmenu;
    }

    public JPopupMenu getColumnPopmenu() {
        this.m_partPopmenu = new JPopupMenu("BarViewMenu");
        this.m_partPopmenu.add(new PopMenuItem(bundle.getString("Common.Edit....txt"), "onEditResultItem", this));
        if (this.getSelectedQueryView().getQuery() == this.m_query) {
            this.m_partPopmenu.add(new PopMenuItem(bundle.getString("UnionListView.OrderBy.txt"), "onOrderByResultItem", this));
        }
        this.m_partPopmenu.add(new PopMenuItem(bundle.getString("UnionListView.RemoveFromResults.txt"), "onRemoveFromResults", this));
        this.m_partPopmenu.addSeparator();
        if (this.m_tabbedPane != null) {
            this.m_partPopmenu.add(new PopMenuItem(bundle.getString("UnionListView.EditQuery....txt"), "onEditQuery", this));
        }
        this.m_partPopmenu.add(new PopMenuItem(bundle.getString("UnionListView.DeleteQuery.txt"), "onDeleteQuery", this));
        this.m_partPopmenu.addSeparator();
        this.m_partPopmenu.add(new PopMenuItem(bundle.getString("UnionListView.InsertQuery....txt"), "onInsertQuery", this));
        return this.m_partPopmenu;
    }

    public void setPartPopmenu(JPopupMenu menu) {
        this.m_partPopmenu = menu;
    }

    public JPopupMenu getJoinPopmenu() {
        if (this.m_joinPopmenu == null) {
            this.m_joinPopmenu = new JPopupMenu("BarViewMenu");
            this.m_joinPopmenu.add(new PopMenuItem(bundle.getString("UnionListView.EditUnion....txt"), "onEditUnion", this));
            this.m_joinPopmenu.add(new PopMenuItem(bundle.getString("UnionListView.DeleteUnion.txt"), "onDeleteUnion", this));
            this.m_joinPopmenu.addSeparator();
            this.m_joinPopmenu.add(new PopMenuItem(bundle.getString("UnionListView.InsertQuery....txt"), "onInsertQuery", this));
        }
        return this.m_joinPopmenu;
    }

    public void setJoinPopmenu(JPopupMenu menu) {
        this.m_partPopmenu = menu;
    }

    protected void _drag(Point point) {
    }

    protected void _drop(Point point) {
    }

    protected void _cancelCurrentAction() {
        if (this.m_bDragging) {
            this.m_bHasDragged = true;
        }
        this.m_bDragging = false;
        this.m_fReadyToDrag = false;
        this.repaint();
    }

    private void _internalHitTest(Point point) {
        this.m_hitLocationType = 1;
        this.m_hitLocationObject = null;
        for (int index = 0; index < this.m_views.size(); ++index) {
            UnionListQueryView view = (UnionListQueryView)this.m_views.elementAt(index);
            if (!view.contains(point)) continue;
            this.m_hitLocationType = 2;
            this.m_hitLocationObject = view;
            return;
        }
        Query union = this._getUnionByLocation(point);
        if (union != null) {
            this.m_hitLocationType = 3;
            this.m_hitLocationObject = union;
        }
    }

    class FocusHandler
    extends FocusAdapter {
        FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (UnionListView.this.getSelectedQueryView() != null) {
                UnionListView.this.getSelectedQueryView().setBackground(UnionListView.this.m_selectedBackground);
                UnionListView.this.getSelectedQueryView().repaint();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (UnionListView.this.getSelectedQueryView() != null) {
                UnionListView.this.getSelectedQueryView().setBackground(UnionListView.this.m_selectedBackground.darker());
                UnionListView.this.getSelectedQueryView().repaint();
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            Cloneable source;
            UnionListView.this._internalHitTest(event.getPoint());
            if (UnionListView.this.m_hitLocationType == 2) {
                source = (UnionListQueryView)UnionListView.this.m_hitLocationObject;
                UnionListView.this.setSelectedQuery((UnionListQueryView)source);
                ((UnionListQueryView)source).setSelection(event.getPoint());
                UnionListView.this.repaint();
                if ((event.getModifiers() & 0x10) != 0) {
                    UnionListView.this.m_fReadyToDrag = true;
                }
                UnionListView.this.m_dragPoint = event.getPoint();
                if (event.getClickCount() == 2) {
                    if ((event.getModifiers() & 0x10) != 0) {
                        ((UnionListQueryView)source).onAction(event.getPoint());
                        return;
                    }
                }
            }
            if (UnionListView.this.m_hitLocationType == 3) {
                source = (Query)UnionListView.this.m_hitLocationObject;
                UnionListView.this.setSelectedUnion((Query)source);
                if (event.getClickCount() == 2) {
                    if ((event.getModifiers() & 0x10) != 0) {
                        UnionListView.this.onEditUnion();
                    }
                }
                UnionListView.this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if ((event.getModifiers() & 4) != 0) {
                JPopupMenu popmenu = null;
                UnionListView.this._internalHitTest(event.getPoint());
                if (UnionListView.this.m_hitLocationType == 2) {
                    popmenu = UnionListView.this.getSelectedQueryView().getSelectedIndex() != -1 ? UnionListView.this.getColumnPopmenu() : UnionListView.this.getTablePopmenu();
                } else if (UnionListView.this.m_hitLocationType == 3) {
                    popmenu = UnionListView.this.getJoinPopmenu();
                } else if (event.getSource() instanceof UnionListView) {
                    popmenu = UnionListView.this.getOverallPopmenu();
                }
                if (popmenu != null) {
                    JComponent source = (JComponent)event.getSource();
                    source.add(popmenu);
                    popmenu.show(source, event.getX(), event.getY());
                    return;
                }
            } else if (UnionListView.this.m_bDragging) {
                UnionListView.this._drop(event.getPoint());
            }
            UnionListView.this._cancelCurrentAction();
        }
    }

    class MouseMotionHandler
    extends MouseMotionAdapter {
        MouseMotionHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            Point point = event.getPoint();
            if (UnionListView.this.m_fReadyToDrag && UnionListView.this.m_views.size() > 1 && UnionListView.this.getSelectedQueryView() != null && UnionListView.this.getSelectedQueryView().getSelectedIndex() != -1 && (Math.abs(UnionListView.this.m_dragPoint.x - point.x) > 2 || Math.abs(UnionListView.this.m_dragPoint.x - point.x) > 2)) {
                UnionListView.this.m_dragOffset = new Dimension(UnionListView.this.m_dragPoint.x - UnionListView.this.getSelectedQueryView().x, UnionListView.this.m_dragPoint.y - UnionListView.this.getSelectedQueryView().y);
                UnionListView.this.m_bDragging = true;
                UnionListView.this.m_fReadyToDrag = false;
            }
            if (UnionListView.this.m_bDragging) {
                UnionListView.this._drag(point);
            }
        }
    }
}

