/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.models.ColumnList;
import com.sas.query.models.ResultItem;
import com.sas.query.models.ResultItemList;
import com.sas.query.visuals.DrawUtil;
import com.sas.query.visuals.Part;
import com.sas.query.visuals.UnionListView;
import com.sas.query.visuals.WindowUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class UnionListQueryView
extends Part {
    public static final int UNITIALIZED = -32153;
    protected static final int INTERLINE_SPACE = 2;
    protected static final int LEFT_MARGIN = 6;
    protected static final int RIGHT_MARGIN = 6;
    protected UnionListView m_parent;
    protected Query m_query;
    protected int m_descent = 0;
    protected int m_lineHeight = 0;
    protected ColumnList m_columnsInWhere;
    protected int m_cResultItems = -1;
    protected int m_selectedIndex = -1;

    public UnionListQueryView(UnionListView parent, Query query) {
        this.m_parent = parent;
        this.m_query = query;
        this.x = -32153;
        this.y = -32153;
        this.width = 120;
        this.setBackground(new Color(211, 211, 211));
    }

    public Query getQuery() {
        return this.m_query;
    }

    public ResultItem getResultItem(int index) {
        return this.m_query.getResultItems().elementAt(index);
    }

    public void onAction() {
        if (this.getSelectedColumn() == null) {
            this.m_parent.onEditQuery();
        } else {
            this.m_parent.onEditResultItem();
        }
    }

    public void onAction(Point point) {
        this.setSelection(point);
        this.onAction();
    }

    public void setSelection(Point point) {
        this.m_selectedIndex = this.getResultItemAtPoint(point);
    }

    public int getResultItemAtPoint(Point point) {
        ResultItemList columnList = this.m_query.getResultItems();
        for (int columnIndex = 0; columnIndex < columnList.size(); ++columnIndex) {
            Rectangle rect = this.getResultItemBounds(columnIndex);
            if (!rect.contains(point)) continue;
            return columnIndex;
        }
        return -1;
    }

    public ResultItem getSelectedColumn() {
        if (this.getSelectedIndex() == -1) {
            return null;
        }
        return this.m_query.getResultItems().elementAt(this.getSelectedIndex());
    }

    public int getSelectedIndex() {
        return this.m_selectedIndex;
    }

    public Rectangle getDropZone(Point point) {
        int columnIndex = this.getResultItemAtPoint(point);
        if (columnIndex == -1) {
            return null;
        }
        return this.getResultItemBounds(columnIndex);
    }

    public Rectangle getResultItemBounds(int index) {
        int columnY = (this.m_lineHeight + 2) * (index + 1) + 2;
        return new Rectangle(this.x, this.y + columnY, this.width, this.m_lineHeight);
    }

    public Rectangle getResultItemBounds(ResultItem column) {
        ResultItemList columnList = this.m_query.getResultItems();
        for (int columnIndex = 0; columnIndex < columnList.size(); ++columnIndex) {
            if (columnList.elementAt(columnIndex) != column) continue;
            return this.getResultItemBounds(columnIndex);
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getBounds().width > 0) {
            return new Dimension(this.getBounds().width, this.getBounds().height);
        }
        return new Dimension(200, 200);
    }

    @Override
    public void paintView(Graphics g) {
        ResultItemList resultItemList = this.m_query.getResultItems();
        if (this.m_cResultItems != resultItemList.size()) {
            FontMetrics fontmetrics = g.getFontMetrics();
            this.m_descent = fontmetrics.getDescent();
            this.m_lineHeight = fontmetrics.getAscent() + fontmetrics.getDescent() + 2;
            this.height = (this.m_lineHeight + 2) * (resultItemList.size() + 1) + 5 + 2;
            this.width = 120;
            this.m_cResultItems = resultItemList.size();
        }
        Graphics stringG = g.create();
        Rectangle rect = this.getBounds();
        stringG.setClip(rect.x, rect.y, rect.width, rect.height);
        if (this == this.m_parent.getSelectedQueryView()) {
            DrawUtil.draw3DBox(stringG, Color.white, Color.white, this.m_parent.getBackground().darker().darker(), this.x, this.y + this.m_lineHeight + 2, rect.width - 1, rect.height - 1 - this.m_lineHeight - 2);
        } else {
            DrawUtil.draw3DBox(stringG, this.getBackground(), Color.white, this.m_parent.getBackground().darker().darker(), this.x, this.y + this.m_lineHeight + 2, rect.width - 1, rect.height - 1 - this.m_lineHeight - 2);
        }
        stringG.setColor(Color.black);
        int cColumns = resultItemList.size();
        for (int columnIndex = 0; columnIndex < cColumns; ++columnIndex) {
            ResultItem columnInfo = resultItemList.elementAt(columnIndex);
            Rectangle columnRect = this.getResultItemBounds(columnIndex);
            int columnY = columnRect.y + columnRect.height - this.m_descent;
            stringG.drawString(columnInfo.getDisplayString(), columnRect.x + 6, columnY);
            if (columnIndex != this.getSelectedIndex() || this.m_parent.getSelectedQueryView() != this) continue;
            WindowUtil.drawFocusRect(stringG, columnRect.x + 2, columnRect.y + 2, columnRect.width - 4, columnRect.height - 2);
        }
        DrawUtil.draw3DBox(stringG, this.m_parent.getBackground().darker(), Color.white, this.m_parent.getBackground().darker().darker(), this.x, this.y, rect.width - 1, this.m_lineHeight + 2 - 1);
        stringG.setColor(Color.white);
        stringG.drawString(bundle.getString("UnionListQV.ResultsOfSelect.txt") + Query.getUnionIndex(this.m_query), this.x + 6, this.y + this.m_lineHeight - this.m_descent + 1);
        stringG.dispose();
    }
}

