/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.QueryConfiguration;
import com.sas.query.datasources.Function;
import com.sas.query.datasources.Operator;
import com.sas.query.models.Column;
import com.sas.query.models.ColumnExpression;
import com.sas.query.models.CompoundExpression;
import com.sas.query.models.Expression;
import com.sas.query.models.ExpressionList;
import com.sas.query.models.JoinRelationship;
import com.sas.query.models.JoinRelationshipList;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.models.ParenExpression;
import com.sas.query.models.PropertyChangeConstants;
import com.sas.query.models.Table;
import com.sas.query.models.TableList;
import com.sas.query.visuals.AddTableDialog;
import com.sas.query.visuals.AdvancedJoinPropertyView;
import com.sas.query.visuals.ClueView;
import com.sas.query.visuals.DrawUtil;
import com.sas.query.visuals.ExpressionEditDialog;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.visuals.PopMenuCheckBoxItem;
import com.sas.query.visuals.PopMenuItem;
import com.sas.query.visuals.QueryComponentDialog;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.TablePropertyView;
import com.sas.query.visuals.TablesAndRelsTableView;
import com.sas.query.visuals.WindowUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TablesAndRelsView
extends JLayeredPane
implements Scrollable,
ModelChangeListener,
PropertyChangeConstants {
    protected Query m_query;
    protected JScrollPane m_scrollPane;
    protected int m_ascent = 0;
    protected int m_lineHeight = 0;
    protected Vector m_views = new Vector();
    protected ClueView m_message = null;
    protected ClueView m_joinMessage = null;
    protected ClueView m_addDataItemMessage = null;
    protected boolean m_bHasDragged = false;
    protected boolean m_joinHasDrawn = false;
    protected boolean m_addDataItem = false;
    protected TablesAndRelsTableView m_selectedTable = null;
    protected JoinRelationship m_selectedJoinRelationship = null;
    protected Color m_selectedBackground = Color.white;
    protected JPopupMenu m_barPopmenu;
    protected JPopupMenu m_joinPopmenu;
    protected int m_hitLocationType;
    protected Object m_hitLocationObject;
    protected static final int ON_NOTHING = 1;
    protected static final int ON_TABLE = 2;
    protected static final int ON_JOIN = 3;
    protected static final int HORIZONTAL_SPACING = 15;
    protected static final int VERTICAL_SPACING = 15;
    protected static final int MINIMUM_DISTANCE_TO_LINE = 6;
    protected transient Dimension m_preferredSize = new Dimension(450, 160);
    protected transient ExpressionEditDialog m_expBuilder;
    protected static QueryResource bundle = new QueryResource(TablesAndRelsView.class);
    protected transient DraggingPanel m_draggingPanel;
    protected transient JoinsRelationshipPanel m_joinsRelationshipPanel;
    protected transient boolean m_colDragging = false;
    protected transient boolean m_colDropVaild = false;
    protected transient Dimension m_dragOffset;
    protected transient Rectangle m_dragStartRect = new Rectangle();
    protected transient Rectangle m_dragCurRect = new Rectangle();
    protected transient Point m_dragPoint = new Point(-1, -1);
    protected transient Column m_dragStartColumn;
    protected transient TablesAndRelsTableView m_dragStartTable;
    protected transient ColumnMouseListener m_columnMouseListener;
    protected transient ColumnMouseMotionListener m_columnMouseMotionListener;
    protected transient ColumnViewChangeListener m_columnViewChangeListener;
    protected transient TableComponentListener m_tableComponentListener;
    protected transient boolean m_bInitialSizeSet = false;
    protected String m_columnLabelFormat = null;

    public TablesAndRelsView(Query query, JScrollPane scrollPane) {
        this.m_query = query;
        this.m_query.addPropertyListener(this, 8 | 0x10);
        this.m_scrollPane = scrollPane;
        this.setLayout(null);
        this._refresh();
        this.m_message = new ClueView(bundle.messageString("ClueView.insertTablesByDoubleClick.txt"), bundle.messageString("ClueView.insertTablesByDoubleClickpart2.txt"));
        this.m_addDataItemMessage = new ClueView(bundle.messageString("ClueView.addColsToRsltSet.txt"), bundle.messageString("ClueView.addColsToRsltSetpart2.txt"));
        this.m_joinMessage = new ClueView(bundle.messageString("ClueView.createJoinRlshipsByDrag.txt"), bundle.messageString("ClueView.createJoinRlshipsByDragpart2.txt"));
        this.displayMessage(this.m_message, 15, 15);
        this.displayMessage(this.m_addDataItemMessage, 162, 15);
        this.displayMessage(this.m_joinMessage, 347, 15);
        this.m_joinsRelationshipPanel = new JoinsRelationshipPanel();
        this.m_joinsRelationshipPanel.setLayout(null);
        this.m_joinsRelationshipPanel.setSize(this.getSize());
        this.m_joinsRelationshipPanel.setOpaque(false);
        this.add(this.m_joinsRelationshipPanel);
        this.setLayer(this.m_joinsRelationshipPanel, DEFAULT_LAYER - 1);
        this.m_draggingPanel = new DraggingPanel();
        this.m_draggingPanel.setLayout(null);
        this.m_draggingPanel.setSize(this.getSize());
        this.m_draggingPanel.setOpaque(false);
        this.add(this.m_draggingPanel);
        this.setLayer(this.m_draggingPanel, DRAG_LAYER);
        this.addKeyListener(new MyKeyListener());
        this.addMouseListener(new MouseHandler());
        this.addMouseMotionListener(new MouseMotionHandler());
        this.m_query.addPropertyListener(this, 8, 4);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        if (this.m_draggingPanel != null) {
            this.m_draggingPanel.setSize(width, height - 1);
        }
        if (this.m_joinsRelationshipPanel != null) {
            this.m_joinsRelationshipPanel.setSize(width, height - 1);
        }
        this.m_preferredSize = new Dimension(width, height);
    }

    @Override
    public void setSize(Dimension dim) {
        this.setSize(dim.width, dim.height);
    }

    public void closing() {
        this.m_query.removePropertyListener(this);
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        this._refresh();
    }

    public Query getQuery() {
        return this.m_query;
    }

    public void finalize() {
        this.closing();
    }

    public void addError(String message) {
        this.m_query.getMessageHandler().addError(message);
    }

    public void addInternalError(Exception e) {
        this.m_query.getMessageHandler().addInternalError(e);
    }

    public void endQueryChange() {
        this.m_query.getMessageHandler().firePropertyChanges();
        MessageUtil.displayMessages(this.m_query.getMessageHandler());
    }

    public boolean failureHasOccurred() {
        this.m_query.getPropertyChangeHandler().firePropertyChanges();
        return this.m_query.getMessageHandler().failureHasOccurred();
    }

    public void firePropertyChanges() {
        this.m_query.getPropertyChangeHandler().firePropertyChanges();
    }

    public void onEditTable() {
        Table item = this.getSelectedTable().getTable();
        TablePropertyView propertyPanel = new TablePropertyView(item);
        WindowUtil.busyOn(this);
        try {
            QueryComponentDialog editDialog = new QueryComponentDialog(WindowUtil.getParentFrame(this), this.m_query, propertyPanel, "Table.Title.txt");
            editDialog.setModal(true);
            editDialog.pack();
            WindowUtil.centerOverWindow(editDialog, this);
            editDialog.setVisible(true);
            propertyPanel.closing();
        }
        catch (Throwable t) {
            WindowUtil.busyOff(this);
            this.m_query.getMessageHandler().addInternalError(t);
        }
        WindowUtil.busyOff(this);
        this.endQueryChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEditJoinRelationship() {
        TablesAndRelsView tablesAndRelsView = this;
        synchronized (tablesAndRelsView) {
            if (this.m_expBuilder != null) {
                return;
            }
            this.m_expBuilder = new ExpressionEditDialog(WindowUtil.getParentFrame(this), true, this.getSelectedJoinRelationship().getComparisonDetails(), this.m_query);
        }
        WindowUtil.busyOn(this);
        try {
            WindowUtil.centerOver(this.m_expBuilder, this.getRootPane());
            this.m_expBuilder.show();
            if (this.m_expBuilder.getReturnValue() == 1) {
                Expression expression = this.m_expBuilder.getExpression();
                if (expression.generateSQL(this.getQuery().getDataSource().getSqlLogic(this.getQuery()), 1).trim().length() == 0) {
                    this.m_query.deleteJoinRelationship(this.getSelectedJoinRelationship());
                } else {
                    this.getSelectedJoinRelationship().setComparisonDetails(expression);
                }
                this.m_query.isValidSql();
            }
        }
        catch (Throwable t) {
            WindowUtil.busyOff(this);
            this.m_query.getMessageHandler().addInternalError(t);
        }
        WindowUtil.busyOff(this);
        this.m_expBuilder = null;
        this.endQueryChange();
    }

    public void onDistinct() {
        if (this.getQuery().getDuplicateRows()) {
            this.getQuery().setDuplicateRowsRule(0);
        } else {
            this.getQuery().setDuplicateRowsRule(2);
        }
        this.endQueryChange();
    }

    public void onAdvancedJoins() {
        WindowUtil.busyOn(this);
        try {
            AdvancedJoinPropertyView propertyView = new AdvancedJoinPropertyView(this.getQuery());
            QueryComponentDialog joinDialog = new QueryComponentDialog(WindowUtil.getParentFrame(this), this.getQuery(), propertyView, "Join.Title.txt");
            joinDialog.pack();
            WindowUtil.center(joinDialog);
            propertyView.setSelectedJoinReleationship(this.getSelectedJoinRelationship());
            joinDialog.setVisible(true);
        }
        catch (Throwable t) {
            WindowUtil.busyOff(this);
            this.m_query.getMessageHandler().addInternalError(t);
        }
        WindowUtil.busyOff(this);
        this.endQueryChange();
    }

    public void onInsertTable() {
        WindowUtil.busyOn(this);
        try {
            AddTableDialog dialog = new AddTableDialog(this.m_query, WindowUtil.getParentFrame(this));
            dialog.setVisible(true);
        }
        catch (Throwable t) {
            WindowUtil.busyOff(this);
            this.m_query.getMessageHandler().addInternalError(t);
        }
        WindowUtil.busyOff(this);
        this.endQueryChange();
    }

    public void onDeleteTable() {
        if (this.getSelectedTable() != null) {
            this.getSelectedTable().onDeleteTable();
        }
        this.endQueryChange();
    }

    public void onDeleteJoinRelationship() {
        if (QueryConfiguration.getConfigurationBoolean("DeleteJoinFromQueryWarningDialogEnabled.notrans", true)) {
            Object[] options = new Object[]{bundle.getString("Standard.ButtonLabel.Yes.txt"), bundle.getString("Standard.ButtonLabel.No.txt")};
            int annoyedUserSays = JOptionPane.showOptionDialog(null, bundle.messageString("TablesAndRels.Label.DeleteJoin.txt"), bundle.messageString("Title.Confirm.txt"), 0, 3, null, options, options[0]);
            if (annoyedUserSays != 0) {
                this.requestFocus();
                return;
            }
        }
        this.m_query.deleteJoinRelationship(this.getSelectedJoinRelationship());
        this.m_joinsRelationshipPanel.repaint();
        this.endQueryChange();
    }

    public TablesAndRelsTableView getNodeView(Table table) {
        for (int index = 0; index < this.m_views.size(); ++index) {
            if (((TablesAndRelsTableView)this.m_views.elementAt(index)).getTable() != table) continue;
            return (TablesAndRelsTableView)this.m_views.elementAt(index);
        }
        TablesAndRelsTableView newView = new TablesAndRelsTableView(this.m_query, this, table);
        TablePosition tablepos = new TablePosition(newView.getSize());
        Dimension currentSize = this.getSize();
        Dimension newSize = new Dimension(currentSize);
        int tempscalar = tablepos.x + newView.getWidth() + 10;
        if (currentSize.width < tempscalar) {
            newSize.width = tempscalar;
        }
        if (currentSize.height < (tempscalar = tablepos.y + newView.getHeight() + 10)) {
            newSize.height = tempscalar;
        }
        if (!newSize.equals(currentSize)) {
            this.setMinimumSize(newSize);
            this.setSize(newSize);
        }
        if (this.m_columnMouseListener == null) {
            this.m_columnMouseListener = new ColumnMouseListener();
        }
        if (this.m_columnMouseMotionListener == null) {
            this.m_columnMouseMotionListener = new ColumnMouseMotionListener();
        }
        newView.addColumnMouseListener(this.m_columnMouseListener);
        newView.addColumnMouseMotionListener(this.m_columnMouseMotionListener);
        if (this.m_columnViewChangeListener == null) {
            this.m_columnViewChangeListener = new ColumnViewChangeListener();
        }
        if (this.m_tableComponentListener == null) {
            this.m_tableComponentListener = new TableComponentListener();
        }
        newView.addColumnViewChangeListener(this.m_columnViewChangeListener);
        newView.addComponentListener(this.m_tableComponentListener);
        newView.setLocation(tablepos);
        this.m_views.addElement(newView);
        newView.setVisible(true);
        this.add(newView);
        newView.doLayout();
        newView.revalidate();
        newView.requestFocus();
        this.resizeForNodes();
        if (this.isShowing()) {
            this.setSelectedTable(newView);
            this.makeTableVisible(newView);
        }
        return newView;
    }

    public TablesAndRelsTableView getSelectedTable() {
        return this.m_selectedTable;
    }

    public synchronized void setSelectedTable(TablesAndRelsTableView tableView) {
        this.m_selectedTable = tableView;
        this.m_selectedJoinRelationship = null;
        this.repaint();
    }

    public JoinRelationship getSelectedJoinRelationship() {
        return this.m_selectedJoinRelationship;
    }

    public synchronized void setSelectedJoinRelationship(JoinRelationship joinRelationship) {
        this.m_selectedTable = null;
        this.requestFocus();
        this.m_selectedJoinRelationship = joinRelationship;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.m_preferredSize;
    }

    public void makeTableVisible(TablesAndRelsTableView tableView) {
        boolean fPositionChanged = false;
        this.m_scrollPane.validate();
        if (tableView.getX() > 0 && this.m_scrollPane != null) {
            int scrollX = this.m_scrollPane.getHorizontalScrollBar().getValue();
            int scrollY = this.m_scrollPane.getVerticalScrollBar().getValue();
            Dimension viewPortSize = this.m_scrollPane.getViewport().getSize();
            int change = scrollX + viewPortSize.width - (tableView.getX() + tableView.getWidth() + 20);
            if (change < 0) {
                this.m_scrollPane.getHorizontalScrollBar().setValue(scrollX - change);
                fPositionChanged = true;
            } else {
                change = scrollX - tableView.getX() + 20;
                if (change > 0) {
                    this.m_scrollPane.getHorizontalScrollBar().setValue(scrollX - change);
                    fPositionChanged = true;
                }
            }
            change = scrollY + viewPortSize.height - (tableView.getY() + tableView.getHeight() + 20);
            if (change < 0) {
                this.m_scrollPane.getVerticalScrollBar().setValue(scrollY - change);
                fPositionChanged = true;
            } else {
                change = scrollY - tableView.getY() + 20;
                if (change > 0) {
                    this.m_scrollPane.getVerticalScrollBar().setValue(scrollY - change);
                    fPositionChanged = true;
                }
            }
        }
        if (fPositionChanged) {
            this.repaint();
        }
    }

    public TablesAndRelsTableView getTableViewAt(Point p) {
        for (int index = 0; index < this.m_views.size(); ++index) {
            if (!((TablesAndRelsTableView)this.m_views.elementAt(index)).getBounds().contains(p)) continue;
            return (TablesAndRelsTableView)this.m_views.elementAt(index);
        }
        return null;
    }

    public TablesAndRelsTableView getTableViewAt(int x, int y) {
        return this.getTableViewAt(new Point(x, y));
    }

    public void resizeForNodes() {
        if (this.m_scrollPane == null) {
            return;
        }
        int desiredWidth = this.m_scrollPane.getViewport().getSize().width - 5;
        int desiredHeight = this.m_scrollPane.getViewport().getSize().height - 5;
        for (int tableIndex = 0; tableIndex < this.m_views.size(); ++tableIndex) {
            TablesAndRelsTableView view = (TablesAndRelsTableView)this.m_views.elementAt(tableIndex);
            desiredWidth = Math.max(desiredWidth, view.getLocation().x + view.getSize().width + 10);
            desiredHeight = Math.max(desiredHeight, view.getLocation().y + view.getSize().height + 10);
        }
        this.setSize(desiredWidth, desiredHeight);
    }

    private void repositionNodes() {
        Vector transientViews = new Vector();
        for (int i = 0; i < this.m_views.size(); ++i) {
            transientViews.addElement(this.m_views.elementAt(i));
        }
        this.m_views.removeAllElements();
        for (int tableIndex = 0; tableIndex < transientViews.size(); ++tableIndex) {
            TablesAndRelsTableView view = (TablesAndRelsTableView)transientViews.elementAt(tableIndex);
            TablePosition tablepos = new TablePosition(view.getSize());
            view.setLocation(tablepos);
            this.m_views.addElement(view);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.m_bInitialSizeSet) {
            this.m_bInitialSizeSet = true;
            this.resizeForNodes();
            this.repositionNodes();
            this.resizeForNodes();
            return;
        }
        if (this.m_views.size() == 0) {
            if (QueryConfiguration.getConfigurationBoolean("DisplayTablesHintViews.notrans", true)) {
                this.m_message.setVisible(true);
            } else {
                this.m_message.setVisible(false);
            }
        } else {
            this.m_message.setVisible(false);
        }
        if (this.m_views.size() == 1 && !this.m_addDataItem) {
            if (QueryConfiguration.getConfigurationBoolean("DisplayTablesHintViews.notrans", true)) {
                TablesAndRelsTableView view = (TablesAndRelsTableView)this.m_views.elementAt(0);
                Rectangle messageRect = new Rectangle(this.m_addDataItemMessage.getLocation());
                messageRect.width = this.m_addDataItemMessage.getWidth();
                messageRect.height = this.m_addDataItemMessage.getHeight();
                Rectangle viewRect = new Rectangle(view.getLocation());
                viewRect.width = view.getWidth();
                viewRect.height = view.getHeight();
                if (!viewRect.intersects(messageRect)) {
                    this.m_addDataItemMessage.setVisible(true);
                }
            } else {
                this.m_addDataItemMessage.setVisible(false);
            }
        } else {
            this.m_addDataItemMessage.setVisible(false);
        }
        if (!this.m_bHasDragged && this.m_views.size() == 2 && !this.m_joinHasDrawn) {
            if (QueryConfiguration.getConfigurationBoolean("DisplayTablesHintViews.notrans", true)) {
                Rectangle messageRect = new Rectangle(this.m_joinMessage.getLocation());
                messageRect.width = this.m_joinMessage.getWidth();
                messageRect.height = this.m_joinMessage.getHeight();
                TablesAndRelsTableView view1 = (TablesAndRelsTableView)this.m_views.elementAt(0);
                Rectangle view1Rect = new Rectangle(view1.getLocation());
                view1Rect.width = view1.getWidth();
                view1Rect.height = view1.getHeight();
                TablesAndRelsTableView view2 = (TablesAndRelsTableView)this.m_views.elementAt(1);
                Rectangle view2Rect = new Rectangle(view2.getLocation());
                view2Rect.width = view2.getWidth();
                view2Rect.height = view2.getHeight();
                boolean canShow = true;
                if (view1Rect.intersects(messageRect)) {
                    canShow = false;
                }
                if (view2Rect.intersects(messageRect)) {
                    canShow = false;
                }
                if (canShow) {
                    this.m_joinMessage.setVisible(true);
                }
            } else {
                this.m_joinMessage.setVisible(false);
            }
        } else {
            this.m_joinMessage.setVisible(false);
        }
        if ((this.m_views.size() > 2 || this.m_joinHasDrawn) && this.m_joinMessage.isVisible()) {
            this.m_joinMessage.setVisible(false);
        }
    }

    public void displayMessage(ClueView message, int startX, int startY) {
        this.add(message);
        message.setSize(message.getPreferredSize());
        message.setLocation(startX, startY);
        message.setVisible(false);
    }

    public void paintJoins(Graphics g, JoinRelationshipList joinList) {
        Rectangle right = new Rectangle();
        Rectangle left = new Rectangle();
        for (int index = 0; index < joinList.size(); ++index) {
            JoinRelationship joinRelationship = joinList.elementAt(index);
            int comparisonType = joinRelationship.getComparisonType();
            if (comparisonType == 1) continue;
            this.buildJoinParms(joinRelationship, left, right);
            DrawUtil.drawJoinLine(g, joinRelationship == this.getSelectedJoinRelationship(), 0, left, right);
        }
    }

    public void buildJoinParms(JoinRelationship join, Rectangle leftRect, Rectangle rightRect) {
        int comparisonType = join.getComparisonType();
        Expression details = join.getComparisonDetails();
        Rectangle dest = null;
        Rectangle source = null;
        if (comparisonType != 1 && comparisonType == 4) {
            if (details instanceof ParenExpression) {
                details = ((ParenExpression)details).getExpression();
            }
            if (details instanceof CompoundExpression) {
                CompoundExpression compound = (CompoundExpression)details;
                ExpressionList paramList = compound.getParameters();
                Function function = compound.getCurrentFunction();
                Column leftColumn = null;
                Column rightColumn = null;
                if (paramList.elementAt(0) instanceof ColumnExpression) {
                    leftColumn = ((ColumnExpression)paramList.elementAt(0)).getColumn();
                }
                if (paramList.elementAt(1) instanceof ColumnExpression) {
                    rightColumn = ((ColumnExpression)paramList.elementAt(1)).getColumn();
                }
                if (function instanceof Operator && leftColumn != null && rightColumn != null) {
                    TablesAndRelsTableView tmptbl = this.getNodeView(leftColumn.getParent());
                    dest = tmptbl.getJoinRectangle(leftColumn);
                    dest.setLocation(dest.getLocation().x + tmptbl.getLocation().x, dest.getLocation().y + tmptbl.getLocation().y + 2);
                    tmptbl = this.getNodeView(rightColumn.getParent());
                    source = tmptbl.getJoinRectangle(rightColumn);
                    source.setLocation(source.getLocation().x + tmptbl.getLocation().x, source.getLocation().y + tmptbl.getLocation().y + 2);
                }
            } else if (comparisonType == 5) {
                // empty if block
            }
        }
        if (source == null || dest == null) {
            int height;
            source = this.getNodeView(join.getRightTable()).getBounds();
            dest = this.getNodeView(join.getLeftTable()).getBounds();
            source.height = height = this.getNodeView(join.getRightTable()).getHeaderHeight();
            dest.height = height;
        }
        leftRect.setBounds(dest);
        rightRect.setBounds(source);
    }

    protected void _refresh() {
        TableList tableList = this.m_query.getReferableTables();
        int cTables = tableList.size();
        for (int index = this.m_views.size() - 1; index >= 0; --index) {
            TablesAndRelsTableView view = (TablesAndRelsTableView)this.m_views.elementAt(index);
            boolean bFound = false;
            for (int tableIndex = 0; tableIndex < cTables; ++tableIndex) {
                if (tableList.elementAt(tableIndex) != view.getTable()) continue;
                bFound = true;
                break;
            }
            if (bFound) continue;
            this.remove((Component)this.m_views.elementAt(index));
            this.m_views.removeElementAt(index);
        }
        for (int tableIndex = 0; tableIndex < cTables; ++tableIndex) {
            this.getNodeView(tableList.elementAt(tableIndex));
        }
        this.repaint();
    }

    protected JoinRelationship _getJoinRelationshipByLocation(Point point) {
        JoinRelationshipList joinList = this.m_query.getJoinRelationships();
        if (joinList.size() == 0) {
            return null;
        }
        Rectangle dest = new Rectangle();
        Rectangle source = new Rectangle();
        Rectangle rightRect = new Rectangle();
        Rectangle leftRect = new Rectangle();
        Point rightPoint = new Point();
        Point leftPoint = new Point();
        int minJoinIndex = -1;
        double minDist = 10.0;
        double dist = -1.0;
        for (int index = 0; index < joinList.size(); ++index) {
            JoinRelationship join = joinList.elementAt(index);
            int comparisonType = join.getComparisonType();
            if (comparisonType == 1) continue;
            this.buildJoinParms(join, dest, source);
            DrawUtil.getJoinLineAreas(false, 0, source, dest, rightRect, leftRect, rightPoint, leftPoint);
            if (rightRect.contains(point) || leftRect.contains(point)) {
                return join;
            }
            dist = DrawUtil.distanceToLine(rightPoint, leftPoint, point);
            if (!(Math.abs(dist) < 6.0) || !(dist < minDist)) continue;
            minDist = dist;
            minJoinIndex = index;
        }
        if (minJoinIndex != -1) {
            return this.m_query.getJoinRelationships().elementAt(minJoinIndex);
        }
        return null;
    }

    public JPopupMenu getOverallPopmenu() {
        this.m_barPopmenu = new JPopupMenu("BarViewMenu");
        this.m_barPopmenu.add(new PopMenuCheckBoxItem(!this.getQuery().getDuplicateRows(), bundle.getString("TARV.SelectDistinct.txt"), "onDistinct", this));
        this.m_barPopmenu.add(new PopMenuItem(bundle.getString("TARV.InsertTable....txt"), "onInsertTable", this));
        return this.m_barPopmenu;
    }

    public JPopupMenu getJoinPopmenu() {
        this.m_joinPopmenu = this.getOverallPopmenu();
        this.m_joinPopmenu.insert(new JPopupMenu.Separator(), 0);
        this.m_joinPopmenu.insert(new PopMenuItem(bundle.getString("TARV.AdvancedJoins.txt"), "onAdvancedJoins", this), 0);
        this.m_joinPopmenu.insert(new PopMenuItem(bundle.getString("TARV.DeleteRelationship.txt"), "onDeleteJoinRelationship", this), 0);
        this.m_joinPopmenu.insert(new PopMenuItem(bundle.getString("TARV.EditRelationship....txt"), "onEditJoinRelationship", this), 0);
        return this.m_joinPopmenu;
    }

    public void setJoinPopmenu(JPopupMenu menu) {
        this.m_joinPopmenu = menu;
    }

    public String getColumnLabelFormat() {
        return this.m_columnLabelFormat;
    }

    public void setColumnLabelFormat(String value) {
        this.m_columnLabelFormat = value;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.m_scrollPane.getViewport().getSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 60;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 15;
    }

    class JoinsRelationshipPanel
    extends JPanel {
        JoinsRelationshipPanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            TablesAndRelsView.this.paintJoins(g, TablesAndRelsView.this.m_query.getJoinRelationships());
        }
    }

    class DraggingPanel
    extends JPanel {
        DraggingPanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            if (TablesAndRelsView.this.m_colDragging) {
                DrawUtil.drawJoinLine(g, false, 0, TablesAndRelsView.this.m_dragStartRect, TablesAndRelsView.this.m_dragCurRect);
            }
        }
    }

    class MyKeyListener
    implements KeyListener {
        MyKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getID() != 401) {
                return;
            }
            switch (event.getKeyCode()) {
                case 127: {
                    if (TablesAndRelsView.this.getSelectedTable() != null) {
                        TablesAndRelsView.this.onDeleteTable();
                    } else if (TablesAndRelsView.this.getSelectedJoinRelationship() != null) {
                        TablesAndRelsView.this.onDeleteJoinRelationship();
                    }
                    event.consume();
                    break;
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            JoinRelationship joinRelationship = TablesAndRelsView.this._getJoinRelationshipByLocation(event.getPoint());
            if (joinRelationship != null) {
                TablesAndRelsView.this.setSelectedJoinRelationship(joinRelationship);
            }
            if (event.getClickCount() == 2) {
                if ((event.getModifiers() & 4) == 0 && joinRelationship != null) {
                    TablesAndRelsView.this.onEditJoinRelationship();
                }
            }
            TablesAndRelsView.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if ((event.getModifiers() & 4) != 0) {
                JPopupMenu popmenu = null;
                JoinRelationship join = TablesAndRelsView.this._getJoinRelationshipByLocation(event.getPoint());
                if (join != null) {
                    TablesAndRelsView.this.setSelectedJoinRelationship(join);
                    popmenu = TablesAndRelsView.this.getJoinPopmenu();
                } else if (event.getSource() instanceof TablesAndRelsView) {
                    popmenu = TablesAndRelsView.this.getOverallPopmenu();
                }
                if (popmenu != null) {
                    JComponent source = (JComponent)event.getSource();
                    source.add(popmenu);
                    popmenu.show(source, event.getX(), event.getY());
                    return;
                }
            }
        }
    }

    class MouseMotionHandler
    extends MouseMotionAdapter {
        MouseMotionHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            TablesAndRelsView.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    class TablePosition
    extends Point {
        protected TablePosition(Dimension size2find) {
            if (TablesAndRelsView.this.m_views.size() == 0) {
                this.x = 15;
                this.y = 15;
                return;
            }
            Dimension panelSize = TablesAndRelsView.this.getSize();
            Rectangle masterRect = new Rectangle(0, 0, panelSize.width, panelSize.height);
            Rectangle tempRect = TablesAndRelsView.this.getVisibleRect();
            if (this.bigenough(size2find, tempRect.getSize())) {
                masterRect.setBounds(tempRect.x, tempRect.y, tempRect.width, masterRect.height - tempRect.y);
            }
            Vector<Rectangle> tableRects = new Vector<Rectangle>();
            for (int index = 0; index < TablesAndRelsView.this.m_views.size(); ++index) {
                tempRect = ((TablesAndRelsTableView)TablesAndRelsView.this.m_views.elementAt(index)).getBounds();
                tempRect.width += 30;
                tempRect.height += 30;
                tableRects.addElement(tempRect);
            }
            Vector<Rectangle> availableRects = new Vector<Rectangle>();
            availableRects.addElement(masterRect);
            for (int i = 0; i < tableRects.size(); ++i) {
                Vector workRects = new Vector();
                Rectangle cantBeHereRect = (Rectangle)tableRects.elementAt(i);
                for (int j = 0; j < availableRects.size(); ++j) {
                    Rectangle newRect;
                    Rectangle bigTestRect = (Rectangle)availableRects.elementAt(j);
                    if (!cantBeHereRect.intersects(bigTestRect)) {
                        this.addWithoutDuplicates(workRects, bigTestRect);
                        continue;
                    }
                    if (cantBeHereRect.y - bigTestRect.y > 0 && this.bigenough(size2find, (newRect = new Rectangle(bigTestRect.x, bigTestRect.y, bigTestRect.width, cantBeHereRect.y - bigTestRect.y)).getSize())) {
                        this.addWithoutDuplicates(workRects, newRect);
                    }
                    if (bigTestRect.y + bigTestRect.height - (cantBeHereRect.y + cantBeHereRect.height) > 0 && this.bigenough(size2find, (newRect = new Rectangle(bigTestRect.x, cantBeHereRect.y + cantBeHereRect.height - 15, bigTestRect.width, bigTestRect.y + bigTestRect.height - cantBeHereRect.y + cantBeHereRect.height)).getSize())) {
                        this.addWithoutDuplicates(workRects, newRect);
                    }
                    if (cantBeHereRect.x - bigTestRect.x > 0 && this.bigenough(size2find, (newRect = new Rectangle(bigTestRect.x, bigTestRect.y, cantBeHereRect.x - bigTestRect.x, bigTestRect.height)).getSize())) {
                        this.addWithoutDuplicates(workRects, newRect);
                    }
                    if (bigTestRect.x + bigTestRect.width - (cantBeHereRect.x + cantBeHereRect.width) <= 0 || !this.bigenough(size2find, (newRect = new Rectangle(cantBeHereRect.x + cantBeHereRect.width, bigTestRect.y, bigTestRect.x + bigTestRect.width - (cantBeHereRect.x + cantBeHereRect.width), bigTestRect.height)).getSize())) continue;
                    this.addWithoutDuplicates(workRects, newRect);
                }
                availableRects = workRects;
            }
            if (availableRects.size() == 0) {
                this.x = masterRect.x + 15;
                this.y = masterRect.y + size2find.height + 45;
            } else {
                int bestY = 5555;
                int bestX = masterRect.x;
                for (int index = 0; index < availableRects.size(); ++index) {
                    tempRect = (Rectangle)availableRects.elementAt(index);
                    if (tempRect.y < bestY) {
                        bestY = tempRect.y;
                        bestX = tempRect.x;
                        continue;
                    }
                    if (tempRect.y != bestY || tempRect.x >= bestX) continue;
                    bestY = tempRect.y;
                    bestX = tempRect.x;
                }
                this.x = bestX + 15;
                this.y = bestY + 15;
            }
        }

        private void addWithoutDuplicates(Vector workRects, Rectangle newRect) {
            for (int index = 0; index < workRects.size(); ++index) {
                Rectangle tempRect = (Rectangle)workRects.elementAt(index);
                if (tempRect.x != newRect.x || tempRect.y != newRect.y || tempRect.width != newRect.width || tempRect.height != newRect.height) continue;
                return;
            }
            workRects.addElement(newRect);
        }

        private boolean bigenough(Dimension desired, Dimension test) {
            return desired.width <= test.width && desired.height <= test.height;
        }
    }

    class ColumnMouseListener
    extends MouseAdapter {
        ColumnMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if ((e.getModifiers() & 4) == 0) {
                if (!TablesAndRelsView.this.m_colDragging) {
                    TablesAndRelsView.this.repaint();
                    return;
                }
                TablesAndRelsView.this.m_colDragging = false;
                int curX = e.getX();
                int curY = e.getY();
                for (Component curComp = (Component)e.getSource(); TablesAndRelsView.this != curComp; curComp = curComp.getParent()) {
                    curX += curComp.getLocation().x;
                    curY += curComp.getLocation().y;
                }
                TablesAndRelsTableView targetTable = TablesAndRelsView.this.getTableViewAt(curX, curY);
                if (targetTable != null) {
                    if (targetTable == TablesAndRelsView.this.m_dragStartTable) {
                        TablesAndRelsView.this.repaint();
                        return;
                    }
                    Point colPoint = new Point(curX - targetTable.getLocation().x, curY - targetTable.getLocation().y);
                    Column targetCol = targetTable.getColumnAtPoint(colPoint);
                    if (targetCol != null) {
                        try {
                            TablesAndRelsView.this.m_query.addJoinRelationship(TablesAndRelsView.this.m_dragStartColumn, targetCol);
                            TablesAndRelsView.this.m_joinHasDrawn = true;
                            TablesAndRelsView.this.m_query.isValidSql();
                            TablesAndRelsView.this.endQueryChange();
                        }
                        catch (Exception ex) {
                            TablesAndRelsView.this.addInternalError(ex);
                        }
                    }
                } else {
                    ((Component)e.getSource()).requestFocus();
                }
                TablesAndRelsView.this.repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if ((e.getModifiers() & 4) == 0) {
                TablesAndRelsView.this.m_dragPoint = new Point(e.getX(), e.getY());
            }
        }
    }

    class ColumnMouseMotionListener
    extends MouseMotionAdapter {
        ColumnMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Component curComp;
            int curX = e.getX();
            int curY = e.getY();
            for (curComp = (Component)e.getSource(); TablesAndRelsView.this != curComp; curComp = curComp.getParent()) {
                curX += curComp.getLocation().x;
                curY += curComp.getLocation().y;
            }
            TablesAndRelsTableView targetTable = TablesAndRelsView.this.getTableViewAt(curX, curY);
            if (TablesAndRelsView.this.m_colDragging) {
                curComp = TablesAndRelsView.this.getComponentAt(curX, curY);
                if (targetTable != null && targetTable != TablesAndRelsView.this.m_dragStartTable) {
                    targetTable.requestFocus();
                    Point columnPoint = new Point(curX - targetTable.getLocation().x, curY - targetTable.getLocation().y);
                    Column targetCol = targetTable.getColumnAtPoint(columnPoint);
                    if (targetCol == null) {
                        TablesAndRelsView.this.m_dragCurRect.setBounds(curX, curY, 0, 0);
                        TablesAndRelsView.this.m_colDropVaild = false;
                    } else {
                        targetTable.setSelection(columnPoint);
                        TablesAndRelsView.this.m_dragCurRect = targetTable.getJoinRectangle(targetTable.getSelectedColumn());
                        TablesAndRelsView.this.m_dragCurRect.setLocation(TablesAndRelsView.this.m_dragCurRect.getLocation().x + targetTable.getLocation().x, TablesAndRelsView.this.m_dragCurRect.getLocation().y + targetTable.getLocation().y + 2);
                    }
                } else {
                    TablesAndRelsView.this.m_dragCurRect.setBounds(curX, curY, 0, 0);
                    TablesAndRelsView.this.m_colDropVaild = false;
                }
            } else if (targetTable != null) {
                Point p = e.getPoint();
                if (Math.abs(TablesAndRelsView.this.m_dragPoint.x - p.x) < 3 && Math.abs(TablesAndRelsView.this.m_dragPoint.x - p.x) < 3) {
                    return;
                }
                TablesAndRelsView.this.m_colDragging = true;
                TablesAndRelsView.this.m_dragStartRect = targetTable.getJoinRectangle(targetTable.getSelectedColumn());
                TablesAndRelsView.this.m_dragStartRect.setLocation(TablesAndRelsView.this.m_dragStartRect.getLocation().x + targetTable.getLocation().x, TablesAndRelsView.this.m_dragStartRect.getLocation().y + targetTable.getLocation().y + 2);
                TablesAndRelsView.this.m_dragStartColumn = targetTable.getSelectedColumn();
                TablesAndRelsView.this.m_dragStartTable = targetTable;
                TablesAndRelsView.this.m_dragCurRect.setBounds(curX, curY, 0, 0);
            }
            TablesAndRelsView.this.m_draggingPanel.repaint();
        }
    }

    public class ColumnViewChangeListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            TablesAndRelsView.this.m_joinsRelationshipPanel.repaint();
        }
    }

    protected class TableComponentListener
    extends ComponentAdapter {
        protected TableComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            TablesAndRelsView.this.m_joinsRelationshipPanel.repaint();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            TablesAndRelsView.this.m_joinsRelationshipPanel.repaint();
        }
    }
}

