/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.QueryConfiguration;
import com.sas.query.QueryUtils;
import com.sas.query.models.Column;
import com.sas.query.models.ColumnList;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ResultItem;
import com.sas.query.models.ResultItemList;
import com.sas.query.models.Table;
import com.sas.query.visuals.AddTableDialog;
import com.sas.query.visuals.ImageHandler;
import com.sas.query.visuals.PopMenuItem;
import com.sas.query.visuals.QueryComponentDialog;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.StandardView;
import com.sas.query.visuals.TablePropertyView;
import com.sas.query.visuals.TablesAndRelsView;
import com.sas.query.visuals.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeListener;

public class TablesAndRelsTableView
extends StandardView {
    protected static QueryResource bundle = new QueryResource(TablesAndRelsTableView.class);
    public static final int UNITIALIZED = -32153;
    protected static final int INTERLINE_SPACE = 2;
    protected static final int LEFT_MARGIN = 6;
    protected static final int RIGHT_MARGIN = 6;
    protected static final int DEFAULT_WIDTH = 140;
    protected static final int DEFAULT_HEIGHT = 140;
    protected TablesAndRelsView m_parent;
    protected Query m_query;
    protected Table m_table;
    protected int m_descent = 0;
    protected int m_lineHeight = 0;
    protected ImageIcon m_blankImage;
    protected ImageIcon m_filterImage;
    protected ColumnList m_columnsInWhere;
    protected int m_selectedIndex = -1;
    protected JScrollPane m_scrollPane;
    protected JList m_list;
    protected ColumnDisplayVector m_colDisplayVector;
    protected JPopupMenu m_tablePopupMenu;
    protected JPopupMenu m_columnPopupMenu;
    protected JLabel m_titleBar;
    protected JPanel m_titlePanel;
    protected TableFocusListner m_tableFocusListner;
    protected Vector columnMouseMotionListeners = new Vector();
    protected boolean m_bReadyToDrag = false;
    protected boolean m_bDragging = false;
    protected Point m_lastMousePoint = new Point(0, 0);
    protected boolean m_bResizing = false;

    public TablesAndRelsTableView(Query query, TablesAndRelsView parent, Table table) {
        super(query);
        this.m_query = query;
        this.m_parent = parent;
        this.m_table = table;
        this.setLocation(-32153, -32153);
        query.addPropertyListener(this, 8 | 0x400);
        this.m_tableFocusListner = new TableFocusListner();
        this.setSize(140, 140);
        this.setPreferredSize(new Dimension(140, 140));
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.m_titleBar = new JLabel();
        this.m_titleBar.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 1));
        this.m_titleBar.setToolTipText(table.getDataSourceTable().getQualifiedName());
        this.m_titlePanel = new JPanel();
        this.m_titlePanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.m_titlePanel.setLayout(new BorderLayout());
        this.m_titlePanel.add(this.m_titleBar);
        Font titleFont = this.m_titleBar.getFont();
        Font newTitleFont = new Font(titleFont.getName(), 1 | titleFont.getStyle(), titleFont.getSize());
        this.m_titleBar.setFont(newTitleFont);
        this.setSize(140, this.getSize().height);
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 11;
        c.weightx = 1.0;
        c.weighty = 0.0;
        gbl.setConstraints(this.m_titlePanel, c);
        this.m_titleBar.setSize(140, 10);
        this.m_titleBar.setOpaque(true);
        this.m_titleBar.addMouseListener(new TitleBarMouseListner());
        this.m_titleBar.addMouseMotionListener(new TitleBarMouseMotionListner());
        this.m_titleBar.addFocusListener(this.m_tableFocusListner);
        this.add(this.m_titlePanel);
        this.addMouseListener(new TableMouseListner());
        this.addMouseMotionListener(new TableMouseMotionListner());
        this.addFocusListener(this.m_tableFocusListner);
        this.m_scrollPane = new JScrollPane();
        WindowUtil.fixupJScrollPane(this.m_scrollPane);
        this.m_list = new JList(){

            @Override
            public String getToolTipText(MouseEvent e) {
                JList colList = (JList)e.getSource();
                int index = colList.locationToIndex(e.getPoint());
                if (index < 0 || index >= TablesAndRelsTableView.this.m_table.getColumns().size()) {
                    return null;
                }
                Column tipColumn = TablesAndRelsTableView.this.getColumn(index);
                if (tipColumn.getLabel() != tipColumn.getName()) {
                    return tipColumn.getLabel();
                }
                return null;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void processMouseMotionEvent(MouseEvent e) {
                if (e.getID() == 506) {
                    if ((e.getModifiers() & 4) == 0) {
                        int i = 0;
                        while (i < TablesAndRelsTableView.this.columnMouseMotionListeners.size()) {
                            ((MouseMotionAdapter)TablesAndRelsTableView.this.columnMouseMotionListeners.elementAt(i)).mouseDragged(e);
                            ++i;
                        }
                        return;
                    }
                }
                if (e.getID() == 503) {
                    if ((e.getModifiers() & 4) == 0) {
                        TablesAndRelsTableView.this.m_parent.setCursor(Cursor.getPredefinedCursor(0));
                        return;
                    }
                }
                super.processMouseMotionEvent(e);
            }
        };
        this.m_list.setCellRenderer(new TableColumnCellRenderer());
        this.m_list.addMouseListener(new ListMouseListner());
        this.m_list.addFocusListener(this.m_tableFocusListner);
        this.m_list.addKeyListener(new myKeyListener());
        this.m_scrollPane.getViewport().setView(this.m_list);
        this.m_scrollPane.setVisible(true);
        this.m_list.setVisible(true);
        this.setVisible(true);
        ToolTipManager.sharedInstance().registerComponent(this.m_list);
        this.m_list.setSelectionMode(0);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        gbl.setConstraints(this.m_scrollPane, c);
        this.add(this.m_scrollPane);
        this.revalidate();
        this.m_blankImage = ImageHandler.getImageIcon(bundle, "blank9x9Icon");
        this.m_filterImage = ImageHandler.getImageIcon(bundle, "smallFilterIcon");
        this.requestFocus();
        this._refresh();
        this.m_query.addPropertyListener(this, 1036);
        this.addKeyListener(new myKeyListener());
    }

    @Override
    public void closing() {
        this.m_query.removePropertyListener(this);
    }

    public int getHeaderHeight() {
        return this.m_titlePanel.getHeight();
    }

    public Table getTable() {
        return this.m_table;
    }

    public Column getColumn(int index) {
        return this.m_table.getColumns().elementAt(index);
    }

    protected void _addResultItems(Table table) {
        ColumnList columnList = table.getColumns();
        for (int index = 0; index < columnList.size(); ++index) {
            this._addResultItem(columnList.elementAt(index));
        }
    }

    protected void _addResultItem(Column column) {
        ResultItem item = this.m_query.addResultItem(column);
        if (this.m_query.isShowLabels() && !column.getLabel().equals(item.getDisplayName())) {
            item.setLabel(QueryUtils.stripAndDouble(column.getLabel(), '\'', "'"));
        }
        item.setFormat(column.getFormat());
        item.setInformat(column.getInformat());
    }

    public void onAction() {
        if (this.getSelectedIndex() != -1) {
            Column column = this.getSelectedColumn();
            this._addResultItem(column);
        } else {
            this.m_parent.onEditTable();
        }
    }

    public void onAction(Point point) {
        this.setSelection(point);
        this.onAction();
    }

    public void onEditTable() {
        TablePropertyView propertyPanel = new TablePropertyView(this.m_table);
        QueryComponentDialog editDialog = new QueryComponentDialog(WindowUtil.getParentFrame(this), this.m_query, propertyPanel, "Table.Title.txt");
        editDialog.setModal(true);
        editDialog.pack();
        WindowUtil.centerOverWindow(editDialog, this.getParent());
        WindowUtil.busyOn(this);
        try {
            editDialog.setVisible(true);
        }
        catch (Throwable t) {
            WindowUtil.busyOff(this);
            this.m_query.getMessageHandler().addInternalError(t);
        }
        WindowUtil.busyOff(this);
        propertyPanel.closing();
        this.firePropertyChanges();
    }

    public void onInsertColumn() {
        this.busyOn();
        try {
            this._addResultItem(((ColumnDisplayVector.ColumnDisplayObject)this.m_list.getSelectedValue()).m_column);
        }
        catch (Throwable t) {
            this.busyOff();
            this.m_query.getMessageHandler().addInternalError(t);
        }
        this.busyOff();
    }

    public void onOrderBy() {
        Column column = this.getSelectedColumn();
        this.m_query.addOrderItem(column);
        this.m_query.getPropertyChangeHandler().firePropertyChanges();
    }

    public void onAddResultItem() {
        Column column = this.getSelectedColumn();
        this._addResultItem(column);
        this.m_query.getPropertyChangeHandler().firePropertyChanges();
    }

    public void onAddAllResultItems() {
        this.busyOn();
        try {
            this._addResultItems(this.m_table);
        }
        catch (Throwable t) {
            this.busyOff();
            this.m_query.getMessageHandler().addInternalError(t);
        }
        this.busyOff();
        this.m_query.getPropertyChangeHandler().firePropertyChanges();
    }

    public void setSelection(Point point) {
        this.m_selectedIndex = this.getColumnIndexAtPoint(point);
        this.m_list.setSelectedIndex(this.m_selectedIndex);
        this.m_parent.setSelectedTable(this);
    }

    public int getColumnIndexAtPoint(Point point) {
        Point listPoint = new Point(point);
        listPoint.x = listPoint.x - this.m_scrollPane.getLocation().x - this.m_list.getLocation().x;
        listPoint.y = listPoint.y - this.m_scrollPane.getLocation().y - this.m_list.getLocation().y;
        if (listPoint.x < 0 || listPoint.y < 0) {
            return -1;
        }
        return this.m_list.locationToIndex(listPoint);
    }

    public Column getColumnAtPoint(Point point) {
        int colIndex = this.getColumnIndexAtPoint(point);
        if (colIndex < 0 || colIndex >= this.m_colDisplayVector.size()) {
            return null;
        }
        return this.m_colDisplayVector.columnAt(colIndex);
    }

    public Rectangle getColumnBounds(Point point) {
        int columnIndex = this.getColumnIndexAtPoint(point);
        if (columnIndex == -1) {
            return null;
        }
        return this.getColumnBounds(columnIndex);
    }

    public Rectangle getColumnBounds(int i) {
        if (!(i >= this.m_list.getFirstVisibleIndex() && i <= this.m_list.getLastVisibleIndex() || i >= this.m_list.getFirstVisibleIndex() && this.m_list.getLastVisibleIndex() == -1 && this.m_list.getFirstVisibleIndex() != -1)) {
            return null;
        }
        Rectangle colRect = this.m_list.getCellBounds(i, i);
        if (colRect == null) {
            return null;
        }
        colRect.x = colRect.x + this.m_scrollPane.getLocation().x + this.m_list.getLocation().x;
        colRect.y = colRect.y + this.m_scrollPane.getLocation().y + this.m_list.getLocation().y;
        return colRect;
    }

    public Column getSelectedColumn() {
        int selectedIndex = this.m_list.getSelectedIndex();
        if (selectedIndex == -1) {
            return null;
        }
        return this.m_colDisplayVector.columnAt(selectedIndex);
    }

    public int getSelectedIndex() {
        return this.m_list.getSelectedIndex();
    }

    public Rectangle getColumnBounds(Column column) {
        ColumnList columnList = this.m_table.getColumns();
        for (int columnIndex = 0; columnIndex < columnList.size(); ++columnIndex) {
            if (columnList.elementAt(columnIndex) != column) continue;
            return this.getColumnBounds(columnIndex);
        }
        return null;
    }

    public Rectangle getJoinRectangle(Column column) {
        Rectangle retRect = this.getColumnBounds(column);
        if (retRect != null) {
            retRect.width = this.getWidth();
            retRect.x = 0;
        } else {
            int colIndex = this.m_colDisplayVector.indexOf(column);
            retRect = colIndex < this.m_list.getFirstVisibleIndex() ? new Rectangle(0, 0, this.getWidth(), 10) : new Rectangle(0, this.getHeight() - 11, this.getWidth(), 11);
        }
        return retRect;
    }

    public void addColumnMouseListener(MouseAdapter listener) {
        this.m_list.addMouseListener(listener);
    }

    public void removeColumnMouseListner(MouseAdapter listener) {
        this.m_list.removeMouseListener(listener);
    }

    public void addColumnMouseMotionListener(MouseMotionAdapter listener) {
        this.columnMouseMotionListeners.addElement(listener);
    }

    public void removeColumnMouseMotionListner(MouseMotionAdapter listener) {
        this.columnMouseMotionListeners.removeElement(listener);
    }

    public void addColumnViewChangeListener(ChangeListener listener) {
        this.m_scrollPane.getViewport().addChangeListener(listener);
    }

    public void removeColumnViewChangeListner(ChangeListener listener) {
        this.m_scrollPane.getViewport().removeChangeListener(listener);
    }

    public JPopupMenu getTablePopmenu() {
        this.m_tablePopupMenu = this.m_parent.getOverallPopmenu();
        this.m_tablePopupMenu.insert(new JPopupMenu.Separator(), 0);
        this.m_tablePopupMenu.insert(new PopMenuItem(bundle.getString("TARTV.DeleteTable.txt"), "onDeleteTable", this), 0);
        this.m_tablePopupMenu.insert(new PopMenuItem(bundle.getString("TARTV.EditTable....txt"), "onEditTable", this), 0);
        this.m_tablePopupMenu.insert(new PopMenuItem(bundle.getString("TARTV.AddAllColumnsToResults.txt"), "onAddAllResultItems", this), 0);
        return this.m_tablePopupMenu;
    }

    public JPopupMenu getColumnPopmenu() {
        this.m_columnPopupMenu = this.getTablePopmenu();
        this.m_columnPopupMenu.insert(new JPopupMenu.Separator(), 0);
        this.m_columnPopupMenu.insert(new PopMenuItem(bundle.getString("TARTV.AddToResults.txt"), "onAddResultItem", this), 0);
        return this.m_columnPopupMenu;
    }

    public void onInsertTable() {
        AddTableDialog dialog = new AddTableDialog(this.m_query, WindowUtil.getParentFrame(this));
        dialog.setVisible(true);
    }

    public void onDeleteTable() {
        if (QueryConfiguration.getConfigurationBoolean("DeleteTableFromQueryWarningDialogEnabled.notrans", true)) {
            Object[] options = new Object[]{bundle.getString("Standard.ButtonLabel.Yes.txt"), bundle.getString("Standard.ButtonLabel.No.txt")};
            int annoyedUserSays = JOptionPane.showOptionDialog(null, bundle.messageString("TablesAndRels.Label.DeleteTable.txt"), bundle.messageString("Title.Confirm.txt"), 0, 3, null, options, options[0]);
            if (annoyedUserSays != 0) {
                this.requestFocus();
                return;
            }
        }
        this.m_query.deleteTable(this.m_table);
        this.endQueryChange();
    }

    protected void _refresh() {
        this.m_titleBar.setText(this.m_table.getDisplayName());
        if (this.m_colDisplayVector == null || this.m_colDisplayVector.m_cList != this.m_table.getColumns()) {
            this.m_colDisplayVector = new ColumnDisplayVector(this.m_table.getColumns());
            this.m_list.setListData(this.m_colDisplayVector);
        }
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        this._refresh();
        this.repaint();
    }

    class TableFocusListner
    extends FocusAdapter {
        TableFocusListner() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            TablesAndRelsTableView.this.m_titleBar.setBackground(SystemColor.activeCaption);
            TablesAndRelsTableView.this.m_titleBar.setForeground(SystemColor.activeCaptionText);
            if (TablesAndRelsTableView.this.getParent() instanceof JLayeredPane) {
                ((JLayeredPane)TablesAndRelsTableView.this.getParent()).moveToFront(TablesAndRelsTableView.this);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            TablesAndRelsTableView.this.m_titleBar.setBackground(SystemColor.inactiveCaption);
            TablesAndRelsTableView.this.m_titleBar.setForeground(SystemColor.inactiveCaptionText);
        }
    }

    class TitleBarMouseListner
    extends MouseAdapter {
        TitleBarMouseListner() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (TablesAndRelsTableView.this.getParent() instanceof JLayeredPane) {
                ((JLayeredPane)TablesAndRelsTableView.this.getParent()).moveToFront(TablesAndRelsTableView.this);
            }
            TablesAndRelsTableView.this.requestFocus();
            if ((e.getModifiers() & 4) == 0) {
                TablesAndRelsTableView.this.m_parent.setSelectedTable(TablesAndRelsTableView.this);
                if (e.getClickCount() == 2) {
                    e.consume();
                    TablesAndRelsTableView.this.m_parent.onEditTable();
                    TablesAndRelsTableView.this.firePropertyChanges();
                    TablesAndRelsTableView.this.displayMessages();
                } else {
                    e.consume();
                    TablesAndRelsTableView.this.m_bReadyToDrag = true;
                    TablesAndRelsTableView.this.m_lastMousePoint.x = e.getX();
                    TablesAndRelsTableView.this.m_lastMousePoint.y = e.getY();
                }
                return;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if ((e.getModifiers() & 4) == 0) {
                TablesAndRelsTableView.this.m_bReadyToDrag = false;
                TablesAndRelsTableView.this.m_bDragging = false;
            } else if ((e.getModifiers() & 4) != 0) {
                JPopupMenu popmenu = null;
                popmenu = TablesAndRelsTableView.this.getTablePopmenu();
                if (popmenu != null) {
                    JComponent source = (JComponent)TablesAndRelsTableView.this.getParent();
                    source.add(popmenu);
                    popmenu.setVisible(true);
                    popmenu.show(source, TablesAndRelsTableView.this.getLocation().x + e.getX(), TablesAndRelsTableView.this.getLocation().y + e.getY());
                    return;
                }
            }
        }
    }

    class TitleBarMouseMotionListner
    extends MouseMotionAdapter {
        TitleBarMouseMotionListner() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            TablesAndRelsTableView.this.m_parent.setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (TablesAndRelsTableView.this.m_bReadyToDrag) {
                Point p = e.getPoint();
                if (Math.abs(TablesAndRelsTableView.this.m_lastMousePoint.x - p.x) > 2 || Math.abs(TablesAndRelsTableView.this.m_lastMousePoint.y - p.y) > 2) {
                    TablesAndRelsTableView.this.m_bDragging = true;
                    TablesAndRelsTableView.this.m_bReadyToDrag = false;
                }
            }
            if (TablesAndRelsTableView.this.m_bDragging) {
                int curX = Math.max(e.getX(), -TablesAndRelsTableView.this.getLocation().x);
                int curY = Math.max(e.getY(), -TablesAndRelsTableView.this.getLocation().y);
                Point newpos = new Point(Math.max(TablesAndRelsTableView.this.getX() + (curX - TablesAndRelsTableView.this.m_lastMousePoint.x), 0), Math.max(TablesAndRelsTableView.this.getY() + (curY - TablesAndRelsTableView.this.m_lastMousePoint.y), 0));
                TablesAndRelsTableView.this.setLocation(newpos);
                TablesAndRelsTableView.this.m_parent.resizeForNodes();
                TablesAndRelsTableView.this.revalidate();
            }
        }
    }

    class TableMouseListner
    extends MouseAdapter {
        TableMouseListner() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if ((e.getModifiers() & 4) == 0) {
                TablesAndRelsTableView.this.m_bResizing = true;
                TablesAndRelsTableView.this.m_lastMousePoint.x = e.getX();
                TablesAndRelsTableView.this.m_lastMousePoint.y = e.getY();
                return;
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if ((event.getModifiers() & 4) == 0) {
                TablesAndRelsTableView.this.revalidate();
                TablesAndRelsTableView.this.m_bResizing = false;
            }
        }
    }

    class TableMouseMotionListner
    extends MouseMotionAdapter {
        TableMouseMotionListner() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (TablesAndRelsTableView.this.m_bResizing) {
                Dimension curSize = TablesAndRelsTableView.this.getSize();
                Dimension newSize = new Dimension(curSize);
                Point curLocation = TablesAndRelsTableView.this.getLocation();
                Point newLocation = new Point(curLocation);
                int curX = e.getX();
                int curY = e.getY();
                int curCursorType = TablesAndRelsTableView.this.m_parent.getCursor().getType();
                int change = 0;
                int minWidth = TablesAndRelsTableView.this.getMinimumSize().width;
                int minHeight = TablesAndRelsTableView.this.getMinimumSize().height;
                curX = Math.max(curX, -curLocation.x);
                curY = Math.max(curY, -curLocation.y);
                if (curCursorType == 8) {
                    newSize.height = Math.max(curSize.height - curY, minHeight);
                    change = newSize.height - curSize.height;
                    newLocation.y = curLocation.y - change;
                } else if (curCursorType == 6) {
                    newSize.height = Math.max(curSize.height - curY, minHeight);
                    change = newSize.height - curSize.height;
                    newLocation.y = curLocation.y - change;
                    newSize.width = Math.max(curSize.width - curX, minWidth);
                    change = newSize.width - curSize.width;
                    newLocation.x = curLocation.x - change;
                } else if (curCursorType == 10) {
                    newSize.width = Math.max(curSize.width - curX, minWidth);
                    change = newSize.width - curSize.width;
                    newLocation.x = curLocation.x - change;
                } else if (curCursorType == 4) {
                    newSize.height = Math.max(curY, minHeight);
                    newSize.width = Math.max(curSize.width - curX, minWidth);
                    change = newSize.width - curSize.width;
                    newLocation.x = curLocation.x - change;
                } else if (curCursorType == 9) {
                    newSize.height = Math.max(curY, minHeight);
                } else if (curCursorType == 5) {
                    newSize.height = Math.max(curY, minHeight);
                    newSize.width = Math.max(curX, minWidth);
                } else if (curCursorType == 11) {
                    newSize.width = Math.max(curX, minWidth);
                } else if (curCursorType == 7) {
                    newSize.height = Math.max(curSize.height - curY, minHeight);
                    change = newSize.height - curSize.height;
                    newLocation.y = curLocation.y - change;
                    newSize.width = Math.max(curX, minWidth);
                } else {
                    return;
                }
                TablesAndRelsTableView.this.setSize(newSize);
                TablesAndRelsTableView.this.setLocation(newLocation);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!TablesAndRelsTableView.this.m_bResizing) {
                Dimension maxSize = TablesAndRelsTableView.this.getSize();
                int maxX = maxSize.width;
                int maxY = maxSize.height;
                int curX = e.getX();
                int curY = e.getY();
                int newCursor = curX <= 5 && curY <= 5 ? 6 : (curX <= 5 && curY >= maxY - 5 ? 4 : (curX >= maxX - 5 && curY <= 5 ? 7 : (curX >= maxX - 5 && curY >= maxY - 5 ? 5 : (curY <= 5 ? 8 : (curX <= 5 ? 10 : (curX >= maxX - 5 ? 11 : (curY >= maxY - 5 ? 9 : 0)))))));
                Cursor existingCursor = TablesAndRelsTableView.this.m_parent.getCursor();
                if (existingCursor == null || newCursor != existingCursor.getType()) {
                    TablesAndRelsTableView.this.m_parent.setCursor(Cursor.getPredefinedCursor(newCursor));
                }
            }
        }
    }

    class TableColumnCellRenderer
    extends DefaultListCellRenderer {
        protected Font m_normalFont;
        protected Font m_boldFont;
        protected Column m_column;

        public TableColumnCellRenderer() {
            this.m_normalFont = TablesAndRelsTableView.this.getFont();
            this.m_boldFont = new Font(this.m_normalFont.getName(), 1 | this.m_normalFont.getStyle(), this.m_normalFont.getSize());
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.m_column = ((ColumnDisplayVector.ColumnDisplayObject)value).m_column;
            if (isSelected && (TablesAndRelsTableView.this.hasFocus() || list.hasFocus())) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
                if (this.m_column.isIndexed()) {
                    this.setForeground(Color.blue);
                }
            }
            TablesAndRelsTableView.this.m_table.getColumns();
            TablesAndRelsTableView.this.m_columnsInWhere = TablesAndRelsTableView.this.m_query.getWhereFilterTree().getUsedColumns();
            ResultItemList m_resultItems = TablesAndRelsTableView.this.m_query.getResultItems();
            this.setFont(this.m_normalFont);
            block0: for (int resultIndex = 0; resultIndex < m_resultItems.size(); ++resultIndex) {
                ColumnList colList = m_resultItems.elementAt(resultIndex).getExpression().getReferencedColumns();
                for (int columnIndex = 0; colList != null && columnIndex < colList.size(); ++columnIndex) {
                    if (colList.elementAt(columnIndex) != this.m_column) continue;
                    this.setFont(this.m_boldFont);
                    continue block0;
                }
            }
            ColumnList columnsInWhere = TablesAndRelsTableView.this.m_query.getWhereFilterTree().getUsedColumns();
            this.setIcon(TablesAndRelsTableView.this.m_blankImage);
            for (int whereIndex = 0; TablesAndRelsTableView.this.m_filterImage != null && whereIndex < columnsInWhere.size(); ++whereIndex) {
                if (columnsInWhere.elementAt(whereIndex) != this.m_column) continue;
                this.setIcon(TablesAndRelsTableView.this.m_filterImage);
                break;
            }
            this.setIconTextGap(18);
            this.setText(value.toString());
            return this;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            ImageIcon icon = WindowUtil.getDataTypeIcon(this.m_column.getDataType());
            if (icon != null) {
                icon.paintIcon(this, g, TablesAndRelsTableView.this.m_filterImage.getIconWidth() + 1, (this.getHeight() - icon.getIconHeight()) / 2);
            }
        }
    }

    class ListMouseListner
    extends MouseAdapter {
        int previouslySelectedRow = -1;
        MouseEvent previousMouseEvent = null;

        ListMouseListner() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (TablesAndRelsTableView.this.getParent() instanceof JLayeredPane) {
                ((JLayeredPane)TablesAndRelsTableView.this.getParent()).moveToFront(TablesAndRelsTableView.this);
            }
            TablesAndRelsTableView.this.requestFocus();
            TablesAndRelsTableView.this.m_parent.setSelectedTable(TablesAndRelsTableView.this);
            super.mousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            long timeDiff;
            int selectedRow = TablesAndRelsTableView.this.m_list.locationToIndex(e.getPoint());
            int clickCount = e.getClickCount();
            if (this.previousMouseEvent != null && selectedRow == this.previouslySelectedRow && (timeDiff = e.getWhen() - this.previousMouseEvent.getWhen()) < 900L && e.getClickCount() < 2 && !e.isPopupTrigger()) {
                if ((e.getModifiers() & 4) == 0) {
                    ++clickCount;
                }
            }
            if (selectedRow != -1) {
                this.previousMouseEvent = e;
                this.previouslySelectedRow = selectedRow;
            }
            if (e.isPopupTrigger()) {
                int index = TablesAndRelsTableView.this.m_list.locationToIndex(e.getPoint());
                if (index == -1) {
                    return;
                }
                TablesAndRelsTableView.this.m_list.setSelectedIndex(index);
                JPopupMenu popmenu = null;
                popmenu = TablesAndRelsTableView.this.getColumnPopmenu();
                if (popmenu != null) {
                    JComponent source = (JComponent)e.getSource();
                    source.add(popmenu);
                    popmenu.show(source, e.getX(), e.getY());
                    return;
                }
            } else if (clickCount == 2) {
                if (TablesAndRelsTableView.this.m_list.getSelectedIndex() > -1) {
                    TablesAndRelsTableView.this.onInsertColumn();
                    selectedRow = -1;
                    TablesAndRelsTableView.this.m_parent.m_addDataItem = true;
                    this.previousMouseEvent = null;
                    TablesAndRelsTableView.this.m_query.getPropertyChangeHandler().firePropertyChanges();
                }
            } else {
                super.mouseReleased(e);
            }
        }
    }

    class myKeyListener
    implements KeyListener {
        myKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getID() != 401) {
                return;
            }
            switch (event.getKeyCode()) {
                case 27: {
                    TablesAndRelsTableView.this.m_parent.m_colDragging = false;
                    TablesAndRelsTableView.this.m_parent.repaint();
                    break;
                }
                case 127: {
                    TablesAndRelsTableView.this.onDeleteTable();
                    event.consume();
                    break;
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }
    }

    class ColumnDisplayVector
    extends Vector {
        ColumnList m_cList;

        protected ColumnDisplayVector(ColumnList cList) {
            this.m_cList = cList;
            for (int i = 0; i < cList.size(); ++i) {
                this.addElement(new ColumnDisplayObject(cList.elementAt(i)));
            }
        }

        public int indexOf(Column column) {
            for (int i = 0; i < this.size(); ++i) {
                if (column != ((ColumnDisplayObject)this.elementAt((int)i)).m_column) continue;
                return i;
            }
            return -1;
        }

        public Column columnAt(int index) {
            return ((ColumnDisplayObject)this.elementAt((int)index)).m_column;
        }

        class ColumnDisplayObject {
            Column m_column;
            String m_displayString;

            protected ColumnDisplayObject(Column col) {
                this.m_column = col;
                if (TablesAndRelsTableView.this.m_query.isShowLabels() && col.getLabel() != null && col.getLabel().length() > 0) {
                    String labelFmt = TablesAndRelsTableView.this.m_parent.getColumnLabelFormat();
                    if (labelFmt != null) {
                        Object[] args = new Object[]{col.getLabel(), col.getName()};
                        this.m_displayString = MessageFormat.format(labelFmt, args);
                    } else {
                        this.m_displayString = col.getLabel();
                    }
                } else {
                    this.m_displayString = col.getName();
                }
            }

            public String toString() {
                return this.m_displayString;
            }
        }
    }
}

