/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class SteppedComboBox
extends JComboBox {
    protected int popupWidth = 0;
    protected int minPopupWidth = 0;
    protected int shownCount = 0;

    protected void registerListeners() {
        this.addFocusListener(new ComboBoxFocusListener());
    }

    public SteppedComboBox(ComboBoxModel aModel) {
        super(aModel);
        this.setUI(new SteppedComboBoxUI());
        this.registerListeners();
    }

    public SteppedComboBox(Object[] items) {
        super(items);
        this.setUI(new SteppedComboBoxUI());
        this.registerListeners();
    }

    public SteppedComboBox(Vector items) {
        super(items);
        this.setUI(new SteppedComboBoxUI());
        this.registerListeners();
    }

    public SteppedComboBox() {
        this.setUI(new SteppedComboBoxUI());
        this.registerListeners();
    }

    public void setPopupWidth(int width) {
        this.popupWidth = width;
    }

    public void setMinPopupWidth(int width) {
        this.minPopupWidth = width;
    }

    public Dimension getPopupSize() {
        Dimension size = this.getSize();
        int width = size.width;
        width = this.popupWidth < 1 ? size.width : this.popupWidth;
        if (this.minPopupWidth > width) {
            width = this.minPopupWidth;
        }
        return new Dimension(width, size.height);
    }

    protected class ComboBoxFocusListener
    implements FocusListener {
        protected ComboBoxFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            SteppedComboBox.this.shownCount = 0;
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (SteppedComboBox.this.shownCount == 1) {
                SteppedComboBox.this.showPopup();
            }
        }
    }

    protected class SteppedComboBoxUI
    extends BasicComboBoxUI {
        protected SteppedComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            BasicComboPopup popup = new BasicComboPopup(this.comboBox){

                @Override
                public void show() {
                    ++SteppedComboBox.this.shownCount;
                    Dimension popupSize = ((SteppedComboBox)this.comboBox).getPopupSize();
                    popupSize.setSize(popupSize.width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
                    Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
                    this.scroller.setMaximumSize(popupBounds.getSize());
                    this.scroller.setPreferredSize(popupBounds.getSize());
                    this.scroller.setMinimumSize(popupBounds.getSize());
                    this.list.invalidate();
                    int selectedIndex = this.comboBox.getSelectedIndex();
                    if (selectedIndex == -1) {
                        this.list.clearSelection();
                    } else {
                        this.list.setSelectedIndex(selectedIndex);
                    }
                    this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
                    this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
                    if (this.comboBox.isShowing()) {
                        this.show(this.comboBox, popupBounds.x, popupBounds.y);
                    }
                }
            };
            popup.getAccessibleContext().setAccessibleParent(this.comboBox);
            return popup;
        }
    }
}

