/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.QueryTabView;
import com.sas.query.visuals.WindowUtil;
import com.sas.text.Message;
import com.sas.visuals.MessageBox;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.EventListener;
import java.util.Stack;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public abstract class StandardDialog
extends JDialog {
    public static final int OK = 1;
    public static final int CANCEL = 2;
    protected Query m_query;
    protected Container m_mainPanel;
    protected Frame m_parentFrame;
    protected int m_returnValue = 2;
    protected GridBagLayout m_gridBagLayout;
    protected JButton m_okButton;
    protected JButton m_closeButton;
    protected String m_strDialogResourceKey;
    protected String m_strTitle;
    protected String m_strOkLabel;
    protected String m_strCancelLabel;
    protected boolean m_layedOut;
    protected Component m_defaultFocus;
    static QueryResource bundle = new QueryResource(StandardDialog.class);
    protected KeyHandler m_keyHandler;

    public StandardDialog() {
        this.setBackground(SystemColor.control);
        this._initialization();
    }

    public StandardDialog(Frame parentFrame, boolean bModal) {
        super(parentFrame, " ", bModal);
        this.setBackground(SystemColor.control);
        this._initialization();
    }

    public StandardDialog(Query query, Frame parentFrame, boolean bModal) {
        this(parentFrame, bModal);
        this.setQuery(query);
    }

    public StandardDialog(Query query, Frame parentFrame, boolean bModal, Container mainPanel, String strDialogResourceKey) {
        this(query, parentFrame, bModal);
        this.setStrDialogResourceKey(strDialogResourceKey);
        this.setMainPanel(mainPanel);
    }

    public void onOK() {
        this.m_returnValue = 1;
        this.dispose();
    }

    protected void onCancel() {
        this.m_returnValue = 2;
        this.dispose();
    }

    public void busyOn() {
        WindowUtil.busyOn(this);
    }

    public void busyOff() {
        WindowUtil.busyOff(this);
    }

    public int getReturnValue() {
        return this.m_returnValue;
    }

    public void removeCancelButton() {
        this.m_closeButton.setVisible(false);
        this.adjustButtonSizes();
    }

    public void setOkLabel(String label) {
        this.m_strOkLabel = label;
        if (this.m_okButton != null) {
            this.m_okButton.setText(label);
            this.adjustButtonSizes();
        }
    }

    private void adjustButtonSizes() {
        Dimension dSize = this.m_okButton.getPreferredSize();
        Dimension eSize = this.m_closeButton.getPreferredSize();
        Dimension buttonSize = new Dimension(Math.max(eSize.width, dSize.width), Math.max(eSize.height, dSize.height));
        this.m_okButton.setMinimumSize(buttonSize);
        this.m_closeButton.setMinimumSize(buttonSize);
    }

    protected void _initialization() {
        this.m_strTitle = "Test Standard Dialog";
        this.m_strOkLabel = bundle.getString("Standard.ButtonLabel.Ok.txt");
        this.m_strCancelLabel = bundle.getString("Standard.ButtonLabel.Cancel.txt");
        this._layoutWidgets();
        this.m_keyHandler = new KeyHandler(this);
        this._addKeyListeners(this, this.m_keyHandler);
        this.m_okButton.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.m_okButton);
    }

    public void _layoutWidgets() {
        Container content = this.getContentPane();
        content.setBackground(SystemColor.control);
        this.setResizable(true);
        this.m_gridBagLayout = new GridBagLayout();
        content.setLayout(this.m_gridBagLayout);
        this.m_okButton = new JButton(this.m_strOkLabel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = new Insets(14, 8, 0, 12);
        this.m_gridBagLayout.setConstraints(this.m_okButton, gbc);
        content.add(this.m_okButton);
        this.m_okButton.addActionListener(new ActionHandler());
        this.m_closeButton = new JButton(this.m_strCancelLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = new Insets(8, 8, 8, 12);
        this.m_gridBagLayout.setConstraints(this.m_closeButton, gbc);
        content.add(this.m_closeButton);
        this.m_closeButton.addActionListener(new DialogCloser(this));
        this.adjustButtonSizes();
        this.setTitle(this.m_strTitle);
        this.addWindowListener(new DialogCloser(this));
    }

    protected void _addKeyListeners(Container container, KeyHandler keyHandler) {
        Component[] components = container.getComponents();
        for (int index = 0; index < components.length; ++index) {
            components[index].addKeyListener(keyHandler);
            if (!(components[index] instanceof Container)) continue;
            this._addKeyListeners((Container)components[index], keyHandler);
        }
    }

    public void setParentFrame(Frame parentFrame) {
        this.m_parentFrame = parentFrame;
    }

    public Frame getParentFrame() {
        return this.m_parentFrame;
    }

    public void setMainPanel(Component mainPanel) {
        this.setMainPanel((Container)mainPanel);
    }

    public void setMainPanel(Container mainPanel) {
        this.m_mainPanel = mainPanel;
        if (this.m_gridBagLayout == null) {
            this.m_gridBagLayout = new GridBagLayout();
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(14, 12, 12, 0);
        this.m_gridBagLayout.setConstraints(this.m_mainPanel, gbc);
        this.getContentPane().add(this.m_mainPanel);
        if (mainPanel instanceof JTabbedPane || mainPanel instanceof QueryTabView) {
            this.alignForTabbedPane();
        }
        this._addKeyListeners(mainPanel, this.m_keyHandler);
    }

    protected void alignForTabbedPane() {
        GridBagConstraints okGbc = this.m_gridBagLayout.getConstraints(this.m_okButton);
        Insets curInsets = okGbc.insets;
        curInsets.top += 24;
        this.m_gridBagLayout.setConstraints(this.m_okButton, okGbc);
    }

    public Component getMainPanel() {
        return this.m_mainPanel;
    }

    public void setQuery(Query query) {
        this.m_query = query;
    }

    public Query getQuery() {
        return this.m_query;
    }

    public void setStrDialogResourceKey(String resKey) {
        this.m_strDialogResourceKey = resKey;
    }

    public String getStrDialogResourceKey() {
        return this.m_strDialogResourceKey;
    }

    public void setDefaultFocus(Component component) {
        this.m_defaultFocus = component;
    }

    public Component setDefaultFocus() {
        return this.m_defaultFocus;
    }

    @Override
    public void show() {
        if (this.m_defaultFocus != null) {
            this.m_defaultFocus.requestFocus();
        }
        super.show();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.closing();
        this.removeAllListeners(this);
        if (this.m_keyHandler != null) {
            this.m_keyHandler.detach();
            this.m_keyHandler = null;
        }
        this.removeAll();
        this.m_mainPanel = null;
        this.m_parentFrame = null;
        this.m_gridBagLayout = null;
        this.m_okButton = null;
        this.m_closeButton = null;
        this.m_defaultFocus = null;
        this.m_strCancelLabel = null;
        this.m_strOkLabel = null;
        this.m_strTitle = null;
        if (this.getRootPane() != null) {
            this.removeAllListeners(this.getRootPane());
            this.setRootPane(null);
        }
        this.setTitle(null);
    }

    public void closing() {
    }

    protected void removeAllNotifies(Component component) {
        if (component != null) {
            if (component instanceof Container) {
                Component[] components = ((Container)component).getComponents();
                for (int index = 0; index < components.length; ++index) {
                    this.removeAllNotifies(components[index]);
                }
            }
            component.removeNotify();
        }
    }

    protected void removeAllListeners(Component component) {
        if (component != null) {
            EventListener[] listeners = null;
            Stack<Component> stack = new Stack<Component>();
            stack.push(component);
            while (!stack.empty()) {
                int i;
                Component comp = (Component)stack.pop();
                listeners = comp.getListeners(ComponentListener.class);
                for (i = 0; i < listeners.length; ++i) {
                    comp.removeComponentListener((ComponentListener)listeners[i]);
                }
                listeners = comp.getListeners(FocusListener.class);
                for (i = 0; i < listeners.length; ++i) {
                    comp.removeFocusListener((FocusListener)listeners[i]);
                }
                listeners = comp.getListeners(KeyListener.class);
                for (i = 0; i < listeners.length; ++i) {
                    comp.removeKeyListener((KeyListener)listeners[i]);
                }
                listeners = comp.getListeners(MouseListener.class);
                for (i = 0; i < listeners.length; ++i) {
                    comp.removeMouseListener((MouseListener)listeners[i]);
                }
                listeners = comp.getListeners(MouseMotionListener.class);
                for (i = 0; i < listeners.length; ++i) {
                    comp.removeMouseMotionListener((MouseMotionListener)listeners[i]);
                }
                if (comp instanceof Container) {
                    Container container = (Container)comp;
                    listeners = container.getListeners(ContainerListener.class);
                    for (int i2 = 0; i2 < listeners.length; ++i2) {
                        container.removeContainerListener((ContainerListener)listeners[i2]);
                    }
                    Component[] components = container.getComponents();
                    for (int index = 0; index < components.length; ++index) {
                        stack.push(components[index]);
                    }
                }
                if (comp instanceof Window) {
                    listeners = comp.getListeners(WindowListener.class);
                    for (int i3 = 0; i3 < listeners.length; ++i3) {
                        ((Window)comp).removeWindowListener((WindowListener)listeners[i3]);
                    }
                }
                if (comp instanceof Button) {
                    listeners = comp.getListeners(ActionListener.class);
                    for (int i4 = 0; i4 < listeners.length; ++i4) {
                        ((Button)comp).removeActionListener((ActionListener)listeners[i4]);
                    }
                }
                if (!(comp instanceof AbstractButton)) continue;
                listeners = comp.getListeners(ActionListener.class);
                for (int i5 = 0; i5 < listeners.length; ++i5) {
                    ((AbstractButton)comp).removeActionListener((ActionListener)listeners[i5]);
                }
            }
        }
    }

    protected void showException(Exception e) {
        e.printStackTrace();
        MessageBox mb = new MessageBox(this.m_parentFrame, bundle.messageString("StandardDialog.badExcMsgInQuery.txt"), true, Message.format((String)bundle.messageString("StandardDialog.badExcMsgInQuery.txt"), (Object)e.getMessage()), 1, 1, 2);
        mb.setVisible(true);
    }

    class KeyHandler
    extends KeyAdapter {
        StandardDialog m_dialog;

        public KeyHandler(StandardDialog dialog) {
            this.m_dialog = dialog;
        }

        public void detach() {
            this.m_dialog = null;
        }

        @Override
        public void keyTyped(KeyEvent event) {
            if (event.getKeyChar() == '\u001b') {
                this.m_dialog.onCancel();
            }
            if (event.getKeyChar() == '\r' && event.getSource() instanceof JTextField && this.m_dialog.m_okButton.isDefaultButton()) {
                this.m_dialog.onOK();
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == StandardDialog.this.m_okButton) {
                StandardDialog.this.onOK();
                return;
            }
        }
    }

    static final class DialogCloser
    extends WindowAdapter
    implements ActionListener {
        StandardDialog m_dialog;

        DialogCloser(StandardDialog dialog) {
            this.m_dialog = dialog;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.m_dialog.onCancel();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.m_dialog.onCancel();
        }
    }
}

