/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.datasources.Function;
import com.sas.query.datasources.FunctionConstants;
import com.sas.query.datasources.FunctionParameter;
import com.sas.query.models.Column;
import com.sas.query.models.CompoundExpression;
import com.sas.query.models.Expression;
import com.sas.query.models.ExpressionConstants;
import com.sas.query.models.ExpressionList;
import com.sas.query.models.Table;
import com.sas.query.models.UnparsedExpression;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.SqlTextHelperConstants;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeSupport;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class SqlTextHelper
implements ExpressionConstants,
FunctionConstants,
SqlTextHelperConstants {
    JPopupMenu m_mainPopmenu = null;
    Method m_sqlTextFieldCallBack = null;
    Expression m_myExp = null;
    transient ExpressionList m_myPreviousExpressions = null;
    CompoundExpression m_myParentExpression = null;
    int m_myPositionInParentExpression = -1;
    Query m_myQuery = null;
    int m_expectedType = 0;
    Table m_tableContext = null;
    String m_previousContents = "";
    JTextComponent m_widget = null;
    private int m_behaviorFlags = 0;
    protected transient PropertyChangeSupport m_pChanges;
    protected transient VetoableChangeSupport m_vChanges;
    protected transient String m_cursel = "";
    protected SQLTextChange aSQLTextChange;
    protected SQLKey aSQLKey;
    protected boolean ImBusy = false;
    protected static QueryResource bundle = new QueryResource(SqlTextHelper.class);

    public void initialize() {
        this.m_pChanges = new PropertyChangeSupport(this);
        this.m_vChanges = new VetoableChangeSupport(this);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_pChanges.addPropertyChangeListener(listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == null && newValue == null || oldValue != newValue && (oldValue == null || !oldValue.equals(newValue))) {
            this.m_pChanges.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_pChanges.removePropertyChangeListener(listener);
    }

    public boolean showExpressionBuilder() {
        return false;
    }

    public void setWidget(JTextComponent wid) {
        this.m_widget = wid;
        Insets i = wid.getMargin();
        if (i.left == 0) {
            i.left = 1;
        }
        wid.setMargin(i);
    }

    public JTextComponent getWidget() {
        return this.m_widget;
    }

    public void setBehavior(int flag) {
        if ((flag & 4) != 0 && (flag & 8) != 0) {
            this.m_myQuery.getMessageHandler().addError(bundle, "SqlTextHelper.cantDisplayToSQLAndDISPLAY.txt");
        }
        this.m_behaviorFlags |= flag;
        if ((flag & 8) != 0) {
            this.clearBehavior(4);
            this.recomputeDisplay();
        }
        if ((flag & 4) != 0) {
            this.clearBehavior(8);
            this.recomputeDisplay();
        }
        if ((flag & 0x200) != 0) {
            this.clearBehavior(1024);
        }
        if ((flag & 0x400) != 0) {
            this.clearBehavior(512);
        }
    }

    public void clearBehavior(int flag) {
        if (this.hasBehavior(flag)) {
            this.m_behaviorFlags ^= flag;
        }
    }

    public boolean hasBehavior(int flag) {
        return (this.m_behaviorFlags & flag) != 0;
    }

    public Table getTableContext() {
        return this.m_tableContext;
    }

    public void setTableContext(Table newTableContext) {
        this.m_tableContext = newTableContext;
    }

    public boolean hasTableContext() {
        return this.m_tableContext != null;
    }

    public void recomputeDisplay() {
        ExpressionList parmList = this.getMyExpressionsFromParent();
        String displayString = new String("");
        if (parmList.size() > 0) {
            Expression thisOne;
            this.m_myExp = thisOne = parmList.elementAt(0);
            if (thisOne != null) {
                displayString = displayString + this.getDisplayString(thisOne);
            }
            if (this.isCommaList()) {
                for (int i = 1; i < parmList.size(); ++i) {
                    thisOne = parmList.elementAt(i);
                    if (thisOne == null) continue;
                    if (displayString.trim().length() > 0) {
                        displayString = displayString + ", ";
                    }
                    displayString = displayString + this.getDisplayString(thisOne);
                }
            }
        }
        this.setMyOwnText(displayString);
    }

    public Query getQuery() {
        return this.m_myQuery;
    }

    public void setQuery(Query newquery) {
        this.m_myQuery = newquery;
    }

    protected void setMyOwnText(String text) {
        this.m_previousContents = text;
        if (this.ImBusy) {
            return;
        }
        this.ImBusy = true;
        this.getWidget().getDocument().removeDocumentListener(this.aSQLTextChange);
        this.getWidget().removeKeyListener(this.aSQLKey);
        this.getWidget().setText(text);
        this.getWidget().getDocument().addDocumentListener(this.aSQLTextChange);
        this.getWidget().addKeyListener(this.aSQLKey);
        this.getWidget().repaint();
        this.ImBusy = false;
    }

    public void addExpressionToCurrentText(Expression exp) {
        if (this.getExpression() == null) {
            this.setExpression(exp);
        } else if (!this.isCommaList()) {
            this.replaceSelectedWith(exp);
        } else {
            this.checkPoint();
            String displayString = this.getWidget().getText();
            if (SqlTextHelper.isMarkerToken(displayString.trim())) {
                displayString = "";
            }
            if (displayString.trim().length() > 0) {
                displayString = displayString + ", ";
            }
            if (this.getExpression() instanceof UnparsedExpression) {
                if (displayString.trim().length() == 0) {
                    this.setExpression(exp);
                } else {
                    displayString = displayString + exp.generateSQL(this.getQuery().getSqlLogic(), this.hasBehavior(2048) ? 2 : 1);
                    ((UnparsedExpression)this.getExpression()).setValue(displayString);
                    this.setMyOwnText(displayString);
                }
            } else {
                displayString = displayString + this.getDisplayString(exp);
                this.setMyOwnText(displayString);
                if (this.m_myParentExpression != null) {
                    this.m_myParentExpression.addParameter(exp);
                }
            }
        }
    }

    public boolean isContentReplaceable() {
        boolean answer = false;
        if (this.isEmpty()) {
            answer = true;
        }
        if (this.isJustAMarkerToken()) {
            answer = true;
        }
        return answer;
    }

    public boolean isEmpty() {
        boolean answer = false;
        if (this.getExpression() == null) {
            answer = true;
        } else {
            String displayString = this.getWidget().getText();
            if (displayString.trim().length() == 0) {
                answer = true;
            }
        }
        return answer;
    }

    public boolean isJustAMarkerToken() {
        String displayString = this.getWidget().getText();
        return SqlTextHelper.isMarkerToken(displayString.trim());
    }

    public String getPrevFocusSel() {
        return this.m_cursel;
    }

    public void setPrevFocusSel(String newsel) {
        String oldsel = this.m_cursel;
        this.m_cursel = newsel;
        this.firePropertyChange("selectionChanged", oldsel, this.m_cursel);
    }

    public void checkPoint() {
        try {
            Expression snapShot = (Expression)this.getExpression().clone();
            this.pushExp(snapShot);
        }
        catch (Throwable t) {
            this.m_myQuery.getMessageHandler().addInternalError(bundle.messageString("SqlTextHelper.couldntCloneAndCheckpointChange.txt"));
        }
    }

    private void pushExp(Expression prevExp) {
        if (prevExp == null) {
            return;
        }
        if (this.m_myPreviousExpressions == null) {
            this.m_myPreviousExpressions = new ExpressionList();
        }
        this.m_myPreviousExpressions.insertElementAt(prevExp, 0);
        if (this.m_myPreviousExpressions.size() > 12) {
            this.m_myPreviousExpressions.removeElementAt(this.m_myPreviousExpressions.size() - 1);
        }
    }

    public String getDisplayString(Expression exp) {
        if (this.hasBehavior(8)) {
            return exp.getDisplayString(2, this.m_myQuery, this.hasBehavior(2048) ? 2 : 1);
        }
        return exp.getDisplayString(1, this.m_myQuery, this.hasBehavior(2048) ? 2 : 1);
    }

    public void setExpression(Expression exp) {
        this.setExpression(null, exp);
    }

    public void setExpression(Query query, Expression exp) {
        this.pushExp(this.m_myExp);
        if (exp == null) {
            exp = new UnparsedExpression("");
        }
        this.m_myExp = exp;
        if (query != null) {
            this.setQuery(query);
        }
        if (exp != null) {
            this.setMyOwnText(this.getDisplayString(exp));
        } else {
            this.setMyOwnText("");
        }
        if (this.m_myParentExpression != null) {
            if (this.isCommaList()) {
                this.zappMyExpressionsFromParentExpList();
                this.m_myParentExpression.addParameter(exp);
            } else {
                this.m_myParentExpression.setParameter(this.m_myExp, this.m_myPositionInParentExpression);
            }
        }
        if (this.isJustAMarkerToken()) {
            this.selAll();
        }
        this.firePropertyChange("HelperExpressionChanged", null, null);
    }

    public void deleteExpression(Expression exp) {
        if (!this.isCommaList()) {
            return;
        }
        ExpressionList currentExps = this.getMyExpressionsFromParent();
        if (currentExps.size() != 0) {
            int deleteItem = -1;
            for (int i = 0; i < currentExps.size(); ++i) {
                if (!currentExps.elementAt(i).equals(exp)) continue;
                deleteItem = i;
            }
            if (deleteItem != -1) {
                currentExps.removeElementAt(deleteItem);
                ExpressionList explist = this.m_myParentExpression.getParameters();
                explist.removeElementAt(this.m_myPositionInParentExpression + deleteItem);
            }
        }
    }

    public Expression getExpression() {
        return this.m_myExp;
    }

    public Expression getExpression(boolean fullCommaList) {
        if (!fullCommaList) {
            return this.getExpression();
        }
        if (!this.isCommaList()) {
            return this.getExpression();
        }
        ExpressionList e = this.getMyExpressionsFromParent();
        String accumulator = new String();
        for (int i = 0; i < e.size(); ++i) {
            accumulator = accumulator + e.elementAt(i).generateSQL(this.getQuery().getSqlLogic(), this.hasBehavior(2048) ? 2 : 1);
            if (i >= e.size() - 1) continue;
            accumulator = accumulator + ", ";
        }
        UnparsedExpression result = new UnparsedExpression(accumulator);
        return result;
    }

    public void textChangeByUser(String change) {
        String newText = this.getWidget().getText();
        if (this.isCommaList()) {
            ExpressionList exps = Expression.createInstanceList(this.getQuery(), newText);
            this.zappMyExpressionsFromParentExpList();
            this.setMyExpressionsInParentExpList(exps);
        } else {
            Expression reparsedExpression = null;
            reparsedExpression = this.hasBehavior(512) ? Expression.createInstance(this.getQuery(), newText) : new UnparsedExpression(newText);
            this.ImBusy = true;
            this.setExpression(reparsedExpression);
            this.ImBusy = false;
        }
        this.firePropertyChange("HelperExpressionChanged", null, null);
    }

    public String getSelectedText() {
        if (this.getWidget() == null) {
            return "";
        }
        String curText = this.getWidget().hasFocus() ? this.getWidget().getSelectedText() : this.getPrevFocusSel();
        if (curText == null) {
            curText = "";
        }
        return curText;
    }

    public void replaceSelectedWith(Expression newExp) {
        Expression selectedSubExpression = this.getSelectedExpression();
        if (selectedSubExpression == null) {
            selectedSubExpression = this.getExpression();
        }
        newExp = new UnparsedExpression(newExp.generateSQL(this.getQuery().getSqlLogic(), this.hasBehavior(2048) ? 2 : 1));
        if (selectedSubExpression == null) {
            this.setExpression(newExp);
        } else {
            int curpos = this.getWidget().getCaretPosition();
            String curText = this.getWidget().getText();
            String curSelText = this.getSelectedText();
            String prefix = curText.substring(0, curpos);
            if (curSelText != null && curSelText.length() > 0) {
                prefix = curText.substring(0, this.getWidget().getSelectionStart());
            }
            String suffix = curText.substring(curpos);
            if (curSelText != null && curSelText.length() > 0) {
                suffix = curText.substring(this.getWidget().getSelectionEnd());
            }
            String newStuff = this.getDisplayString(newExp);
            if (prefix.length() > 0 && prefix.charAt(prefix.length() - 1) != ' ') {
                newStuff = " " + newStuff;
            }
            if (suffix.length() > 0 && suffix.charAt(0) != ' ') {
                newStuff = newStuff + " ";
            }
            String newText = prefix + newStuff + suffix;
            int newpos = prefix.length() + newStuff.length();
            this.getWidget().setText(newText);
            this.textChangeByUser(null);
            this.setCaretPosition(newpos);
            this.getWidget().repaint();
        }
        this.getWidget().requestFocus();
    }

    public void setExpectedType(int expType) {
        if (this.getExpression() != null) {
            // empty if block
        }
        this.m_expectedType = expType;
    }

    public void setExpectedType(Expression exp) {
        if (exp == null) {
            FunctionParameter myParmDef = this.getParmDef();
            if (myParmDef != null) {
                this.setExpectedType(myParmDef.getType());
            } else {
                this.setExpectedType(0);
            }
        } else {
            this.setExpectedType(exp.getDataType());
        }
    }

    public int getExpectedType() {
        if (this.getExpression() != null) {
            return this.getExpression().getDataType();
        }
        return 0;
    }

    public void setParentExpression(CompoundExpression myParent, int myPositionInParent, Query query) {
        this.m_myParentExpression = myParent;
        this.m_myPositionInParentExpression = myPositionInParent;
        this.m_myQuery = query;
    }

    protected ExpressionList getMyExpressionsFromParent() {
        ExpressionList retVec = new ExpressionList();
        if (this.m_myParentExpression == null) {
            retVec.addElement(this.getExpression());
            return retVec;
        }
        ExpressionList explist = this.m_myParentExpression.getParameters();
        if (this.isCommaList()) {
            for (int i = this.m_myPositionInParentExpression; i < explist.size(); ++i) {
                retVec.addElement(explist.elementAt(i));
            }
        } else if (this.m_myPositionInParentExpression < explist.size()) {
            retVec.addElement(explist.elementAt(this.m_myPositionInParentExpression));
        }
        return retVec;
    }

    protected void zappMyExpressionsFromParentExpList() {
        if (this.m_myParentExpression == null) {
            return;
        }
        ExpressionList explist = this.m_myParentExpression.getParameters();
        while (explist.size() > this.m_myPositionInParentExpression) {
            explist.removeElementAt(this.m_myPositionInParentExpression);
        }
    }

    protected void setMyExpressionsInParentExpList(ExpressionList explist) {
        if (this.m_myParentExpression == null) {
            return;
        }
        this.zappMyExpressionsFromParentExpList();
        for (int i = 0; i < explist.size(); ++i) {
            this.m_myParentExpression.addParameter(explist.elementAt(i));
        }
    }

    public void detachFromParent() {
        if (this.m_myParentExpression != null && this.m_myPositionInParentExpression > -1 && this.m_myParentExpression.getParameters().size() > this.m_myParentExpression.getMaxNumberOfOperands()) {
            this.m_myParentExpression.removeParameter(this.m_myPositionInParentExpression);
        }
    }

    public void attachToParent() {
        if (this.m_myParentExpression != null && this.m_myPositionInParentExpression > -1 && this.m_myParentExpression.getParameters().size() > this.m_myPositionInParentExpression) {
            this.m_myExp = this.m_myParentExpression.getParameter(this.m_myPositionInParentExpression);
            this.setExpectedType(this.m_myExp);
        } else {
            this.m_myExp = null;
            this.m_myParentExpression.setParameter(this.m_myExp, this.m_myPositionInParentExpression);
            this.setExpectedType(this.m_myExp);
        }
        this.recomputeDisplay();
    }

    public boolean isCommaList() {
        FunctionParameter myParmDef = this.getParmDef();
        boolean answer = myParmDef == null ? false : myParmDef.isCommaList();
        return answer;
    }

    public FunctionParameter getParmDef() {
        if (this.m_myParentExpression == null) {
            return null;
        }
        if (this.m_myPositionInParentExpression < 0) {
            return null;
        }
        Function myFunctdef = this.m_myParentExpression.getCurrentFunction();
        if (myFunctdef == null) {
            return null;
        }
        FunctionParameter myParmDef = myFunctdef.getParmDef(this.m_myPositionInParentExpression);
        return myParmDef;
    }

    public boolean hasEditFunction() {
        return this.getEditorClass(this.getExpectedType()) != "";
    }

    public String getEditorClass(int expType) {
        switch (expType) {
            case 0: {
                return "";
            }
            case 1: {
                return "";
            }
            case 2: {
                return "";
            }
            case 4: {
                return "";
            }
            case 8: {
                return "";
            }
            case 16: {
                return "";
            }
            case 32: {
                return "";
            }
            case 64: {
                return "";
            }
            case 128: {
                return "";
            }
            case 256: {
                return "";
            }
            case 32768: {
                return "";
            }
        }
        return "";
    }

    public SqlTextHelper(JTextComponent widget) {
        this.setWidget(widget);
        this.initialize();
        this.m_behaviorFlags = 520;
        SQLMouse aSQLMouse = new SQLMouse();
        this.getWidget().addMouseListener(aSQLMouse);
        this.aSQLTextChange = new SQLTextChange();
        this.getWidget().getDocument().addDocumentListener(this.aSQLTextChange);
        this.aSQLKey = new SQLKey();
        this.getWidget().addKeyListener(this.aSQLKey);
    }

    public SqlTextHelper(JTextComponent widget, int behavior) {
        this(widget);
        this.setBehavior(behavior);
    }

    public static final boolean isTokenDelimiter(char c) {
        boolean retVal = false;
        if (c == ' ' || c == '(' || c == ')' || c == ',') {
            retVal = true;
        }
        return retVal;
    }

    private boolean getCurrentTokenBounds(int[] bounds) {
        int start;
        String curText = this.getWidget().getText();
        int maxPos = curText.length();
        int curPos = this.getWidget().getCaretPosition();
        if (curPos == 0) {
            ++curPos;
        }
        if (maxPos > curPos && SqlTextHelper.isTokenDelimiter(curText.charAt(curPos - 1))) {
            ++curPos;
        }
        if (maxPos == 0 || SqlTextHelper.isTokenDelimiter(curText.charAt(curPos - 1))) {
            return false;
        }
        int end = curPos;
        for (start = curPos; start > 1 && !SqlTextHelper.isTokenDelimiter(curText.charAt(start - 2)); --start) {
        }
        while (end < maxPos && !SqlTextHelper.isTokenDelimiter(curText.charAt(end))) {
            ++end;
        }
        bounds[0] = start;
        bounds[1] = end;
        return true;
    }

    public String getCurrentToken() {
        String curText = this.getWidget().getText();
        String token = "";
        int[] bounds = new int[2];
        token = this.getCurrentTokenBounds(bounds) ? curText.substring(bounds[0] - 1, bounds[1]) : "";
        return token;
    }

    public Expression getSelectedExpression() {
        String curSelText = this.getSelectedText();
        int i = this.getWidget().getCaretPosition();
        if (i == 0) {
            ++i;
        }
        if (this.m_myExp == null) {
            return null;
        }
        if (curSelText.length() > 0) {
            return new UnparsedExpression(curSelText);
        }
        return null;
    }

    public void popMenuCallbackExpBuilder() {
    }

    public void popMenuCallbackRevert(Expression exp) {
    }

    public void callbackUndo() {
    }

    public void popMenuCallbackOtherColumn(String colname, Column col) {
    }

    public void popMenuCallbackAddValue(Expression newExp) {
    }

    public void popMenuCallbackFunction(Function fun) {
    }

    public void popMenuCallbackWrapWithFunction(Function fun) {
    }

    public void popMenuCallbackSetBehavior(Integer behavior) {
    }

    public void popMenuCallback(String parm1, String parm2, Object parm3) {
    }

    public void showRevertPopmenu(JComponent where) {
    }

    private void addUndoList(JPopupMenu addToMenu) {
    }

    private void addColumnList(JPopupMenu main, boolean addDirectly) {
    }

    public void showColumnPopmenu(JComponent where) {
    }

    public static final boolean isFunctionString(String str) {
        boolean ret = false;
        if (str.equals("+")) {
            ret = true;
        }
        if (str.equals("-")) {
            ret = true;
        }
        if (str.equals("*")) {
            ret = true;
        }
        if (str.equals("/")) {
            ret = true;
        }
        if (str.equals("||")) {
            ret = true;
        }
        return ret;
    }

    public static final boolean isMarkerToken(String str) {
        boolean ret = true;
        if (str.length() == 0) {
            ret = false;
        } else {
            if (str.charAt(0) != '<') {
                ret = false;
            }
            if (str.charAt(str.length() - 1) != '>') {
                ret = false;
            }
        }
        return ret;
    }

    private void selAll() {
        String currentText = this.getWidget().getText();
        if (currentText.length() > 0) {
            this.setSelection(0, currentText.length());
        }
    }

    private void selectCurrentToken() {
        int[] bounds = new int[2];
        this.firePropertyChange("NewCurrentToken", null, null);
        if (this.getCurrentTokenBounds(bounds)) {
            this.setSelection(bounds[0] - 1, bounds[1]);
        }
    }

    private TextReplacement tokenReplace(KeyEvent event, String curSelText) {
        String tooltip;
        String suffix;
        String prefix;
        TextReplacement retVal = null;
        if (curSelText.length() < 2) {
            return retVal;
        }
        if (curSelText.charAt(0) != '<') {
            return retVal;
        }
        if (curSelText.charAt(curSelText.length() - 1) != '>') {
            return retVal;
        }
        if (event.isActionKey()) {
            return retVal;
        }
        if (event.getKeyCode() == 16) {
            return retVal;
        }
        if (event.getKeyCode() == 17) {
            return retVal;
        }
        if (event.getKeyCode() == 18) {
            return retVal;
        }
        if (event.getKeyCode() == 8 || event.getKeyCode() == 127) {
            return retVal;
        }
        String tokenContents = curSelText.substring(1, curSelText.length() - 1);
        if (tokenContents.equals(bundle.getString("SqlTextHelperPanel.charValue.txt"))) {
            prefix = this.getQuery().getSqlLogic().getFormatPrefix(4);
            suffix = this.getQuery().getSqlLogic().getFormatSuffix(4);
            if (prefix.length() > 0 && event.getKeyChar() != prefix.charAt(0)) {
                retVal = new TextReplacement(prefix + event.getKeyChar() + suffix, prefix.length() + 1);
                tooltip = this.getQuery().getSqlLogic().getFormatExample(4);
                if (tooltip != null) {
                    this.getWidget().setToolTipText(tooltip);
                }
            }
        }
        if (tokenContents.equals(bundle.getString("SqlTextHelperPanel.dateValue.txt"))) {
            prefix = this.getQuery().getSqlLogic().getFormatPrefix(16);
            suffix = this.getQuery().getSqlLogic().getFormatSuffix(16);
            if (prefix.length() > 0 && event.getKeyChar() != prefix.charAt(0)) {
                retVal = new TextReplacement(prefix + event.getKeyChar() + suffix, prefix.length() + 1);
                tooltip = this.getQuery().getSqlLogic().getFormatExample(16);
                if (tooltip != null) {
                    this.getWidget().setToolTipText(tooltip);
                }
            }
        }
        if (tokenContents.equals(bundle.getString("SqlTextHelperPanel.timeValue.txt"))) {
            prefix = this.getQuery().getSqlLogic().getFormatPrefix(32);
            suffix = this.getQuery().getSqlLogic().getFormatSuffix(32);
            if (prefix.length() > 0 && event.getKeyChar() != prefix.charAt(0)) {
                retVal = new TextReplacement(prefix + event.getKeyChar() + suffix, prefix.length() + 1);
                tooltip = this.getQuery().getSqlLogic().getFormatExample(32);
                if (tooltip != null) {
                    this.getWidget().setToolTipText(tooltip);
                }
            }
        }
        if (tokenContents.equals(bundle.getString("SqlTextHelperPanel.timestampValue.txt"))) {
            prefix = this.getQuery().getSqlLogic().getFormatPrefix(64);
            suffix = this.getQuery().getSqlLogic().getFormatSuffix(64);
            if (prefix.length() > 0 && event.getKeyChar() != prefix.charAt(0)) {
                retVal = new TextReplacement(prefix + event.getKeyChar() + suffix, prefix.length() + 1);
                tooltip = this.getQuery().getSqlLogic().getFormatExample(64);
                if (tooltip != null) {
                    this.getWidget().setToolTipText(tooltip);
                }
            }
        }
        return retVal;
    }

    private TextReplacement intelliReplace(KeyEvent event, String curSelText) {
        TextReplacement retVal = null;
        if (curSelText.length() < 5) {
            return retVal;
        }
        if (curSelText.charAt(0) != '<') {
            return retVal;
        }
        if (curSelText.charAt(1) != '{') {
            return retVal;
        }
        if (curSelText.charAt(curSelText.length() - 1) != '>') {
            return retVal;
        }
        if (curSelText.charAt(curSelText.length() - 2) != '}') {
            return retVal;
        }
        if (event.isActionKey()) {
            return retVal;
        }
        String choiceList = curSelText.substring(2, curSelText.length() - 2);
        StringTokenizer st = new StringTokenizer(choiceList, "|", false);
        while (st.hasMoreTokens()) {
            String thisone = st.nextToken();
            if (thisone.length() <= 1 || Character.toUpperCase(event.getKeyChar()) != thisone.charAt(0) && Character.toLowerCase(event.getKeyChar()) != thisone.charAt(0)) continue;
            return new TextReplacement(thisone, thisone.length());
        }
        return retVal;
    }

    public void setVisible(boolean newVal) {
        this.getWidget().setVisible(newVal);
    }

    public void setEditable(boolean newVal) {
        this.getWidget().setEditable(newVal);
    }

    public void requestFocus() {
        this.getWidget().requestFocus();
    }

    public void runExpressionBuilder() {
        this.popMenuCallbackExpBuilder();
    }

    public String getText() {
        return this.getWidget().getText();
    }

    public int getSelectionStart() {
        return this.getWidget().getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.getWidget().getSelectionEnd();
    }

    public void setCaretPosition(int i) {
        this.getWidget().setCaretPosition(i);
        this.setPrevFocusSel("");
    }

    public void setSelection(int start, int end) {
        JTextComponent wid = this.getWidget();
        try {
            wid.getCaret().setDot(start);
            wid.getCaret().moveDot(end);
        }
        catch (Throwable t) {
            wid.getHighlighter().removeAllHighlights();
        }
        this.setPrevFocusSel(this.getWidget().getSelectedText());
    }

    public void popMenuRequest(MouseEvent event) {
    }

    class TextReplacement {
        String newString = null;
        int cursorAdvanceInNewString = 0;

        public TextReplacement(String s, int i) {
            this.newString = s;
            this.cursorAdvanceInNewString = i;
        }

        public String getReplacementText() {
            return this.newString;
        }

        public int getCursorAdvance() {
            return this.cursorAdvanceInNewString;
        }

        public void setReplacementText(String s) {
            this.newString = s;
        }

        public void setCursorAdvance(int adv) {
            this.cursorAdvanceInNewString = adv;
        }
    }

    class SQLTextChange
    implements DocumentListener {
        SQLTextChange() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (!SqlTextHelper.this.ImBusy) {
                this.textValueChanged(e);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (!SqlTextHelper.this.ImBusy) {
                this.textValueChanged(e);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (!SqlTextHelper.this.ImBusy) {
                this.textValueChanged(e);
            }
        }

        public void textValueChanged(DocumentEvent event) {
            if (!SqlTextHelper.this.ImBusy && !SqlTextHelper.this.getWidget().getText().equals(SqlTextHelper.this.m_previousContents)) {
                SqlTextHelper.this.m_previousContents = SqlTextHelper.this.getWidget().getText();
                if (SqlTextHelper.this.m_previousContents.length() == 1) {
                    SqlTextHelper.this.textChangeByUser(SqlTextHelper.this.m_previousContents);
                } else {
                    SqlTextHelper.this.textChangeByUser(null);
                }
            }
        }
    }

    class SQLKey
    extends KeyAdapter {
        boolean eatRelease = false;

        SQLKey() {
        }

        @Override
        public void keyTyped(KeyEvent event) {
            if (this.eatRelease) {
                event.consume();
                this.eatRelease = false;
                return;
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
            if (this.eatRelease) {
                event.consume();
                return;
            }
            String cursel = SqlTextHelper.this.getSelectedText();
            if (!cursel.equals(SqlTextHelper.this.getPrevFocusSel())) {
                SqlTextHelper.this.setPrevFocusSel(cursel);
            }
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 65 && event.isControlDown()) {
                SqlTextHelper.this.selAll();
                this.eatRelease = true;
                event.consume();
            }
            JTextComponent widg = SqlTextHelper.this.getWidget();
            String curSelText = SqlTextHelper.this.getSelectedText();
            String curText = widg.getText();
            if (curSelText != null && curSelText.length() > 0) {
                int curpos = widg.getSelectionEnd();
                String prefix = curText.substring(0, widg.getSelectionStart());
                String suffix = curText.substring(widg.getSelectionEnd());
                TextReplacement newStuff = SqlTextHelper.this.intelliReplace(event, curSelText);
                if (newStuff != null) {
                    String newText = prefix + newStuff.getReplacementText() + suffix;
                    int newpos = prefix.length() + newStuff.getCursorAdvance();
                    widg.setText(newText);
                    widg.repaint();
                    SqlTextHelper.this.setCaretPosition(newpos);
                    if (newStuff.getReplacementText().length() > 1) {
                        SqlTextHelper.this.setSelection(prefix.length() + 1, prefix.length() + newStuff.getReplacementText().length());
                    }
                    event.consume();
                    this.eatRelease = true;
                } else {
                    newStuff = SqlTextHelper.this.tokenReplace(event, curSelText);
                    if (newStuff != null) {
                        String newText = prefix + newStuff.getReplacementText() + suffix;
                        int newpos = prefix.length() + newStuff.getCursorAdvance();
                        widg.setText(newText);
                        widg.repaint();
                        SqlTextHelper.this.setCaretPosition(newpos);
                        event.consume();
                        this.eatRelease = true;
                    }
                }
            }
        }
    }

    class SQLMouse
    extends MouseAdapter {
        SQLMouse() {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            String cursel;
            int modifiers = event.getModifiers();
            if ((modifiers & 4) != 0 & !SqlTextHelper.this.hasBehavior(1)) {
                SqlTextHelper.this.popMenuRequest(event);
            } else if (!(SqlTextHelper.this.hasBehavior(2) || (cursel = SqlTextHelper.this.getSelectedText()) != null && cursel.length() != 0)) {
                String currentToken = SqlTextHelper.this.getCurrentToken();
                if (SqlTextHelper.isFunctionString(currentToken)) {
                    SqlTextHelper.this.selectCurrentToken();
                } else if (SqlTextHelper.isMarkerToken(currentToken)) {
                    SqlTextHelper.this.selectCurrentToken();
                } else if (event.getClickCount() > 1) {
                    SwingUtilities.invokeLater(new DelayedSelectionSnooper());
                }
            }
            cursel = SqlTextHelper.this.getSelectedText();
            if (cursel == null) {
                cursel = "";
            }
            if (!cursel.equals(SqlTextHelper.this.getPrevFocusSel())) {
                SqlTextHelper.this.setPrevFocusSel(cursel);
            }
        }
    }

    class DelayedSelectionSnooper
    implements Runnable {
        DelayedSelectionSnooper() {
        }

        @Override
        public void run() {
            SqlTextHelper.this.setPrevFocusSel(SqlTextHelper.this.getWidget().getSelectedText());
        }
    }
}

