/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.datasources.Function;
import com.sas.query.datasources.FunctionList;
import com.sas.query.models.CompoundExpression;
import com.sas.query.models.Expression;
import com.sas.query.models.GroupItemList;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.models.OrderItem;
import com.sas.query.models.OrderItemList;
import com.sas.query.models.PropertyChangeConstants;
import com.sas.query.models.ResultItem;
import com.sas.query.models.ResultItemList;
import com.sas.query.visuals.QueryComponentDialog;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.ResultItemPropertyView;
import com.sas.query.visuals.StandardView;
import com.sas.query.visuals.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class ResultItemListView
extends StandardView {
    static QueryResource bundle = new QueryResource(ResultItemListView.class);
    protected ResultItemList m_resultItems = null;
    protected JTable m_tableView;
    protected JScrollPane m_scrollpane;
    protected JButton m_editButton;
    protected JButton m_deleteButton;
    protected JButton m_moveFirstButton;
    protected JButton m_moveUpButton;
    protected JButton m_moveDownButton;
    protected JButton m_moveLastButton;
    protected String[] m_labels = new String[]{"", bundle.getString("Common.ResultItem.txt"), bundle.getString("Common.Direction.txt")};
    protected int[] m_minSize = new int[]{35, 200, 80};

    public ResultItemListView(Query query) {
        super(query);
        this.m_tableView = new JTable(new ResultItemTableModel(query)){

            @Override
            public void tableChanged(TableModelEvent e) {
                super.tableChanged(e);
                ResultItemListView.this._setState();
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                ResultItemListView.this._setState();
            }
        };
        this.m_tableView.setSelectionMode(0);
        TableCellRenderer headerRenderer = this.m_tableView.getColumnModel().getColumn(0).getHeaderRenderer();
        if (headerRenderer instanceof DefaultTableCellRenderer) {
            URL url = this.getClass().getResource("res/aggregate.gif");
            ImageIcon icon = new ImageIcon(url);
            ((DefaultTableCellRenderer)headerRenderer).setIcon(icon);
        }
        for (int index = 0; index < this.m_minSize.length; ++index) {
            this.m_tableView.getColumnModel().getColumn(index).setMinWidth(this.m_minSize[index]);
        }
        this.m_tableView.getColumnModel().getColumn(0).setCellEditor(new AggregateCellEditor());
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem(bundle.getString("Common.defaultinBrackets.txt"));
        comboBox.addItem(bundle.getString("Common.Ascending.txt"));
        comboBox.addItem(bundle.getString("Common.Descending.txt"));
        this.m_tableView.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(comboBox));
        this.m_scrollpane = new JScrollPane(this.m_tableView);
        WindowUtil.fixupJScrollPane(this.m_scrollpane);
        this.m_editButton = new JButton(bundle.getString("Common.Edit....txt"));
        this.m_editButton.addActionListener(new EditButtonHandler());
        this.m_deleteButton = new JButton(bundle.getString("Common.Delete.txt"));
        this.m_deleteButton.addActionListener(new DeleteButtonHandler());
        URL url = this.getClass().getResource("res/upFirst.gif");
        ImageIcon defaultIcon = new ImageIcon(url);
        this.m_moveFirstButton = new JButton(bundle.getString("Common.First.txt"));
        this.m_moveFirstButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_moveFirstButton.addActionListener(new MoveButtonHandler("First"));
        url = this.getClass().getResource("res/upArrow.gif");
        defaultIcon = new ImageIcon(url);
        this.m_moveUpButton = new JButton(bundle.getString("Common.Up.txt"));
        this.m_moveUpButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_moveUpButton.addActionListener(new MoveButtonHandler("Up"));
        url = this.getClass().getResource("res/downArrow.gif");
        defaultIcon = new ImageIcon(url);
        this.m_moveDownButton = new JButton(bundle.getString("Common.Down.txt"));
        this.m_moveDownButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_moveDownButton.addActionListener(new MoveButtonHandler("Down"));
        url = this.getClass().getResource("res/downLast.gif");
        defaultIcon = new ImageIcon(url);
        this.m_moveLastButton = new JButton(bundle.getString("Common.Last.txt"));
        this.m_moveLastButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_moveLastButton.addActionListener(new MoveButtonHandler("Last"));
        JPanel listPanel = new JPanel();
        GridBagLayout listPanelGridBagLayout = new GridBagLayout();
        listPanel.setLayout(listPanelGridBagLayout);
        listPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 11;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_editButton, gbc);
        listPanel.add(this.m_editButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 11;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_deleteButton, gbc);
        listPanel.add(this.m_deleteButton);
        JPanel spacer = new JPanel();
        spacer.setSize(10, 80);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.anchor = 11;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(spacer, gbc);
        listPanel.add(spacer);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.anchor = 10;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_moveFirstButton, gbc);
        listPanel.add(this.m_moveFirstButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 5;
        gbc.anchor = 10;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_moveUpButton, gbc);
        listPanel.add(this.m_moveUpButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 6;
        gbc.anchor = 10;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_moveDownButton, gbc);
        listPanel.add(this.m_moveDownButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 7;
        gbc.anchor = 10;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_moveLastButton, gbc);
        listPanel.add(this.m_moveLastButton);
        this.setLayout(new BorderLayout());
        this.add(this.m_scrollpane);
        this.add("East", listPanel);
        this.m_tableView.setRowSelectionInterval(0, 0);
        this._setState();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, SystemColor.controlLtHighlight, SystemColor.controlHighlight, SystemColor.controlDkShadow, SystemColor.controlShadow), BorderFactory.createEmptyBorder(12, 12, 12, 12)));
    }

    @Override
    public void closing() {
        this.m_query.removePropertyListener((ResultItemTableModel)this.m_tableView.getModel());
    }

    public void onEdit() {
        ResultItem item = this.getSelectedItem();
        ResultItemPropertyView propertyPanel = new ResultItemPropertyView(this.m_query, item);
        QueryComponentDialog editDialog = new QueryComponentDialog(WindowUtil.getParentFrame(this), this.m_query, propertyPanel, "BUG - need Prefix");
        WindowUtil.centerOverWindow(editDialog, this);
        editDialog.setModal(true);
        editDialog.pack();
        editDialog.setVisible(true);
        propertyPanel.closing();
    }

    public void onDelete() {
        ResultItem item = this.getSelectedItem();
        this.m_query.deleteResultItem(item);
        this.displayMessages();
        this.firePropertyChanges();
    }

    public void valueChanged(ListSelectionEvent e) {
        this._setState();
    }

    protected void _setState() {
        int nSelected = this.m_tableView.getSelectedRow();
        if (this.m_tableView.getRowCount() == 0 || nSelected > this.m_tableView.getRowCount() - 1) {
            nSelected = -1;
        }
        boolean bCanMoveUp = true;
        boolean bCanMoveDown = true;
        if (nSelected == 0) {
            bCanMoveUp = false;
        } else if (nSelected == -1) {
            bCanMoveUp = false;
            bCanMoveDown = false;
        } else if (nSelected == this.m_tableView.getRowCount() - 1) {
            bCanMoveDown = false;
        }
        this.m_moveFirstButton.setEnabled(bCanMoveUp);
        this.m_moveUpButton.setEnabled(bCanMoveUp);
        this.m_moveDownButton.setEnabled(bCanMoveDown);
        this.m_moveLastButton.setEnabled(bCanMoveDown);
        if (!bCanMoveUp && !bCanMoveDown) {
            this.m_editButton.setEnabled(false);
            this.m_deleteButton.setEnabled(false);
        } else {
            this.m_editButton.setEnabled(true);
            this.m_deleteButton.setEnabled(true);
        }
    }

    protected ResultItem getSelectedItem() {
        ResultItem item = null;
        int index = this.m_tableView.getSelectedRow();
        if (index != -1) {
            item = this.m_resultItems.elementAt(index);
        }
        return item;
    }

    class ResultItemTableModel
    extends AbstractTableModel
    implements PropertyChangeConstants,
    ModelChangeListener {
        Hashtable isItemSelectedList = new Hashtable();

        public ResultItemTableModel(Query query) {
            query.addPropertyListener(this, 324);
            this.refresh();
        }

        @Override
        public int getColumnCount() {
            return ResultItemListView.this.m_labels.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return ResultItemListView.this.m_labels[columnIndex];
        }

        public Class getColumnClass(int c) {
            String junk = "";
            return junk.getClass();
        }

        @Override
        public int getRowCount() {
            return ResultItemListView.this.m_resultItems.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ResultItem item = ResultItemListView.this.m_resultItems.elementAt(row);
            if (item.getExpression().isAggregation()) {
                if (col == 0) {
                    return item.getExpression().getAggregationType();
                }
                if (col == 1) {
                    return ((CompoundExpression)item.getExpression()).getParameter(0).getDisplayString();
                }
            } else {
                if (col == 0) {
                    GroupItemList itemList = ResultItemListView.this.m_query.getGroupItems();
                    for (int index = 0; index < itemList.size(); ++index) {
                        if (item != itemList.elementAt(index).getResultItem()) continue;
                        return bundle.getString("Common.groupinBrackets.txt");
                    }
                    return "";
                }
                if (col == 1) {
                    return item.getDisplayString();
                }
            }
            if (col == 2) {
                OrderItemList itemList = ResultItemListView.this.m_query.getOrderItems();
                for (int index = 0; index < itemList.size(); ++index) {
                    OrderItem orderItem = itemList.elementAt(index);
                    if (item != orderItem.getResultItem()) continue;
                    if (orderItem.getSortingDirection() == 0) {
                        return bundle.getString("Common.defaultinBrackets.txt");
                    }
                    if (orderItem.getSortingDirection() == 1) {
                        return bundle.getString("Common.Ascending.txt");
                    }
                    if (orderItem.getSortingDirection() != 2) continue;
                    return bundle.getString("Common.Descending.txt");
                }
                return "";
            }
            return bundle.getString("Common.nullinBrackets.txt");
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            boolean bEditable = false;
            return bEditable;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            ResultItem item = ResultItemListView.this.m_resultItems.elementAt(row);
            if (col == -1) {
                Boolean isReturned = (Boolean)this.isItemSelectedList.get(item);
                if (isReturned.booleanValue()) {
                    ResultItemListView.this.m_query.deleteResultItem(item);
                } else {
                    ResultItemListView.this.m_query.addResultItem(item);
                }
            } else if (col == 0) {
                Expression exp = item.getExpression();
                if (exp.isAggregation()) {
                    exp = exp.deleteAggregation();
                }
                if (value instanceof Function) {
                    exp = exp.addAggregation((Function)value);
                    item.setExpression(exp);
                    GroupItemList groupList = ResultItemListView.this.m_query.getGroupItems();
                    for (int index = 0; index < ResultItemListView.this.m_resultItems.size(); ++index) {
                        if (ResultItemListView.this.m_resultItems.elementAt(index).getExpression().isAggregation()) continue;
                        boolean bAlreadyGrouped = false;
                        for (int orderIndex = 0; orderIndex < groupList.size(); ++orderIndex) {
                            if (ResultItemListView.this.m_resultItems.elementAt(index) != groupList.elementAt(orderIndex).getResultItem()) continue;
                            bAlreadyGrouped = true;
                        }
                        if (bAlreadyGrouped) continue;
                        ResultItemListView.this.m_query.addGroupItem(ResultItemListView.this.m_resultItems.elementAt(index));
                    }
                }
            } else if (col == 2 || col == 3) {
                // empty if block
            }
            ResultItemListView.this.displayMessages();
            ResultItemListView.this.firePropertyChanges();
        }

        public void refresh() {
            ResultItemList newResultItems = new ResultItemList();
            newResultItems.add(ResultItemListView.this.m_query.getResultItems());
            ResultItemListView.this.m_resultItems = newResultItems;
            TableModelEvent event = new TableModelEvent(this);
            this.fireTableChanged(event);
        }

        @Override
        public void modelChangeCallback(ModelChangeEvent event) {
            this.refresh();
        }
    }

    class AggregateCellEditor
    extends DefaultCellEditor {
        AggregateCellEditor() {
            super(new JComboBox());
        }

        public AggregateCellEditor(JComboBox x) {
            super(x);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComboBox comboBox = (JComboBox)this.getComponent();
            if (comboBox != null && comboBox.getItemCount() == 0) {
                FunctionList functionList = ResultItemListView.this.m_query.getDataSourceFunctions();
                functionList = functionList.getSubsetByFunctionType(1);
                functionList = functionList.getSubsetByPrimaryParmType(ResultItemListView.this.m_resultItems.elementAt(row).getExpression().getDataType());
                comboBox.addItem(" ");
                comboBox.addItem(bundle.getString("Common.groupinBrackets.txt"));
                for (int index = 0; index < functionList.size(); ++index) {
                    comboBox.addItem(functionList.elementAt(index));
                }
                comboBox.addActionListener(new ComboHandler(ResultItemListView.this.m_resultItems.elementAt(row)));
            }
            return comboBox;
        }

        protected class ComboHandler
        implements ActionListener {
            ResultItem m_item;

            ComboHandler(ResultItem item) {
                this.m_item = item;
            }

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        }
    }

    protected class EditButtonHandler
    implements ActionListener {
        EditButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ResultItemListView.this.onEdit();
        }
    }

    protected class DeleteButtonHandler
    implements ActionListener {
        DeleteButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ResultItemListView.this.onDelete();
            ResultItemListView.this._setState();
        }
    }

    protected class MoveButtonHandler
    implements ActionListener {
        String m_strAction;

        MoveButtonHandler(String action) {
            this.m_strAction = action;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int index = ResultItemListView.this.m_tableView.getSelectedRow();
            if (this.m_strAction.equals("First")) {
                ResultItemListView.this.m_query.moveResultItem(index, 0);
                ResultItemListView.this.m_tableView.setRowSelectionInterval(0, 0);
            } else if (this.m_strAction.equals("Up")) {
                ResultItemListView.this.m_query.moveResultItem(index, index - 1);
                ResultItemListView.this.m_tableView.setRowSelectionInterval(index - 1, index - 1);
            } else if (this.m_strAction.equals("Down")) {
                ResultItemListView.this.m_query.moveResultItem(index, index + 2);
                ResultItemListView.this.m_tableView.setRowSelectionInterval(index + 1, index + 1);
            } else if (this.m_strAction.equals("Last")) {
                ResultItemListView.this.m_query.moveResultItem(index, ResultItemListView.this.m_resultItems.size());
                ResultItemListView.this.m_tableView.setRowSelectionInterval(ResultItemListView.this.m_resultItems.size() - 1, ResultItemListView.this.m_resultItems.size() - 1);
            }
            ResultItemListView.this.displayMessages();
            ResultItemListView.this.firePropertyChanges();
        }
    }
}

