/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.models.ConstantExpression;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ResultItem;
import com.sas.query.models.ResultItemList;
import com.sas.query.visuals.BarNoun;
import com.sas.query.visuals.BarView;
import com.sas.query.visuals.PopMenuItem;
import com.sas.query.visuals.QueryComponentDialog;
import com.sas.query.visuals.ResultItemPropertyView;
import com.sas.query.visuals.ResultItemsEditDialog;
import com.sas.query.visuals.WindowUtil;
import java.awt.Color;
import javax.swing.JPopupMenu;

public class ResultItemBarView
extends BarView {
    public ResultItemBarView(Query query) {
        super(query, bundle.getString("ResultItemBarView.Results.txt"), new Color(0, 204, 255), Color.black);
        this.m_query.addPropertyListener(this, 4);
        this.refresh();
    }

    @Override
    public void closing() {
        this.m_query.removePropertyListener(this);
    }

    @Override
    public void refresh() {
        ResultItemList list = this.m_query.getResultItems();
        this.removeAllParts();
        for (int index = 0; index < list.size(); ++index) {
            ResultItem item = list.elementAt(index);
            try {
                BarNoun noun = new BarNoun(item, item.getClass().getMethod("getDisplayString", null));
                this.addPart(noun);
                continue;
            }
            catch (Exception e) {
                this.m_query.getMessageHandler().addInternalError(e);
            }
        }
        super.refresh();
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        this.refresh();
    }

    @Override
    public JPopupMenu getPartPopmenu() {
        if (this.m_partPopmenu == null) {
            this.m_partPopmenu = super.getPartPopmenu();
            this.m_partPopmenu.addSeparator();
            this.m_partPopmenu.add(new PopMenuItem(bundle.getString("Common.OrderBy.txt"), "onOrderBy", this));
            this.m_partPopmenu.add(new PopMenuItem(bundle.getString("Common.GroupBy.txt"), "onGroupBy", this));
        }
        return this.m_partPopmenu;
    }

    public void onOrderBy() {
        ResultItem item = this.getSelectedItem();
        this.m_query.addOrderItem(item);
        this.displayMessages();
        this.firePropertyChanges();
    }

    public void onGroupBy() {
        ResultItem item = this.getSelectedItem();
        this.m_query.addGroupItem(item);
        this.displayMessages();
        this.firePropertyChanges();
    }

    @Override
    public void onEditBar() {
        ResultItem item = this.getSelectedItem();
        ResultItemsEditDialog editDialog = new ResultItemsEditDialog(WindowUtil.getParentFrame(this), this.m_query, item);
        WindowUtil.centerOverWindow(editDialog, this);
        editDialog.setModal(true);
        editDialog.pack();
        editDialog.setVisible(true);
        this.displayMessages();
    }

    @Override
    public void onEdit() {
        ResultItem item = this.getSelectedItem();
        ResultItemPropertyView propertyPanel = new ResultItemPropertyView(this.m_query, item);
        QueryComponentDialog editDialog = new QueryComponentDialog(WindowUtil.getParentFrame(this), this.m_query, propertyPanel, "BUG - need Prefix");
        WindowUtil.centerOverWindow(editDialog, this);
        editDialog.setModal(true);
        editDialog.pack();
        editDialog.setVisible(true);
        propertyPanel.closing();
        this.displayMessages();
    }

    @Override
    public void onInsert() {
        ResultItem item = new ResultItem(this.m_query, new ConstantExpression());
        ResultItemPropertyView propertyPanel = new ResultItemPropertyView(this.m_query, item);
        QueryComponentDialog editDialog = new QueryComponentDialog(WindowUtil.getParentFrame(this), this.m_query, propertyPanel, "BUG - need Prefix");
        editDialog.setModal(true);
        editDialog.pack();
        editDialog.setVisible(true);
        if (editDialog.getReturnValue() == 1) {
            if (this.getSelectedIndex() != -1) {
                this.m_query.addResultItem(item, this.getSelectedIndex());
            } else {
                this.m_query.addResultItem(item);
            }
        }
        propertyPanel.closing();
        this.displayMessages();
        this.firePropertyChanges();
    }

    @Override
    public void onDelete() {
        ResultItem item = (ResultItem)this.getSelectedPart().getData();
        this.m_query.deleteResultItem(item);
        super.onDelete();
        this.displayMessages();
        this.firePropertyChanges();
    }

    @Override
    public void onMovePart(int oldIndex, int newIndex) {
        if (oldIndex != newIndex) {
            this.m_query.moveResultItem(oldIndex, newIndex);
        }
        this.refresh();
        this.displayMessages();
        this.firePropertyChanges();
    }

    protected ResultItem getSelectedItem() {
        ResultItem item = null;
        if (this.getSelectedPart() != null) {
            item = (ResultItem)this.getSelectedPart().getData();
        }
        return item;
    }
}

