/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.models.FilterNode;
import com.sas.query.models.FilterTree;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.ResultPanel;
import com.sas.query.visuals.SqlPanel;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ResultDialog
extends JDialog {
    protected Query m_query;
    protected Frame m_parentFrame;
    protected FilterNode m_finalWhereNode;
    protected FilterNode m_finalHavingNode;
    protected FilterTree m_filterTree;
    protected JTabbedPane m_tabbedPane;
    protected SqlPanel m_sqlPanel;
    protected ResultPanel m_resultPanel;
    protected String m_strTitle;
    static QueryResource bundle = new QueryResource(ResultDialog.class);

    public ResultDialog(Query query, Frame parentFrame, boolean bModalFlag) {
        this(query, null, null, null, parentFrame, bModalFlag);
    }

    public ResultDialog(Query query, FilterTree filterTree, FilterNode finalWhereNode, FilterNode finalHavingNode, Frame parentFrame, boolean bModalFlag) {
        super(parentFrame, " ", bModalFlag);
        this.m_filterTree = filterTree;
        this.m_finalWhereNode = finalWhereNode;
        this.m_finalHavingNode = finalHavingNode;
        this.m_parentFrame = parentFrame;
        this.m_query = query;
        this._initialization();
        this._layoutWidgets();
        this.enableEvents(4L);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                FilterNode node = ResultDialog.this.m_finalWhereNode;
                if (ResultDialog.this.m_finalHavingNode != null) {
                    node = ResultDialog.this.m_finalHavingNode;
                }
                if (ResultDialog.this.m_filterTree != null) {
                    ResultDialog.this.m_filterTree.setSelectedNode(node);
                    ResultDialog.this.m_query.getMessageHandler().firePropertyChanges();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    @Override
    public void processFocusEvent(FocusEvent event) {
        super.processFocusEvent(event);
    }

    protected void _initialization() {
        this.m_strTitle = bundle.getString("ResultDialog.Title.txt");
        this.m_resultPanel = new ResultPanel(this.m_query, this.m_finalWhereNode, this.m_finalHavingNode);
        this.m_sqlPanel = new SqlPanel(this.m_query, this.m_finalWhereNode, this.m_finalHavingNode);
    }

    protected void _layoutWidgets() {
        this.setResizable(true);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.m_tabbedPane = new JTabbedPane();
        this.m_tabbedPane.addTab(bundle.getString("ResultDialog.TabLabel.Results.txt"), this._layoutResultWidgets());
        this.m_tabbedPane.addTab(bundle.getString("ResultDialog.TabLabel.Sql.txt"), this._layoutSqlWidgets());
        panel.add(this.m_tabbedPane);
        this.getContentPane().add(panel);
        this.setTitle(this.m_strTitle);
        this.setBounds(100, 100, 670, 340);
        this.addWindowListener(new DialogCloser(this));
    }

    protected JPanel _layoutSqlWidgets() {
        GridBagLayout gridBagLayout = (GridBagLayout)this.m_sqlPanel.getLayout();
        JButton closeButton = new JButton(bundle.getString("Standard.ButtonLabel.Close.txt"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 8, 12, 12);
        gridBagLayout.setConstraints(closeButton, gbc);
        this.m_sqlPanel.add(closeButton);
        closeButton.addActionListener(new DialogCloser(this));
        this.m_sqlPanel.getTextPanel().setEditable(false);
        return this.m_sqlPanel;
    }

    protected JPanel _layoutResultWidgets() {
        GridBagLayout gridBagLayout = (GridBagLayout)this.m_resultPanel.getLayout();
        JButton closeButton = new JButton(bundle.getString("Standard.ButtonLabel.Close.txt"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 8, 12, 12);
        gridBagLayout.setConstraints(closeButton, gbc);
        this.m_resultPanel.add(closeButton);
        closeButton.addActionListener(new DialogCloser(this));
        return this.m_resultPanel;
    }

    protected static final class DialogCloser
    extends WindowAdapter
    implements ActionListener {
        JDialog m_dialog;

        DialogCloser(JDialog dialog) {
            this.m_dialog = dialog;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.m_dialog.dispose();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.m_dialog.dispose();
        }
    }
}

