/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.Table;
import com.sas.query.models.TableList;
import com.sas.query.visuals.AddTableDialog;
import com.sas.query.visuals.BarNoun;
import com.sas.query.visuals.BarView;
import com.sas.query.visuals.QueryComponentDialog;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.TablePropertyView;
import com.sas.query.visuals.WindowUtil;
import java.awt.Color;

public class ReferableTableBarView
extends BarView {
    protected static QueryResource bundle = new QueryResource(ReferableTableBarView.class);

    public ReferableTableBarView(Query query) {
        super(query, bundle.getString("ReferableTableBarView.Tables.txt"), new Color(51, 204, 204), Color.black);
        this.m_query.addPropertyListener(this, 8);
        this.setAllowArrangement(false);
        this.refresh();
    }

    @Override
    public void closing() {
        this.m_query.removePropertyListener(this);
    }

    @Override
    public void refresh() {
        TableList list = this.m_query.getReferableTables();
        this.removeAllParts();
        for (int index = 0; index < list.size(); ++index) {
            Table item = list.elementAt(index);
            try {
                BarNoun noun = new BarNoun(item, item.getClass().getMethod("getDisplayName", null));
                this.addPart(noun);
                continue;
            }
            catch (Exception e) {
                this.m_query.getMessageHandler().addInternalError(bundle.messageString("ReferableTableBarView.creatingTableBarnoun.fmt.txt", e.getMessage()));
            }
        }
        super.refresh();
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        this.refresh();
    }

    @Override
    public void onEditBar() {
    }

    @Override
    public void onEdit() {
        Table item = this.getSelectedItem();
        TablePropertyView propertyPanel = new TablePropertyView(item);
        QueryComponentDialog editDialog = new QueryComponentDialog(WindowUtil.getParentFrame(this), this.m_query, propertyPanel, "BUG - need Prefix");
        WindowUtil.centerOverWindow(editDialog, this);
        editDialog.setModal(true);
        editDialog.pack();
        editDialog.setVisible(true);
        propertyPanel.closing();
    }

    @Override
    public void onInsert() {
        AddTableDialog dialog = new AddTableDialog(this.m_query, WindowUtil.getParentFrame(this));
        dialog.setVisible(true);
    }

    @Override
    public void onDelete() {
        Table item = this.getSelectedItem();
        this.m_query.deleteTable(item);
        super.onDelete();
        this.firePropertyChanges();
    }

    @Override
    public void onMovePart(int oldIndex, int newIndex) {
        this.firePropertyChanges();
    }

    protected Table getSelectedItem() {
        Table item = null;
        if (this.getSelectedPart() != null) {
            item = (Table)this.getSelectedPart().getData();
        }
        return item;
    }
}

