/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.collection.OrderedCollection;
import com.sas.query.Query;
import com.sas.query.QueryDefiner;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.models.ResultItemList;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.ResultPanel;
import com.sas.query.visuals.SqlPanel;
import com.sas.query.visuals.SummaryView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class QueryTabView
extends JPanel
implements ModelChangeListener,
ChangeListener {
    protected Query m_query;
    protected Vector m_listeners;
    protected JTabbedPane m_tabbedPane;
    protected ResultPanel m_resultPanel;
    protected SqlPanel m_sqlPanel;
    protected JPanel m_queryPanel;
    protected JPanel m_wherePanel;
    protected JPanel m_havingPanel;
    protected boolean m_currentlyProcessingSetSelectedTabEvent = false;
    protected boolean m_recynchingModelAndTabber = false;
    public static final int QUERY_TAB = 0;
    public static final int DATA_FILTER_TAB = 1;
    public static final int GROUP_FILTER_TAB = 2;
    public static final int RESULTS_TAB = 3;
    public static final int SQL_TAB = 4;
    protected Dimension m_preferredSize;
    protected int[] defaultTabs = new int[]{0, 1, 2, 3, 4};
    protected static QueryResource bundle = new QueryResource(QueryTabView.class);
    protected String[] tabNames = new String[]{bundle.getString("QueryTabView.SelectAndFrom.txt"), bundle.getString("QueryTabView.WhereClauseBuilder.txt"), bundle.getString("QueryTabView.GroupBy.txt"), bundle.getString("QueryTabView.Results.txt"), bundle.getString("QueryTabView.SQL.txt")};
    protected int[] curTabOrder;

    public QueryTabView() {
        this.setLayout(new BorderLayout());
        this.m_tabbedPane = new JTabbedPane();
        this.m_tabbedPane.setModel(new DefaultSingleSelectionModel(){

            @Override
            public void setSelectedIndex(int index) {
                if (QueryTabView.this.m_recynchingModelAndTabber) {
                    return;
                }
                int sqlindex = QueryTabView.this.m_tabbedPane.getSelectedIndex();
                if (QueryTabView.this.OkToChangeTabs()) {
                    if (QueryTabView.this.hasPendingChanges()) {
                        QueryTabView.this.discardPendingChanges();
                    }
                    super.setSelectedIndex(index);
                } else {
                    QueryTabView.this.m_recynchingModelAndTabber = true;
                    QueryTabView.this.m_tabbedPane.getModel().setSelectedIndex(sqlindex);
                    QueryTabView.this.m_recynchingModelAndTabber = false;
                }
            }
        });
        this.add(this.m_tabbedPane);
        this.setTabOrder(this.defaultTabs);
        this.m_tabbedPane.addChangeListener(this);
    }

    public QueryTabView(Query query) {
        this();
        this.setQuery(query);
    }

    protected boolean OkToChangeTabs() {
        boolean retVal = false;
        if (!this.m_currentlyProcessingSetSelectedTabEvent) {
            this.m_currentlyProcessingSetSelectedTabEvent = true;
            if (this.hasPendingChanges()) {
                Object[] warningOptions = new Object[]{bundle.getString("Common.Discard.txt"), bundle.getString("Common.Cancel.txt")};
                int warningChoice = JOptionPane.showOptionDialog(this, bundle.getString("QueryTabView.DiscardUnappliedMessage.txt"), bundle.getString("QueryTabView.DiscardUnappliedTitle.txt"), 2, 2, null, warningOptions, warningOptions[0]);
                retVal = warningChoice == 0;
            } else {
                retVal = true;
            }
        }
        this.m_currentlyProcessingSetSelectedTabEvent = false;
        return retVal;
    }

    public boolean hasPendingChanges() {
        if (this.m_sqlPanel == null) {
            return false;
        }
        return this.m_sqlPanel.hasPendingChanges();
    }

    public void discardPendingChanges() {
        if (this.m_sqlPanel == null) {
            return;
        }
        this.m_sqlPanel.discardPendingChanges();
    }

    protected void initTabs() {
        try {
            this.orderTabs();
        }
        catch (Throwable t) {
            this.m_query.getMessageHandler().addInternalError(t);
        }
    }

    public void setTabOrder(int[] orderArray) {
        int[] oldTabOrder = this.curTabOrder;
        this.curTabOrder = orderArray;
        this.firePropertyChange("tabOrder", oldTabOrder, this.curTabOrder);
    }

    public void setTabOrder(String[] strArray) {
        int[] orderArray = new int[strArray.length];
        for (int i = 0; i < strArray.length; ++i) {
            String t1 = strArray[i];
            int curInt = -1;
            for (int i2 = 0; i2 < this.tabNames.length; ++i2) {
                if (!t1.equals(this.tabNames[i2])) continue;
                curInt = i2;
                break;
            }
            if (curInt <= -1) continue;
            orderArray[i] = curInt;
        }
        this.setTabOrder(orderArray);
    }

    public OrderedCollection getFormattedCurrentTabs() {
        return this.getFormattedTabs(this.curTabOrder);
    }

    public OrderedCollection getFormattedDefaultTabs() {
        return this.getFormattedTabs(this.defaultTabs);
    }

    protected OrderedCollection getFormattedTabs(int[] orderArray) {
        String curTabs = this.tabNames[orderArray[0]];
        for (int i = 1; i < orderArray.length; ++i) {
            curTabs = curTabs + "," + this.tabNames[orderArray[i]];
        }
        return new OrderedCollection(curTabs);
    }

    public int[] getTabOrder() {
        return this.curTabOrder;
    }

    public int[] getDefaultTabOrder() {
        return this.defaultTabs;
    }

    public void orderTabs() {
        this.orderTabs(this.curTabOrder);
    }

    public void orderTabs(int[] orderArray) {
        if (this.m_query != null) {
            this.m_tabbedPane.setVisible(false);
            int numtabs = orderArray.length;
            for (int i = 0; i < numtabs; ++i) {
                int componentId = orderArray[i];
                if (componentId == -1) {
                    this.m_tabbedPane.removeTabAt(i);
                    continue;
                }
                this.addIndexPanel(orderArray[i]);
            }
            this.setState();
            this.m_tabbedPane.setVisible(true);
        }
    }

    protected void addIndexPanel(int panelId) {
        switch (panelId) {
            case 0: {
                if (this.isQueryTabVisible()) break;
                this.addQueryPanel();
                break;
            }
            case 1: {
                if (this.isDataFiltersTabVisible()) break;
                this.addWherePanel();
                break;
            }
            case 2: {
                if (this.isGroupFiltersTabVisible()) break;
                this.addHavingPanel();
                break;
            }
            case 3: {
                if (this.isResultsTabVisible()) break;
                this.addResultsPanel();
                break;
            }
            case 4: {
                if (this.isSQLTabVisible()) break;
                this.addSQLPanel();
            }
        }
    }

    public void setQuery(Query q) {
        if (this.m_query != null) {
            this.m_query.removePropertyListener(this);
        }
        this.m_query = q;
        this.m_query.addPropertyListener(this, 512);
        this.m_query.addPropertyListener(this, 65535);
        this.initTabs();
        this.setState();
    }

    public Query getQuery() {
        return this.m_query;
    }

    public Component getActiveTab() {
        return this.m_tabbedPane.getSelectedComponent();
    }

    public int getActiveTabIndex() {
        return this.m_tabbedPane.getSelectedIndex();
    }

    public void addQueryPanel() {
        if (this.m_queryPanel == null) {
            this.m_queryPanel = new QueryDefiner(this.m_query, 290, 0);
        }
        this.m_tabbedPane.addTab(bundle.getString("QueryTabView.QueryTabLabel.txt"), null, this.m_queryPanel, bundle.getString("QueryTabView.QueryTabTip.txt"));
    }

    public JPanel getQueryPanel() {
        return this.m_queryPanel;
    }

    public void addWherePanel() {
        if (this.m_wherePanel == null) {
            QueryDefiner dataFilters = new QueryDefiner(this.m_query, 65, 0);
            this.m_wherePanel = new JPanel();
            this.m_wherePanel.setLayout(new BorderLayout());
            this.m_wherePanel.add(dataFilters);
            SummaryView wherebar = new SummaryView(this.m_query, 4);
            wherebar.showEditorButtons(false);
            wherebar.setBorder(BorderFactory.createEmptyBorder(0, 12, 12, 12));
            this.m_wherePanel.add("South", wherebar);
        }
        this.m_tabbedPane.addTab(bundle.getString("QueryTabView.DataFiltersTabLabel.txt"), null, this.m_wherePanel, bundle.getString("QueryTabView.DataFiltersTabTip.txt"));
    }

    public void addHavingPanel() {
        if (this.m_havingPanel == null) {
            QueryDefiner recordFilters = new QueryDefiner(this.m_query, 576, 0);
            this.m_havingPanel = new JPanel();
            this.m_havingPanel.setLayout(new BorderLayout());
            this.m_havingPanel.add(recordFilters);
            this.m_havingPanel.add("South", new SummaryView(this.m_query, 16));
        }
        this.m_tabbedPane.addTab(bundle.getString("QueryTabView.GroupFiltersTabLabel.txt"), null, this.m_havingPanel, bundle.getString("QueryTabView.GroupFiltersTabTip.txt"));
    }

    public void addResultsPanel() {
        if (this.m_resultPanel == null) {
            this.m_resultPanel = new ResultPanel(this.m_query);
        }
        this.m_tabbedPane.addTab(bundle.getString("QueryTabView.ResultsTabLabel.txt"), null, this.m_resultPanel, bundle.getString("QueryTabView.ResultsTabTip.txt"));
    }

    public void addSQLPanel() {
        if (this.m_sqlPanel == null) {
            this.m_sqlPanel = new SqlPanel(this.m_query);
        }
        this.m_tabbedPane.addTab(bundle.getString("QueryTabView.SQLTabLabel.txt"), null, this.m_sqlPanel, bundle.getString("QueryTabView.SQLTabTip.txt"));
    }

    protected void showTab(int componentConstant, boolean doShow) {
        this.showTab(componentConstant, doShow, -1);
    }

    protected void showTab(int componentConstant, boolean doShow, int index) {
        int i;
        int position = -1;
        int highestTab = 0;
        int maxTabs = this.curTabOrder.length;
        for (i = 0; i < maxTabs; ++i) {
            if (this.curTabOrder[i] == componentConstant) {
                position = i;
            }
            if (this.curTabOrder[i] >= 0) continue;
            highestTab = i;
        }
        if (index == -1) {
            index = highestTab;
        }
        if (position >= 0 && !doShow) {
            this.curTabOrder[position] = -1;
        } else if (position == -1 && doShow) {
            if (index < highestTab) {
                for (i = highestTab; i > index; --i) {
                    this.curTabOrder[i] = this.curTabOrder[i - 1];
                }
            }
            this.curTabOrder[index] = componentConstant;
        }
        this.orderTabs();
    }

    public void setQueryTabVisible(boolean doShow) {
        this.showTab(0, doShow);
    }

    public void setResultsTabVisible(boolean doShow) {
        this.showTab(3, doShow);
    }

    public void setSQLTabVisible(boolean doShow) {
        this.showTab(4, doShow);
    }

    public void setDataFiltersTabVisible(boolean doShow) {
        this.showTab(1, doShow);
    }

    public void setGroupFiltersTabVisible(boolean doShow) {
        this.showTab(2, doShow);
    }

    protected boolean isTabVisible(Component c) {
        return this.m_tabbedPane.indexOfComponent(c) >= 0;
    }

    public boolean isQueryTabVisible() {
        return this.isTabVisible(this.m_queryPanel);
    }

    public boolean isResultsTabVisible() {
        return this.isTabVisible(this.m_resultPanel);
    }

    public boolean isSQLTabVisible() {
        return this.isTabVisible(this.m_sqlPanel);
    }

    public boolean isDataFiltersTabVisible() {
        return this.isTabVisible(this.m_wherePanel);
    }

    public boolean isGroupFiltersTabVisible() {
        return this.isTabVisible(this.m_havingPanel);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.m_preferredSize == null) {
            this.m_preferredSize = new Dimension(600, 500);
        }
        return this.m_preferredSize;
    }

    public void setState() {
        if (this.m_tabbedPane != null) {
            Component selComp;
            int tabIndex = this.m_tabbedPane.indexOfComponent(this.m_queryPanel);
            boolean enabled = this.m_query.isParsable();
            if (tabIndex >= 0) {
                this.m_tabbedPane.setEnabledAt(tabIndex, enabled);
            }
            boolean bWhereFilterTreePresent = false;
            if (this.getQuery().getWhereFilterTree().getRoot() != null) {
                bWhereFilterTreePresent = true;
            }
            tabIndex = this.m_tabbedPane.indexOfComponent(this.m_wherePanel);
            enabled = this.m_query.isParsable();
            boolean bl = enabled = enabled && (this.m_query.getTableCount() > 0 || bWhereFilterTreePresent);
            if (tabIndex >= 0) {
                this.m_tabbedPane.setEnabledAt(tabIndex, enabled);
            }
            boolean bAggregatesUsed = false;
            ResultItemList list = this.m_query.getResultItems();
            int cItems = list.size();
            for (int index = 0; index < cItems; ++index) {
                if (!list.elementAt(index).getExpression().isAggregation()) continue;
                bAggregatesUsed = true;
                break;
            }
            boolean bGroupsPresent = false;
            if (this.getQuery().getGroupItemCount() > 0) {
                bGroupsPresent = true;
            }
            boolean bHavingFilterTreePresent = false;
            if (this.getQuery().getHavingFilterTree().getRoot() != null) {
                bHavingFilterTreePresent = true;
            }
            tabIndex = this.m_tabbedPane.indexOfComponent(this.m_havingPanel);
            enabled = this.m_query.isParsable();
            boolean bl2 = enabled = enabled && (bAggregatesUsed || bGroupsPresent || bHavingFilterTreePresent);
            if (tabIndex >= 0) {
                this.m_tabbedPane.setEnabledAt(tabIndex, enabled);
            }
            if ((tabIndex = this.m_tabbedPane.indexOfComponent(this.m_sqlPanel)) >= 0 && !this.m_query.isParsable() && this.m_tabbedPane.getSelectedIndex() != tabIndex) {
                this.m_tabbedPane.setSelectedIndex(tabIndex);
            }
            tabIndex = this.m_tabbedPane.indexOfComponent(this.m_resultPanel);
            enabled = this.m_query.canResultsBeGotten();
            if (tabIndex >= 0) {
                this.m_tabbedPane.setEnabledAt(tabIndex, enabled);
            }
            if ((selComp = this.m_tabbedPane.getSelectedComponent()) != null && !this.m_tabbedPane.isEnabledAt(this.m_tabbedPane.getSelectedIndex())) {
                tabIndex = this.m_tabbedPane.indexOfComponent(this.m_queryPanel);
                if (this.m_tabbedPane.isEnabledAt(this.m_tabbedPane.getSelectedIndex())) {
                    this.m_tabbedPane.setSelectedComponent(this.m_queryPanel);
                } else {
                    this.m_tabbedPane.setSelectedComponent(this.m_sqlPanel);
                }
            }
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = new Vector();
        }
        this.m_listeners.addElement(listener);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        for (int index = 0; this.m_listeners != null && index < this.m_listeners.size(); ++index) {
            ((ChangeListener)this.m_listeners.elementAt(index)).stateChanged(new ChangeEvent(this));
        }
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        this.setState();
    }
}

