/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.QueryUtils;
import com.sas.query.models.MessageHandler;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class QueryResource {
    protected static Hashtable m_bundleCache;
    protected boolean m_bResourceFileMissing = false;
    protected String m_strResourceFileName;
    protected ResourceBundle m_bundle;

    public QueryResource(String strResourceFileName) {
        this.m_bundle = this._getBundle(strResourceFileName);
    }

    public QueryResource(Class source) {
        String strClassName = source.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        this.m_bundle = this._getBundle(strPackageName + ".PropertyBundle");
    }

    protected ResourceBundle getCachedBundle(String key) {
        if (m_bundleCache == null) {
            m_bundleCache = new Hashtable();
        }
        return (ResourceBundle)m_bundleCache.get(key);
    }

    protected void cacheBundle(String key, ResourceBundle bundle) {
        m_bundleCache.put(key, bundle);
    }

    protected ResourceBundle _getBundle(String strBundlePath) {
        ResourceBundle returnValue = this.getCachedBundle(strBundlePath);
        if (returnValue != null) {
            return returnValue;
        }
        Locale locale = Locale.getDefault();
        try {
            returnValue = ResourceBundle.getBundle(strBundlePath, locale);
        }
        catch (Throwable e) {
            try {
                returnValue = PropertyResourceBundle.getBundle(strBundlePath, locale);
            }
            catch (Throwable e2) {
                this.m_bResourceFileMissing = true;
                return null;
            }
        }
        this.cacheBundle(strBundlePath, returnValue);
        this.m_strResourceFileName = strBundlePath;
        return returnValue;
    }

    public String getString(String key) {
        String retValue;
        block7: {
            retValue = "";
            if (this.m_bundle == null) {
                retValue = new QueryResource(QueryResource.class).messageString("CommonUI.unableLoadResourceContaining.txt") + key;
                MessageHandler.addStaticError(retValue);
                try {
                    throw new Throwable();
                }
                catch (Throwable t) {
                    MessageHandler.addStaticError(t);
                    break block7;
                }
            }
            if (this.m_bResourceFileMissing) {
                retValue = "Missing resource file " + this.m_strResourceFileName;
                MessageHandler.addStaticError(retValue);
            } else {
                try {
                    retValue = this.m_bundle.getString(key);
                }
                catch (Throwable t) {
                    retValue = "Missing resource " + key;
                    MessageHandler.addStaticError(t);
                    MessageHandler.addStaticError(retValue);
                }
            }
        }
        return retValue;
    }

    public String getRawString(String key) {
        String retValue = null;
        if (this.m_bundle != null && !this.m_bResourceFileMissing) {
            try {
                retValue = this.m_bundle.getString(key);
                retValue = retValue.trim();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return retValue;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int notFoundReturnValue) {
        try {
            String strValue = this.m_bundle.getString(key);
            return new Integer(strValue);
        }
        catch (Throwable throwable) {
            return notFoundReturnValue;
        }
    }

    public ImageIcon getImageIcon(String key) {
        try {
            String strValue = this.m_bundle.getString(key);
            if ("null".equals(strValue)) {
                return null;
            }
            byte[] byteArray = QueryUtils.convertHexStringToByteArray(strValue);
            return new ImageIcon(byteArray);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String messageString(String key) {
        String pattern = this.getString(key);
        return pattern;
    }

    public String messageString(String key, Object parm1) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3, Object parm4) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3, Object parm4, Object parm5) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString(), parm5.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3, Object parm4, Object parm5, Object parm6) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString(), parm5.toString(), parm6.toString()};
        return MessageFormat.format(pattern, args);
    }

    public Enumeration getKeys() {
        if (this.m_bundle != null && !this.m_bResourceFileMissing) {
            return this.m_bundle.getKeys();
        }
        return null;
    }
}

