/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.visuals.QueryComponentInterface;
import com.sas.query.visuals.QueryResource;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTextField;

public class QueryComponentDialog
extends JDialog {
    public static final int OK = 1;
    public static final int CANCEL = 2;
    protected Query m_query;
    protected Frame m_parentFrame;
    protected QueryComponentInterface m_propertyPanel;
    protected int m_returnValue = 2;
    protected GridBagLayout m_gridBagLayout;
    protected JButton m_okButton;
    protected JButton m_closeButton;
    protected String m_strDialogResourceKey;
    protected String m_strTitle;
    protected String m_strOkLabel;
    protected String m_strCancelLabel;
    static QueryResource bundle = new QueryResource(QueryComponentDialog.class);

    public QueryComponentDialog(Frame parentFrame, Query query, QueryComponentInterface propertyPanel, String strDialogResourceKey) {
        super(parentFrame, " ", true);
        this.m_parentFrame = parentFrame;
        this.m_query = query;
        this.m_propertyPanel = propertyPanel;
        this.m_strDialogResourceKey = strDialogResourceKey;
        this._initialization();
        this.m_okButton.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.m_okButton);
    }

    public void onOK() {
        if (!this.m_propertyPanel.validateInput()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.m_propertyPanel.doDataExchange(true);
        if (this.m_query != null) {
            this.m_query.getPropertyChangeHandler().firePropertyChanges();
            this.m_query.isValidSql();
            MessageUtil.displayMessages(this.m_query.getMessageHandler());
        }
        this.m_returnValue = 1;
        this.dispose();
    }

    public void onCancel() {
        this.m_returnValue = 2;
        this.dispose();
    }

    public int getReturnValue() {
        return this.m_returnValue;
    }

    public void removeCancelButton() {
        this.m_closeButton.setVisible(false);
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                QueryComponentDialog.this.onCancel();
            }
        });
    }

    protected void _initialization() {
        this.m_strTitle = bundle.getString(this.m_strDialogResourceKey);
        this.m_strOkLabel = bundle.getString("Standard.ButtonLabel.Ok.txt");
        this.m_strCancelLabel = bundle.getString("Standard.ButtonLabel.Cancel.txt");
        this._layoutWidgets();
        this._addKeyListeners(this, new KeyHandler());
        this.m_propertyPanel.doDataExchange(false);
    }

    public void _layoutWidgets() {
        this.setResizable(true);
        this.m_gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(this.m_gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(8, 8, 8, 8);
        this.m_gridBagLayout.setConstraints((Component)((Object)this.m_propertyPanel), gbc);
        this.getContentPane().add((Component)((Object)this.m_propertyPanel));
        int nextButtonGridY = 1;
        this.m_okButton = new JButton(this.m_strOkLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = nextButtonGridY++;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = new Insets(16, 8, 0, 12);
        this.m_gridBagLayout.setConstraints(this.m_okButton, gbc);
        this.getContentPane().add(this.m_okButton);
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                QueryComponentDialog.this.onOK();
            }
        });
        this.m_closeButton = new JButton(this.m_strCancelLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = nextButtonGridY++;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = new Insets(8, 8, 0, 12);
        this.m_gridBagLayout.setConstraints(this.m_closeButton, gbc);
        this.getContentPane().add(this.m_closeButton);
        this.m_closeButton.addActionListener(new DialogCloser(this));
        JButton bHelp = new JButton(bundle.getString("Common.Help.txt"));
        String helpKey = "ComponentDialog." + this.m_strDialogResourceKey;
        boolean helpAvailable = false;
        if (helpAvailable) {
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = nextButtonGridY++;
            gbc.anchor = 12;
            gbc.fill = 2;
            gbc.insets = new Insets(8, 8, 8, 12);
            this.m_gridBagLayout.setConstraints(bHelp, gbc);
            this.getContentPane().add(bHelp);
        }
        this.setTitle(this.m_strTitle);
        this.addWindowListener(new DialogCloser(this));
    }

    protected void _addKeyListeners(Container container, KeyHandler keyHandler) {
        Component[] components = container.getComponents();
        for (int index = 0; index < components.length; ++index) {
            components[index].addKeyListener(keyHandler);
            if (!(components[index] instanceof Container)) continue;
            this._addKeyListeners((Container)components[index], keyHandler);
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyTyped(KeyEvent event) {
            if (event.getKeyChar() == '\u001b') {
                QueryComponentDialog.this.onCancel();
            }
            if (event.getKeyChar() == '\r' && event.getSource() instanceof JTextField && QueryComponentDialog.this.m_okButton.isDefaultButton()) {
                QueryComponentDialog.this.onOK();
            }
        }
    }

    protected static final class DialogCloser
    extends WindowAdapter
    implements ActionListener {
        QueryComponentDialog m_dialog;

        DialogCloser(QueryComponentDialog dialog) {
            this.m_dialog = dialog;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.m_dialog.onCancel();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.m_dialog.onCancel();
        }
    }
}

