/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.QueryResource;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import javax.swing.JComponent;

public class Part
extends Rectangle {
    protected JComponent _parent;
    protected Color _fg;
    protected Color _bg;
    protected Font _font;
    protected boolean _visible = true;
    protected Boolean _transparent;
    protected static QueryResource bundle = new QueryResource(Part.class);

    protected Part() {
    }

    public Part(JComponent parent) {
        this();
        this.setParent(parent);
    }

    public Part(JComponent parent, Dimension size) {
        this.setSize(size);
        this.setParent(parent);
    }

    public Part(JComponent parent, Rectangle size) {
        this.setSize(size.getSize());
        this.setLocation(size.getLocation());
        this.setParent(parent);
    }

    public JComponent getParent() {
        return this._parent;
    }

    public void setParent(JComponent parent) {
        if (parent != null && !parent.equals(this._parent)) {
            this._parent = parent;
        }
    }

    public void repaint() {
        try {
            JComponent parent = this.getParent();
            parent.repaint(this.x, this.y, this.width, this.height);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void paint(Graphics g) {
        try {
            Rectangle clip = g.getClipBounds();
            if (this.isVisible() && this.intersects(clip)) {
                Font font = g.getFont();
                Rectangle c = this.getBounds();
                c = this.intersection(clip);
                g.setClip(c.x, c.y, c.width, c.height);
                g.setFont(this.getFont());
                if (!this.isTransparent()) {
                    this.paintBackground(g);
                }
                if (g instanceof PrintGraphics) {
                    this.printView((PrintGraphics)((Object)g));
                } else {
                    this.paintView(g);
                }
                if (clip != null) {
                    g.setClip(clip);
                }
                g.setFont(font);
            }
        }
        catch (NullPointerException e) {
            MessageHandler.addStaticError(bundle.messageString("Part.nullPtrInPaint.txt") + e + g);
        }
    }

    public void paint(JComponent component, Graphics g, int x, int y, int width, int height) {
        this.setParent(component);
        this.paint(g);
    }

    protected void paintView(Graphics g) {
    }

    protected void paintBackground(Graphics g) {
    }

    protected void printView(PrintGraphics g) {
        this.paintView((Graphics)((Object)g));
    }

    public Dimension getPreferredSize() {
        return this.getPreferredSize(null);
    }

    public Dimension getPreferredSize(Graphics g) {
        Dimension size = new Dimension(0, 0);
        return size;
    }

    public Dimension getMinimumSize() {
        Dimension size = new Dimension(0, 0);
        return size;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setBackground(Color c) {
        this._bg = c instanceof SystemColor ? new Color(c.getRGB()) : c;
    }

    public Color getBackground() {
        Color bg = null;
        if (this._bg != null) {
            bg = this._bg;
        } else {
            try {
                bg = this._parent.getBackground();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return bg;
    }

    public void setForeground(Color c) {
        this._fg = c instanceof SystemColor ? new Color(c.getRGB()) : c;
    }

    public Color getForeground() {
        Color fg = null;
        if (this._fg != null) {
            fg = this._fg;
        } else {
            try {
                fg = this._parent.getForeground();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return fg;
    }

    public void setFont(Font font) {
        this._font = font;
    }

    public Font getFont() {
        Font font = null;
        if (this._font != null) {
            font = this._font;
        } else {
            try {
                font = this._parent.getFont();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return font;
    }

    public void setVisible(boolean visible) {
        if (this._visible != visible) {
            this._visible = visible;
        }
    }

    public boolean isVisible() {
        JComponent parent = this.getParent();
        boolean visible = false;
        if (parent != null) {
            visible = parent.isVisible();
        }
        return this._visible && !this.isEmpty();
    }

    public void setTransparent(boolean transparent) {
        this._transparent = new Boolean(transparent);
    }

    public boolean isTransparent() {
        boolean transparent = true;
        if (this._transparent == null) {
            if (this._bg != null && transparent) {
                transparent = false;
            }
        } else {
            transparent = this._transparent;
        }
        return transparent;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

