/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.models.OrderItem;
import com.sas.query.visuals.QueryComponentInterface;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.SqlTextHelperConstants;
import com.sas.query.visuals.SqlTextPanel;
import com.sas.query.visuals.SqlTextPanelPlus;
import com.sas.query.visuals.StandardView;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OrderItemPropertyView
extends StandardView
implements QueryComponentInterface,
SqlTextHelperConstants {
    protected OrderItem m_OrderItem;
    protected SqlTextPanel m_expressionText;
    protected JComboBox m_sortDirectionChoice;
    protected static QueryResource bundle = new QueryResource(OrderItemPropertyView.class);

    public OrderItemPropertyView(Query query, OrderItem OrderItem2) {
        super(query);
        this.m_OrderItem = OrderItem2;
        this._initialize();
        this._layoutWidgets();
        this._setState();
    }

    public void setOrderItem(OrderItem OrderItem2) {
        this.doDataExchange(true);
        this.m_OrderItem = OrderItem2;
        this.doDataExchange(false);
        if (this.m_OrderItem == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    @Override
    public void closing() {
    }

    @Override
    public boolean validateInput() {
        return true;
    }

    @Override
    public void doDataExchange(boolean bSaveToModel) {
        if (this.m_OrderItem == null) {
            return;
        }
        String defStr = bundle.getString("Common.defaultinBrackets.txt");
        String ascStr = bundle.getString("Common.Ascending.txt");
        String descStr = bundle.getString("Common.Descending.txt");
        if (bSaveToModel) {
            if (this.m_expressionText.getExpression() != this.m_OrderItem.getExpression()) {
                this.m_OrderItem.setExpression(this.m_expressionText.getExpression());
            }
            if (this.m_sortDirectionChoice.getSelectedItem().equals(ascStr)) {
                this.m_OrderItem.setSortingDirection(1);
            } else if (this.m_sortDirectionChoice.getSelectedItem().equals(descStr)) {
                this.m_OrderItem.setSortingDirection(2);
            } else if (this.m_sortDirectionChoice.getSelectedItem().equals(defStr)) {
                this.m_OrderItem.setSortingDirection(0);
            }
        } else {
            this.m_expressionText.setExpression(this.m_OrderItem.getExpression());
            if (this.m_OrderItem.getSortingDirection() == 1) {
                this.m_sortDirectionChoice.setSelectedItem(ascStr);
            } else if (this.m_OrderItem.getSortingDirection() == 2) {
                this.m_sortDirectionChoice.setSelectedItem(descStr);
            } else if (this.m_OrderItem.getSortingDirection() == 0) {
                this.m_sortDirectionChoice.setSelectedItem(defStr);
            }
        }
    }

    protected void _initialize() {
        this.m_expressionText = new SqlTextPanelPlus(2);
        this.m_expressionText.setQuery(this.m_query);
        this.m_expressionText.setBehavior(16);
        this.m_sortDirectionChoice = new JComboBox();
        this.m_sortDirectionChoice.addItem(bundle.getString("Common.defaultinBrackets.txt"));
        this.m_sortDirectionChoice.addItem(bundle.getString("Common.Ascending.txt"));
        this.m_sortDirectionChoice.addItem(bundle.getString("Common.Descending.txt"));
    }

    protected void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        JLabel label = new JLabel(bundle.getString("OrderItemListView.Direction2.txt"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(4, 0, 0, 8);
        gridBagLayout.setConstraints(label, gbc);
        this.add(label);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_sortDirectionChoice, gbc);
        this.add(this.m_sortDirectionChoice);
        JPanel borderPanel = new JPanel();
        borderPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), bundle.getString("CommonUI.BorderTitle.Expression.txt")));
        borderPanel.setLayout(new BorderLayout());
        borderPanel.add("Center", this.m_expressionText);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = new Insets(6, 0, 0, 0);
        gridBagLayout.setConstraints(borderPanel, gbc);
        this.add(borderPanel);
    }

    protected void _setState() {
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(260, 280);
    }
}

