/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.OrderItem;
import com.sas.query.models.OrderItemList;
import com.sas.query.visuals.BarNoun;
import com.sas.query.visuals.BarView;
import com.sas.query.visuals.OrderItemPropertyView;
import com.sas.query.visuals.QueryComponentDialog;
import com.sas.query.visuals.WindowUtil;
import java.awt.Color;

public class OrderItemBarView
extends BarView {
    public OrderItemBarView(Query query) {
        super(query, bundle.getString("OrderItemBarView.OrderBy.txt"), new Color(0, 204, 255), Color.black);
        this.m_query.addPropertyListener(this, 256);
        this.refresh();
    }

    @Override
    public void closing() {
        this.m_query.removePropertyListener(this);
    }

    @Override
    public void refresh() {
        OrderItemList list = this.m_query.getOrderItems();
        this.removeAllParts();
        for (int index = 0; index < list.size(); ++index) {
            OrderItem item = list.elementAt(index);
            try {
                BarNoun noun = new BarNoun(item, item.getClass().getMethod("getDisplayString", null));
                this.addPart(noun);
                continue;
            }
            catch (Exception e) {
                this.m_query.getMessageHandler().addError("Error creating OrderItem BarNoun ");
                this.m_query.getMessageHandler().addInternalError(e);
            }
        }
        super.refresh();
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        this.refresh();
    }

    @Override
    public boolean hasEditor() {
        return false;
    }

    @Override
    public void onEditBar() {
    }

    @Override
    public void onEdit() {
        OrderItem item = this.getSelectedItem();
        OrderItemPropertyView propertyPanel = new OrderItemPropertyView(this.m_query, item);
        QueryComponentDialog editDialog = new QueryComponentDialog(WindowUtil.getParentFrame(this), this.m_query, propertyPanel, "BUG - need Prefix");
        WindowUtil.centerOverWindow(editDialog, this);
        editDialog.setModal(true);
        editDialog.pack();
        editDialog.setVisible(true);
        propertyPanel.closing();
        this.displayMessages();
    }

    @Override
    public void onInsert() {
    }

    @Override
    public void onDelete() {
        OrderItem item = (OrderItem)this.getSelectedPart().getData();
        this.m_query.deleteOrderItem(item);
        super.onDelete();
        this.displayMessages();
        this.firePropertyChanges();
    }

    @Override
    public void onMovePart(int oldIndex, int newIndex) {
        if (oldIndex != newIndex) {
            this.m_query.moveOrderItem(oldIndex, newIndex);
        }
        this.refresh();
        this.displayMessages();
        this.firePropertyChanges();
    }

    protected OrderItem getSelectedItem() {
        OrderItem item = null;
        if (this.getSelectedPart() != null) {
            item = (OrderItem)this.getSelectedPart().getData();
        }
        return item;
    }
}

