/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.StandardToolbarButton;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;

public class MenuUtil {
    public static final String imageSuffix = "Image";
    public static final String labelSuffix = ".Label.txt";
    public static final String mneumonicSuffix = ".Accelerator.txt";
    public static final String actionSuffix = "Action";
    public static final String shortcutSuffix = "Shortcut";
    public static final String tipSuffix = ".Tooltip.txt";
    public static final String toolTypeSuffix = "Type";

    public static JMenuBar createMenubar(QueryResource resources, String key, Hashtable menuItems, Hashtable actionList) {
        JMenuBar menuBar = new JMenuBar();
        menuBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        String[] menuKeys = MenuUtil.tokenize(MenuUtil.getResourceString(resources, key));
        for (int index = 0; index < menuKeys.length; ++index) {
            JMenu menu = MenuUtil.createMenu(resources, menuKeys[index], menuItems, actionList);
            if (menu == null) continue;
            menuBar.add(menu);
        }
        return menuBar;
    }

    public static JMenu createMenu(QueryResource resources, String key, Hashtable menuItems, Hashtable actionList) {
        String[] itemKeys = MenuUtil.tokenize(MenuUtil.getResourceString(resources, key));
        JMenu menu = new JMenu(MenuUtil.getResourceString(resources, key + labelSuffix));
        menu.setAlignmentX(0.0f);
        String mneumonic = MenuUtil.getResourceString(resources, key + mneumonicSuffix);
        if (mneumonic != null) {
            menu.setMnemonic(mneumonic.charAt(0));
        }
        for (int index = 0; index < itemKeys.length; ++index) {
            String name;
            Action a;
            if (itemKeys[index].equals("-")) {
                menu.addSeparator();
                continue;
            }
            String astr = MenuUtil.getResourceString(resources, itemKeys[index] + actionSuffix);
            if (astr == null) {
                astr = itemKeys[index];
            }
            if ((a = (Action)actionList.get(name = MenuUtil.getResourceString(resources, astr + labelSuffix))) != null) {
                menu.add(a);
                continue;
            }
            MessageHandler.addStaticError("Action not found for " + itemKeys[index]);
        }
        return menu;
    }

    public static JToolBar createToolbar(QueryResource resources, String key, Hashtable actionList) {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 12, 1, 12), BorderFactory.createBevelBorder(1)));
        String[] toolKeys = MenuUtil.tokenize(MenuUtil.getResourceString(resources, key));
        for (int index = 0; index < toolKeys.length; ++index) {
            String name;
            Action a;
            if (toolKeys[index].equals("-")) {
                toolbar.add(Box.createHorizontalStrut(8));
                continue;
            }
            String astr = MenuUtil.getResourceString(resources, toolKeys[index] + actionSuffix);
            if (astr == null) {
                astr = toolKeys[index];
            }
            if ((a = (Action)actionList.get(name = MenuUtil.getResourceString(resources, astr + labelSuffix))) != null) {
                toolbar.add(new StandardToolbarButton(a));
                continue;
            }
            MessageHandler.addStaticError("Action not found for " + toolKeys[index]);
        }
        toolbar.add(Box.createHorizontalGlue());
        return toolbar;
    }

    protected static String getResourceString(QueryResource resources, String nm) {
        String str;
        try {
            str = resources.getRawString(nm);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    public static String[] tokenize(String input) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = (String)v.elementAt(i);
        }
        return cmd;
    }
}

