/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.models.Join;
import com.sas.query.models.JoinConstants;
import com.sas.query.models.JoinList;
import com.sas.query.models.JoinRelationship;
import com.sas.query.models.JoinRelationshipList;
import com.sas.query.models.Table;
import com.sas.query.models.UnparsedExpression;
import com.sas.query.visuals.ButtonBar;
import com.sas.query.visuals.ClueView;
import com.sas.query.visuals.DrawUtil;
import com.sas.query.visuals.ExpressionEditDialog;
import com.sas.query.visuals.JoinTypeRadioGroup;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.SqlTextHelper;
import com.sas.query.visuals.SqlTextHelperConstants;
import com.sas.query.visuals.StandardView;
import com.sas.query.visuals.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JoinPropertyView
extends StandardView
implements JoinConstants,
SqlTextHelperConstants {
    protected Join m_join;
    protected JoinList m_joinList;
    protected JoinRelationshipList m_joinRelationshipList;
    protected boolean m_bRelationshipExists = true;
    protected ClueView m_initialClue;
    protected ClueView m_dragClue;
    protected JPanel m_previewPanel;
    protected JPanel m_leftTable;
    protected JPanel m_middlePanel;
    protected JPanel m_rightTable;
    protected JPanel m_typePanel;
    protected JLabel m_typeLabel;
    protected JRadioButton m_innerButton;
    protected JRadioButton m_leftButton;
    protected JRadioButton m_rightButton;
    protected JRadioButton m_fullButton;
    protected JoinTypeRadioGroup m_joinTypes;
    protected JPanel m_relationshipPanel;
    protected JLabel m_relationshipLabel;
    protected JList m_relationshipList;
    protected JButton m_editButton;
    protected JButton m_deleteButton;
    protected JButton m_insertButton;
    protected Color m_greenColor = new Color(102, 204, 153);
    private Table m_temp_leftTable;
    private Table m_temp_rightTable;
    protected transient ExpressionEditDialog m_expBuilder;
    public static final String joinPropertyChange = "joins";
    protected static QueryResource bundle = new QueryResource(JoinPropertyView.class);
    static boolean bFirstPaint = true;

    public JoinPropertyView(Query query, JoinList joinList, JoinRelationshipList joinRelationshipList) {
        super(query);
        this.m_joinList = joinList;
        this.m_joinRelationshipList = joinRelationshipList;
        this._initialize();
        this._layoutWidgets();
        this._setState();
        this.setPreferredSize(new Dimension(475, 340));
    }

    public void setJoin(Join join) {
        this.m_join = join;
        this._setState();
        this.repaint();
    }

    public void setJoinLists(JoinList joinList, JoinRelationshipList joinRelationshipList) {
        this.m_joinList = joinList;
        this.m_joinRelationshipList = joinRelationshipList;
        this._setState();
        this.repaint();
    }

    @Override
    public void closing() {
    }

    public void setSelectedJoinReleationship(JoinRelationship joinRel) {
        this.m_relationshipList.setSelectedValue(joinRel, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEditJoinRelationship() {
        JoinRelationship selectedRelationship = null;
        if (this.m_relationshipList != null) {
            selectedRelationship = (JoinRelationship)this.m_relationshipList.getSelectedValue();
        }
        if (selectedRelationship == null) {
            return;
        }
        this.busyOn();
        try {
            JoinPropertyView joinPropertyView = this;
            synchronized (joinPropertyView) {
                if (this.m_expBuilder != null) {
                    return;
                }
                this.m_expBuilder = new ExpressionEditDialog(WindowUtil.getParentFrame(this), true, selectedRelationship.getComparisonDetails(), this.m_query);
            }
            WindowUtil.centerOver(this.m_expBuilder, this.getRootPane());
            this.m_expBuilder.show();
            if (this.m_expBuilder.getReturnValue() == 1) {
                selectedRelationship.setComparisonDetails(this.m_expBuilder.getExpression());
                this.firePropertyChange(joinPropertyChange, null, this.m_joinRelationshipList);
                this._setState();
            }
        }
        catch (Throwable t) {
            this.busyOff();
            this.addInternalError(t);
        }
        this.busyOff();
        this.m_expBuilder = null;
    }

    public void onInsert() {
        ExpressionEditDialog expBuilder = null;
        this.busyOn();
        Component focus = null;
        SqlTextHelper helper = null;
        try {
            JTextField invisibleHolder = new JTextField();
            helper = new SqlTextHelper(invisibleHolder);
            helper.setQuery(this.getQuery());
            helper.setExpression(this.m_query, new UnparsedExpression(""));
            expBuilder = new ExpressionEditDialog(WindowUtil.getParentFrame(this.m_insertButton), true, helper);
            WindowUtil.centerOver(expBuilder, this.m_insertButton.getParent());
            focus = WindowUtil.getParentFrame(this.m_editButton).getFocusOwner();
            expBuilder.show();
        }
        catch (Throwable t) {
            this.busyOff();
            this.addInternalError(t);
        }
        this.busyOff();
        if (focus != null) {
            focus.requestFocus();
        }
        if (expBuilder != null && helper != null && expBuilder.m_success) {
            JoinRelationship jr = new JoinRelationship(this.m_query, this.m_temp_leftTable, this.m_temp_rightTable, 4, helper.getExpression());
            this.m_joinRelationshipList.addElement(jr);
            this.m_joinList.setAllRelationships(this.m_joinRelationshipList);
            this.m_joinList.groupJoinsFromList(this.m_joinRelationshipList);
            this.firePropertyChange(joinPropertyChange, null, this.m_joinRelationshipList);
            this._setState();
        }
    }

    public void onDelete() {
        if (this.m_relationshipList == null || this.m_relationshipList.getSelectedValue() == null) {
            return;
        }
        JoinRelationship jr = (JoinRelationship)this.m_relationshipList.getSelectedValue();
        this.m_joinRelationshipList.removeElement(jr);
        this.m_joinList.setAllRelationships(this.m_joinRelationshipList);
        this.m_joinList.groupJoinsFromList(this.m_joinRelationshipList);
        this.firePropertyChange(joinPropertyChange, null, this.m_joinRelationshipList);
        this._setState();
    }

    protected void _initialize() {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_initialClue = new ClueView(bundle.messageString("ClueView.viewJoinsDetailsByClickTableNameOnLeft.txt"), bundle.messageString("ClueView.howTableIsJoinedwPreviousTableIsDisplayed.txt"));
        this.m_initialClue.setSize(this.m_initialClue.getPreferredSize());
        this.m_dragClue = new ClueView(bundle.messageString("ClueView.dragSelectedTableToMovePosInJoinSequence.txt"), null);
        this.m_previewPanel = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (JoinPropertyView.this.m_join != null) {
                    if (JoinPropertyView.this.m_bRelationshipExists) {
                        DrawUtil.drawJoinLine(g, false, JoinPropertyView.this.m_join.getJoinType(), JoinPropertyView.this.m_leftTable.getBounds(), JoinPropertyView.this.m_rightTable.getBounds());
                    } else {
                        DrawUtil.drawJoinString(g, bundle.getString("JoinPropertyView.CartesianProduct.txt"), JoinPropertyView.this.m_leftTable.getBounds(), JoinPropertyView.this.m_rightTable.getBounds());
                    }
                }
            }
        };
        Dimension minimumSize = this.m_previewPanel.getMinimumSize();
        minimumSize.height = Math.max(minimumSize.height, 50);
        this.m_previewPanel.setMinimumSize(minimumSize);
        this.m_leftTable = new JPanel();
        this.m_leftTable.setLayout(new BorderLayout());
        this.m_leftTable.setBorder(BorderFactory.createRaisedBevelBorder());
        this.m_leftTable.setBackground(SystemColor.window);
        minimumSize.width /= 4;
        this.m_leftTable.setMinimumSize(minimumSize);
        this.m_middlePanel = new JPanel();
        this.m_middlePanel.setOpaque(true);
        this.m_middlePanel.setSize(5, 1);
        this.m_rightTable = new JPanel();
        this.m_rightTable.setLayout(new BorderLayout());
        this.m_rightTable.setBorder(BorderFactory.createRaisedBevelBorder());
        this.m_rightTable.setBackground(SystemColor.window);
        this.m_rightTable.add(new JLabel(""));
        this.m_rightTable.setMinimumSize(minimumSize);
        this.m_typePanel = new JPanel();
        this.m_typeLabel = new JLabel(bundle.getString("Common.Type.txt"));
        RadioListener radioListener = new RadioListener();
        this.m_joinTypes = new JoinTypeRadioGroup();
        this.m_innerButton = this.m_joinTypes.getButton(0);
        this.m_innerButton.addActionListener(radioListener);
        this.m_leftButton = this.m_joinTypes.getButton(1);
        this.m_leftButton.addActionListener(radioListener);
        this.m_rightButton = this.m_joinTypes.getButton(2);
        this.m_rightButton.addActionListener(radioListener);
        this.m_fullButton = this.m_joinTypes.getButton(3);
        this.m_fullButton.addActionListener(radioListener);
        this.m_relationshipPanel = new JPanel();
        this.m_relationshipLabel = new JLabel(bundle.getString("JoinPropertyView.JoinRelationships.txt"));
        this.m_relationshipList = new JList();
        this.m_relationshipList.setBackground(SystemColor.window);
        this.m_editButton = new JButton(bundle.getString("Common.Edit....txt"));
        this.m_editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JoinPropertyView.this.onEditJoinRelationship();
            }
        });
        this.m_deleteButton = new JButton(bundle.getString("Common.Delete.txt"));
        this.m_deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JoinPropertyView.this.onDelete();
            }
        });
        this.m_insertButton = new JButton(bundle.getString("Common.Insert....txt"));
        this.m_insertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JoinPropertyView.this.onInsert();
            }
        });
    }

    protected void _layoutWidgets() {
        this._layoutPreviewPanel();
        this._layoutTypePanel();
        this._layoutRelationshipPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_previewPanel, gbc);
        this.add(this.m_previewPanel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_typePanel, gbc);
        this.add(this.m_typePanel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 3.0;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(6, 0, 0, 0);
        gridBagLayout.setConstraints(this.m_relationshipPanel, gbc);
        this.add(this.m_relationshipPanel);
    }

    protected void _layoutPreviewPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.m_previewPanel.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 40, 0, 20);
        gridBagLayout.setConstraints(this.m_leftTable, gbc);
        this.m_previewPanel.add(this.m_leftTable);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gridBagLayout.setConstraints(this.m_middlePanel, gbc);
        this.m_previewPanel.add(this.m_middlePanel);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 20, 10, 20);
        gridBagLayout.setConstraints(this.m_rightTable, gbc);
        this.m_previewPanel.add(this.m_rightTable);
    }

    protected void _layoutTypePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.m_typePanel.setLayout(gridBagLayout);
        int gridy = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 10, 0, 10);
        gridBagLayout.setConstraints(this.m_typeLabel, gbc);
        this.m_typePanel.add(this.m_typeLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 10, 0, 10);
        gridBagLayout.setConstraints(this.m_joinTypes, gbc);
        this.m_typePanel.add(this.m_joinTypes);
    }

    protected void _layoutRelationshipPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.m_relationshipPanel.setLayout(gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 10, 0, 10);
        gridBagLayout.setConstraints(this.m_relationshipLabel, gbc);
        this.m_relationshipPanel.add(this.m_relationshipLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 3.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(6, 45, 10, 0);
        JScrollPane scroll = new JScrollPane(this.m_relationshipList);
        WindowUtil.fixupJScrollPane(scroll);
        gridBagLayout.setConstraints(scroll, gbc);
        this.m_relationshipPanel.add(scroll);
        Vector<Serializable> buttons = new Vector<Serializable>();
        buttons.addElement(this.m_editButton);
        buttons.addElement(new Integer(6));
        buttons.addElement(this.m_insertButton);
        buttons.addElement(new Integer(6));
        buttons.addElement(this.m_deleteButton);
        ButtonBar bbar = new ButtonBar(3, buttons, new Insets(0, 0, 0, 30), true);
        JScrollPane bbarScrollPane = new JScrollPane(bbar, 20, 31);
        bbarScrollPane.setBorder(BorderFactory.createEmptyBorder());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 12;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(6, 10, 2, 10);
        gridBagLayout.setConstraints(bbarScrollPane, gbc);
        this.m_relationshipPanel.add(bbarScrollPane);
        this.m_relationshipList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                JoinPropertyView.this.enableRelationshipButtons();
            }
        });
    }

    protected void _setState() {
        this.m_leftTable.removeAll();
        this.m_rightTable.removeAll();
        if (this.m_join == null) {
            this._setEnableAll(false);
        } else {
            Join join;
            this._setEnableAll(true);
            JPanel tempPanel = new JPanel();
            tempPanel.setBackground(SystemColor.window);
            GridBagLayout layout = new GridBagLayout();
            tempPanel.setLayout(layout);
            int index = 0;
            while (this.m_joinList != null && index < this.m_joinList.size() && (join = this.m_joinList.elementAt(index)) != this.m_join) {
                JLabel label = new JLabel(join.getTable().getDisplayName());
                this.m_temp_leftTable = join.getTable();
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = index++;
                gbc.weightx = 1.0;
                gbc.anchor = 10;
                gbc.insets = new Insets(1, 4, 1, 4);
                gbc.fill = 2;
                tempPanel.setBackground(this.m_greenColor);
                layout.setConstraints(label, gbc);
                tempPanel.add(label);
            }
            JScrollPane scrollPane = new JScrollPane(tempPanel);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.m_leftTable.add(scrollPane);
            JLabel rightName = new JLabel(this.m_join.getTable().getDisplayName());
            this.m_temp_rightTable = this.m_join.getTable();
            JPanel anotherDummy = new JPanel();
            GridBagLayout dummylayout = new GridBagLayout();
            anotherDummy.setLayout(dummylayout);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.insets = new Insets(1, 4, 1, 4);
            gbc.fill = 2;
            tempPanel.setBackground(this.m_greenColor);
            dummylayout.setConstraints(rightName, gbc);
            anotherDummy.add(rightName);
            JScrollPane rightscrollPane = new JScrollPane(anotherDummy);
            rightscrollPane.setBorder(BorderFactory.createEmptyBorder());
            anotherDummy.setBackground(this.m_greenColor);
            this.m_rightTable.add("Center", rightscrollPane);
            this.m_previewPanel.doLayout();
            this.m_leftTable.validate();
            this.m_rightTable.validate();
            this.m_previewPanel.repaint();
            JoinRelationshipList relationships = this.m_join.getRelationships();
            Vector<JoinRelationship> vector = new Vector<JoinRelationship>();
            if (this.m_joinRelationshipList != null && relationships != null) {
                for (int index2 = 0; index2 < relationships.size(); ++index2) {
                    JoinRelationship relationship = relationships.elementAt(index2);
                    vector.addElement(relationship);
                }
            }
            this.m_relationshipList.setListData(vector);
            this.m_innerButton.setSelected(false);
            this.m_leftButton.setSelected(false);
            this.m_rightButton.setSelected(false);
            this.m_fullButton.setSelected(false);
            if (vector.isEmpty()) {
                this.m_bRelationshipExists = false;
                WindowUtil.setDeepEnabled(this.m_typePanel, false);
            } else {
                if (this.m_join.getJoinType() == 0) {
                    this.m_innerButton.setSelected(true);
                } else if (this.m_join.getJoinType() == 1) {
                    this.m_leftButton.setSelected(true);
                } else if (this.m_join.getJoinType() == 2) {
                    this.m_rightButton.setSelected(true);
                } else if (this.m_join.getJoinType() == 3) {
                    this.m_fullButton.setSelected(true);
                }
                this.m_bRelationshipExists = true;
                WindowUtil.setDeepEnabled(this.m_typePanel, true);
            }
        }
        this.enableRelationshipButtons();
    }

    private void enableRelationshipButtons() {
        boolean canInsert;
        boolean bEnabled = this.m_relationshipList.getSelectedIndex() > -1;
        this.m_editButton.setEnabled(bEnabled);
        this.m_deleteButton.setEnabled(bEnabled);
        boolean bl = canInsert = this.m_join != null;
        if (canInsert) {
            if (this.m_join.getJoinType() == 4) {
                canInsert = false;
            }
            if (this.m_join.getJoinType() == 5) {
                canInsert = false;
            }
        }
        this.m_insertButton.setEnabled(canInsert);
    }

    protected void _setEnableAll(boolean bEnabled) {
        this.m_previewPanel.setEnabled(bEnabled);
        this.m_leftTable.setEnabled(bEnabled);
        this.m_middlePanel.setEnabled(bEnabled);
        this.m_rightTable.setEnabled(bEnabled);
        this.m_typePanel.setEnabled(bEnabled);
        this.m_typeLabel.setEnabled(bEnabled);
        this.m_innerButton.setEnabled(bEnabled);
        this.m_leftButton.setEnabled(bEnabled);
        this.m_rightButton.setEnabled(bEnabled);
        this.m_fullButton.setEnabled(bEnabled);
        this.m_relationshipPanel.setEnabled(bEnabled);
        this.m_relationshipLabel.setEnabled(bEnabled);
        this.m_relationshipList.setEnabled(bEnabled);
        this.m_editButton.setEnabled(bEnabled);
        this.m_deleteButton.setEnabled(bEnabled);
        this.m_insertButton.setEnabled(bEnabled);
        this.enableRelationshipButtons();
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (bFirstPaint) {
            bFirstPaint = false;
            this.validate();
            this.repaint();
        }
        Rectangle rect = this.getBounds();
        rect.x = this.m_typePanel.getBounds().x + this.m_typeLabel.getBounds().width + 15;
        rect.width -= rect.x + 12;
        rect.y = this.m_typePanel.getBounds().y + this.m_typeLabel.getBounds().height / 2;
        DrawUtil.drawSeparatorLine(g, this.getBackground(), rect);
        rect = this.getBounds();
        rect.x = this.m_relationshipPanel.getBounds().x + this.m_relationshipLabel.getBounds().width + 15;
        rect.width -= rect.x + 12;
        rect.y = this.m_relationshipPanel.getBounds().y + this.m_relationshipLabel.getBounds().height / 2;
        DrawUtil.drawSeparatorLine(g, this.getBackground(), rect);
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JoinPropertyView.this.m_join == null) {
                return;
            }
            if (e.getSource() == JoinPropertyView.this.m_innerButton) {
                if (JoinPropertyView.this.m_join.getJoinType() == 0) {
                    JoinPropertyView.this.m_innerButton.setSelected(true);
                    return;
                }
                JoinPropertyView.this.m_join.setJoinType(0);
                JoinPropertyView.this.m_fullButton.setSelected(false);
                JoinPropertyView.this.m_leftButton.setSelected(false);
                JoinPropertyView.this.m_rightButton.setSelected(false);
            }
            if (e.getSource() == JoinPropertyView.this.m_fullButton) {
                if (JoinPropertyView.this.m_join.getJoinType() == 3) {
                    JoinPropertyView.this.m_fullButton.setSelected(true);
                    return;
                }
                JoinPropertyView.this.m_join.setJoinType(3);
                JoinPropertyView.this.m_innerButton.setSelected(false);
                JoinPropertyView.this.m_leftButton.setSelected(false);
                JoinPropertyView.this.m_rightButton.setSelected(false);
            }
            if (e.getSource() == JoinPropertyView.this.m_leftButton) {
                if (JoinPropertyView.this.m_join.getJoinType() == 1) {
                    JoinPropertyView.this.m_leftButton.setSelected(true);
                    return;
                }
                JoinPropertyView.this.m_join.setJoinType(1);
                JoinPropertyView.this.m_innerButton.setSelected(false);
                JoinPropertyView.this.m_fullButton.setSelected(false);
                JoinPropertyView.this.m_rightButton.setSelected(false);
            }
            if (e.getSource() == JoinPropertyView.this.m_rightButton) {
                if (JoinPropertyView.this.m_join.getJoinType() == 2) {
                    JoinPropertyView.this.m_rightButton.setSelected(true);
                    return;
                }
                JoinPropertyView.this.m_join.setJoinType(2);
                JoinPropertyView.this.m_innerButton.setSelected(false);
                JoinPropertyView.this.m_fullButton.setSelected(false);
                JoinPropertyView.this.m_leftButton.setSelected(false);
            }
            JoinPropertyView.this._setState();
        }
    }
}

