/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.models.Column;
import com.sas.query.models.ColumnExpression;
import com.sas.query.models.ColumnStar;
import com.sas.query.models.Expression;
import com.sas.query.models.FilterNode;
import com.sas.query.models.FilterTree;
import com.sas.query.models.JReferableTree;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.OrderItem;
import com.sas.query.models.ResultItem;
import com.sas.query.models.Table;
import com.sas.query.visuals.FilterEditDialog;
import com.sas.query.visuals.JTreeCellRenderer;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.visuals.PopMenuItem;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.StandardView;
import com.sas.query.visuals.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JReferableTreeView
extends StandardView
implements TreeModelListener {
    public static final int DO_NOTHING = 0;
    public static final int ADD_RECORD_FILTER = 1;
    public static final int ADD_GROUP_FILTER = 2;
    public static final int ADD_RESULT_ITEM = 3;
    public static final int ADD_GROUP_ITEM = 4;
    public static final int ADD_ORDER_ITEM = 5;
    protected TreeModel m_referableTree = null;
    protected MouseListener m_mouseListener = null;
    protected KeyAdapter m_keyAdapter = null;
    protected JTree m_tree;
    protected int m_modelFlags = 0;
    protected int m_defaultAction = 0;
    protected JScrollPane m_scrollPane;
    protected boolean m_processingAction = false;
    protected static QueryResource bundle = new QueryResource(JReferableTreeView.class);

    public JReferableTreeView(Query query) {
        this(query, 0);
    }

    public JReferableTreeView(Query query, int modelFlags) {
        super(query);
        this.m_modelFlags = modelFlags;
        this.setLayout(new BorderLayout());
        this._initialize();
    }

    @Override
    public void closing() {
        if (this.m_mouseListener != null) {
            this.m_tree.removeMouseListener(this.m_mouseListener);
            this.m_mouseListener = null;
        }
        if (this.m_referableTree != null) {
            this.m_referableTree.removeTreeModelListener(this);
        }
        if (this.m_keyAdapter != null) {
            this.m_tree.removeKeyListener(this.m_keyAdapter);
            this.m_keyAdapter = null;
        }
        if (this.m_tree.getModel() != null) {
            this.m_query.removePropertyListener((JReferableTree)this.m_tree.getModel());
        }
    }

    public void setDefaultAction(int defaultAction) {
        this.m_defaultAction = defaultAction;
    }

    protected TreeModel getTreeModel() {
        return this.m_referableTree;
    }

    protected void setTreeModel(TreeModel treeModel) {
        this.m_referableTree = treeModel;
    }

    public TreePath getSelectionPath() {
        return this.m_tree.getSelectionPath();
    }

    protected void _initialize() {
        this.m_tree = new JTree(){

            @Override
            public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                ResultItem ri;
                String ret = super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
                if (value instanceof ResultItem && (ri = (ResultItem)value).getAliasString().length() > 0) {
                    String definition = null;
                    if (ri.getExpression() instanceof ColumnExpression) {
                        ColumnExpression ce = (ColumnExpression)ri.getExpression();
                        definition = ce.getColumn().getParent().toString() + "." + ce.getColumn().toString();
                    } else {
                        definition = ri.getExpression().toString();
                    }
                    if (!definition.equals(ret)) {
                        ret = ret + "(" + definition + ")";
                    }
                }
                return ret;
            }
        };
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.setCellRenderer(new JTreeCellRenderer(this.m_tree, bundle));
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
        this.m_scrollPane = new JScrollPane(this.m_tree);
        WindowUtil.fixupJScrollPane(this.m_scrollPane);
        this.add(this.m_scrollPane);
        if (this.getTreeModel() == null) {
            this.setTreeModel(new JReferableTree(this.m_query, this.m_modelFlags));
        }
        this.m_tree.setModel(this.getTreeModel());
        this.getTreeModel().addTreeModelListener(this);
        if (this.m_query.getLimit(2)) {
            this.m_tree.setRootVisible(false);
            this.m_tree.setShowsRootHandles(true);
        }
        this.m_mouseListener = new MouseInputAdapter(){
            int previouslySelectedRow = -1;
            MouseEvent previousMouseEvent = null;

            @Override
            public void mouseReleased(MouseEvent e) {
                long timeDiff;
                int selectedRow = JReferableTreeView.this.m_tree.getRowForLocation(e.getX(), e.getY());
                TreePath selectedPath = JReferableTreeView.this.m_tree.getPathForLocation(e.getX(), e.getY());
                int clickCount = e.getClickCount();
                if (this.previousMouseEvent != null && selectedRow == this.previouslySelectedRow && (timeDiff = e.getWhen() - this.previousMouseEvent.getWhen()) < 900L && e.getClickCount() < 2 && !e.isPopupTrigger()) {
                    if ((e.getModifiers() & 4) == 0) {
                        ++clickCount;
                    }
                }
                if (selectedRow != -1) {
                    this.previousMouseEvent = e;
                    this.previouslySelectedRow = selectedRow;
                }
                if (selectedRow != -1) {
                    if (clickCount == 2 && selectedPath.equals(JReferableTreeView.this.m_tree.getSelectionPath())) {
                        JReferableTreeView.this.onAction(selectedPath);
                        this.previousMouseEvent = null;
                        selectedRow = -1;
                    } else if ((e.getModifiers() & 4) != 0) {
                        JReferableTreeView.this.m_tree.setSelectionRow(selectedRow);
                        JReferableTreeView.this.displayPopmenu(e, selectedPath);
                    }
                }
            }
        };
        this.m_tree.addMouseListener(this.m_mouseListener);
        this.m_keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                TreePath selectedPath = JReferableTreeView.this.m_tree.getLeadSelectionPath();
                if (selectedPath != null && event.getKeyChar() == '\n') {
                    JReferableTreeView.this.onAction(selectedPath);
                }
            }
        };
        this.m_tree.addKeyListener(this.m_keyAdapter);
        this.expandAll();
    }

    public void expandAll() {
        for (int index = 0; index < this.m_tree.getRowCount(); ++index) {
            this.m_tree.collapseRow(index);
            this.m_tree.expandRow(index);
        }
    }

    public void onAction(TreePath path) {
        if (this.m_processingAction) {
            return;
        }
        Object node = path.getLastPathComponent();
        if (node == null) {
            return;
        }
        this.busyOn();
        this.m_processingAction = true;
        try {
            Expression expression = null;
            if (node instanceof Column) {
                expression = new ColumnExpression((Column)node);
            } else if (node instanceof ResultItem) {
                expression = ((ResultItem)node).getExpression();
            }
            if (expression != null) {
                if (this.m_defaultAction == 1 || this.m_defaultAction == 2) {
                    if (expression instanceof ColumnExpression && ((ColumnExpression)expression).getColumn() instanceof ColumnStar) {
                        this.m_query.getMessageHandler().addError(bundle.getString("JReferableTreeView.cantFilteronColumnStar.txt"));
                    } else {
                        FilterNode newNode = new FilterNode(this.m_query, expression);
                        Frame parent = WindowUtil.getParentFrame(this);
                        FilterEditDialog limitDialog = new FilterEditDialog(this.m_query, parent, newNode, false);
                        WindowUtil.centerOver(limitDialog, this.getParent());
                        limitDialog.setVisible(true);
                        if (limitDialog.isReturnActionOK()) {
                            if (this.m_defaultAction == 1) {
                                FilterTree whereNodeWent = this.m_query.addAndFilter(newNode);
                                whereNodeWent.setSelectedNode(newNode);
                            } else {
                                this.m_query.addHavingAndFilter(newNode);
                                this.m_query.getHavingFilterTree().setSelectedNode(newNode);
                            }
                            this.m_query.isValidSql();
                        }
                        parent.remove(limitDialog);
                        limitDialog.dispose();
                        limitDialog = null;
                    }
                } else if (this.m_defaultAction == 3) {
                    this.m_query.addResultItem(expression);
                } else if (this.m_defaultAction == 4) {
                    this.m_query.addGroupItem(expression);
                } else if (this.m_defaultAction == 5) {
                    OrderItem orderItem = this.m_query.addOrderItem(expression);
                    orderItem.setSortingDirection(1);
                }
                this.m_query.getPropertyChangeHandler().firePropertyChanges();
                MessageUtil.displayMessages(this.m_query.getMessageHandler());
            }
        }
        catch (Exception e) {
            this.m_query.getMessageHandler().addInternalError(bundle.messageString("Message.ReferableTreeView.AddFilterFailed.fmt.txt", e));
            e.printStackTrace(System.err);
        }
        this.m_processingAction = false;
        this.busyOff();
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.expandAll();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.expandAll();
    }

    protected void displayPopmenu(MouseEvent event, TreePath path) {
        Object node = path.getLastPathComponent();
        if (node == null) {
            return;
        }
        JPopupMenu popmenu = null;
        popmenu = new JPopupMenu();
        if (node instanceof Table) {
            // empty if block
        }
        if (node instanceof Column) {
            popmenu.add(new PopMenuItem(bundle.getString("Common.AddFilter.txt"), "onAction", (Object)this, (Object)this.m_tree.getSelectionPath(), TreePath.class));
        }
        if (popmenu.getSubElements().length != 0) {
            JComponent source = (JComponent)event.getSource();
            source.add(popmenu);
            popmenu.show(source, event.getX(), event.getY());
        }
    }

    public JScrollBar getVScrollBar() {
        return this.m_scrollPane.getVerticalScrollBar();
    }
}

