/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.QueryResource;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;

public class ImageHandler {
    protected static Applet m_applet;
    protected static MessageHandler m_messages;
    protected static Hashtable m_imageCache;

    public ImageHandler() {
    }

    public ImageHandler(MessageHandler messages) {
        m_messages = messages;
    }

    public ImageHandler(Applet applet, MessageHandler messages) {
        m_applet = applet;
        m_messages = messages;
    }

    public static ImageIcon getImageIcon(QueryResource bundle, String strName) {
        String strIconPath;
        ImageIcon returnValue;
        block8: {
            returnValue = null;
            String strIconFileName = bundle.getString(strName + "File.image");
            strIconPath = bundle.getString("ImageLocation.notrans") + strIconFileName;
            if (m_imageCache == null) {
                m_imageCache = new Hashtable();
            } else {
                returnValue = (ImageIcon)m_imageCache.get(strIconPath);
                if (returnValue != null) {
                    return returnValue;
                }
            }
            if (bundle != null) {
                returnValue = bundle.getImageIcon(strName);
            }
            if (returnValue != null) {
                m_imageCache.put(strIconPath, returnValue);
                return returnValue;
            }
            try {
                URL url = ClassLoader.getSystemResource(strIconPath);
                returnValue = new ImageIcon(url);
            }
            catch (Exception e) {
                if (m_messages == null) break block8;
                m_messages.addInternalError(bundle.messageString("ImageHandler.loadImage.fmt.txt", strIconPath, e.toString()));
            }
        }
        if (returnValue != null) {
            m_imageCache.put(strIconPath, returnValue);
        }
        return returnValue;
    }

    public static Applet getApplet(Component source) {
        Container parent;
        for (parent = source.getParent(); parent != null && !(parent instanceof Applet); parent = parent.getParent()) {
        }
        return (Applet)parent;
    }
}

