/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.models.Expression;
import com.sas.query.models.GroupItem;
import com.sas.query.models.GroupItemList;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.models.PropertyChangeConstants;
import com.sas.query.models.ResultItem;
import com.sas.query.models.ResultItemList;
import com.sas.query.visuals.GroupItemPropertyView;
import com.sas.query.visuals.QueryComponentDialog;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.StandardView;
import com.sas.query.visuals.WindowUtil;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class GroupItemListView
extends StandardView {
    protected GroupItemList m_GroupItems = null;
    protected JTable m_tableView;
    protected JScrollPane m_scrollpane;
    protected JButton m_editButton;
    protected JButton m_deleteButton;
    protected JButton m_moveFirstButton;
    protected JButton m_moveUpButton;
    protected JButton m_moveDownButton;
    protected JButton m_moveLastButton;
    protected static QueryResource bundle = new QueryResource(GroupItemListView.class);
    protected String[] m_labels = new String[]{"", bundle.getString("GroupItemListView.DataItemToGroupBy.txt")};
    protected int[] m_minSize = new int[]{30, 200};

    public GroupItemListView(Query query) {
        super(query);
        this.m_tableView = new JTable(new GroupItemTableModel(query)){

            @Override
            public void tableChanged(TableModelEvent e) {
                super.tableChanged(e);
                GroupItemListView.this._setState();
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                GroupItemListView.this._setState();
            }
        };
        this.m_tableView.setSelectionMode(0);
        TableColumn resultCol = this.m_tableView.getColumnModel().getColumn(0);
        TableCellRenderer headerRenderer = resultCol.getHeaderRenderer();
        if (headerRenderer instanceof DefaultTableCellRenderer) {
            URL url = this.getClass().getResource("res/DataSet.gif");
            ImageIcon icon = new ImageIcon(url);
            ((DefaultTableCellRenderer)headerRenderer).setIcon(icon);
            ((DefaultTableCellRenderer)headerRenderer).setToolTipText(bundle.getString("GroupItemListView.ReturnItemInResultsTip.txt"));
        }
        for (int index = 0; index < this.m_minSize.length; ++index) {
            this.m_tableView.getColumnModel().getColumn(index).setMinWidth(this.m_minSize[index]);
        }
        this.m_scrollpane = new JScrollPane(this.m_tableView);
        WindowUtil.fixupJScrollPane(this.m_scrollpane);
        this.m_editButton = new JButton(bundle.getString("Common.Edit....txt"));
        this.m_editButton.addActionListener(new EditButtonHandler());
        this.m_deleteButton = new JButton(bundle.getString("Common.Delete.txt"));
        this.m_deleteButton.addActionListener(new DeleteButtonHandler());
        URL url = this.getClass().getResource("res/upFirst.gif");
        ImageIcon defaultIcon = new ImageIcon(url);
        this.m_moveFirstButton = new JButton(bundle.getString("Common.First.txt"));
        this.m_moveFirstButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_moveFirstButton.addActionListener(new MoveButtonHandler("First"));
        url = this.getClass().getResource("res/upArrow.gif");
        defaultIcon = new ImageIcon(url);
        this.m_moveUpButton = new JButton(bundle.getString("Common.Up.txt"));
        this.m_moveUpButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_moveUpButton.addActionListener(new MoveButtonHandler("Up"));
        url = this.getClass().getResource("res/downArrow.gif");
        defaultIcon = new ImageIcon(url);
        this.m_moveDownButton = new JButton(bundle.getString("Common.Down.txt"));
        this.m_moveDownButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_moveDownButton.addActionListener(new MoveButtonHandler("Down"));
        url = this.getClass().getResource("res/downLast.gif");
        defaultIcon = new ImageIcon(url);
        this.m_moveLastButton = new JButton(bundle.getString("Common.Last.txt"));
        this.m_moveLastButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_moveLastButton.addActionListener(new MoveButtonHandler("Last"));
        JPanel listPanel = new JPanel();
        GridBagLayout listPanelGridBagLayout = new GridBagLayout();
        listPanel.setLayout(listPanelGridBagLayout);
        listPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 11;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_editButton, gbc);
        listPanel.add(this.m_editButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 11;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_deleteButton, gbc);
        listPanel.add(this.m_deleteButton);
        JPanel spacer = new JPanel();
        spacer.setSize(10, 80);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.anchor = 11;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(spacer, gbc);
        listPanel.add(spacer);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.anchor = 10;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_moveFirstButton, gbc);
        listPanel.add(this.m_moveFirstButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 5;
        gbc.anchor = 10;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_moveUpButton, gbc);
        listPanel.add(this.m_moveUpButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 6;
        gbc.anchor = 10;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_moveDownButton, gbc);
        listPanel.add(this.m_moveDownButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 7;
        gbc.anchor = 10;
        gbc.fill = 2;
        listPanelGridBagLayout.setConstraints(this.m_moveLastButton, gbc);
        listPanel.add(this.m_moveLastButton);
        this.setLayout(new BorderLayout());
        this.add(this.m_scrollpane);
        this.add("East", listPanel);
        this.m_tableView.setRowSelectionInterval(0, 0);
        this._setState();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, SystemColor.controlLtHighlight, SystemColor.controlHighlight, SystemColor.controlDkShadow, SystemColor.controlShadow), BorderFactory.createEmptyBorder(12, 12, 12, 12)));
    }

    @Override
    public void closing() {
        this.m_query.removePropertyListener((GroupItemTableModel)this.m_tableView.getModel());
    }

    public void onEdit() {
        GroupItem item = this.getSelectedItem();
        GroupItemPropertyView propertyPanel = new GroupItemPropertyView(this.m_query, item);
        QueryComponentDialog editDialog = new QueryComponentDialog(WindowUtil.getParentFrame(this), this.m_query, propertyPanel, "BUG - need Prefix");
        WindowUtil.centerOverWindow(editDialog, this);
        editDialog.setModal(true);
        editDialog.pack();
        editDialog.setVisible(true);
        propertyPanel.closing();
    }

    public void onDelete() {
        GroupItem item = this.getSelectedItem();
        this.m_query.deleteGroupItem(item);
        this.firePropertyChanges();
    }

    public void valueChanged(ListSelectionEvent e) {
        this._setState();
    }

    protected void _setState() {
        int nSelected = this.m_tableView.getSelectedRow();
        if (this.m_tableView.getRowCount() == 0 || nSelected > this.m_tableView.getRowCount() - 1) {
            nSelected = -1;
        }
        boolean bCanMoveUp = true;
        boolean bCanMoveDown = true;
        if (nSelected == 0) {
            bCanMoveUp = false;
        } else if (nSelected == -1) {
            bCanMoveUp = false;
            bCanMoveDown = false;
        } else if (nSelected == this.m_tableView.getRowCount() - 1) {
            bCanMoveDown = false;
        }
        this.m_moveFirstButton.setEnabled(bCanMoveUp);
        this.m_moveUpButton.setEnabled(bCanMoveUp);
        this.m_moveDownButton.setEnabled(bCanMoveDown);
        this.m_moveLastButton.setEnabled(bCanMoveDown);
        if (!bCanMoveUp && !bCanMoveDown) {
            this.m_editButton.setEnabled(false);
            this.m_deleteButton.setEnabled(false);
        } else {
            this.m_editButton.setEnabled(true);
            this.m_deleteButton.setEnabled(true);
        }
    }

    protected GroupItem getSelectedItem() {
        GroupItem item = null;
        int index = this.m_tableView.getSelectedRow();
        if (index != -1) {
            item = this.m_GroupItems.elementAt(index);
        }
        return item;
    }

    class GroupItemTableModel
    extends AbstractTableModel
    implements PropertyChangeConstants,
    ModelChangeListener {
        Hashtable isItemSelectedList = new Hashtable();

        public GroupItemTableModel(Query query) {
            query.addPropertyListener(this, 64);
            this.refresh();
        }

        @Override
        public int getColumnCount() {
            return GroupItemListView.this.m_labels.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return GroupItemListView.this.m_labels[columnIndex];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public int getRowCount() {
            return GroupItemListView.this.m_GroupItems.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            GroupItem item = GroupItemListView.this.m_GroupItems.elementAt(row);
            if (col == 0) {
                return new Boolean(item.getResultItem() != null);
            }
            if (col == 1) {
                return item.getDisplayString();
            }
            return bundle.getString("Common.nullinBrackets.txt");
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            boolean bEditable = false;
            if (col == 0) {
                bEditable = true;
            }
            return bEditable;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            GroupItem item = GroupItemListView.this.m_GroupItems.elementAt(row);
            if (col == 0) {
                if (item.getResultItem() == null) {
                    this._shareWithResultItem(item);
                } else {
                    try {
                        item.setExpression((Expression)item.getResultItem().getExpression().clone());
                    }
                    catch (Exception e) {
                        MessageHandler.addStaticError("Unable to copy result expression into group item.");
                    }
                }
            }
            this.refresh();
            GroupItemListView.this.firePropertyChanges();
        }

        protected void _shareWithResultItem(GroupItem item) {
            ResultItemList resultList = GroupItemListView.this.m_query.getResultItems();
            GroupItemList groupList = GroupItemListView.this.m_query.getGroupItems();
            for (int index = 0; index < resultList.size(); ++index) {
                ResultItem resultItem = resultList.elementAt(index);
                if (!resultItem.getExpression().equivalentTo(GroupItemListView.this.m_query, item.getExpression())) continue;
                boolean bUsed = false;
                for (int groupIndex = 0; groupIndex < groupList.size(); ++groupIndex) {
                    GroupItem groupItem = groupList.elementAt(groupIndex);
                    if (groupItem.getResultItem() != resultItem) continue;
                    bUsed = true;
                }
                if (bUsed) continue;
                item.setResultItem(resultItem);
                return;
            }
            GroupItemListView.this.m_query.addResultItem(item.getExpression());
        }

        public void refresh() {
            GroupItemListView.this.m_GroupItems = GroupItemListView.this.m_query.getGroupItems();
            TableModelEvent event = new TableModelEvent(this);
            this.fireTableChanged(event);
        }

        @Override
        public void modelChangeCallback(ModelChangeEvent event) {
            this.refresh();
        }
    }

    protected class EditButtonHandler
    implements ActionListener {
        EditButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            GroupItemListView.this.onEdit();
        }
    }

    protected class DeleteButtonHandler
    implements ActionListener {
        DeleteButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            GroupItemListView.this.onDelete();
            GroupItemListView.this._setState();
        }
    }

    protected class MoveButtonHandler
    implements ActionListener {
        String m_strAction;

        MoveButtonHandler(String action) {
            this.m_strAction = action;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int index = GroupItemListView.this.m_tableView.getSelectedRow();
            if (this.m_strAction.equals("First")) {
                GroupItemListView.this.m_query.moveGroupItem(index, 0);
                GroupItemListView.this.m_tableView.setRowSelectionInterval(0, 0);
            } else if (this.m_strAction.equals("Up")) {
                GroupItemListView.this.m_query.moveGroupItem(index, index - 1);
                GroupItemListView.this.m_tableView.setRowSelectionInterval(index - 1, index - 1);
            } else if (this.m_strAction.equals("Down")) {
                GroupItemListView.this.m_query.moveGroupItem(index, index + 2);
                GroupItemListView.this.m_tableView.setRowSelectionInterval(index + 1, index + 1);
            } else if (this.m_strAction.equals("Last")) {
                GroupItemListView.this.m_query.moveGroupItem(index, GroupItemListView.this.m_GroupItems.size());
                GroupItemListView.this.m_tableView.setRowSelectionInterval(GroupItemListView.this.m_GroupItems.size() - 1, GroupItemListView.this.m_GroupItems.size() - 1);
            }
        }
    }
}

